/* 
make_zero_flux_struct.c
create structures initialized with zero for forcing fluxes to zero between simulation days

*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
Biome-BGCMuSo v7.0.
Original code: Copyright 2000, Peter E. Thornton
Numerical Terradynamic Simulation Group, The University of Montana, USA
Modified code: Copyright 2025, D. Hidy [dori.hidy@gmail.com]
Hungarian Academy of Sciences, Hungary
See the website of Biome-BGCMuSo at http://nimbus.elte.hu/bbgc/ for documentation, model executable and example input files.
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "ini.h"
#include "bgc_struct.h"
#include "bgc_func.h"
#include "bgc_constants.h"

int make_zero_flux_struct(const control_struct* ctrl, wflux_struct* wf, cflux_struct* cf, nflux_struct* nf, soilInfo_struct* soilInfo, summary_struct* summary)
{
	int errorCode=0;
	int layer, dm;

	if (ctrl->simyr == 0 && ctrl->yday == 0)
	{
		wf->soilwFLuxFromBelow = 0;
	}
	for (layer = 0; layer < N_SOILLAYERS; layer++)
	{
		wf->FRZ_to_NORM[layer] = 0;
		wf->FRZ_to_CAPIL[layer] = 0;
	}

	wf->prcp_to_canopyw = 0;
	wf->prcp_to_soilSurface = 0;
	wf->prcp_to_snoww = 0;
	wf->prcp_to_runoff = 0;
	wf->pondw_to_runoff = 0;
	wf->EVPcanopyw = 0;
	wf->canopyw_to_soilw = 0;
	wf->EVPpondw = 0;
	wf->EVPsurface = 0;
	wf->SUBLsnoww = 0;
	wf->snoww_to_soilw = 0;
	wf->EVPsoilw = 0;
	wf->EVPsoilwNORMcf = 0;
	wf->EVPsoilwCAPILcf = 0;
	wf->TRPsoilwNORMcf = 0;
	wf->TRPsoilwCAPILcf = 0;

	wf->potEVPsurface = 0;
	wf->potETcanopy = 0;
	wf->potSUBLsnow = 0;
	wf->potEVPandSUBLsurface = 0;
	wf->ET_Elimit = 0;
	wf->potTRPsoilw = 0;


	wf->TRPsoilw_SUM = 0;
	wf->ET = 0;
	wf->PET = 0;
	wf->pondw_to_soilw = 0;
	wf->soilw_to_pondw = 0;
	wf->prcp_to_pondw = 0;
	wf->GW_to_pondw = 0;
	wf->FL_to_soilw = 0;
	wf->FL_to_pondw = 0;
	wf->FL_to_soilwTOTAL = 0;
	wf->canopyw_to_THN = 0;
	wf->canopyw_to_MOW = 0;
	wf->canopyw_to_HRV = 0;
	wf->canopyw_to_PLG = 0;
	wf->canopyw_to_GRZ = 0;
	wf->IRG_to_prcp = 0;
	wf->IRG_to_soilw = 0;
	wf->IRG_to_soilSurface = 0;
	wf->FRZ_to_soilw = 0;
	wf->infiltPOT = 0;
	wf->waterFromAbove = 0;
	wf->EVPfromGW = 0;
	wf->TRPsoilw_CAPILgw = 0;
	wf->TRPsoilw_NORMgw = 0;
	wf->TRPfromGW_CAPILcf = 0;
	wf->TRPfromGW_NORMcf = 0;
	wf->TRPfromGW_total = 0;
	wf->GWmovchange = 0;
	wf->soilwFlux_NORMvsCAPILgw = 0;
	wf->soilwPercol_NORMvsCAPILgw = 0;
	wf->soilwDiffus_NORMvsCAPILgw = 0;
	wf->soilwFlux_NORMvsCAPILcf = 0;
	wf->soilwPercol_NORMvsCAPILcf = 0;
	wf->soilwDiffus_NORMvsCAPILcf = 0;
	wf->GWdischarge_total = 0;

	wf->GWdischargeNORMcf = 0;
	wf->GWdischargeNORMgw = 0;
	wf->GWdischargeCAPILcf = 0;
	wf->GWdischargeCAPILgw = 0;

	wf->soilwDiffus_aboveGWlayer_vs_NORMgw = 0;
	wf->soilwDiffus_aboveGWlayer_vs_CAPILgw = 0;
	wf->soilwDiffusNORMcf = 0;
	wf->soilwDiffusCAPILcf = 0;
	wf->soilwDiffus_aboveCFlayer_vs_NORMcf = 0;
	wf->soilwDiffus_aboveCFlayer_vs_CAPILcf = 0;
	wf->soilwPercolDiffus_fromNORM_total = 0;

	wf->GWrecharge_NORMcf = 0;
	wf->GWrecharge_NORMgw = 0;
	wf->GWrecharge_CAPILgw = 0;
	wf->GWrecharge_CAPILcf = 0;
	wf->GWrecharge_lastCAPIL = 0;
	wf->GWrecharge_total = 0;


	wf->inflow_NORMcf = 0;
	wf->inflow_CAPILcf = 0;
	wf->inflow_NORMgw = 0;
	wf->inflow_CAPILgw = 0;
	wf->outflow_NORMcf = 0;
	wf->outflow_CAPILcf = 0;
	wf->outflow_NORMgw = 0;
	wf->outflow_CAPILgw = 0;

	cf->m_leafc_to_litr1c = 0;
	cf->m_leafc_to_litr2c = 0;
	cf->m_leafc_to_litr3c = 0;
	cf->m_leafc_to_litr4c = 0;
	cf->m_frootc_to_litr1c = 0;
	cf->m_frootc_to_litr2c = 0;
	cf->m_frootc_to_litr3c = 0;
	cf->m_frootc_to_litr4c = 0;
	cf->m_yieldc_to_litr1c = 0;
	cf->m_yieldc_to_litr2c = 0;
	cf->m_yieldc_to_litr3c = 0;
	cf->m_yieldc_to_litr4c = 0;
	cf->m_softstemc_to_litr1c = 0;
	cf->m_softstemc_to_litr2c = 0;
	cf->m_softstemc_to_litr3c = 0;
	cf->m_softstemc_to_litr4c = 0;
	cf->m_leafc_storage_to_litr1c = 0;
	cf->m_frootc_storage_to_litr1c = 0;
	cf->m_softstemc_storage_to_litr1c = 0;
	cf->m_yieldc_storage_to_litr1c = 0;
	cf->m_livestemc_storage_to_litr1c = 0;
	cf->m_deadstemc_storage_to_litr1c = 0;
	cf->m_livecrootc_storage_to_litr1c = 0;
	cf->m_deadcrootc_storage_to_litr1c = 0;
	cf->m_leafc_transfer_to_litr1c = 0;
	cf->m_frootc_transfer_to_litr1c = 0;
	cf->m_yieldc_transfer_to_litr1c = 0;
	cf->m_softstemc_transfer_to_litr1c = 0;
	cf->m_livestemc_transfer_to_litr1c = 0;
	cf->m_deadstemc_transfer_to_litr1c = 0;
	cf->m_livecrootc_transfer_to_litr1c = 0;
	cf->m_deadcrootc_transfer_to_litr1c = 0;
	cf->m_livestemc_to_cwdc = 0;
	cf->m_deadstemc_to_cwdc = 0;
	cf->m_livecrootc_to_cwdc = 0;
	cf->m_deadcrootc_to_cwdc = 0;
	cf->m_gresp_storage_to_litr1c = 0;
	cf->m_gresp_transfer_to_litr1c = 0;
	cf->m_leafc_to_fire = 0;
	cf->m_frootc_to_fire = 0;
	cf->m_yieldc_to_fire = 0;
	cf->m_softstemc_to_fire = 0;
	cf->m_STDBc_to_fire = 0;
	cf->m_CTDBc_to_fire = 0;
	cf->m_leafc_storage_to_fire = 0;
	cf->m_frootc_storage_to_fire = 0;
	cf->m_yieldc_storage_to_fire = 0;
	cf->m_softstemc_storage_to_fire = 0;
	cf->m_livestemc_storage_to_fire = 0;
	cf->m_deadstemc_storage_to_fire = 0;
	cf->m_livecrootc_storage_to_fire = 0;
	cf->m_deadcrootc_storage_to_fire = 0;
	cf->m_leafc_transfer_to_fire = 0;
	cf->m_frootc_transfer_to_fire = 0;
	cf->m_yieldc_transfer_to_fire = 0;
	cf->m_softstemc_transfer_to_fire = 0;
	cf->m_livestemc_transfer_to_fire = 0;
	cf->m_deadstemc_transfer_to_fire = 0;
	cf->m_livecrootc_transfer_to_fire = 0;
	cf->m_deadcrootc_transfer_to_fire = 0;
	cf->m_livestemc_to_fire = 0;
	cf->m_deadstemc_to_fire = 0;
	cf->m_livecrootc_to_fire = 0;
	cf->m_deadcrootc_to_fire = 0;
	cf->m_gresp_storage_to_fire = 0;
	cf->m_gresp_transfer_to_fire = 0;
	cf->m_litr1c_to_fire_total = 0;
	cf->m_litr2c_to_fire_total = 0;
	cf->m_litr3c_to_fire_total = 0;
	cf->m_litr4c_to_fire_total = 0;
	cf->m_cwdc_to_fire_total = 0;
	cf->m_vegc_to_SNSC = 0;
	cf->m_leafc_to_SNSC = 0;
	cf->m_leafc_to_SNSCgenprog = 0;
	cf->m_frootc_to_SNSC = 0;
	cf->m_yieldc_to_SNSC = 0;
	cf->m_softstemc_to_SNSC = 0;
	cf->m_leafc_storage_to_SNSC = 0;
	cf->m_frootc_storage_to_SNSC = 0;
	cf->m_leafc_transfer_to_SNSC = 0;
	cf->m_frootc_transfer_to_SNSC = 0;
	cf->m_yieldc_storage_to_SNSC = 0;
	cf->m_yieldc_transfer_to_SNSC = 0;
	cf->m_softstemc_storage_to_SNSC = 0;
	cf->m_softstemc_transfer_to_SNSC = 0;
	cf->m_gresp_storage_to_SNSC = 0;
	cf->m_gresp_transfer_to_SNSC = 0;
	cf->HRV_leafc_storage_to_SNSC = 0;               
	cf->HRV_leafc_transfer_to_SNSC = 0;    
	cf->HRV_yieldc_storage_to_SNSC = 0;              
	cf->HRV_yieldc_transfer_to_SNSC = 0;   
	cf->HRV_frootc_to_SNSC = 0;                          
	cf->HRV_softstemc_to_SNSC = 0;                 
	cf->HRV_frootc_storage_to_SNSC = 0;               
	cf->HRV_frootc_transfer_to_SNSC = 0;               
	cf->HRV_softstemc_storage_to_SNSC = 0;        
	cf->HRV_softstemc_transfer_to_SNSC = 0;       
	cf->HRV_gresp_storage_to_SNSC = 0;
	cf->HRV_gresp_transfer_to_SNSC = 0;
	cf->yieldc_to_flowHS = 0;
	cf->STDBc_leaf_to_litr = 0;
	cf->STDBc_froot_to_litr = 0;
	cf->STDBc_yield_to_litr = 0;
	cf->STDBc_softstem_to_litr = 0;
	cf->STDBc_to_litr = 0;
	cf->CTDBc_leaf_to_litr = 0;
	cf->CTDBc_froot_to_litr = 0;
	cf->CTDBc_yield_to_litr = 0;
	cf->CTDBc_softstem_to_litr = 0;
	cf->CTDBc_cstem_to_cwd = 0;
	cf->CTDBc_croot_to_cwd = 0;
	cf->CTDBc_to_litr = 0;
	cf->leafc_transfer_to_leafc = 0;
	cf->frootc_transfer_to_frootc = 0;
	cf->yieldc_transfer_to_yield = 0;
	cf->softstemc_transfer_to_softstemc = 0;
	cf->livestemc_transfer_to_livestemc = 0;
	cf->deadstemc_transfer_to_deadstemc = 0;
	cf->livecrootc_transfer_to_livecrootc = 0;
	cf->deadcrootc_transfer_to_deadcrootc = 0;
	cf->leafc_to_litr1c = 0;
	cf->leafc_to_litr2c = 0;
	cf->leafc_to_litr3c = 0;
	cf->leafc_to_litr4c = 0;
	cf->frootc_to_litr1c = 0;
	cf->frootc_to_litr2c = 0;
	cf->frootc_to_litr3c = 0;
	cf->frootc_to_litr4c = 0;
	cf->yieldc_to_litr1c = 0;
	cf->yieldc_to_litr2c = 0;
	cf->yieldc_to_litr3c = 0;
	cf->yieldc_to_litr4c = 0;
	cf->softstemc_to_litr1c = 0;
	cf->softstemc_to_litr2c = 0;
	cf->softstemc_to_litr3c = 0;
	cf->softstemc_to_litr4c = 0;
	cf->leaf_day_MR = 0;
	cf->leaf_night_MR = 0;
	cf->froot_MR = 0;
	cf->yield_MR = 0;
	cf->softstem_MR = 0;
	cf->livestem_MR = 0;
	cf->livecroot_MR = 0;
	cf->psnsun_to_cpool = 0;
	cf->psnshade_to_cpool = 0;


	cf->cpool_to_leafc = 0;
	cf->cpool_to_leafc_storage = 0;
	cf->cpool_to_frootc = 0;
	cf->cpool_to_frootc_storage = 0;
	cf->cpool_to_yield = 0;
	cf->cpool_to_yieldc_storage = 0;
	cf->cpool_to_softstemc = 0;
	cf->cpool_to_softstemc_storage = 0;
	cf->cpool_to_livestemc = 0;
	cf->cpool_to_livestemc_storage = 0;
	cf->cpool_to_deadstemc = 0;
	cf->cpool_to_deadstemc_storage = 0;
	cf->cpool_to_livecrootc = 0;
	cf->cpool_to_livecrootc_storage = 0;
	cf->cpool_to_deadcrootc = 0;
	cf->cpool_to_deadcrootc_storage = 0;
	cf->cpool_to_gresp_storage = 0;
	cf->cpool_leaf_GR = 0;
	cf->cpool_leaf_storage_GR = 0;
	cf->transfer_leaf_GR = 0;
	cf->cpool_froot_GR = 0;
	cf->cpool_froot_storage_GR = 0;
	cf->transfer_froot_GR = 0;
	cf->cpool_yield_GR = 0;
	cf->cpool_yieldc_storage_GR = 0;
	cf->transfer_yield_GR = 0;
	cf->cpool_softstem_GR = 0;
	cf->cpool_softstem_storage_GR = 0;
	cf->transfer_softstem_GR = 0;
	cf->cpool_livestem_GR = 0;
	cf->cpool_livestem_storage_GR = 0;
	cf->transfer_livestem_GR = 0;
	cf->cpool_deadstem_GR = 0;
	cf->cpool_deadstem_storage_GR = 0;
	cf->transfer_deadstem_GR = 0;
	cf->cpool_livecroot_GR = 0;
	cf->cpool_livecroot_storage_GR = 0;
	cf->transfer_livecroot_GR = 0;
	cf->cpool_deadcroot_GR = 0;
	cf->cpool_deadcroot_storage_GR = 0;
	cf->transfer_deadcroot_GR = 0;
	cf->leafc_storage_to_MRdef = 0;
	cf->frootc_storage_to_MRdef = 0;
	cf->yieldc_storage_to_MRdef = 0;
	cf->softstemc_storage_to_MRdef = 0;
	cf->livestemc_storage_to_MRdef = 0;
	cf->livecrootc_storage_to_MRdef = 0;
	cf->deadstemc_storage_to_MRdef = 0;
	cf->deadcrootc_storage_to_MRdef = 0;
	cf->leafc_transfer_to_MRdef = 0;
	cf->frootc_transfer_to_MRdef = 0;
	cf->yieldc_transfer_to_MRdef = 0;
	cf->softstemc_transfer_to_MRdef = 0;
	cf->livestemc_transfer_to_MRdef = 0;
	cf->livecrootc_transfer_to_MRdef = 0;
	cf->deadstemc_transfer_to_MRdef = 0;
	cf->deadcrootc_transfer_to_MRdef = 0;
	cf->leafc_to_MRdef = 0;
	cf->frootc_to_MRdef = 0;
	cf->yieldc_to_MRdef = 0;
	cf->softstemc_to_MRdef = 0;
	cf->livestemc_to_MRdef = 0;
	cf->livecrootc_to_MRdef = 0;
	cf->NSCnw_to_MRdef = 0;
	cf->SCnw_to_MRdef = 0;
	cf->NSCw_to_MRdef = 0;
	cf->SCw_to_MRdef = 0;
	cf->cpool_to_MRdef = 0;

	cf->leafc_storage_to_leafc_transfer = 0;
	cf->frootc_storage_to_frootc_transfer = 0;
	cf->yieldc_storage_to_yieldc_transfer = 0;
	cf->softstemc_storage_to_softstemc_transfer = 0;
	cf->livestemc_storage_to_livestemc_transfer = 0;
	cf->deadstemc_storage_to_deadstemc_transfer = 0;
	cf->livecrootc_storage_to_livecrootc_transfer = 0;
	cf->deadcrootc_storage_to_deadcrootc_transfer = 0;
	cf->gresp_storage_to_gresp_transfer = 0;
	cf->livestemc_to_deadstemc = 0;
	cf->livecrootc_to_deadcrootc = 0;
	cf->leafc_transfer_from_PLT = 0;
	cf->frootc_transfer_from_PLT = 0;
	cf->yieldc_transfer_from_PLT = 0;
	cf->softstemc_transfer_from_PLT = 0;
	cf->STDBc_leaf_to_PLT = 0;				 			 
	cf->STDBc_yield_to_PLT = 0;
	cf->STDBc_froot_to_PLT = 0;	
	cf->STDBc_softstem_to_PLT = 0;	
	cf->leafc_to_THN = 0;
	cf->leafc_storage_to_THN = 0;
	cf->leafc_transfer_to_THN = 0;
	cf->frootc_to_THN = 0;
	cf->frootc_storage_to_THN = 0;
	cf->frootc_transfer_to_THN = 0;
	cf->yieldc_to_THN = 0;
	cf->yieldc_storage_to_THN = 0;
	cf->yieldc_transfer_to_THN = 0;
	cf->livestemc_to_THN = 0;
	cf->livestemc_storage_to_THN = 0;
	cf->livestemc_transfer_to_THN = 0;
	cf->deadstemc_to_THN = 0;
	cf->deadstemc_storage_to_THN = 0;
	cf->deadstemc_transfer_to_THN = 0;
	cf->livecrootc_to_THN = 0;
	cf->livecrootc_storage_to_THN = 0;
	cf->livecrootc_transfer_to_THN = 0;
	cf->deadcrootc_to_THN = 0;
	cf->deadcrootc_storage_to_THN = 0;
	cf->deadcrootc_transfer_to_THN = 0;
	cf->gresp_storage_to_THN = 0;
	cf->gresp_transfer_to_THN = 0;
	cf->THN_to_CTDBc_leaf = 0;
	cf->THN_to_CTDBc_froot = 0;
	cf->THN_to_CTDBc_yield = 0;
	cf->THN_to_CTDBc_cstem = 0;
	cf->THN_to_CTDBc_croot = 0;
	cf->STDBc_leaf_to_THN = 0;
	cf->STDBc_froot_to_THN = 0;
	cf->STDBc_yield_to_THN = 0;
	cf->leafc_to_MOW = 0;
	cf->leafc_storage_to_MOW = 0;
	cf->leafc_transfer_to_MOW = 0;
	cf->yieldc_to_MOW = 0;
	cf->yieldc_storage_to_MOW = 0;
	cf->yieldc_transfer_to_MOW = 0;
	cf->softstemc_to_MOW = 0;
	cf->softstemc_storage_to_MOW = 0;
	cf->softstemc_transfer_to_MOW = 0;
	cf->gresp_storage_to_MOW = 0;
	cf->gresp_transfer_to_MOW = 0;
	cf->MOW_to_CTDBc_leaf = 0;
	cf->MOW_to_CTDBc_yield = 0;
	cf->MOW_to_CTDBc_softstem = 0;
	cf->STDBc_leaf_to_MOW = 0;
	cf->STDBc_yield_to_MOW = 0;
	cf->STDBc_softstem_to_MOW = 0;
	cf->MOW_to_transpC = 0;
	cf->leafc_to_HRV = 0;
	cf->leafc_storage_to_HRV = 0;
	cf->leafc_transfer_to_HRV = 0;
	cf->yieldc_to_HRV = 0;
	cf->yieldc_storage_to_HRV = 0;
	cf->yieldc_transfer_to_HRV = 0;
	cf->softstemc_to_HRV = 0;
	cf->softstemc_storage_to_HRV = 0;
	cf->softstemc_transfer_to_HRV = 0;
	cf->frootc_to_HRV = 0;
	cf->frootc_storage_to_HRV = 0;
	cf->frootc_transfer_to_HRV = 0;
	cf->gresp_storage_to_HRV = 0;
	cf->gresp_transfer_to_HRV = 0;
	cf->HRV_to_CTDBc_leaf = 0;
	cf->HRV_to_CTDBc_softstem = 0;
	cf->HRV_to_CTDBc_yield = 0;
	cf->STDBc_leaf_to_HRV = 0;
	cf->STDBc_yield_to_HRV = 0;
	cf->STDBc_softstem_to_HRV = 0;
	cf->STDBc_froot_to_HRV = 0;
	cf->leafc_to_PLG = 0;
	cf->leafc_storage_to_PLG = 0;
	cf->leafc_transfer_to_PLG = 0;
	cf->frootc_to_PLG = 0;
	cf->frootc_storage_to_PLG = 0;
	cf->frootc_transfer_to_PLG = 0;
	cf->yieldc_to_PLG = 0;
	cf->yieldc_storage_to_PLG = 0;
	cf->yieldc_transfer_to_PLG = 0;
	cf->softstemc_to_PLG = 0;
	cf->softstemc_storage_to_PLG = 0;
	cf->softstemc_transfer_to_PLG = 0;
	cf->gresp_storage_to_PLG = 0;
	cf->gresp_transfer_to_PLG = 0;
	cf->STDBc_leaf_to_PLG = 0;
	cf->STDBc_froot_to_PLG = 0;
	cf->STDBc_yield_to_PLG = 0;
	cf->STDBc_softstem_to_PLG = 0;
	cf->CTDBc_leaf_to_PLG = 0;
	cf->CTDBc_yield_to_PLG = 0;
	cf->CTDBc_softstem_to_PLG = 0;
	cf->leafc_to_GRZ = 0;
	cf->leafc_storage_to_GRZ = 0;
	cf->leafc_transfer_to_GRZ = 0;
	cf->yieldc_to_GRZ = 0;
	cf->yieldc_storage_to_GRZ = 0;
	cf->yieldc_transfer_to_GRZ = 0;
	cf->softstemc_to_GRZ = 0;
	cf->softstemc_storage_to_GRZ = 0;
	cf->softstemc_transfer_to_GRZ = 0;
	cf->gresp_storage_to_GRZ = 0;
	cf->gresp_transfer_to_GRZ = 0;
	cf->STDBc_leaf_to_GRZ = 0;
	cf->STDBc_yield_to_GRZ = 0;
	cf->STDBc_softstem_to_GRZ = 0;
	cf->GRZ_to_litr1c = 0;
	cf->GRZ_to_litr2c = 0;
	cf->GRZ_to_litr3c = 0;
	cf->GRZ_to_litr4c = 0;
	cf->FRZ_to_litr1c = 0;
	cf->FRZ_to_litr2c = 0;
	cf->FRZ_to_litr3c = 0;
	cf->FRZ_to_litr4c = 0;

	cf->cwdc_to_CWE = 0;
	cf->CH4flux_soil = 0;
	cf->CH4flux_manure = 0;
	cf->CH4flux_animal = 0;
	cf->litr1_hr_total = 0;		
	cf->litr2_hr_total = 0;		
	cf->litr4_hr_total = 0;		
	cf->soil1_hr_total = 0;		
	cf->soil2_hr_total = 0;		
	cf->soil3_hr_total = 0;		
	cf->soil4_hr_total = 0;	
		
	cf->litr1c_to_soil1c_total = 0;
	cf->litr2c_to_soil2c_total = 0;
	cf->litr4c_to_soil3c_total = 0;
	cf->litrc_to_soilc_total = 0;						
	cf->cwdc_to_litrc_total = 0;						
	cf->litrc_to_release_total = 0;  
	cf->litr3c_to_litr2c_total = 0;
	cf->soil1c_to_soil2c_total = 0;
	cf->soil2c_to_soil3c_total = 0;
	cf->soil3c_to_soil4c_total = 0;

	cf->orgC_fromFL = 0;


	cf->litrc_from_MUL = 0;
	cf->cwdc_from_MUL = 0;

	nf->m_leafn_to_litr1n = 0;
	nf->m_leafn_to_litr2n = 0;
	nf->m_leafn_to_litr3n = 0;
	nf->m_leafn_to_litr4n = 0;
	nf->m_frootn_to_litr1n = 0;
	nf->m_frootn_to_litr2n = 0;
	nf->m_frootn_to_litr3n = 0;
	nf->m_frootn_to_litr4n = 0;
	nf->m_yieldn_to_litr1n = 0;
	nf->m_yieldn_to_litr2n = 0;
	nf->m_yieldn_to_litr3n = 0;
	nf->m_yieldn_to_litr4n = 0;
	nf->m_softstemn_to_litr1n = 0;
	nf->m_softstemn_to_litr2n = 0;
	nf->m_softstemn_to_litr3n = 0;
	nf->m_softstemn_to_litr4n = 0;
	nf->m_leafn_storage_to_litr1n = 0;
	nf->m_frootn_storage_to_litr1n = 0;
	nf->m_yieldn_storage_to_litr1n = 0;
	nf->m_yieldn_transfer_to_litr1n = 0;
	nf->m_softstemn_storage_to_litr1n = 0;
	nf->m_softstemn_transfer_to_litr1n = 0;
	nf->m_livestemn_storage_to_litr1n = 0;
	nf->m_deadstemn_storage_to_litr1n = 0;
	nf->m_livecrootn_storage_to_litr1n = 0;
	nf->m_deadcrootn_storage_to_litr1n = 0;
	nf->m_leafn_transfer_to_litr1n = 0;
	nf->m_frootn_transfer_to_litr1n = 0;
	nf->m_livestemn_transfer_to_litr1n = 0;
	nf->m_deadstemn_transfer_to_litr1n = 0;
	nf->m_livecrootn_transfer_to_litr1n = 0;
	nf->m_deadcrootn_transfer_to_litr1n = 0;
	nf->m_livestemn_to_litr1n = 0;
	nf->m_livestemn_to_cwdn = 0;
	nf->m_deadstemn_to_cwdn = 0;
	nf->m_livecrootn_to_litr1n = 0;
	nf->m_livecrootn_to_cwdn = 0;
	nf->m_deadcrootn_to_cwdn = 0;
	nf->m_retransn_to_litr1n = 0;
	nf->m_vegn_to_SNSC = 0;
	nf->m_leafn_to_SNSC = 0;
	nf->m_leafn_to_SNSCgenprog = 0;
	nf->m_frootn_to_SNSC = 0;
	nf->m_leafn_storage_to_SNSC = 0;
	nf->m_frootn_storage_to_SNSC = 0;
	nf->m_leafn_transfer_to_SNSC = 0;
	nf->m_frootn_transfer_to_SNSC = 0;
	nf->m_yieldn_to_SNSC = 0;
	nf->m_yieldn_storage_to_SNSC = 0;
	nf->m_yieldn_transfer_to_SNSC = 0;
	nf->m_softstemn_to_SNSC = 0;
	nf->m_softstemn_storage_to_SNSC = 0;
	nf->m_softstemn_transfer_to_SNSC = 0;
	nf->m_retransn_to_SNSC = 0;
	nf->SNSC_to_retrans = 0;
	nf->leafSNSCgenprog_to_retrans = 0;
	nf->leafSNSC_to_retrans = 0;
	nf->frootSNSC_to_retrans = 0;
	nf->yieldSNSC_to_retrans = 0;
	nf->softstemSNSC_to_retrans = 0;
	nf->leaf_transferSNSC_to_retrans = 0;
	nf->froot_transferSNSC_to_retrans = 0;
	nf->yieldc_transferSNSC_to_retrans = 0;
	nf->softstem_transferSNSC_to_retrans = 0;
	nf->leaf_storageSNSC_to_retrans = 0;
	nf->froot_storageSNSC_to_retrans = 0;
	nf->yieldc_storageSNSC_to_retrans = 0;
	nf->softstem_storageSNSC_to_retrans = 0;
	nf->HRV_leafn_storage_to_SNSC = 0;               
	nf->HRV_leafn_transfer_to_SNSC = 0;    
	nf->HRV_yieldn_storage_to_SNSC = 0;              
	nf->HRV_yieldn_transfer_to_SNSC = 0;  
	nf->HRV_frootn_to_SNSC = 0;                           
	nf->HRV_softstemn_to_SNSC = 0;                 
	nf->HRV_frootn_storage_to_SNSC = 0;               
	nf->HRV_frootn_transfer_to_SNSC = 0;               
	nf->HRV_softstemn_storage_to_SNSC = 0;        
	nf->HRV_softstemn_transfer_to_SNSC = 0;       
	nf->HRV_retransn_to_SNSC = 0;
	nf->yieldn_to_flowHS = 0;
	nf->STDBn_leaf_to_litr = 0;
	nf->STDBn_froot_to_litr = 0;
	nf->STDBn_yield_to_litr = 0;
	nf->STDBn_softstem_to_litr = 0;
	nf->STDBn_to_litr = 0;
	nf->CTDBn_leaf_to_litr = 0;
	nf->CTDBn_froot_to_litr = 0;
	nf->CTDBn_yield_to_litr = 0;
	nf->CTDBn_softstem_to_litr = 0;

	nf->CTDBn_cstem_to_cwd = 0;
	nf->CTDBn_croot_to_cwd = 0;
	nf->CTDBn_to_litr = 0;
	nf->m_leafn_to_fire = 0;
	nf->m_frootn_to_fire = 0;
	nf->m_yieldn_to_fire = 0;
	nf->m_softstemn_to_fire = 0;
	nf->m_STDBn_to_fire = 0;
	nf->m_CTDBn_to_fire = 0;
	nf->m_leafn_storage_to_fire = 0;
	nf->m_frootn_storage_to_fire = 0;
	nf->m_yieldn_storage_to_fire = 0;
	nf->m_yieldn_transfer_to_fire = 0;
	nf->m_softstemn_storage_to_fire = 0;
	nf->m_softstemn_transfer_to_fire = 0;
	nf->m_livestemn_storage_to_fire = 0;
	nf->m_deadstemn_storage_to_fire = 0;
	nf->m_livecrootn_storage_to_fire = 0;
	nf->m_deadcrootn_storage_to_fire = 0;
	nf->m_leafn_transfer_to_fire = 0;
	nf->m_frootn_transfer_to_fire = 0;
	nf->m_livestemn_transfer_to_fire = 0;
	nf->m_deadstemn_transfer_to_fire = 0;
	nf->m_livecrootn_transfer_to_fire = 0;
	nf->m_deadcrootn_transfer_to_fire = 0;
	nf->m_livestemn_to_fire = 0;
	nf->m_deadstemn_to_fire = 0;
	nf->m_livecrootn_to_fire = 0;
	nf->m_deadcrootn_to_fire = 0;
	nf->m_retransn_to_fire = 0;
	nf->m_litr1n_to_fire_total = 0;
	nf->m_litr2n_to_fire_total = 0;
	nf->m_litr3n_to_fire_total = 0;
	nf->m_litr4n_to_fire_total = 0;
	nf->m_cwdn_to_fire_total = 0;
	nf->leafn_transfer_to_leafn = 0;
	nf->frootn_transfer_to_frootn = 0;
	nf->yieldn_transfer_to_yieldn = 0;
	nf->softstemn_transfer_to_softstemn = 0;
	nf->livestemn_transfer_to_livestemn = 0;
	nf->deadstemn_transfer_to_deadstemn = 0;
	nf->livecrootn_transfer_to_livecrootn = 0;
	nf->deadcrootn_transfer_to_deadcrootn = 0;
	nf->leafn_to_litr1n = 0;
	nf->leafn_to_litr2n = 0;
	nf->leafn_to_litr3n = 0;
	nf->leafn_to_litr4n = 0;
	nf->leafn_to_retransn = 0;
	nf->frootn_to_litr1n = 0;
	nf->frootn_to_litr2n = 0;
	nf->frootn_to_litr3n = 0;
	nf->frootn_to_litr4n = 0;
	nf->yieldn_to_litr1n = 0;
	nf->yieldn_to_litr2n = 0;
	nf->yieldn_to_litr3n = 0;
	nf->yieldn_to_litr4n = 0;
	nf->softstemn_to_litr1n = 0;
	nf->softstemn_to_litr2n = 0;
	nf->softstemn_to_litr3n = 0;
	nf->softstemn_to_litr4n = 0;
	nf->ndep_to_sminn_total = 0;
	nf->nfix_to_sminn_total = 0;

	nf->litr1n_to_soil1n_total = 0;
	nf->litr2n_to_soil2n_total = 0;
	nf->litr4n_to_soil3n_total = 0;
	nf->litrn_to_soiln_total = 0;
	nf->cwdn_to_litrn_total = 0;                               
	nf->litrn_to_release_total = 0;  
	nf->soil1n_to_soil2n_total = 0;
	nf->soil2n_to_soil3n_total = 0;
	nf->soil3n_to_soil4n_total = 0;

	nf->NO3_to_denitr_total = 0;
	nf->NH4_to_nitrif_total = 0;
	nf->N2fluxDENITR_total = 0;
	nf->N2OfluxNITRIF_total = 0;
	nf->N2OfluxDENITR_total = 0;
	nf->NH4_to_npool_total = 0;
	nf->NO3_to_npool_total = 0;
	nf->sminn_to_npool_total = 0;

	nf->sminN_fromFL = 0;
	nf->orgN_fromFL = 0;


	nf->retransn_to_npool_total = 0;
	nf->npool_to_leafn = 0;
	nf->npool_to_leafn_storage = 0;
	nf->npool_to_frootn = 0;
	nf->npool_to_frootn_storage = 0;
	nf->npool_to_yieldn = 0;
	nf->npool_to_yieldn_storage = 0;
	nf->npool_to_softstemn = 0;
	nf->npool_to_softstemn_storage = 0;
	nf->npool_to_livestemn = 0;
	nf->npool_to_livestemn_storage = 0;
	nf->npool_to_deadstemn = 0;
	nf->npool_to_deadstemn_storage = 0;
	nf->npool_to_livecrootn = 0;
	nf->npool_to_livecrootn_storage = 0;
	nf->npool_to_deadcrootn = 0;
	nf->npool_to_deadcrootn_storage = 0;
	nf->leafn_storage_to_MRdef = 0;
	nf->frootn_storage_to_MRdef = 0;
	nf->yieldn_storage_to_MRdef = 0;
	nf->softstemn_storage_to_MRdef = 0;
	nf->livestemn_storage_to_MRdef = 0;
	nf->livecrootn_storage_to_MRdef = 0;
	nf->deadstemn_storage_to_MRdef = 0;
	nf->deadcrootn_storage_to_MRdef = 0;
	nf->leafn_transfer_to_MRdef = 0;
	nf->frootn_transfer_to_MRdef = 0;
	nf->yieldn_transfer_to_MRdef = 0;
	nf->softstemn_transfer_to_MRdef = 0;
	nf->livestemn_transfer_to_MRdef = 0;
	nf->livecrootn_transfer_to_MRdef = 0;
	nf->deadstemn_transfer_to_MRdef = 0;
	nf->deadcrootn_transfer_to_MRdef = 0;
	nf->leafn_to_MRdef = 0;
	nf->frootn_to_MRdef = 0;
	nf->yieldn_to_MRdef = 0;
	nf->softstemn_to_MRdef = 0;
	nf->livestemn_to_MRdef = 0;
	nf->livecrootn_to_MRdef = 0;
	nf->NSNnw_to_MRdef = 0;
	nf->SNnw_to_MRdef = 0;
	nf->NSNw_to_MRdef = 0;
	nf->SNw_to_MRdef = 0;
	nf->leafn_storage_to_leafn_transfer = 0;
	nf->frootn_storage_to_frootn_transfer = 0;
	nf->livestemn_storage_to_livestemn_transfer = 0;
	nf->deadstemn_storage_to_deadstemn_transfer = 0;
	nf->livecrootn_storage_to_livecrootn_transfer = 0;
	nf->deadcrootn_storage_to_deadcrootn_transfer = 0;
	nf->yieldn_storage_to_yieldn_transfer = 0;
	nf->softstemn_storage_to_softstemn_transfer = 0;
	nf->livestemn_to_deadstemn = 0;
	nf->livestemn_to_retransn = 0;
	nf->livecrootn_to_deadcrootn = 0;
	nf->livecrootn_to_retransn = 0;
	nf->leafn_transfer_from_PLT = 0;
	nf->frootn_transfer_from_PLT = 0;
	nf->yieldn_transfer_from_PLT = 0;
	nf->softstemn_transfer_from_PLT = 0;
	nf->STDBn_leaf_to_PLT = 0;	
	nf->STDBn_froot_to_PLT = 0;	
	nf->STDBn_yield_to_PLT = 0;	
	nf->STDBn_softstem_to_PLT = 0;
	nf->leafn_to_THN = 0;
	nf->leafn_storage_to_THN = 0;
	nf->leafn_transfer_to_THN = 0;
	nf->frootn_to_THN = 0;
	nf->frootn_storage_to_THN = 0;
	nf->frootn_transfer_to_THN = 0;
	nf->yieldn_to_THN = 0;
	nf->yieldn_storage_to_THN = 0;
	nf->yieldn_transfer_to_THN = 0;
	nf->livestemn_to_THN = 0;
	nf->livestemn_storage_to_THN = 0;
	nf->livestemn_transfer_to_THN = 0;
	nf->deadstemn_to_THN = 0;
	nf->deadstemn_storage_to_THN = 0;
	nf->deadstemn_transfer_to_THN = 0;
	nf->livecrootn_to_THN = 0;
	nf->livecrootn_storage_to_THN = 0;
	nf->livecrootn_transfer_to_THN = 0;
	nf->deadcrootn_to_THN = 0;
	nf->deadcrootn_storage_to_THN = 0;
	nf->deadcrootn_transfer_to_THN = 0;
	nf->retransn_to_THN = 0;
	nf->THN_to_CTDBn_leaf = 0;
	nf->THN_to_CTDBn_froot = 0;
	nf->THN_to_CTDBn_yield = 0;
	nf->THN_to_CTDBn_cstem = 0;
	nf->THN_to_CTDBn_croot = 0;
	nf->STDBn_leaf_to_THN = 0;
	nf->STDBn_froot_to_THN = 0;
	nf->STDBn_yield_to_THN = 0;
	nf->leafn_to_MOW = 0;
	nf->leafn_storage_to_MOW = 0;
	nf->leafn_transfer_to_MOW = 0;
	nf->yieldn_to_MOW = 0;
	nf->yieldn_storage_to_MOW = 0;
	nf->yieldn_transfer_to_MOW = 0;
	nf->softstemn_to_MOW = 0;
	nf->softstemn_storage_to_MOW = 0;
	nf->softstemn_transfer_to_MOW = 0;
	nf->MOW_to_CTDBn_leaf = 0;
	nf->MOW_to_CTDBn_yield = 0;
	nf->MOW_to_CTDBn_softstem = 0;
	nf->STDBn_leaf_to_MOW = 0;
	nf->STDBn_yield_to_MOW = 0;
	nf->STDBn_softstem_to_MOW = 0;
	nf->leafn_to_HRV = 0;
	nf->leafn_storage_to_HRV = 0;
	nf->leafn_transfer_to_HRV = 0;
	nf->yieldn_to_HRV = 0;
	nf->yieldn_storage_to_HRV = 0;
	nf->yieldn_transfer_to_HRV = 0;
	nf->softstemn_to_HRV = 0;
	nf->softstemn_storage_to_HRV = 0;
	nf->softstemn_transfer_to_HRV = 0;
	nf->frootn_to_HRV = 0;
	nf->frootn_storage_to_HRV = 0;
	nf->frootn_transfer_to_HRV = 0;
	nf->HRV_to_CTDBn_leaf = 0;
	nf->HRV_to_CTDBn_softstem = 0;
	nf->HRV_to_CTDBn_yield = 0;
	nf->HRV_to_transpN = 0;
	nf->STDBn_leaf_to_HRV = 0;
	nf->STDBn_yield_to_HRV = 0;
	nf->STDBn_softstem_to_HRV = 0;
	nf->STDBn_froot_to_HRV = 0;
	nf->leafn_to_PLG = 0;
	nf->leafn_storage_to_PLG = 0;
	nf->leafn_transfer_to_PLG = 0;
	nf->frootn_to_PLG = 0;
	nf->frootn_storage_to_PLG = 0;
	nf->frootn_transfer_to_PLG = 0;
	nf->yieldn_to_PLG = 0;
	nf->yieldn_storage_to_PLG = 0;
	nf->yieldn_transfer_to_PLG = 0;
	nf->softstemn_to_PLG = 0;
	nf->softstemn_storage_to_PLG = 0;
	nf->softstemn_transfer_to_PLG = 0;
	nf->retransn_to_PLG = 0;
	nf->STDBn_leaf_to_PLG = 0;
	nf->STDBn_froot_to_PLG = 0;
	nf->STDBn_yield_to_PLG = 0;
	nf->STDBn_softstem_to_PLG = 0;
	nf->CTDBn_leaf_to_PLG = 0;
	nf->CTDBn_yield_to_PLG = 0;
	nf->CTDBn_softstem_to_PLG = 0;
	nf->leafn_to_GRZ = 0;
	nf->leafn_storage_to_GRZ = 0;
	nf->leafn_transfer_to_GRZ = 0;
	nf->yieldn_to_GRZ = 0;
	nf->yieldn_storage_to_GRZ = 0;
	nf->yieldn_transfer_to_GRZ = 0;
	nf->softstemn_to_GRZ = 0;
	nf->softstemn_storage_to_GRZ = 0;
	nf->softstemn_transfer_to_GRZ = 0;
	nf->STDBn_leaf_to_GRZ = 0;
	nf->STDBn_yield_to_GRZ = 0;
	nf->STDBn_softstem_to_GRZ = 0;

	nf->retransn_to_GRZ = 0;
	nf->GRZ_to_litr1n = 0;
	nf->GRZ_to_litr2n = 0;
	nf->GRZ_to_litr3n = 0;
	nf->GRZ_to_litr4n = 0;
	nf->FRZ_to_NH4 = 0;
	nf->FRZ_to_NO3 = 0;
	nf->FRZ_to_litr1n = 0;
	nf->FRZ_to_litr2n = 0;
	nf->FRZ_to_litr3n = 0;
	nf->FRZ_to_litr4n = 0;
	nf->N2OfluxGRZ = 0;
	nf->N2OfluxFRZ = 0;
	nf->N2OfluxFRZ_NH4 = 0;
	nf->N2OfluxFRZ_NO3 = 0;

	nf->litrn_from_MUL = 0;
	nf->cwdn_from_MUL = 0;
	nf->cwdn_to_CWE = 0;


	nf->sminn_to_soil1n_l1_total    = 0; 
    nf->sminn_to_soil2n_l2_total    = 0; 
    nf->sminn_to_soil3n_l4_total    = 0; 
    nf->sminn_to_soil2n_s1_total    = 0; 
    nf->sminn_to_soil3n_s2_total    = 0; 
    nf->sminn_to_soil4n_s3_total    = 0; 
	nf->sminn_to_soiln_s4_total     = 0;
	nf->NH4_to_soilSUM_total = 0;
	nf->NO3_to_soilSUM_total = 0;

	nf->minerFlux_LtoS_total = 0;
	nf->minerFlux_StoS_total = 0;
	nf->immobFlux_LtoS_total = 0; 
	nf->immobFlux_StoS_total = 0; 
	nf->environment_to_NH4_total = 0;
	nf->environment_to_NO3_total = 0;

	

	for (layer = 0; layer < N_SOILLAYERS; layer++)
	{
		wf->TRPsoilw[layer] = 0;
		wf->TRPsoilw_demand[layer] = 0;
		wf->soilwFlux[layer] = 0;
		wf->soilwPercol[layer] = 0;
		wf->soilwDiffus[layer] = 0;
		wf->soilwPercolDiffus_fromNORM[layer] = 0;
		wf->GWdischarge[layer] = 0;
		wf->TRPfromGW[layer] = 0;

		cf->cwdc_to_litr2c[layer] = 0;
		cf->cwdc_to_litr3c[layer] = 0;
		cf->cwdc_to_litr4c[layer] = 0;
		cf->litr1_hr[layer] = 0;
		cf->litr1c_to_soil1c[layer] = 0;
		cf->litr2_hr[layer] = 0;
		cf->litr2c_to_soil2c[layer] = 0;
		cf->litr3c_to_litr2c[layer] = 0;
		cf->litr4_hr[layer] = 0;
		cf->litr4c_to_soil3c[layer] = 0;
		cf->soil1_hr[layer] = 0;
		cf->soil1c_to_soil2c[layer] = 0;
		cf->soil2_hr[layer] = 0;
		cf->soil2c_to_soil3c[layer] = 0;
		cf->soil3_hr[layer] = 0;
		cf->soil3c_to_soil4c[layer] = 0;
		cf->soil4_hr[layer] = 0;
		cf->cwdc_to_CWElayer[layer] = 0;

		cf->m_litr1c_to_fire[layer] = 0;  
		cf->m_litr2c_to_fire[layer] = 0;              
		cf->m_litr3c_to_fire[layer] = 0;             
		cf->m_litr4c_to_fire[layer] = 0;          
		cf->m_cwdc_to_fire[layer] = 0;  
		
		cf->litr1c_to_release[layer] = 0;  
		cf->litr2c_to_release[layer] = 0;  
		cf->litr4c_to_release[layer] = 0;  

		nf->m_litr1n_to_fire[layer] = 0;  
		nf->m_litr2n_to_fire[layer] = 0;              
		nf->m_litr3n_to_fire[layer] = 0;             
		nf->m_litr4n_to_fire[layer] = 0;          
		nf->m_cwdn_to_fire[layer] = 0; 
		nf->cwdn_to_litr2n[layer] = 0;
		nf->cwdn_to_litr3n[layer] = 0;
		nf->cwdn_to_litr4n[layer] = 0;
		nf->litr1n_to_soil1n[layer] = 0;
		nf->litr2n_to_soil2n[layer] = 0;
		nf->litr3n_to_litr2n[layer] = 0;
		nf->litr4n_to_soil3n[layer] = 0;
		nf->soil1n_to_soil2n[layer] = 0;
		nf->soil2n_to_soil3n[layer] = 0;
		nf->soil3n_to_soil4n[layer] = 0;
		nf->sminn_to_soilSUM[layer] = 0;
		nf->NH4_to_soilSUM[layer] = 0;
		nf->NO3_to_soilSUM[layer] = 0;
		nf->sminn_to_soil1n_l1[layer] = 0;
		nf->sminn_to_soil2n_l2[layer] = 0;
		nf->sminn_to_soil3n_l4[layer] = 0;
		nf->sminn_to_soil2n_s1[layer] = 0;
		nf->sminn_to_soil3n_s2[layer] = 0;
		nf->sminn_to_soil4n_s3[layer] = 0;
		nf->sminn_to_soiln_s4[layer] = 0;
		nf->NO3_to_denitr[layer] = 0;
		nf->NH4_to_nitrif[layer] = 0;
		nf->N2fluxDENITR[layer] = 0;
		nf->N2OfluxNITRIF[layer] = 0;
		nf->N2OfluxDENITR[layer] = 0;
		nf->NH4_to_npool[layer] = 0;
		nf->NO3_to_npool[layer] = 0;
		nf->sminn_to_npool[layer] = 0;
		nf->retransn_to_npool[layer] = 0;
		nf->ndep_to_NH4[layer] = 0;
		nf->ndep_to_NO3[layer] = 0;
		nf->nfix_to_NH4[layer] = 0;
		nf->litr1n_to_release[layer] = 0;  
		nf->litr2n_to_release[layer] = 0;  
		nf->litr4n_to_release[layer] = 0; 
		nf->minerFlux_StoS[layer] = 0;
		nf->minerFlux_LtoS[layer] = 0;
		nf->environment_to_sminn[layer] = 0;    
		nf->immobFlux_LtoS[layer] = 0; 
		nf->immobFlux_StoS[layer] = 0; 
		nf->grossMINERflux[layer] = 0;
		nf->netMINERflux[layer] = 0;
		nf->actIMMOBflux[layer] = 0;
		nf->potIMMOBflux[layer] = 0;
		nf->cwdn_to_CWElayer[layer] = 0;

		for (dm = 0; dm < N_DISSOLVMATER; dm++)
		{
			soilInfo->dismatLeach[dm][layer] = 0;	
			soilInfo->dismatLeach_percolDiffus[dm][layer] = 0;

			soilInfo->dismatGWrecharge[dm][layer] = 0;
			soilInfo->dismatGWdischarge[dm][layer] = 0;
			soilInfo->dismatGWmovchange[dm][layer] = 0;
			soilInfo->dismatGWdecomp[dm][layer] = 0;
			soilInfo->dismatGWfertil[dm][layer] = 0;
			soilInfo->dismatGWecofunc[dm][layer] = 0;
			soilInfo->dismatUNSATdecomp[dm][layer] = 0;
			soilInfo->dismatUNSATfertil[dm][layer] = 0;
			soilInfo->dismatUNSATecofunc[dm][layer] = 0;
			soilInfo->dismatTOTALdecomp[dm][layer] = 0;
			soilInfo->dismatTOTALfertil[dm][layer] = 0;
			soilInfo->dismatTOTALecofunc[dm][layer] = 0;
		}
		
	}

	soilInfo->dismatGWmovchangeN_total = 0;
	soilInfo->dismatGWecofuncN_total = 0;
	soilInfo->dismatGWdecompN_total = 0;
	soilInfo->dismatGWfertilN_total = 0;
	soilInfo->dismatGWmovchangeC_total = 0;
	soilInfo->dismatGWecofuncC_total = 0;
	soilInfo->dismatGWdecompC_total = 0;
	soilInfo->dismatGWfertilC_total = 0;

	for (dm = 0; dm < N_DISSOLVMATER; dm++)
	{
		soilInfo->dismatLeach_NORMgw[dm] = 0;	
		soilInfo->dismatLeach_NORMcf[dm] = 0;

	}


	summary->litr1HR_total = 0;
	summary->litr2HR_total = 0;
	summary->litr4HR_total = 0;
	summary->soil1HR_total = 0;
	summary->soil2HR_total = 0;
	summary->soil3HR_total = 0;
	summary->soil4HR_total = 0;
	summary->N2Oflux_total = 0;
	summary->N2OfluxCeq = 0;
	summary->CH4fluxCeq = 0;
	summary->NEP = 0;
	summary->NPP = 0;
	summary->NPPabove_w = 0;
	summary->NPPbelow_w = 0;
	summary->NPPabove_nw = 0;
	summary->NPPbelow_nw = 0;
	summary->NEE = 0;
	summary->NBP = 0;
	summary->NGB = 0;
	summary->GPP = 0;
	summary->MR = 0;
	summary->GR = 0;
	summary->HR = 0;
	summary->SR = 0;
	summary->TR = 0;
	summary->fire = 0;
	summary->litfallc = 0;
	summary->litfallc_above = 0;
	summary->litfallc_below = 0;
	summary->mortc = 0;
	summary->mortc_above = 0;
	summary->mortc_below = 0;
	summary->litdecomp = 0;
	summary->litfire = 0;
	summary->CH4flux_total = 0;
	summary->Cflux_lateral = 0;

	summary->GWdischarge_NH4 = 0;
	summary->GWdischarge_NO3 = 0;
	summary->GWdischarge_orgN = 0;
	summary->GWrecharge_NH4 = 0;
	summary->GWrecharge_NO3 = 0;
	summary->GWrecharge_orgN = 0;
	summary->GWbalance = 0;
	summary->GWbalance_NH4 = 0;
	summary->GWbalance_NO3 = 0;
	summary->GWbalance_orgN = 0;


	return (errorCode);
}
