/*
output_map.c
defines an array of pointers to doubles that map to all the intermediate
variables in bgc

*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
Biome-BGCMuSo v7.0.
Original code: Copyright 2000, Peter E. Thornton
Numerical Terradynamic Simulation Group, The University of Montana, USA
Modified code: Copyright 2025, D. Hidy [dori.hidy@gmail.com]
Hungarian Academy of Sciences, Hungary
See the website of Biome-BGCMuSo at http://nimbus.elte.hu/bbgc/ for documentation, model executable and example input files.
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "ini.h"
#include "bgc_struct.h"     /* structure definitions */
#include "bgc_func.h"       /* function prototypes */
#include "bgc_constants.h"


int output_map_init(double** output_map, phenology_struct* phen, metvar_struct* metv, wstate_struct* ws,
	wflux_struct* wf, cstate_struct* cs, cflux_struct* cf, nstate_struct* ns, nflux_struct* nf, 
	soilprop_struct* sprop, epvar_struct* epv, soilInfo_struct* soilInfo, psn_struct* psn_sun, psn_struct* psn_shade, summary_struct* summary)

/*int output_map_init(double** output_map, const phenology_struct* phen, const metvar_struct* metv, const wstate_struct* ws,
	const wflux_struct* wf, const cstate_struct* cs, const cflux_struct* cf, const nstate_struct* ns, const nflux_struct* nf,
	const epvar_struct* epv, const psn_struct* psn_sun, const psn_struct* psn_shade, const summary_struct* summary);*/
{
	int errorCode=0;
	int i;
	
	for (i=0 ; !errorCode && i<NMAP ; i++)
	{
		output_map[i] = NULL;
	}
	
	if (!errorCode)
	{
		output_map[0] = &phen->remdays_curgrowth; //%"Remaining days current growth season" $\\left[n\\right]$ "Az aktulis vegetcis idoszakban htralvo napok szma" $\\left[db\\right]$ "Days left in current growth season" %
		output_map[1] = &phen->remdays_transfer; //%"Remaining days transfer period" $\\left[n\\right]$ "A transzfer idoszakban htralvo napok szma" $\\left[db\\right]$ "Number of transfer days remaining" %
		output_map[2] = &phen->remdays_litfall; //%"Remaining days litterfall" $\\left[n\\right]$ "Fennmarad lombhullsi napok szma" $\\left[db\\right]$ "Number of litterfall days remaining" %
		output_map[3] = &phen->predays_transfer; //%"Previous days transfer period" $\\left[n\\right]$ "Eddigi transzfer napok szma" $\\left[db\\right]$ "Number of transfer days previous" %
		output_map[4] = &phen->predays_litfall; //%"Previous days litterfall" $\\left[n\\right]$ "Eddigi lombhullsi napok szma" $\\left[db\\right]$ "Number of litterfall days previous" %
		output_map[5] = &phen->n_growthday; //%"Number of growing days" $\\left[n\\right]$ "Nvekedsi napok szma" $\\left[db\\right]$ "Number of growing days in actual simulation year" %
		output_map[6] = &phen->n_transferday; //%"Number of transfer days" $\\left[n\\right]$ "Transzfer napok szma" $\\left[db\\right]$ "Number of transfer days in actual simulation year" %
		output_map[7] = &phen->n_litfallday; //%"Number of litterfall days" $\\left[n\\right]$ "Lombhullsi napok szma" $\\left[db\\right]$ "Number of litterfall days in actual simulation year" %
		output_map[8] = &phen->yday_total; //%"Counter for simdays of the whole simulation" $\\left[dimless\\right]$ "Napszmll a teljes futtatsra vonatkozan" $\\left[dimless\\right]$ "Counter for simdays of the whole simulation" %
		output_map[9] = &phen->phpsl_dev_rate; //%"Photoslowing effect rel. development" $\\left[dimless\\right]$ "Fotoperiodikus limitci fejlodsi arnyszma" $\\left[dimless\\right]$ "Relative development rate of photoslowing effect" %
		output_map[10] = &phen->vern_dev_rate; //%"Vernalization rel. development" $\\left[dimless\\right]$ "Vernalizci limitci fejlodsi arnyszma" $\\left[dimless\\right]$ "Relative development rate of vernalization" %
		output_map[11] = &phen->vern_days; //%"Vernalization days" $\\left[n\\right]$ "Vernalizcis napok szma" $\\left[db\\right]$ "Number of vernalization days" %
		output_map[12] = &phen->GDD_limit; //%"Lower limit of GDD in given phen.phase" $\\left[Celsius\\right]$ "Hsszeg als hatra adott fenofzisban" $\\left[Celsius\\right]$ "Lower limit of growing degree Days in the given phen.phase" %
		output_map[13] = &phen->GDD_crit[0]; //%"Critical GDD phen.phase 1" $\\left[Celsius\\right]$ "Hsszeg kritikus rtke az 1. fenofzisban" $\\left[Celsius\\right]$ "Critical growing degree Day at the beginning of phen.phase 1" %
		output_map[14] = &phen->GDD_crit[1]; //%"Critical GDD phen.phase 2" $\\left[Celsius\\right]$ "Hsszeg kritikus rtke a 2. fenofzisban" $\\left[Celsius\\right]$ "Critical growing degree Day at the beginning of phen.phase 2" %
		output_map[15] = &phen->GDD_crit[2]; //%"Critical GDD phen.phase 3" $\\left[Celsius\\right]$ "Hsszeg kritikus rtke a 3. fenofzisban" $\\left[Celsius\\right]$ "Critical growing degree Day at the beginning of phen.phase 3" %
		output_map[16] = &phen->GDD_crit[3]; //%"Critical GDD phen.phase 4" $\\left[Celsius\\right]$ "Hsszeg kritikus rtke a 4. fenofzisban" $\\left[Celsius\\right]$ "Critical growing degree Day at the beginning of phen.phase 4" %
		output_map[17] = &phen->GDD_crit[4]; //%"Critical GDD phen.phase 5" $\\left[Celsius\\right]$ "Hsszeg kritikus rtke az 5. fenofzisban" $\\left[Celsius\\right]$ "Critical growing degree Day at the beginning of phen.phase 5" %
		output_map[18] = &phen->GDD_crit[5]; //%"Critical GDD phen.phase 6" $\\left[Celsius\\right]$ "Hsszeg kritikus rtke a 6. fenofzisban" $\\left[Celsius\\right]$ "Critical growing degree Day at the beginning of phen.phase 6" %
		output_map[19] = &phen->GDD_crit[6]; //%"Critical GDD phen.phase 7" $\\left[Celsius\\right]$ "Hsszeg kritikus rtke a 7. fenofzisban" $\\left[Celsius\\right]$ "Critical growing degree Day at the beginning of phen.phase 7" %
		output_map[20] = &phen->GDD_emergSTART; //%"GDD at start of emergence period" $\\left[Celsius\\right]$ "Hsszeg a kikels elejn" $\\left[Celsius\\right]$ "Start of emergence period" %
		output_map[21] = &phen->GDD_emergEND; //%"GDD at end of emergence period" $\\left[Celsius\\right]$ "Hsszeg a kikels vgn" $\\left[Celsius\\right]$ "End of emergence period" %
		output_map[22] = &phen->ondayANN; //%"Actual onday value" $\\left[dimless\\right]$ "Aktulis vegetcis peridus kezedeti nap" $\\left[dimless\\right]$ "Actual onday value (-1: dormant period)" %
		output_map[23] = &phen->offdayANN; //%"Actual offday value" $\\left[dimless\\right]$ "Aktulis nyugalmi peridus kezedeti nap" $\\left[dimless\\right]$ "Actual offday value (-1: dormant period)" %
		output_map[24] = &phen->planttype; //%"Plant type (maize:1,wheat:2,barley:3,...)" $\\left[dimless\\right]$ "Nvnytpus (kukorica:1,bza:2,rpa:3,napraforg:4,repce:5, gyep:6)" $\\left[dimless\\right]$ "Plant type" %
		output_map[25] = &phen->Tmin_index; //%"Part index of GSI" $\\left[dimless\\right]$ "A GSI index rszindexe" $\\left[dimless\\right]$ "Part index of GSI" %
		output_map[26] = &phen->vpd_index; //%"Part index of GSI" $\\left[dimless\\right]$ "A GSI index rszindexe" $\\left[dimless\\right]$ "Part index of GSI" %
		output_map[27] = &phen->dayl_index; //%"Part index of GSI" $\\left[dimless\\right]$ "A GSI index rszindexe" $\\left[dimless\\right]$ "Part index of GSI" %
		output_map[28] = &phen->gsi_indexAVG; //%"Part index of GSI" $\\left[dimless\\right]$ "A GSI index rszindexe" $\\left[dimless\\right]$ "Part index of GSI" %
		output_map[29] = &phen->heatsum_index; //%"Part index of GSI" $\\left[dimless\\right]$ "A GSI index rszindexe" $\\left[dimless\\right]$ "Part index of GSI" %
		output_map[30] = &phen->heatsum; //%"n-day heatsum" $\\left[Celsius\\right]$ "n napos Hsszeg" $\\left[dimless\\right]$ "n-day heatsum" %
	
		output_map[40] = &metv->Tacclim; //%"Acclimation temperature" $\\left[Celsius\\right]$ "Akklimcis homrsklet" $\\left[Celsius\\right]$ "Acclimation temperature" %
        output_map[41] = &metv->Tnight; //%"Nighttime temperature" $\\left[Celsius\\right]$ "jszakai homrsklet" $\\left[Celsius\\right]$ "Nighttime average air temperature" %
        output_map[42] = &metv->TavgRA11; //%"11-day running average temperature" $\\left[Celsius\\right]$ "11 napos mozg tlaghomrsklet" $\\left[Celsius\\right]$ "11-day running average air temperature (linear weighted)" %
        output_map[43] = &metv->TavgRA10; //%"10-day running average temperature" $\\left[Celsius\\right]$ "10 napos mozg tlaghomrsklet" $\\left[Celsius\\right]$ "10-day running average air temperature (linear weighted)" %
        output_map[44] = &metv->TavgRA30; //%"30-day running average temperature" $\\left[Celsius\\right]$ "30 napos mozg tlaghomrsklet" $\\left[Celsius\\right]$ "30-day running average air temperature (linear weighted)" %
        output_map[45] = &metv->tempradF; //%"Soil temperature factor (air temperature and radiation)" $\\left[dimless\\right]$ "Talajhomrsklet faktor (lghomrsklet s sugrzs)" $\\left[dimless\\right]$ "Soil temperature factor of radiation and air temperature" %
        output_map[46] = &metv->tempradFra; //%"5-day running average soil temperature factor" $\\left[dimless\\right]$ "5 napos mozg tlag talajhomrsklet faktor" $\\left[dimless\\right]$ "5-day running avg soil temperature factor" %
        output_map[47] = &metv->Tsoil_surface; //%"Soil surface temperature" $\\left[Celsius\\right]$ "Talajfelszn homrsklet" $\\left[Celsius\\right]$ "Daily soil surface temperature" %
        output_map[48] = &metv->Tsoil_top_change; //%"Change of surface soil temperature based on empirical function for Tair changing" $\\left[Celsius\\right]$ "A talajfeszn hmrskletnek vltozsa (empirikus becsls) " $\\left[Celsius\\right]$ "change of surface soil temperature" %
        output_map[49] = &metv->Tsoil_avg; //%"Average soil temperature" $\\left[Celsius\\right]$ "Talaj tlaghomrsklet" $\\left[Celsius\\right]$ "Average soil temperature" %
        output_map[50] = &metv->Tsoil[0]; //%"Daily temperature of soil layer 1 (0 - 3 cm)" $\\left[Celsius\\right]$ "Az 1. talajrteg (0 - 3 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 1 (0 - 3 cm)" %
        output_map[51] = &metv->Tsoil[1]; //%"Daily temperature of soil layer 2 (3 - 10 cm)" $\\left[Celsius\\right]$ "A 2. talajrteg (3 - 10 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 2 (3 - 10 cm)" %
        output_map[52] = &metv->Tsoil[2]; //%"Daily temperature of soil layer 3 (10 - 30 cm cm)" $\\left[Celsius\\right]$ "A 3. talajrteg (10 - 30 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 3 (10 - 30 cm cm)" %
        output_map[53] = &metv->Tsoil[3]; //%"Daily temperature of soil layer 4 (30 - 60 cm)" $\\left[Celsius\\right]$ "Az 4. talajrteg (30 - 60 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 4 (30 - 60 cm)" %
        output_map[54] = &metv->Tsoil[4]; //%"Daily temperature of soil layer 5 (60 - 90 cm)" $\\left[Celsius\\right]$ "Az 5. talajrteg (60 - 90 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 5 (60 - 90 cm)" %
        output_map[55] = &metv->Tsoil[5]; //%"Daily temperature of soil layer 6 (90 - 120 cm)" $\\left[Celsius\\right]$ "A 6. talajrteg (90 - 120 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 6 (90 - 120 cm)" %
        output_map[56] = &metv->Tsoil[6]; //%"Daily temperature of soil layer 7 (120 - 150 cm)" $\\left[Celsius\\right]$ "A 7. talajrteg (120 - 150 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 7 (120 - 150 cm)" %
        output_map[57] = &metv->Tsoil[7]; //%"Daily temperature of soil layer 8 (150 - 200 cm)" $\\left[Celsius\\right]$ "A 8. talajrteg (150 - 200 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 8 (150 - 200 cm)" %
        output_map[58] = &metv->Tsoil[8]; //%"Daily temperature of soil layer 9 (200 - 400 cm)" $\\left[Celsius\\right]$ "A 9. talajrteg (200 - 400 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 9 (200 - 400 cm)" %
        output_map[59] = &metv->Tsoil[9]; //%"Daily temperature of soil layer 10 (400 - 1000 cm)" $\\left[Celsius\\right]$ "A 10. talajrteg (400-1000 cm) homrsklete" $\\left[Celsius\\right]$ "Daily temperature of soil layer 10 (400 - 1000 cm)" %
        output_map[60] = &metv->swRADnet; //%"Net shortwave radiation" $\\left[\\Wm^{-2}\\right]$ "Nett rvidhullm sugrzs" $\\left[\\Wm^{-2}\\right]$ "Net shortwave radiation" %
        output_map[61] = &metv->lwRADnet; //%"Net outgoing longwave radiation" $\\left[\\Wm^{-2}\\right]$ "Nett hosszhullm kisugrzs" $\\left[\\Wm^{-2}\\right]$ "Net longwave outgoing radiation" %
        output_map[62] = &metv->RADnet; //%"Daylight average net radiation flux" $\\left[\\Wm^{-2}\\right]$ "tlagos nappali sugrzsi fluxus" $\\left[\\Wm^{-2}\\right]$ "Daylight average net radiation flux" %
        output_map[63] = &metv->RADnet_per_plaisun; //%"Daylight avg. net radiation flux sunlit proj. leaf area index" $\\left[\\Wm^{-2}\\right]$ " Napos levlfelleti index egysgre vettett nappali tlagos nett sugrzsi fluxus" $\\left[\\Wm^{-2}\\right]$ "Daylight average net radiation flux per unit sunshade proj leaf area index" %
        output_map[64] = &metv->RADnet_per_plaishade; //%"Daylight avg. net radiation flux sunlit proj. leaf area index" $\\left[\\Wm^{-2}\\right]$ " Napos levlfelleti index egysgre vettett nappali tlagos nett sugrzsi fluxus" $\\left[\\Wm^{-2}\\right]$ "Daylight average net radiation flux per unit sunshade proj leaf area index" %
        output_map[65] = &metv->swavgfd; //%"Daylight average shortwave flux" $\\left[\\Wm^{-2}\\right]$ "tlagos nappali rvidhullm fluxus" $\\left[\\Wm^{-2}\\right]$ "Daylight average shortwave flux" %
        output_map[66] = &metv->swabs; //%"Canopy absorbed shortwave flux" $\\left[\\Wm^{-2}\\right]$ "A lombkorona ltal abszorbelt rvidhullm fluxus" $\\left[\\Wm^{-2}\\right]$ "Canopy absorbed shortwave flux" %
        output_map[67] = &metv->swtrans; //%"Transmitted shortwave flux" $\\left[\\Wm^{-2}\\right]$ "Transzmittlt rvidhullm fluxus" $\\left[\\Wm^{-2}\\right]$ "Transmitted shortwave flux" %
        output_map[68] = &metv->swabs_per_plaisun; //%"Canopy absorbed shortwave flux sunlit prof. leaf area index" $\\left[\\Wm^{-2}\\right]$ "Napos levlfelleti index egysgre vettett lombkorona ltal elnyelt rvidhullm fluxus" $\\left[\\Wm^{-2}\\right]$ "Canopy absorbed shortwave flux per unit sunlit proj leaf area index" %
        output_map[69] = &metv->swabs_per_plaishade; //%"Canopy absorbed shortwave flux sunshade prof. leaf area index" $\\left[\\Wm^{-2}\\right]$ "rnykos levlfelleti index egysgre vettett lombkorona ltal elnyelt rvidhullm fluxus" $\\left[\\Wm^{-2}\\right]$ "Canopy absorbed shortwave flux per unit sunshade proj leaf area index" %
        output_map[70] = &metv->ppfd_per_plaisun; //%"PPFD sunlit proj. leaf area index" $\\left[\\molm^{-2}s^{-1}\\right]$ "Napos levlfelleti index egysgre vettett PPFD" $\\left[\\molm^{-2}s^{-1}\\right]$ "Photosynthetic photon flux density per unit sunlit proj leaf area index" %
        output_map[71] = &metv->ppfd_per_plaishade; //%"PPFD sunshade proj. leaf area index" $\\left[\\molm^{-2}s^{-1}\\right]$ "rnykos levlfelleti index egysgre vettett PPFD" $\\left[\\molm^{-2}s^{-1}\\right]$ "Photosynthetic photon flux density per unit sunshade proj leaf area index" %
        output_map[72] = &metv->parabs; //%"Canopy absorbed PAR" $\\left[\\Wm^{-2}\\right]$ "A lombkorona ltal abszorbelt PAR" $\\left[\\Wm^{-2}\\right]$ "Photosynthetically active radiation absorbed by canopy" %
        output_map[73] = &metv->parabs_plaisun; //%"PAR absorbed by sunlit canopy fraction" $\\left[\\Wm^{-2}\\right]$ "A lomkorona napos rsze ltal abszorbelt PAR" $\\left[\\Wm^{-2}\\right]$ "Photosynthetically active radiation absorbed by sunlit canopy fraction" %
        output_map[74] = &metv->parabs_plaishade; //%"PAR absorbed by sunshade canopy fraction" $\\left[\\Wm^{-2}\\right]$ "A lomkorona rnykos rsze ltal abszorbelt PAR" $\\left[\\Wm^{-2}\\right]$ "Photosynthetically active radiation absorbed by sunshade canopy fraction" %
        output_map[75] = &metv->GDD; //%"GDD" $\\left[Celsius\\right]$ "Hsszeg" $\\left[Celsius\\right]$ "growing degree day" %
        output_map[76] = &metv->GDD_wMOD; //%"GDD modified by vern. and photop. effect" $\\left[Celsius\\right]$ "Mdostott Hsszeg (vernalizcival s fotop. lasstssal)" $\\left[Celsius\\right]$  %
       	output_map[77] = &metv->annTavgRA; //%"10-year running average of mean annual air temperature " $\\left[Celsius\\right]$ "Az ves tlaghmrsklet 10 ves mozgtlaga" $\\left[Celsius\\right]$ "10-year running average of mean annual air temperature " %
        output_map[78] = &metv->annTrangeRA; //%"10-year running average of mean annual air temperature range" $\\left[Celsius\\right]$ "Az ves lghmrskleti tartomny 10 ves mozgtlaga" $\\left[Celsius\\right]$ "10-year running average of mean annual air temperature range" %
		output_map[79] = &metv->pa; //%"Atmospheric pressure" $\\left[Pa\\right]$ "Lgnyoms" $\\left[Pa\\right]$ "Atmospheric pressure" %
  
		output_map[80] = &ws->soilw[0]; //%"SWC of soil layer 1 (0 - 3 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Az 1. talajrteg (0 - 3 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 1 (0 - 3 cm)" %
        output_map[81] = &ws->soilw[1]; //%"SWC of soil layer 2 (3 - 10 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 2. talajrteg (3 - 10 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 2 (3 - 10 cm)" %
        output_map[82] = &ws->soilw[2]; //%"SWC of soil layer 3 (10 - 30 cm cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 3. talajrteg (10 - 30 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 3 (10 - 30 cm cm)" %
        output_map[83] = &ws->soilw[3]; //%"SWC of soil layer 4 (30 - 60 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Az 4. talajrteg (30 - 60 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 4 (30 - 60 cm)" %
        output_map[84] = &ws->soilw[4]; //%"SWC of soil layer 5 (60 - 90 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Az 5. talajrteg (60 - 90 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 5 (60 - 90 cm)" %
        output_map[85] = &ws->soilw[5]; //%"SWC of soil layer 6 (90 - 120 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 6. talajrteg (90 - 120 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 6 (90 - 120 cm)" %
        output_map[86] = &ws->soilw[6]; //%"SWC of soil layer 7 (120 - 150 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 7. talajrteg (120 - 150 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 7 (120 - 150 cm)" %
        output_map[87] = &ws->soilw[7]; //%"SWC of soil layer 8 (150 - 200 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 8. talajrteg (150 - 200 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 8 (150 - 200 cm)" %
        output_map[88] = &ws->soilw[8]; //%"SWC of soil layer 9 (200 - 400 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 9. talajrteg (200 - 400 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 9 (200 - 400 cm)" %
        output_map[89] = &ws->soilw[9]; //%"SWC of soil layer 10 (400 - 1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Soil water content of soil layer 10 (400 - 1000 cm)" %
        output_map[90] = &ws->soilw_SUM; //%"SWC" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A talaj nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water stored in soil" %
        output_map[91] = &ws->pondw; //%"Pond water" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Lecsapdsbl eredo felszni vztartalom" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Water stored on surface because of saturation" %
        output_map[92] = &ws->snoww; //%"Snow water" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A htakar vztartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Water stored in snowpack" %
        output_map[93] = &ws->canopyw; //%"Canopy water" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A lombkoronn trolt vz" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Water stored on canopy" %
        output_map[94] = &ws->prcp_src; //%"Precipitation" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Csapadk" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of precipitation" %
        output_map[95] = &ws->soilEVP_snk; //%"Soil water evaporation" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Talajnedvessg prolgs" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of soil water evaporation" %
        output_map[96] = &ws->snowSUBL_snk; //%"Snow sublimation" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "H szublimci" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of snow water sublimation" %
        output_map[97] = &ws->EVPcanopyw_snk; //%"Canopy evaporation" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Prolgs a lomkoronrl" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of canopy water evaporation" %
        output_map[98] = &ws->pondEVP_snk; //%"Pond water decrease" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Tcsa cskkense" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of pond water decrease" %
        output_map[99] = &ws->TRP_snk; //%"transpiration" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Transpirci" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of transpiration" %    
		output_map[100] = &ws->runoff_snk; //%"Runoff" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Lefolys" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of runoff" %
        output_map[101] = &ws->deeppercolation_snk; //%"Deep percolation" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A rendszerbol elszivrg vzmennyisg" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of percolated water out of the system" %
        output_map[102] = &ws->GWsrc_W; //%"Water plus from groundwater" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A talajvzbl szrmaz vztbblet" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water plus from groundwater" %
        output_map[103] = &ws->GWsnk_W;        //%"SUM of water loss to groundwater (recharge)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A talajvzbe tvoz vzvesztesg" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water loss to groundwater" %
        output_map[104] = &ws->FLsrc_W;       //%"Water plus from flooding" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Az elrasztsbl szrmaz tbbletvz" $\\left[\\n\\right]$ "Water plus from flooding" %
        output_map[105] = &ws->condIRGsrc;     //%"Cumulative amount of conditional irrigation" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A feltteles ntzs mennyisge" $\\left[\\n\\right]$ "Amount of conditional irrigation" %
        output_map[106] = &ws->IRGsrc_W; //%"Water income from irrigation" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "ntzsbol szrmaz vztbblet" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ " "SUM of water from irrigation" %
        output_map[107] = &ws->FRZsrc_W; //%"Water income from fertilizers" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Trgyzsbl szrmaz vztbblet" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ " "SUM of water from fertilization" %
        output_map[108] = &ws->canopyw_THNsnk; //%"Canopy water loss thinning" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Lomkoronn trolt vzvesztesg ritkts miatt" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ " SUM of water stored on canopy is disappered because of thinning" %
        output_map[109] = &ws->canopyw_MOWsnk; //%"Canopy water loss mowing" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Lombkoronn trolt vzvesztesg kaszls miatt" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ " SUM of water stored on canopy is disappered because of mowing" %
        output_map[110] = &ws->canopyw_HRVsnk; //%"Canopy water loss harvesting" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Lombkoronn trolt vzvesztesg arats miatt" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water stored on canopy is disappered because of harvesting" %
        output_map[111] = &ws->canopyw_PLGsnk; //%"Canopy water loss ploughing" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Lombkoronn trolt vzvesztesg sznts miatt" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water stored on canopy is disappered because of ploughing" %
        output_map[112] = &ws->canopyw_GRZsnk; //%"Canopy water loss grazing" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Lombkoronn trolt vzvesztesg legeltets miatt" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ " SUM of water stored on canopy is disappered because of grazing" %
        output_map[113] = &ws->WbalanceERR; //%"Water balance error" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A vzmrleg hibja" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ " ""SUM of water balance error" %
        output_map[114] = &ws->inW; //%"SUM of water input" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Vzbevtel sszege" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water input" %
        output_map[115] = &ws->outW; //%"SUM of water output" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Vzvesztesg sszege" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water output" %
        output_map[116] = &ws->storeW; //%"SUM of water storage" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Vztrozs sszege" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water storage" %
        output_map[117] = &ws->EVPsurface1cum; //%"Cumulated soil evaporation in first evaporation phase (no limit)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Kumullt talajprolgs az elso prolgsi szakaszban" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Cumulated soil evaporation in first evaporation phase (no limit)" %
        output_map[118] = &ws->EVPsurface2cum; //%"Cumulated soil evaporation in second evaporation phase (DSR limit)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Vztrozs sszege" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Cumulated soil evaporation in second evaporation phase (DSR limit)" %
		output_map[119] = &ws->soilw_2m; //%"SWC in 0-2 m" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A talaj nedvessgtartalma a 0-2 mteres rtegben" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water stored in soil (0-2m)" %
		output_map[120] = &ws->soilw_RZ; //%"SWC in rootzone" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A talaj nedvessgtartalma a gykrznban" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water stored in rootzone" %
		output_map[121] = &ws->soilwAVAIL_RZ; //%"SWC in rootzone available for plants" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A talaj hozzfrhet nedvessgtartalma a gykrznban" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "SUM of water stored in rootzone available for plants" %
		output_map[122] = &ws->soilwAVAIL[0]; //%"Available soil water 1 (0 - 3 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Az 1. talajrteg (0 - 3 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 1 (0 - 3 cm)" %
        output_map[123] = &ws->soilwAVAIL[1]; //%"Available soil water 2 (3 - 10 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 2. talajrteg (3 - 10 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 2 (3 - 10 cm)" %
        output_map[124] = &ws->soilwAVAIL[2]; //%"Available soil water 3 (10 - 30 cm cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 3. talajrteg (10 - 30 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 3 (10 - 30 cm cm)" %
        output_map[125] = &ws->soilwAVAIL[3]; //%"Available soil water 4 (30 - 60 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Az 4. talajrteg (30 - 60 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 4 (30 - 60 cm)" %
        output_map[126] = &ws->soilwAVAIL[4]; //%"Available soil water 5 (60 - 90 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Az 5. talajrteg (60 - 90 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 5 (60 - 90 cm)" %
        output_map[127] = &ws->soilwAVAIL[5]; //%"Available soil water 6 (90 - 120 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 6. talajrteg (90 - 120 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 6 (90 - 120 cm)" %
        output_map[128] = &ws->soilwAVAIL[6]; //%"Available soil water 7 (120 - 150 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 7. talajrteg (120 - 150 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 7 (120 - 150 cm)" %
        output_map[129] = &ws->soilwAVAIL[7]; //%"Available soil water 8 (150 - 200 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 8. talajrteg (150 - 200 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 8 (150 - 200 cm)" %
        output_map[130] = &ws->soilwAVAIL[8]; //%"Available soil water 9 (200 - 400 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 9. talajrteg (200 - 400 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 9 (200 - 400 cm)" %
        output_map[131] = &ws->soilwAVAIL[9]; //%"Available soil water 10 (400 - 1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) hozzfrhet nedvessgtartalma" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Available soil water of soil layer 10 (400 - 1000 cm)" %
        output_map[132] = &ws->Wprec_snk; //%"SUM of W lost to precision control" $\\left[\\kg_{H2O}m^{-2} \\right]$
  
		output_map[150] = &wf->prcp_to_canopyw; //%"Interception on canopy" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Intercepci a lombkoronn" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ " Interception on canopy" %
        output_map[151] = &wf->prcp_to_soilSurface; //%"Precipitation entering soilwater pool" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "A talajvz trozba jut csapadk" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Precipitation entering soilwater pool" %
        output_map[152] = &wf->prcp_to_snoww; //%"Snowpack accumulation" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Htakar felhalmozdsa" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Snowpack accumulation" %
        output_map[153] = &wf->prcp_to_runoff; //%"Hortonian runoff flux" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Hortoni elfolys fluxus" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Hortonian runoff flux" %
        output_map[154] = &wf->EVPcanopyw; //%"evaporation from canopy" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Prolgs a lombkoronrl" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "evaporation from canopy" %
        output_map[155] = &wf->canopyw_to_soilw; //%"Canopy drip and stemflow" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Csepegs a lombkoronrl s a szron lefoly csapadk" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Canopy drip and stemflow" %
        output_map[156] = &wf->EVPpondw; //%"Pond water evaporation" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Felszni vztkr prolgsa" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Pond water evaporation" %
        output_map[157] = &wf->SUBLsnoww; //%"Sublimation from snowpack" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Szublimci a htakarbl" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Sublimation from snowpack" %
        output_map[158] = &wf->snoww_to_soilw; //%"Melt from snowpack" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Holvads" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Melt from snowpack" %
        output_map[159] = &wf->EVPsoilw; //%"evaporation from soil" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajprolgs" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "evaporation from soil" %
        output_map[160] = &wf->TRPsoilw[0]; //%"transpiration from soil layer 1 (0 - 3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci az 1. talajrtegbol (0 - 3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 1 (0 - 3 cm)" %
        output_map[161] = &wf->TRPsoilw[1]; //%"transpiration from soil layer 2 (3 - 10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 2. talajrtegbol (3 - 10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 2 (3 - 10 cm)" %
        output_map[162] = &wf->TRPsoilw[2]; //%"transpiration from soil layer 3 (10 - 30 cm cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 3. talajrtegbol (10 - 30 cm cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 3 (10 - 30 cm cm)" %
        output_map[163] = &wf->TRPsoilw[3]; //%"transpiration from soil layer 4 (30 - 60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 4. talajrtegbol (30 - 60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 4 (30 - 60 cm)" %
        output_map[164] = &wf->TRPsoilw[4]; //%"transpiration from soil layer 5 (60 - 90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci az 5. talajrtegbol (60 - 90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 5 (60 - 90 cm)" %
        output_map[165] = &wf->TRPsoilw[5]; //%"transpiration from soil layer 6 (90 - 120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 6. talajrtegbol (90 - 120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 6 (90 - 120 cm)" %
        output_map[166] = &wf->TRPsoilw[6]; //%"transpiration from soil layer 7 (120 - 150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 7. talajrtebol (120 - 150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 7 (120 - 150 cm)" %
        output_map[167] = &wf->TRPsoilw[7]; //%"transpiration from soil layer 8 (150 - 200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 8. talajrtegbol (150 - 200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 8 (150 - 200 cm)" %
        output_map[168] = &wf->TRPsoilw[8]; //%"transpiration from soil layer 9 (200 - 400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 9. talajrtegbol (200 - 400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 9 (200 - 400 cm)" %
        output_map[169] = &wf->TRPsoilw[9]; //%"transpiration from soil layer 10 (400 - 1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 10. talajrtegbol (400 - 1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 10 (400 - 1000 cm)" %
        output_map[170] = &wf->TRPsoilw_SUM; //%"SUM of transpiration from the soil layers" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "A talajrtegekbol trtno Transpirci sszege" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ " ""SUM of transpiration from the soil layers" %
        output_map[171] = &wf->ET; //%"evapotranspiration (EVP+TRP+subl)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "ETirci (EVPorci + Transpirci + szublimci)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "evapotranspiration (evaporation+transpiration+sublimation)" %
        output_map[172] = &wf->pondw_to_soilw; //%"Water flux from pond to soil" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Vzmozgs a felszni vztkrrol a talajba" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water flux from pond to soil" %
        output_map[173] = &wf->soilw_to_pondw; //%"Water flux from soil to pond" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Vzmozgs a talajbl a felszni vztkrbe" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water flux from soil to pond" %
        output_map[174] = &wf->soilwFlux[0]; //%"Soil water flux in soil layer 1 (0-3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 1 (0-3 cm)" %
        output_map[175] = &wf->soilwFlux[1]; //%"Soil water flux in soil layer 2 (3-10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 2 (3-10 cm)" %
        output_map[176] = &wf->soilwFlux[2]; //%"Soil water flux in soil layer 3 (10-30 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 3 (10-30 cm)" %
        output_map[177] = &wf->soilwFlux[3]; //%"Soil water flux in soil layer 4 (30-60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 4 (30-60 cm)" %
        output_map[178] = &wf->soilwFlux[4]; //%"Soil water flux in soil layer 5 (60-90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa a 5. talajrtegben (60-90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 5 (60-90 cm)" %
        output_map[179] = &wf->soilwFlux[5]; //%"Soil water flux in soil layer 6 (90-120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 6 (90-120 cm)" %
        output_map[180] = &wf->soilwFlux[6]; //%"Soil water flux in soil layer 7 (120-150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 7 (120-150 cm)" %
        output_map[181] = &wf->soilwFlux[7]; //%"Soil water flux in soil layer 8 (150-200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 8 (150-200 cm)" %
        output_map[182] = &wf->soilwFlux[8]; //%"Soil water flux in soil layer 9 (200-400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 9 (200-400 cm)" %
        output_map[183] = &wf->soilwFlux[9]; //%"Soil water flux in soil layer 10 (400-1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajnedvessg fluxusa a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water flux in soil layer 10 (400-1000 cm)" %

        output_map[194] = &wf->GWdischarge[0]; //%"Soil water change due to the movement of groundwater table in soil layer 1 (0-3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 1 (0-3 cm)" %
        output_map[195] = &wf->GWdischarge[1]; //%"Soil water change due to the movement of groundwater table in soil layer 2 (3-10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater tablein soil layer 2 (3-10 cm)" %
        output_map[196] = &wf->GWdischarge[2]; //%"Soil water change due to the movement of groundwater table in soil layer 3 (10-30 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 3 (10-30 cm)" %
        output_map[197] = &wf->GWdischarge[3]; //%"Soil water change due to the movement of groundwater table in soil layer 4 (30-60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 4 (30-60 cm)" %
        output_map[198] = &wf->GWdischarge[4]; //%"Soil water change due to the movement of groundwater table in soil layer 5 (60-90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs a 5. talajrtegben (60-90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 5 (60-90 cm)" %
        output_map[199] = &wf->GWdischarge[5]; //%"Soil water change due to the movement of groundwater table in soil layer 6 (90-120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 6 (90-120 cm)" %
        output_map[200] = &wf->GWdischarge[6]; //%"Soil water change due to the movement of groundwater table in soil layer 7 (120-150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 7 (120-150 cm)" %
        output_map[201] = &wf->GWdischarge[7]; //%"Soil water change due to the movement of groundwater table in soil layer 8 (150-200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 8 (150-200 cm)" %
        output_map[202] = &wf->GWdischarge[8]; //%"Soil water change due to the movement of groundwater table in soil layer 9 (200-400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 9 (200-400 cm)" %
        output_map[203] = &wf->GWdischarge[9]; //%"Soil water change due to the movement of groundwater table in soil layer 10 (400-1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz talajnedvessg-vltozs a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 10 (400-1000 cm)" %
        output_map[204] = &wf->GWdischarge_total;   //%"Total soil water from groundwater" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[205] = &wf->GWrecharge_total;   //%"Total soil water to groundwater" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[206] = &wf->canopyw_to_MOW; //%"Canopy water loss mowing" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Lombkoronn trolt vz vesztesg kaszls miatt" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water stored on canopy is disappered because of mowing" %
        output_map[207] = &wf->canopyw_to_HRV; //%"Canopy water loss harvesting" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Lombkoronn trolt vz vesztesg arats miatt" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water stored on canopy is disappered because of harvesting" %
        output_map[208] = &wf->canopyw_to_PLG; //%"Canopy water loss ploughing" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Lombkoronn trolt vz vesztesg sznts miatt" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water stored on canopy is disappered because of ploughing" %
        output_map[209] = &wf->canopyw_to_GRZ; //%"Canopy water loss grazing" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Lombkoronn trolt vz vesztesg legeltets miatt" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water stored on canopy is disappered because of grazing" %
        output_map[210] = &wf->IRG_to_soilw;    //%"Irrigated water amount (above canopy height)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Az llomny feletti magassgban ntztt vz mennyisge" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Irrigated water amount (above canopy height)" %
        output_map[211] = &wf->FRZ_to_soilw;   //%"Water flux from fertilization" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Trgyzsbl szrmaz vzfluxus" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water flux from fertilization" %
        output_map[212] = &wf->potEVPandSUBLsurface;  //%"Potential evaporation (including sublimation) of surface" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Potencilis felszni prolgs s szublimci" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Potential evaporation of surface" %
		output_map[213] = &wf->infiltPOT;      //%"Potential infiltration" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Potencilis beszivrgs" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Potential infiltration: sum of prcp fluxes" %
        output_map[214] = &wf->TRPsoilw_demand[0]; //%"transpiration demand from soil layer 1 (0 - 3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny az 1. talajrtegbol (0 - 3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration from soil layer 1 (0 - 3 cm)" %
        output_map[215] = &wf->TRPsoilw_demand[1]; //%"transpiration demand from soil layer 2 (3 - 10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny  a 2. talajrtegbol (3 - 10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration demand from soil layer 2 (3 - 10 cm)" %
        output_map[216] = &wf->TRPsoilw_demand[2]; //%"transpiration demand from soil layer 3 (10 - 30 cm cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny  a 3. talajrtegbol (10 - 30 cm cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration demand from soil layer 3 (10 - 30 cm cm)" %
        output_map[217] = &wf->TRPsoilw_demand[3]; //%"transpiration demand from soil layer 4 (30 - 60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny  a 4. talajrtegbol (30 - 60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration demand from soil layer 4 (30 - 60 cm)" %
        output_map[218] = &wf->TRPsoilw_demand[4]; //%"transpiration demand from soil layer 5 (60 - 90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny  az 5. talajrtegbol (60 - 90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration demand from soil layer 5 (60 - 90 cm)" %
        output_map[219] = &wf->TRPsoilw_demand[5]; //%"transpiration demand from soil layer 6 (90 - 120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny  a 6. talajrtegbol (90 - 120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration demand from soil layer 6 (90 - 120 cm)" %
        output_map[220] = &wf->TRPsoilw_demand[6]; //%"transpiration demand from soil layer 7 (120 - 150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny  a 7. talajrtebol (120 - 150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration demand from soil layer 7 (120 - 150 cm)" %
        output_map[221] = &wf->TRPsoilw_demand[7]; //%"transpiration demand from soil layer 8 (150 - 200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny  a 8. talajrtegbol (150 - 200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration demand from soil layer 8 (150 - 200 cm)" %
        output_map[222] = &wf->TRPsoilw_demand[8]; //%"transpiration demand from soil layer 9 (200 - 400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny  a 9. talajrtegbol (200 - 400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration demand from soil layer 9 (200 - 400 cm)" %
        output_map[223] = &wf->TRPsoilw_demand[9]; //%"transpiration demand from soil layer 10 (400 - 1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpircis igny  a 10. talajrtegbol (400 - 1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "transpiration demand from soil layer 10 (400 - 1000 cm)" %
		output_map[224] = &wf->ET_Elimit;         //%"Energy limit of evapotranspiration" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Az evaportranspirci energialimitje" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Energy limit of evapotranspiration" %
		output_map[225] = &wf->potTRPsoilw;       //%"Potential transpiration (no SWC limit)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Potencilis Transpirci" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Potential transpiration" %
		output_map[226] = &wf->PET;                //%"Potential evapotranspiration" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Potencilis Transpirci s potencilis prolgs ssszege" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Potential evapotranspiration" %
 		output_map[237] = &wf->IRG_to_prcp;   //%"Water from irrigation (below canopy height)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Az llomny alatti ntzsbl szrmaz vzmennyisg" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water from irrigation (below canopy height)" % 
		output_map[238] = &wf->GW_to_pondw;   //%"Water flux from GW to pond water (GW above surface)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Vzfluxus a talajvzbl a tcsba (felszn feletti TV)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water flux from GW to pond water" % 
		output_map[239] = &wf->EVPsurface;    //%"SUM of soilw and pond water evaporation" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Vzfluxus a talajvzbl a tcsba (felszn feletti TV)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water flux from GW to pond water" % 
		output_map[240] = &wf->pondw_to_runoff; //%"Dunnian runoff flux (from pond water)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Felszni prolgs (talaj s tcsa sszege)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "SUM of soilw and pond water evaporation" %
		output_map[241] = &wf->prcp_to_pondw;   //%"Precipitation entering pond " $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Beszivrgs a tcsba" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Infiltration flux from prcp to pond" %
        output_map[242] = &wf->EVPfromGW;          //%"Evaporation flux covered by groundwater" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Evaporation flux covered by groundwater" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Evaporation flux covered by groundwater" % 
        output_map[243] = &wf->potETcanopy;     //%"Potential evaporation and transpiration of canopy" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Potencilis levlfelleti prolgs-prologtats" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Potential evaporation of canopy" %
		output_map[244] = &wf->potEVPsurface;  //%"Potential evaporation of surface" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Potencilis felszni prolgs" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Potential evaporation of surface" %
        output_map[245] = &wf->TRPfromGW_total; //%"SUM of Transpiration covered by groundwater" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci az 1. talajrtegbol (0 - 3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 1 (0 - 3 cm)" %
        output_map[246] = &wf->FL_to_soilwTOTAL;  //%"Water flux from flooding to soilw and pondw" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Az elrasztsbl a talajba jut vzfluxus" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water flux from flooding to soilw" %
        output_map[247] = &wf->waterFromAbove;  //%"Water flux from above (rain, snowmelt, irrigation)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Fellrl rkez vzram (es, holvads, ntzs)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Water flux from above (rain, snowmelt, irrigation)" %
        output_map[248] = &wf->TRPsoilw_NORMgw; //%"Transpiration covered by groundwater in normal zone of GWlayer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ t]$ 
        output_map[249] = &wf->TRPsoilw_CAPILgw; //%"Transpiration covered by groundwater in capillary zone of GWlayer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ t]$ 
        output_map[250] = &wf->TRPfromGW[0]; //%"Transpiration covered by groundwater from soil layer 1 (0 - 3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci az 1. talajrtegbol (0 - 3 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 1 (0 - 3 cm)" %
        output_map[251] = &wf->TRPfromGW[1]; //%"Transpiration covered by groundwater from soil layer 2 (3 - 10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 2. talajrtegbol (3 - 10 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 2 (3 - 10 cm)" %
        output_map[252] = &wf->TRPfromGW[2]; //%"Transpiration covered by groundwater from soil layer 3 (10 - 30 cm cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 3. talajrtegbol (10 - 30 cm cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 3 (10 - 30 cm cm)" %
        output_map[253] = &wf->TRPfromGW[3]; //%"Transpiration covered by groundwater from soil layer 4 (30 - 60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 4. talajrtegbol (30 - 60 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 4 (30 - 60 cm)" %
        output_map[254] = &wf->TRPfromGW[4]; //%"Transpiration covered by groundwater from soil layer 5 (60 - 90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci az 5. talajrtegbol (60 - 90 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 5 (60 - 90 cm)" %
        output_map[255] = &wf->TRPfromGW[5]; //%"Transpiration covered by groundwater from soil layer 6 (90 - 120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 6. talajrtegbol (90 - 120 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 6 (90 - 120 cm)" %
        output_map[256] = &wf->TRPfromGW[6]; //%"Transpiration covered by groundwater from soil layer 7 (120 - 150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 7. talajrtebol (120 - 150 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 7 (120 - 150 cm)" %
        output_map[257] = &wf->TRPfromGW[7]; //%"Transpiration covered by groundwater from soil layer 8 (150 - 200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 8. talajrtegbol (150 - 200 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 8 (150 - 200 cm)" %
        output_map[258] = &wf->TRPfromGW[8]; //%"Transpiration covered by groundwater from soil layer 9 (200 - 400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 9. talajrtegbol (200 - 400 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 9 (200 - 400 cm)" %
        output_map[259] = &wf->TRPfromGW[9]; //%"Transpiration covered by groundwater from soil layer 10 (400 - 1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Transpirci a 10. talajrtegbol (400 - 1000 cm)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Transpiration covered by groundwater from soil layer 10 (400 - 1000 cm)" %
        output_map[260] = &wf->soilwFlux_NORMvsCAPILgw;  //%"Soilw water flux between NORM and CAPIL part of GW-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[261] = &wf->soilwFlux_NORMvsCAPILcf; //%"Soilw water flux between NORM and CAPIL part of CF-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[262] = &wf->GWrecharge_NORMcf;   //%"Soil water to groundwater from CF-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[263] = &wf->GWrecharge_CAPILcf;   //%"Soil water to groundwater from CAPIL zone of CF-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[264] = &wf->GWrecharge_NORMgw;   //%"Soil water to groundwater from NORM zone of GW-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[265] = &wf->GWrecharge_CAPILgw;   //%"Soil water to groundwater from CAPIL zone of GW-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[266] = &wf->GWrecharge_lastCAPIL;   //%"Soil water to groundwater from last CAPIL layer (above GW-layer)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[267] = &wf->GWdischargeNORMcf;    //%"Soil water from groundwater into NORM zone of CF-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[268] = &wf->GWdischargeCAPILcf;    //%"Soil water from groundwater into CAPIL zone of CF-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[269] = &wf->GWdischargeNORMgw;    //%"Soil water from groundwater into NORM zone of GW-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[270] = &wf->GWdischargeCAPILgw;    //%"Soil water from groundwater into CAPIL zone of GW-layer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[271] = &wf->soilwDiffus_aboveGWlayer_vs_NORMgw; //%"Soil water diffusion flux between above-GWlayer and NORM zone of GWlayer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[272] = &wf->soilwDiffus_aboveGWlayer_vs_CAPILgw; //%"Soil water diffusion flux between above-GWlayer and CAPIL zone of GWlayer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[273] = &wf->soilwDiffusNORMcf; //%"Soil water diffusion flux of NORM zone in CFlayer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[274] = &wf->soilwDiffusCAPILcf; //%"Soil water diffusion flux of CAPIL zone in CFlayer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[275] = &wf->soilwDiffus_aboveCFlayer_vs_NORMcf;  //%"Soil water diffusion fluxF between above-CFlayer and NORM zone of CFlayer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[276] = &wf->soilwDiffus_aboveCFlayer_vs_CAPILcf; //%"Soil water diffusion flux between above-CFlayer and CAPIL zone of CFlayer" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[277] = &wf->soilwPercolDiffus_fromNORM_total; //%"Soil percolation-diffusion mixed flux between NORM zone of CFlayer and non-saturated CF-layers" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$
        output_map[278] = &wf->GWmovchange; //%"Total soil water change due to the movement of groundwater table" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Talajvz mozgsbl szrmaz sszestett talajnedvessg-vltozs" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water change due to the movement of groundwater table in soil layer 1 (0-3 cm)" %

        output_map[300] = &cs->leafcSUM_phenphase[0]; //%"SUM of leaf C content in phen.phase 1" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl troz szntartalma az 1. fenofzisban" $\\left[\\frac{kg_{C}}{m^2} \\right]$ "SUM of leaf C pool in phenophase 1" %
        output_map[301] = &cs->leafcSUM_phenphase[1]; //%"SUM of leaf C content in phen.phase 2" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl troz szntartalma a 2. fenofzisban" $\\left[\\frac{kg_{C}}{m^2} \\right]$ "SUM of leaf C pool in phenophase 2" %
        output_map[302] = &cs->leafcSUM_phenphase[2]; //%"SUM of leaf C content in phen.phase 3" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl troz szntartalma a 3. fenofzisban" $\\left[\\frac{kg_{C}}{m^2} \\right]$ "SUM of leaf C pool in phenophase 3" %
        output_map[303] = &cs->leafcSUM_phenphase[3]; //%"SUM of leaf C content in phen.phase 4" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl troz szntartalma a 4. fenofzisban" $\\left[\\frac{kg_{C}}{m^2} \\right]$ "SUM of leaf C pool in phenophase 4" %
        output_map[304] = &cs->leafcSUM_phenphase[4]; //%"SUM of leaf C content in phen.phase 5" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl troz szntartalma a 5. fenofzisban" $\\left[\\frac{kg_{C}}{m^2} \\right]$ "SUM of leaf C pool in phenophase 5" %
        output_map[305] = &cs->leafcSUM_phenphase[5]; //%"SUM of leaf C content in phen.phase 6" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl troz szntartalma a 6. fenofzisban" $\\left[\\frac{kg_{C}}{m^2} \\right]$ "SUM of leaf C pool in phenophase 6" %
        output_map[306] = &cs->leafcSUM_phenphase[6]; //%"SUM of leaf C content in phen.phase 7" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl troz szntartalma a 7. fenofzisban" $\\left[\\frac{kg_{C}}{m^2} \\right]$ "SUM of leaf C pool in phenophase 7" %
        output_map[307] = &cs->leafc; //%"Actual C content of leaf pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Actual C pool of leaf" %
        output_map[308] = &cs->leafc_storage; //%"C content of leaf storage pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl raktr troz szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Storage C pool of leaf" %
        output_map[309] = &cs->leafc_transfer; //%"C content of leaf transfer pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl transzfer troz szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Transfer C pool of leaf" %
        output_map[310] = &cs->frootc; //%"Actual C content of fine root pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Hajszlgykr troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Actual C pool of fine root" %
        output_map[311] = &cs->frootc_storage; //%"C content of fine root storage pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Hajszlgykr raktr troz szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Storage C pool of fine root" %
        output_map[312] = &cs->frootc_transfer; //%"C content of fine root storage pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Hajszlgykr transzfer troz szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Transfer C pool of fine root" %
        output_map[313] = &cs->yieldc; //%"Actual C content of yield pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Terms troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Actual C pool of yield" %
        output_map[314] = &cs->yieldc_storage; //%"C content of yield storage pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Terms raktr troz szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Storage C pool of yield" %
        output_map[315] = &cs->yieldc_transfer; //%"C content of yield transfer pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Terms transzfer troz szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Transfer C pool of yield" %
        output_map[316] = &cs->softstemc; //%"Actual C content of softstem pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Lgyszr troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Actual C pool of softstem" %
        output_map[317] = &cs->softstemc_storage; //%"C content of softstem storage pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Lgyszr raktr troz szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Storage C pool of softstem" %
        output_map[318] = &cs->softstemc_transfer; //%"C content of softstem transfer pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Lgyszr transzfer troz szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Transfer C pool of softstem" %
        output_map[319] = &cs->livestemc; //%"Actual C content of live stem pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A szjcs (fs szr klso  l rsze) raktr troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Actual C pool of live stem" %
        output_map[320] = &cs->livestemc_storage; //%"C content of live stem storage pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A szjcs (fs szr klso  l rsze) transzfer troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Storage C pool of live stem" %
        output_map[321] = &cs->livestemc_transfer; //%"C content of live stem transfer pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A szjcs (fs szr klso  l rsze) troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Transfer C pool of live stem" %
        output_map[322] = &cs->deadstemc; //%"Actual C content of dead stem pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A geszt (fs szr belso  lettelen rsze)raktr troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Actual C pool of dead stem" %
        output_map[323] = &cs->deadstemc_storage; //%"C content of dead stem storage pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A geszt (fs szr belso  lettelen rsze) transzfer troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Storage C stem of dead stem" %
        output_map[324] = &cs->deadstemc_transfer; //%"C content of dead stem transfer pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A geszt (fs szr belso  lettelen rsze) troz aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Transfer C stem of dead stem" %
        output_map[325] = &cs->livecrootc; //%"Actual C content of live coarse root pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A fs gykr klso  l rsz raktr trozjnak aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Actual C pool of live coarse root" %
        output_map[326] = &cs->livecrootc_storage; //%"C content of live coarse root storge pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A fs gykr klso  l rsz transzfer trozjnak aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Storage C pool of live coarse root" %
        output_map[327] = &cs->livecrootc_transfer; //%"C content of live coarse root transfer pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A fs gykr klso  l rsznek aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Transfer C pool of live coarse root" %
        output_map[328] = &cs->deadcrootc; //%"Actual C content of dead coarse root pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A fs gykr belso  lettelen rsz raktr trozjnak aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Actual C pool of dead coarse root" %
        output_map[329] = &cs->deadcrootc_storage; //%"C content of dead coarse root storage pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A fs gykr belso  lettelen rsz transzfer trozjnak aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Storage C pool of dead coarse root" %
        output_map[330] = &cs->deadcrootc_transfer; //%"C content of dead coarse root transfer pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A fs gykr belso  lettelen rsznek aktulis szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Transfer C pool of dead coarse root" %
        output_map[331] = &cs->gresp_storage; //%"growth respiration storage pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Nvekedsi respirci raktr troz" $\\left[\\kg_{C}m^{-2} \\right]$ "growth respiration storage pool" %
        output_map[332] = &cs->gresp_transfer; //%"growth respiration transfer pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Fenntartsi respirci transzfer troz" $\\left[\\kg_{C}m^{-2} \\right]$ "growth respiration transfer pool" %
        output_map[333] = &cs->NSCw; //%"Non-structured woody carbohydrate pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Nem strukturlt fs sznhidrt troz" $\\left[\\kg_{C}m^{-2} \\right]$ "Non-structured woody carbohydrate pool" %
        output_map[334] = &cs->NSCnw; //%"Non-structured non-woody carbohydrate pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Nem strukturlt nem fs sznhidrt troz" $\\left[\\kg_{C}m^{-2} \\right]$ "Non-structured non-woody arbohydrate pool" %
        output_map[335] = &cs->SCw; //%"Structured woody carbohydrate pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Strukturlt fs sznhidrt troz" $\\left[\\kg_{C}m^{-2} \\right]$ "Structured woody carbohydrate pool" %
        output_map[336] = &cs->SCnw; //%"Structured non-woody carbohydrate pool" $\\left[\\kg_{C}m^{-2} \\right]$ "Strukturlt nem fs sznhidrt troz" $\\left[\\kg_{C}m^{-2} \\right]$ "Structured non-woody carbohydrate pool" %
        output_map[337] = &cs->cwdc[0]; //%"Coarse woody debris in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 1 (0-3 cm)" %
        output_map[338] = &cs->cwdc[1]; //%"Coarse woody debris in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 2 (3-10 cm)" %
        output_map[339] = &cs->cwdc[2]; //%"Coarse woody debris in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 3 (10-30 cm)" %
        output_map[340] = &cs->cwdc[3]; //%"Coarse woody debris in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 4 (30-60 cm)" %
        output_map[341] = &cs->cwdc[4]; //%"Coarse woody debris in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 5 (60-90 cm)" %
        output_map[342] = &cs->cwdc[5]; //%"Coarse woody debris in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 6 (90-120 cm)" %
        output_map[343] = &cs->cwdc[6]; //%"Coarse woody debris in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 7 (100-200 cm)" %
        output_map[344] = &cs->cwdc[7]; //%"Coarse woody debris in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 7 (120-150 cm)" %
        output_map[345] = &cs->cwdc[8]; //%"Coarse woody debris in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 8 (150-200 cm)" %
        output_map[346] = &cs->cwdc[9]; //%"Coarse woody debris in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 9 (200-400 cm)" %
        output_map[347] = &cs->litr1c[0]; //%"Labile C proportion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya az 1. talajrtegben" $\\left[\\kg_{C}m^{-2} \\right]$ "Coarse woody debris in soil layer 10 (400-1000 cm)" %
        output_map[348] = &cs->litr1c[1]; //%"Labile C proportion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 2 (3-10 cm)" %
        output_map[349] = &cs->litr1c[2]; //%"Labile C proportion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 3 (10-30 cm)" %
        output_map[350] = &cs->litr1c[3]; //%"Labile C proportion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 4 (30-60 cm)" %
        output_map[351] = &cs->litr1c[4]; //%"Labile C proportion of litter in soil layer 5 (60-90 cm)$" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 5 (60-90 cm)$" %
        output_map[352] = &cs->litr1c[5]; //%"Labile C proportion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 6 (90-120 cm)" %
        output_map[353] = &cs->litr1c[6]; //%"Labile C proportion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 7 (100-200 cm)" %
        output_map[354] = &cs->litr1c[7]; //%"Labile C proportion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 7 (120-150 cm)" %
        output_map[355] = &cs->litr1c[8]; //%"Labile C proportion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 8 (150-200 cm)" %
        output_map[356] = &cs->litr1c[9]; //%"Labile C proportion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml szn rszarnya a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 9 (200-400 cm)" %
        output_map[357] = &cs->litr2c[0]; //%"Unshielded cellulose proportion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya az 1. talajrtegben" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter in soil layer 10 (400-1000 cm)" %
        output_map[358] = &cs->litr2c[1]; //%"Unshielded cellulose proportion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter in soil layer 2 (3-10 cm)" %
        output_map[359] = &cs->litr2c[2]; //%"Unshielded cellulose proportion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter in soil layer 3 (10-30 cm)" %
        output_map[360] = &cs->litr2c[3]; //%"Unshielded cellulose proportion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter in soil layer 4 (30-60 cm)" %
        output_map[361] = &cs->litr2c[4]; //%"Unshielded cellulose proportion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter in soil layer 5 (60-90 cm)" %
        output_map[362] = &cs->litr2c[5]; //%"Unshielded cellulose proportion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter in soil layer 6 (90-120 cm)" %
        output_map[363] = &cs->litr2c[6]; //%"Unshielded cellulose proportion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter in soil layer 7 (100-200 cm)" %
        output_map[364] = &cs->litr2c[7]; //%"Unshielded cellulose proportion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter in soil layer 8 (150-200 cm)" %
        output_map[365] = &cs->litr2c[8]; //%"Unshielded cellulose proportion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter in soil layer 9 (200-400 cm)" %
        output_map[366] = &cs->litr2c[9]; //%"Unshielded cellulose proportion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnya a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter in soil layer 10 (400-1000 cm)" %
        output_map[367] = &cs->litr3c[0]; //%"Shielded cellulose proportion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya az 1. talajrtegben" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 1 (0-3 cm)" %
        output_map[368] = &cs->litr3c[1]; //%"Shielded cellulose proportion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 2 (3-10 cm)" %
        output_map[369] = &cs->litr3c[2]; //%"Shielded cellulose proportion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 3 (0-3 cm)" %
        output_map[370] = &cs->litr3c[3]; //%"Shielded cellulose proportion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 4 (0-3 cm)" %
        output_map[371] = &cs->litr3c[4]; //%"Shielded cellulose proportion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 5 (0-3 cm)" %
        output_map[372] = &cs->litr3c[5]; //%"Shielded cellulose proportion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 6 (0-3 cm)" %
        output_map[373] = &cs->litr3c[6]; //%"Shielded cellulose proportion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 7 (0-3 cm)" %
        output_map[374] = &cs->litr3c[7]; //%"Shielded cellulose proportion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 7 (120-150 cm)" %
        output_map[375] = &cs->litr3c[8]; //%"Shielded cellulose proportion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 8 (150-200 cm)" %
        output_map[376] = &cs->litr3c[9]; //%"Shielded cellulose proportion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnya a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 9 (200-400 cm)" %
        output_map[377] = &cs->litr4c[0]; //%"Lignin proportion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose proportion of litter in soil layer 10 (400-1000 cm)" %
        output_map[378] = &cs->litr4c[1]; //%"Lignin proportion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter in soil layer 2 (3-10 cm)" %
        output_map[379] = &cs->litr4c[2]; //%"Lignin proportion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter in soil layer 3 (10-30 cm)" %
        output_map[380] = &cs->litr4c[3]; //%"Lignin proportion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter in soil layer 4 (30-60 cm)" %
        output_map[381] = &cs->litr4c[4]; //%"Lignin proportion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter in soil layer 5 (60-90 cm)" %
        output_map[382] = &cs->litr4c[5]; //%"Lignin proportion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter in soil layer 6 (90-120 cm)" %
        output_map[383] = &cs->litr4c[6]; //%"Lignin proportion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter in soil layer 7 (120-150 cm)" %
        output_map[384] = &cs->litr4c[7]; //%"Lignin proportion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter in soil layer 8 (150-200 cm)" %
        output_map[385] = &cs->litr4c[8]; //%"Lignin proportion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter in soil layer 9 (200-400 cm)" %
        output_map[386] = &cs->litr4c[9]; //%"Lignin proportion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnya a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter in soil layer 10 (400-1000 cm)" %
        output_map[387] = &cs->litrC[0]; //%"Total litter content in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 1 (0-3 cm)" %
        output_map[388] = &cs->litrC[1]; //%"Total litter content in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 2 (3-10 cm)" %
        output_map[389] = &cs->litrC[2]; //%"Total litter content in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 3 (10-30 cm)" %
        output_map[390] = &cs->litrC[3]; //%"Total litter content in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 4 (30-60 cm)" %
        output_map[391] = &cs->litrC[4]; //%"Total litter content in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 5 (60-90 cm)" %
        output_map[392] = &cs->litrC[5]; //%"Total litter content in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 6 (90-120 cm)" %
        output_map[393] = &cs->litrC[6]; //%"Total litter content in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 7 (120-150 cm)" %
        output_map[394] = &cs->litrC[7]; //%"Total litter content in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 8 (150-200 cm)" %
        output_map[395] = &cs->litrC[8]; //%"Total litter content in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 9 (200-400 cm)" %
        output_map[396] = &cs->litrC[9]; //%"Total litter content in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes szntartalma a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter content in soil layer 10 (400-1000 cm)" %
        output_map[397] = &cs->litr1c_total; //%"Labile C proportion of litter" $\\left[\\kg_{C}m^{-2} \\right]$ "Knnyen boml szn rszarnya az elhalt nvnyi anyagban" $\\left[\\kg_{C}m^{-2} \\right]$ "Labile C proportion of litter" %
        output_map[398] = &cs->litr2c_total; //%"Unshielded cellulose proportion of litter" $\\left[\\kg_{C}m^{-2} \\right]$ "hozzfrhet cellulz rszarnya az elhalt nvnyi anyagban" $\\left[\\kg_{C}m^{-2} \\right]$ "Unshielded cellulose proportion of litter" %
        output_map[399] = &cs->litr3c_total; //%"Shielded cellulose proportion of litter" $\\left[\\kg_{C}m^{-2} \\right]$ "Nem hozzfrhet cellulz rszarnya az elhalt nvnyi anyagban" $\\left[\\kg_{C}m^{-2} \\right]$ "Shielded cellulose C proportion of litter" %
        output_map[400] = &cs->litr4c_total; //%"Lignin proportion of litter" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin rszarnya az elhalt nvnyi anyagban" $\\left[\\kg_{C}m^{-2} \\right]$ "Lignin proportion of litter" %
        output_map[401] = &cs->cwdc_total; //%"Total C content of coarse woody debris" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of coarse woody debris" %
        output_map[402] = &cs->STDBc_leaf; //%"Wilted leaf biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhervadt levl biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Wilted leaf biomass" %
        output_map[403] = &cs->STDBc_froot; //%"Wilted fine root biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhervadt hajszlgykr biomoassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Wilted fineroot biomass" %
        output_map[404] = &cs->STDBc_yield; //%"Wilted yield biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhervadt terms biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Wilted yield biomass" %
        output_map[405] = &cs->STDBc_softstem; //%"Wilted softstem biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhervadt lgyszr biomoassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Wilted softstem biomass" %
        
        output_map[407] = &cs->STDBc_above; //%"Wilted aboveground plant biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhervadt talajfeletti nvnybiomassza" $\\left[\\kg_{C}m^{-2} \\right]$ "Wilted aboveground plant biomass" %
        output_map[408] = &cs->STDBc_below; //%"Wilted belowground plant biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhervadt talajalatti nvnyi biomassza" $\\left[\\kg_{C}m^{-2} \\right]$ "Wilted belowground plant biomass" %
        output_map[409] = &cs->CTDBc_leaf; //%"Cut-down leaf biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Levgott levl biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Cut-down leaf biomass" %
        output_map[410] = &cs->CTDBc_froot; //%"Cut-down fineroot biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Levgott hajszlgykr biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Cut-down fineroot biomass" %
        output_map[411] = &cs->CTDBc_yield; //%"Cut-down yield biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Levgott terms biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Cut-down yield biomass" %
        output_map[412] = &cs->CTDBc_softstem; //%"Cut-down softstem biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Levgott lgyszr biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Cut-down softstem biomass" %

        output_map[414] = &cs->CTDBc_cstem; //%"Cut-down coarse stem biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Levgott fs szr biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Cut-down coarse stem biomass" %
        output_map[415] = &cs->CTDBc_croot; //%"Cut-down coarse root biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Levgott fs gykr biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Cut-down coarse root biomass" %
        output_map[416] = &cs->CTDBc_above; //%"Cut-down aboveground plant biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Levgott talajfeletti nvnyi biomassza" $\\left[\\kg_{C}m^{-2} \\right]$ "Cut-down aboveground plant biomass" %
        output_map[417] = &cs->CTDBc_below; //%"Cut-down belowground plant biomass" $\\left[\\kg_{C}m^{-2} \\right]$ "Levgott talajalatti nvnyi biomassza" $\\left[\\kg_{C}m^{-2} \\right]$ "Cut-down belowground plant biomass" %
        output_map[418] = &cs->soil1c[0]; //%"C content of SOM pool in soil layer 1 (0-3 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 1 (0-3 cm) (labile)" %
        output_map[419] = &cs->soil1c[1]; //%"C content of SOM pool in soil layer 2 (3-10 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 2 (3-10 cm) (labile)" %
        output_map[420] = &cs->soil1c[2]; //%"C content of SOM pool in soil layer 3 (10-30 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 3 (10-30 cm) (labile)" %
        output_map[421] = &cs->soil1c[3]; //%"C content of SOM pool in soil layer 4 (30-60 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 4 (30-60 cm) (labile)" %
        output_map[422] = &cs->soil1c[4]; //%"C content of SOM pool in soil layer 5 (60-90 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 5 (60-90 cm) (labile)" %
        output_map[423] = &cs->soil1c[5]; //%"C content of SOM pool in soil layer 6 (90-120 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) soil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 6 (90-120 cm) (labile)" %
        output_map[424] = &cs->soil1c[6]; //%"C content of SOM pool in soil layer 7 (120-150 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 7 (120-150 cm) (labile)" %
        output_map[425] = &cs->soil1c[7]; //%"C content of SOM pool in soil layer 8 (150-200 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 8 (150-200 cm) (labile)" %
        output_map[426] = &cs->soil1c[8]; //%"C content of SOM pool in soil layer 9 (200-400 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 9 (200-400 cm) (labile)" %
        output_map[427] = &cs->soil1c[9]; //%"C content of SOM pool in soil layer 10 (400-1000 cm) (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 10 (400-1000 cm) (labile)" %
        output_map[428] = &cs->soil2c[0]; //%"C content of SOM pool in soil layer 1 (0-3 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 1 (0-3 cm) (fast)" %
        output_map[429] = &cs->soil2c[1]; //%"C content of SOM pool in soil layer 2 (3-10 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 2 (3-10 cm) (fast)" %
        output_map[430] = &cs->soil2c[2]; //%"C content of SOM pool in soil layer 3 (10-30 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 3 (10-30 cm) (fast)" %
        output_map[431] = &cs->soil2c[3]; //%"C content of SOM pool in soil layer 4 (30-60 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 4 (30-60 cm) (fast)" %
        output_map[432] = &cs->soil2c[4]; //%"C content of SOM pool in soil layer 5 (60-90 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 5 (60-90 cm) (fast)" %
        output_map[433] = &cs->soil2c[5]; //%"C content of SOM pool in soil layer 6 (90-120 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 6 (90-120 cm) (fast)" %
        output_map[434] = &cs->soil2c[6]; //%"C content of SOM pool in soil layer 7 (120-150 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 7 (120-150 cm) (fast)" %
        output_map[435] = &cs->soil2c[7]; //%"C content of SOM pool in soil layer 8 (150-200 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 8 (150-200 cm) (fast)" %
        output_map[436] = &cs->soil2c[8]; //%"C content of SOM pool in soil layer 9 (200-400 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 9 (200-400 cm) (fast)" %
        output_map[437] = &cs->soil2c[9]; //%"C content of SOM pool in soil layer 10 (400-1000 cm) (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 10 (400-1000 cm) (fast)" %
        output_map[438] = &cs->soil3c[0]; //%"C content of SOM pool in soil layer 1 (0-3 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 1 (0-3 cm) (slow)" %
        output_map[439] = &cs->soil3c[1]; //%"C content of SOM pool in soil layer 2 (3-10 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 2 (3-10 cm) (slow)" %
        output_map[440] = &cs->soil3c[2]; //%"C content of SOM pool in soil layer 3 (10-30 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 3 (10-30 cm) (slow)" %
        output_map[441] = &cs->soil3c[3]; //%"C content of SOM pool in soil layer 4 (30-60 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 4 (30-60 cm) (slow)" %
        output_map[442] = &cs->soil3c[4]; //%"C content of SOM pool in soil layer 5 (60-90 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 5 (60-90 cm) (slow)" %
        output_map[443] = &cs->soil3c[5]; //%"C content of SOM pool in soil layer 6 (90-120 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 6 (90-120 cm) (slow)" %
        output_map[444] = &cs->soil3c[6]; //%"C content of SOM pool in soil layer 7 (120-150 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 7 (120-150 cm) (slow)" %
        output_map[445] = &cs->soil3c[7]; //%"C content of SOM pool in soil layer 8 (150-200 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 8 (150-200 cm) (slow)" %
        output_map[446] = &cs->soil3c[8]; //%"C content of SOM pool in soil layer 9 (200-400 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 9 (200-400 cm) (slow)" %
        output_map[447] = &cs->soil3c[9]; //%"C content of SOM pool in soil layer 10 (400-1000 cm) (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 10 (400-1000 cm) (slow)" %
        output_map[448] = &cs->soil4c[0]; //%"C content of SOM pool in soil layer 1 (0-3 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 1 (0-3 cm) (stable)" %
        output_map[449] = &cs->soil4c[1]; //%"C content of SOM pool in soil layer 2 (3-10 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 2 (3-10 cm) (stable)" %
        output_map[450] = &cs->soil4c[2]; //%"C content of SOM pool in soil layer 3 (10-30 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 3 (10-30 cm) (stable)" %
        output_map[451] = &cs->soil4c[3]; //%"C content of SOM pool in soil layer 4 (30-60 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 4 (30-60 cm) (stable)" %
        output_map[452] = &cs->soil4c[4]; //%"C content of SOM pool in soil layer 5 (60-90 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 5 (60-90 cm) (stable)" %
        output_map[453] = &cs->soil4c[5]; //%"C content of SOM pool in soil layer 6 (90-120 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 6 (90-120 cm) (stable)" %
        output_map[454] = &cs->soil4c[6]; //%"C content of SOM pool in soil layer 7 (120-150 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 7 (120-150 cm) (stable)" %
        output_map[455] = &cs->soil4c[7]; //%"C content of SOM pool in soil layer 8 (150-200 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 8 (150-200 cm) (stable)" %
        output_map[456] = &cs->soil4c[8]; //%"C content of SOM pool in soil layer 9 (200-400 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 9 (200-400 cm) (stable)" %
        output_map[457] = &cs->soil4c[9]; //%"C content of SOM pool in soil layer 10 (400-1000 cm) (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) stabil szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM pool in soil layer 10 (400-1000 cm) (stable)" %
        output_map[458] = &cs->soilC[0]; //%"Total C content of soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 1 (0-3 cm)" %
        output_map[459] = &cs->soilC[1]; //%"Total C content of soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 2 (3-10 cm)" %
        output_map[460] = &cs->soilC[2]; //%"Total C content of soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 3 (10-30 cm)" %
        output_map[461] = &cs->soilC[3]; //%"Total C content of soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 4 (30-60 cm)" %
        output_map[462] = &cs->soilC[4]; //%"Total C content of soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 5 (60-90 cm)" %
        output_map[463] = &cs->soilC[5]; //%"Total C content of soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 6 (90-120 cm)" %
        output_map[464] = &cs->soilC[6]; //%"Total C content of soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 7 (120-150 cm)" %
        output_map[465] = &cs->soilC[7]; //%"Total C content of soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 8 (150-200 cm)" %
        output_map[466] = &cs->soilC[8]; //%"Total C content of soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 9 (200-400 cm)" %
        output_map[467] = &cs->soilC[9]; //%"Total C content of soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) teljes szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content of soil layer 10 (400-1000 cm)" %
  
        output_map[518] = &cs->soil1c_total; //%"C content of SOM (labile)" $\\left[\\kg_{C}m^{-2} \\right]$ "A labilisan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM (labile)" %
        output_map[519] = &cs->soil2c_total; //%"C content of SOM (fast)" $\\left[\\kg_{C}m^{-2} \\right]$ "A lassan boml szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM (fast)" %
        output_map[520] = &cs->soil3c_total; //%"C content of SOM (slow)" $\\left[\\kg_{C}m^{-2} \\right]$ "A labilis szervesanyag-trozjnak szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "MC content of SOM (slow)" %
        output_map[521] = &cs->soil4c_total; //%"C content of SOM (stable)" $\\left[\\kg_{C}m^{-2} \\right]$ "Az ellenll talaj szervesanyagtartalom sszege (leglassabb)" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of SOM (stable)" %
        output_map[522] = &cs->cpool; //%"Temporary photosynthate C pool" $\\left[\\kg_{C}m^{-2} \\right]$ "tmeneti fotoszintzis szntroz" $\\left[\\kg_{C}m^{-2} \\right]$ "Temporary photosynthate C pool" %
        output_map[523] = &cs->psnsun_src; //%"gross photosynthesis from sunlit canopy" $\\left[\\kg_{C}m^{-2} \\right]$ "Brutt fotoszintzis a lomkorona napos rszrol" $\\left[\\kg_{C}m^{-2} \\right]$ "gross photosynthesis from sunlit canopy" %
        output_map[524] = &cs->psnshade_src; //%"gross photosynthesis from shaded canopy" $\\left[\\kg_{C}m^{-2} \\right]$ "Brutt fotoszintzis a lombkorona rnykos rszrol" $\\left[\\kg_{C}m^{-2} \\right]$ "gross photosynthesis from shaded canopy" %
        output_map[525] = &cs->GWsrc_C; //%"Groundwater as carbon source" $\\left[\\kg_{C}m^{-2} \\right]$" %
        output_map[526] = &cs->GWsnk_C; //%"Groundwater as carbon sink" $\\left[\\kg_{C}m^{-2} \\right]$" %
		output_map[527] = &cs->MRleaf_snk; //%"Leaf maintenance respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl nfenntart respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of leaf maintenance respiration" %
        output_map[528] = &cs->MRfroot_snk; //%"Fine root maintenance respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Hajszlgykr nfenntart respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of fine root maintenance respiration" %
        output_map[529] = &cs->MRyield_snk; //%"yield maintenance respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Terms nfenntart respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of yield maintenance respiration" %
        output_map[530] = &cs->MRsoftstem_snk; //%"Softstem maintenance respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Lgyszr nfenntart respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of softstem maintenance respiration" %
        output_map[531] = &cs->MRlivestem_snk; //%"Live stem maintenance respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Szjcs (fs szr klso  l rsze) nfenntart respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of live stem maintenance respiration" %
        output_map[532] = &cs->MRlivecroot_snk; //%"Live coarse root maintenance respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs gykr klso  l rsznek nfenntart respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of live coarse root maintenance respiration" %
        output_map[533] = &cs->GRleaf_snk; //%"Leaf growth respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Levl nvekedsi respirci" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of leaf growth respiration" %
        output_map[534] = &cs->GRfroot_snk; //%"Fine root growth respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Hajszlgykr nvekedsi respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of fine root growth respiration" %
        output_map[535] = &cs->GRyield_snk; //%"yield growth respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Terms nvekedsi respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of yield growth respiration" %
        output_map[536] = &cs->GRsoftstem_snk; //%"Softstem growth respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Lgyszr nvekedsi respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of softstem growth respiration" %
        output_map[537] = &cs->GRlivestem_snk; //%"Live stem growth respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Szjcs (fs szr klso  l rsze) nvekedsi respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of live stem growth respiration" %
        output_map[538] = &cs->GRlivecroot_snk; //%"Live coarse root growth respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs gykr klso  l rsznek nvekedsi respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of live coarse growth respiration" %
        output_map[539] = &cs->GRdeadstem_snk; //%"Dead stem growth respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Geszt (fatest belso  lettelen rsze) nvekedsi respirci" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of dead stem growth respiration" %
        output_map[540] = &cs->GRdeadcroot_snk; //%"Dead coarse root growth respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs gykr belso  lettelen rsznek nvekedsi respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of dead coarse root growth respiration" %
        output_map[541] = &cs->HRlitr1_snk; //%"Labile litter microbial respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Knnyen boml elhalt nvnyi anyag mikrobilis respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of labile litter microbial respiration" %
        output_map[542] = &cs->HRlitr2_snk; //%"Cellulose litter microbial respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag cellulz rsznek mikrobilis respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of cellulose litter microbial respiration" %
        output_map[543] = &cs->HRlitr4_snk; //%"Lignin litter microbial respiration" $\\left[\\kg_{C}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rsznek mikrobilis respircija" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of lignin litter microbial respiration" %
        output_map[544] = &cs->HRsoil1_snk; //%"Respiration of labile SOM" $\\left[\\kg_{C}m^{-2} \\right]$ "Labilis SOM-respirci sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Respiration of labile SOM" %
        output_map[545] = &cs->HRsoil2_snk; //%"Respiration of fast SOM" $\\left[\\kg_{C}m^{-2} \\right]$ "Gyors bomls SOM-respirci sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Respiration of fast SOM" %
        output_map[546] = &cs->HRsoil3_snk; //%"Respiration of slow SOM" $\\left[\\kg_{C}m^{-2} \\right]$ "Lass bomls SOM-respirci sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Respiration of slow SOM" %
        output_map[547] = &cs->HRsoil4_snk; //%"Respiration of stable SOM" $\\left[\\kg_{C}m^{-2} \\right]$ "Satbil SOM-respirci sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Respiration of stable SOM" %
        output_map[548] = &cs->FIREsnk_C; //%"Fire C losses" $\\left[\\kg_{C}m^{-2} \\right]$ "Tuzelhals okozta sznveszetsg" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of fire C losses" %
        output_map[549] = &cs->SNSCsnk_C; //%"Senescence C losses" $\\left[\\kg_{C}m^{-2} \\right]$ "regeds okozta  sznvesztesg" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of senescence C losses" %
        output_map[550] = &cs->PLTsrc_C; //%"C content of planted plant material" $\\left[\\kg_{C}m^{-2} \\right]$ "Elltett nvnyi anyag szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C content of planted plant material" %
        output_map[551] = &cs->THN_transportC; //%"C content of thinned and transported plant material" $\\left[\\kg_{C}m^{-2} \\right]$ "Kivgott s elszlltott nvnyi anyag szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C content of thinned and transported plant material" %
        output_map[552] = &cs->HRV_snkC; //%"C content of harvested and transported plant material" $\\left[\\kg_{C}m^{-2} \\right]$ "Betakartott s elszlltott nvnyi anyag szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C content of harvested and transported plant material"" " %
        output_map[553] = &cs->MOW_snkC; //%"C content of mowed and transported plant material" $\\left[\\kg_{C}m^{-2} \\right]$ "Lekaszlt s elszlltott nvnyi anyag szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C content of mowed and transported plant material" %
        output_map[554] = &cs->GRZsnk_C; //%"C content of grazed leaf" $\\left[\\kg_{C}m^{-2} \\right]$ "Lelegelt levl szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C content of grazed leaf" %
        output_map[555] = &cs->GRZsrc_C; //%"Added C from fertilizer" $\\left[\\kg_{C}m^{-2} \\right]$ "Trgya szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of added C from fertilizer" %
        output_map[556] = &cs->FRZsrc_C; //%"C content of fertilizer return to the litter pool" $\\left[\\kg_{C}m^{-2} \\right]$ "A trgybl szrmaz  elhalt nvnyi anyag trozba kerlt szn" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C content of fertilizer return to the litter pool" %
		output_map[557] = &cs->yieldC_HRV; //%"C content of havested yield in a year" $\\left[\\kg_{C}m^{-2} \\right]$ "A learatott terms szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "SUM of C content of havested yield in a year" %
		output_map[558] = &cs->vegCabove_HRV; //%"C content of havested plant (leaf+stem+yield)  in a year" $\\left[\\kg_{C}m^{-2} \\right]$ "A learatott nvny (szr+levl+terms) szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "SUM of C content of havested plant (leaf+stem+yield) in a year" %
        output_map[559] = &cs->CbalanceERR; //%"C balance error" $\\left[\\kg_{C}m^{-2} \\right]$ "Sznmrleg hibja" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C balance error" %
        output_map[560] = &cs->inC; //%"C input" $\\left[\\kg_{C}m^{-2} \\right]$ "Sznbevtel" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C input" %
        output_map[561] = &cs->outC; //%"C output" $\\left[\\kg_{C}m^{-2} \\right]$ "Sznvesztesg" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C output" %
        output_map[562] = &cs->storeC; //%"C store" $\\left[\\kg_{C}m^{-2} \\right]$ "Szntrozs" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C store" %
		output_map[563] = &cs->Cdeepleach_snk; //%"SUM of C deep leaching" $\\left[\\kg_{C}m^{-2} \\right]$ "A rendszerbol kimosdott C mennyisg" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of C deep leaching" 
        output_map[564] = &cs->litrCabove_total; //%"C content of aboveground litter" $\\left[\\kg_{C}m^{-2} \\right]$ "Lgyszr nvnyi maradvny felszn feletti rsze" $\\left[\\kg_{C}m^{-2} \\right]$ "Aboveground litrc" 
        output_map[565] = &cs->litrCbelow_total; //%"C content of belowground litter" $\\left[\\kg_{C}m^{-2} \\right]$ "Lgyszr nvnyi maradvny felszn feletti rsze" $\\left[\\kg_{C}m^{-2} \\right]$ "Aboveground litrc" 
        output_map[566] = &cs->cwdCabove_total; //%"C content of  coarse aboveground woody debris" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny felszn feletti rsze" $\\left[\\kg_{C}m^{-2} \\right]$ "Aboveground cwdc" 
        output_map[567] = &cs->cwdCbelow_total; //%"C content of belowground  coarse woody debris" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs nvnyi maradvny felszn feletti rsze" $\\left[\\kg_{C}m^{-2} \\right]$ "Aboveground cwdc" 
        output_map[568] = &cs->CNratioERR; //%"CN ratio error" $\\left[\\kg_{C}m^{-2} \\right]$ "CN arny szmts hibja" $\\left[\\kg_{C}m^{-2} \\right]$ "CN ratio error" 
		output_map[569] = &cs->flowHSsnk_C; //%"C loss due to flower heat stress" $\\left[\\kg_{C}m^{-2} \\right]$ "Virgzsi hostressz okozta C-vesztesg" $\\left[\\kg_{C}m^{-2} \\right]$ "C loss due to flower heat stress" 
        output_map[570] = &cs->MRlimitSUM; //%"Cumulative flux of non-materialized MR due to lack of C in carbon pools" $
        output_map[571] = &cs->FLsrc_C; //%"Flooding as carbon source" $\\left[\\kg_{C}m^{-2} \\right]$" %
        output_map[572] = &cs->CWEsnk_C; //%"C content of CWD-extract (sink)" $\\left[\\kg_{C}m^{-2} \\right]$ "Letrtt gak elszlltsakor tvoz C" $\\left[\\kg_{C}m^{-2} \\right]$ "C content of CWD-extract (sink)" %
        output_map[573] = &cs->MULsrc_C; //%"C content of mulched material" $\\left[\\kg_{C}m^{-2} \\right]$ "Mulcsknt bekerlt szerves anyag C-tartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of C content of mulched material" %
        output_map[574] = &cs->Cprec_snk; //%"SUM of C lost to precision control" $\\left[\\kg_{H2O}m^{-2} \\right]$

		output_map[600] = &cf->m_leafc_to_litr1c; //%"Mortality C flux from leaf to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus levlbol knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from leaf to labile litter" %
        output_map[601] = &cf->m_leafc_to_litr2c; //%"Mortality C flux from leaf to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus levlbol hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from leaf to unshielded cellulose portion of litter" %
        output_map[602] = &cf->m_leafc_to_litr3c; //%"Mortality C flux from leaf to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus levlbol nem hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from leaf to shielded cellulose portion of litter" %
        output_map[603] = &cf->m_leafc_to_litr4c; //%"Mortality C flux from leaf to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus levlbol ligninn" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from leaf to lignin portion of litter" %
        output_map[604] = &cf->m_frootc_to_litr1c; //%"Mortality C flux from fine root to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus hajszlgykrbol knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from fine root to labile litter" %
        output_map[605] = &cf->m_frootc_to_litr2c; //%"Mortality C flux from fine root to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus hajszlgykrbol hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from fine root to unshielded cellulose portion of litter" %
        output_map[606] = &cf->m_frootc_to_litr3c; //%"Mortality C flux from fine root to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus hajszlgykrbol nem hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from fine root to shielded cellulose portion of litter" %
        output_map[607] = &cf->m_frootc_to_litr4c; //%"Mortality C flux from fine root to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus hajszlgykrbol ligninn" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from fine root to lignin portion of litter" %
        output_map[608] = &cf->m_yieldc_to_litr1c; //%"Mortality C flux from yield to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus termsbol knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from yield to labile litter" %
        output_map[609] = &cf->m_yieldc_to_litr2c; //%"Mortality C flux from yield to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus termsbol hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from yield to unshielded cellulose portion of litter" %
        output_map[610] = &cf->m_yieldc_to_litr3c; //%"Mortality C flux from yield to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus termsbol nem hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from yield to shielded cellulose portion of litter" %
        output_map[611] = &cf->m_yieldc_to_litr4c; //%"Mortality C flux from yield to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus termsbol ligninn" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from yield to lignin portion of litter" %
        output_map[612] = &cf->m_softstemc_to_litr1c; //%"Mortality C flux from softstem to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus lgyszrbl knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from softstem to labile litter" %
        output_map[613] = &cf->m_softstemc_to_litr2c; //%"Mortality C flux from softstem to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus lgyszrbl hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from softstem to unshielded cellulose portion of litter" %
        output_map[614] = &cf->m_softstemc_to_litr3c; //%"Mortality C flux from softstem to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus lgyszrbl nem hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from softstem to shielded cellulose portion of litter" %
        output_map[615] = &cf->m_softstemc_to_litr4c; //%"Mortality C flux from softstem to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus lgyszrbl ligninn" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from softstem to lignin portion of litter" %
        output_map[616] = &cf->m_leafc_storage_to_litr1c; //%"Mortality C flux from leaf storage pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a levl raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from leaf storage pool to labile litter" %
        output_map[617] = &cf->m_frootc_storage_to_litr1c; //%"Mortality C flux from fine root storage pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a hajszlgykr raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from fine root storage pool to labile litter" %
        output_map[618] = &cf->m_softstemc_storage_to_litr1c; //%"Mortality C flux from softstem storage pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a lgyszr raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from softstem storage pool to labile litter" %
        output_map[619] = &cf->m_yieldc_storage_to_litr1c; //%"Mortality C flux from yield storage pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a terms raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from yield storage pool to labile litter" %
        output_map[620] = &cf->m_livestemc_storage_to_litr1c; //%"Mortality C flux from live stem storage pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a szjcs (fatest klso  l rsze) raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from live stem storage pool to labile litter" %
        output_map[621] = &cf->m_deadstemc_storage_to_litr1c; //%"Mortality C flux from dead stem storage pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a geszt (fatest belso  lettelen rsze) raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from dead stem storage pool to labile litter" %
        output_map[622] = &cf->m_livecrootc_storage_to_litr1c; //%"Mortality C flux from live coarse root storage pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a fs gykr klso  l rsznek raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from live coarse root storage pool to labile litter" %
        output_map[623] = &cf->m_deadcrootc_storage_to_litr1c; //%"Mortality C flux from dead coarse root storage pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a fs gykr belso  lettelen rsznek raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from dead coarse root storage pool to labile litter" %
        output_map[624] = &cf->m_leafc_transfer_to_litr1c; //%"Mortality C flux from leaf transfer pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a levl transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from leaf transfer pool to labile litter" %
        output_map[625] = &cf->m_frootc_transfer_to_litr1c; //%"Mortality C flux from fine root transfer pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a hajszlgykr transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from fine root transfer pool to labile litter" %
        output_map[626] = &cf->m_yieldc_transfer_to_litr1c; //%"Mortality C flux from yield transfer pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a lgyszr transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from yield transfer pool to labile litter" %
        output_map[627] = &cf->m_softstemc_transfer_to_litr1c; //%"Mortality C flux from softstem transfer pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a terms transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from softstem transfer pool to labile litter" %
        output_map[628] = &cf->m_livestemc_transfer_to_litr1c; //%"Mortality C flux from live stem transfer pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a szjcs (fatest klso  l rsze) transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from live stem transfer pool to labile litter" %
        output_map[629] = &cf->m_deadstemc_transfer_to_litr1c; //%"Mortality C flux from dead stem transfer pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a geszt (fatest belso  lettelen rsze) transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from dead stem transfer pool to labile litter" %
        output_map[630] = &cf->m_livecrootc_transfer_to_litr1c; //%"Mortality C flux from live coarse root transfer pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a fs gykr klso  l rsznek transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from live coarse root transfer pool to labile litter" %
        output_map[631] = &cf->m_deadcrootc_transfer_to_litr1c; //%"Mortality C flux from dead coarse root transfer pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a fs gykr belso  lettelen rsznek transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from dead coarse root transfer pool to labile litter" %
        output_map[632] = &cf->m_livestemc_to_cwdc; //%"Moartality C flux from live stem to coarse woody debris" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a szjcs (fatest klso  l rsze) anyagbl Fs nvnyi maradvnyk" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Moartality C flux from live stem to coarse woody debris" %
        output_map[633] = &cf->m_deadstemc_to_cwdc; //%"Mortality C flux from dead stem to coarse woody debris" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a geszt (fatest belso  lettelen rsze) anyagbl Fs nvnyi maradvnyk" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from dead stem to coarse woody debris" %
        output_map[634] = &cf->m_livecrootc_to_cwdc; //%"Mortality C flux from live coarse root to coarse woody debris" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a fs gykr klso  l rszbol dzrva fs trmelkk" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from live coarse root to coarse woody debris" %
        output_map[635] = &cf->m_deadcrootc_to_cwdc; //%"Moartality C flux from dead coarse root to coarse woody debris" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a fs gykr belso  lettelen rszbol Fs nvnyi maradvnyk" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Moartality C flux from dead coarse root to coarse woody debris" %
        output_map[636] = &cf->m_gresp_storage_to_litr1c; //%"Mortality C flux from growth respiration storage pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a nvekedsi respirci raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from growth respiration storage pool to labile litter" %
        output_map[637] = &cf->m_gresp_transfer_to_litr1c; //%"Mortality C flux from growth respiration transfer pool to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalsi C fluxus a nvekedsi respirci transzfer trozjbl knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Mortality C flux from growth respiration transfer pool to labile litter" %
        output_map[638] = &cf->m_leafc_to_fire; //%"Leaf fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levl tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leaf fire C flux" %
        output_map[639] = &cf->m_frootc_to_fire; //%"Fine root fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Hajszlgykr tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Fine root fire C flux" %
        output_map[640] = &cf->m_yieldc_to_fire; //%"yield fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Terms tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "yield fire C flux" %
        output_map[641] = &cf->m_softstemc_to_fire; //%"Softstem fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Lgyszr tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Softstem fire C flux" %
        output_map[642] = &cf->m_STDBc_to_fire; //%"Wilted plant biomass fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhervadt nvnyi anyag tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Wilted plant biomass fire C flux" %
        output_map[643] = &cf->m_CTDBc_to_fire; //%"Cut-down plant biomass fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levgott nvnyi anyag tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Cut-down plant biomass fire C flux" %
        output_map[644] = &cf->m_leafc_storage_to_fire; //%"Leaf storage pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levl raktr troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leaf storage pool fire C flux" %
        output_map[645] = &cf->m_frootc_storage_to_fire; //%"Fine root storage pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Hajszlgykr raktr troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Fine root storage pool fire C flux" %
        output_map[646] = &cf->m_yieldc_storage_to_fire; //%"yield storage pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Terms raktr troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "yield storage pool fire C flux" %
        output_map[647] = &cf->m_softstemc_storage_to_fire; //%"Softstem storage pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Lgyszr raktr troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Softstem storage pool fire C flux" %
        output_map[648] = &cf->m_livestemc_storage_to_fire; //%"Live stem storage pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szjcs (fatest klso  l rsze) raktr trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Live stem storage pool fire C flux" %
        output_map[649] = &cf->m_deadstemc_storage_to_fire; //%"Dead stem storage pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Geszt (fatest belso  lettelen rsze) raktr trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Dead stem storage pool fire C flux" %
        output_map[650] = &cf->m_livecrootc_storage_to_fire; //%"Live coarse root storage pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Fs gykr klso  l rsz raktr trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Live coarse root storage pool fire C flux" %
        output_map[651] = &cf->m_deadcrootc_storage_to_fire; //%"Dead coarse root storage pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Fs gykr belso  lettelen rsz raktr trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Dead coarse root storage pool fire C flux" %
        output_map[652] = &cf->m_leafc_transfer_to_fire; //%"Leaf transfer pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levl transzfer troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leaf transfer pool fire C flux" %
        output_map[653] = &cf->m_frootc_transfer_to_fire; //%"Fine root transfer pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Hajszlgykr transzfer troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Fine root transfer pool fire C flux" %
        output_map[654] = &cf->m_yieldc_transfer_to_fire; //%"yield transfer pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Terms transzfer troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "yield transfer pool fire C flux" %
        output_map[655] = &cf->m_softstemc_transfer_to_fire; //%"Softstem transfer pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Lgyszr transzfer troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Softstem transfer pool fire C flux" %
        output_map[656] = &cf->m_livestemc_transfer_to_fire; //%"Live stem transfer pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szjcs (fatest klso  l rsze) transzfer trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Live stem transfer pool fire C flux" %
        output_map[657] = &cf->m_deadstemc_transfer_to_fire; //%"Dead stem transfer pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Geszt (fatest belso  lettelen rsze) transzfer trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Dead stem transfer pool fire C flux" %
        output_map[658] = &cf->m_livecrootc_transfer_to_fire; //%"Live coarse root transfer pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Fs gykr klso  l rsz transzfer trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Live coarse root transfer pool fire C flux" %
        output_map[659] = &cf->m_deadcrootc_transfer_to_fire; //%"Dead coarse root transfer pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Fs gykr belso  lettelen rsz transzfer trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Dead coarse root transfer pool fire C flux" %
        output_map[660] = &cf->m_livestemc_to_fire; //%"Live stem fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szjcs (fatest klso  l rsze) tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Live stem fire C flux" %
        output_map[661] = &cf->m_deadstemc_to_fire; //%"Dead stem fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Geszt (fatest belso  lettelen rsze) tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Dead stem fire C flux" %
        output_map[662] = &cf->m_livecrootc_to_fire; //%"Live coarse root fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Fs gykr klso  l rsznek tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Live coarse root fire C flux" %
        output_map[663] = &cf->m_deadcrootc_to_fire; //%"Dead coarse root fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Fs gykr belso  lettelen rsznek tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Dead coarse root fire C flux" %
        output_map[664] = &cf->m_gresp_storage_to_fire; //%"growth respiration storage pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nvekedsi respirci raktr troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "growth respiration storage pool fire C flux" %
        output_map[665] = &cf->m_gresp_transfer_to_fire; //%"growth respiration transfer pool fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nvekedsi respirci transzfer troz tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "growth respiration transfer pool fire C flux" %
        output_map[666] = &cf->m_litr1c_to_fire_total; //%"labile litter fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalt nvnyi anyag knnyen boml rsznek tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Labile C portion of litter fire C flux" %
        output_map[667] = &cf->m_litr2c_to_fire_total; //%"Unshielded cellulose portion of litter fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz tartalmnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Unshielded cellulose portion of litter fire C flux" %
        output_map[668] = &cf->m_litr3c_to_fire_total; //%"Shielded cellulose portion of litter fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz tartalmnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Shielded cellulose portion of litter fire C flux" %
        output_map[669] = &cf->m_litr4c_to_fire_total; //%"Lignin portion of litter fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Elhalt nvnyi anyag lignin tartalmnak tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Lignin portion of litter fire C flux" %
        output_map[670] = &cf->m_cwdc_to_fire_total; //%"Coarse woody debris fire C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Fs nvnyi maradvny tuzelhalsi fluxusa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Coarse woody debris fire C flux" %
        output_map[671] = &cf->m_vegc_to_SNSC; //%"Total vegetation senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Teljes vegetci elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Total vegetation senescence C flux" %
        output_map[672] = &cf->m_leafc_to_SNSC; //%"Leaf senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levl elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leaf senescence C flux" %
        output_map[673] = &cf->m_leafc_to_SNSCgenprog; //%"Leaf gen. prog. scenescene C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Genetikailag programozott elhals a levlsznre vonatkozan" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$  %
        output_map[674] = &cf->m_frootc_to_SNSC; //%"Fine root senescene C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Hajszlgykr elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Fine root senescene C flux" %
        output_map[675] = &cf->m_yieldc_to_SNSC; //%"yield senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Terms elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "yield senescence C flux" %
        output_map[676] = &cf->m_softstemc_to_SNSC; //%"Softstem senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Lgyszr elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Softstem senescence C flux" %
        output_map[677] = &cf->m_leafc_storage_to_SNSC; //%"Leaf storage pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levl raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leaf storage pool senescence C flux" %
        output_map[678] = &cf->m_frootc_storage_to_SNSC; //%"Fine root storage pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Hajszlgykr raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Fine root storage pool senescence C flux" %
        output_map[679] = &cf->m_leafc_transfer_to_SNSC; //%"Leaf transfer pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levl transzfer troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leaf transfer pool senescence C flux" %
        output_map[680] = &cf->m_frootc_transfer_to_SNSC; //%"Fine root transfer pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Hajszlgykr transzfer troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Fine root transfer pool senescence C flux" %
        output_map[681] = &cf->m_yieldc_storage_to_SNSC; //%"yield storage pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Terms raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "yield storage pool senescence C flux" %
        output_map[682] = &cf->m_yieldc_transfer_to_SNSC; //%"yield transfer pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Terms raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "yield transfer pool senescence C flux" %
        output_map[683] = &cf->m_softstemc_storage_to_SNSC; //%"Softstem storage pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Lgyszr raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Softstem storage pool senescence C flux" %
        output_map[684] = &cf->m_softstemc_transfer_to_SNSC; //%"Softstem transfer pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Lgyszr transzfer troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Softstem transfer pool senescence C flux" %
        output_map[685] = &cf->m_gresp_storage_to_SNSC; //%"growth respiration storage pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nvekedsi respirci raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "growth respiration storage pool senescence C flux" %
        output_map[686] = &cf->m_gresp_transfer_to_SNSC; //%"growth respiration transfer pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nvekedsi respirci transzfer troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "growth respiration transfer pool senescence C flux" %
        output_map[687] = &cf->HRV_leafc_storage_to_SNSC; //%"Harvested leaf storage pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott levl raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested leaf storage pool senescence C flux" %
        output_map[688] = &cf->HRV_leafc_transfer_to_SNSC; //%"Harvested leaf transfer pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott levl transzfer troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested leaf transfer pool senescence C flux" %
        output_map[689] = &cf->HRV_yieldc_storage_to_SNSC; //%"Harvested yield storage pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott terms raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested yield storage pool senescence C flux" %
        output_map[690] = &cf->HRV_yieldc_transfer_to_SNSC; //%"Harvested yield transfer pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott terms transzfer troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested yield transfer pool senescence C flux" %
        output_map[691] = &cf->HRV_frootc_to_SNSC; //%"Harvested fine root senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott hajszlgykr elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested fine root senescence C flux" %
        output_map[692] = &cf->HRV_softstemc_to_SNSC; //%"Harvested softstem senscence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott lgyszr elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested softstem senscence C flux" %
        output_map[693] = &cf->HRV_frootc_storage_to_SNSC; //%"Harvested fine root storage senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott hajszlgykr raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested fine root storage senescence C flux" %
        output_map[694] = &cf->HRV_frootc_transfer_to_SNSC; //%"Harvested fine root transfer senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott hajszlgykr transzfer troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested fine root transfer senescence C flux" %
        output_map[695] = &cf->HRV_softstemc_storage_to_SNSC; //%"Harvested softstem storage senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott lgyszr raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested softstem storage senescence C flux" %
        output_map[696] = &cf->HRV_softstemc_transfer_to_SNSC; //%"Harvested softstem transfer senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott lgyszr transzfer troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested softstem transfer senescence C flux" %
        output_map[697] = &cf->HRV_gresp_storage_to_SNSC; //%"Harvested growth respiration storage pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott nvekedsi respirci raktr troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested growth respiration storage pool senescence C flux" %
        output_map[698] = &cf->HRV_gresp_transfer_to_SNSC; //%"Harvested growth respiration transfer pool senescence C flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartott nvekedsi respirci transzfer troz elregedsbol szrmaz sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Harvested growth respiration transfer pool senescence C flux" %
        output_map[699] = &cf->yieldc_to_flowHS; //%"C flux from yield flowering heat stress" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Terms virgzs alatti hostresszbol eredo sznfluxus" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from yield flowering heat stress" %
        output_map[700] = &cf->STDBc_leaf_to_litr; //%"Leaf standing dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ll elhalt levl biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leaf standing dead biomass C flux to litter" %
        output_map[701] = &cf->STDBc_froot_to_litr; //%"Fine root standing dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ll elhalt hajszlgykr biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Fine root standing dead biomass C flux to litter" %
        output_map[702] = &cf->STDBc_yield_to_litr; //%"yield standing dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ll elhalt terms biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "yield standing dead biomass C flux to litter" %
        output_map[703] = &cf->STDBc_softstem_to_litr; //%"Softstem standing dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ll elhalt lgyszr biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Softstem standing dead biomass C flux to litter" %
		output_map[704] = &cf->litrc_to_soilc_total; //%"Total C flux from litter to soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyagbl a talajba jut sznram" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Total C flux from litter to soil" %
		output_map[705] = &cf->STDBc_to_litr; //%"Standing dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ll elhalt nvnyi biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Standing dead biomass C flux to litter" %
        output_map[706] = &cf->CTDBc_leaf_to_litr; //%"Cut-down leaf dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levgott elhalt levl biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Cut-down leaf dead biomass C flux to litter" %
        output_map[707] = &cf->CTDBc_froot_to_litr; //%"Cut-down fine root dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levgott elhalt hajszlgykr biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Cut-down fine root dead biomass C flux to litter" %
        output_map[708] = &cf->CTDBc_yield_to_litr; //%"Cut-down yield dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levgott elhalt terms biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Cut-down yield dead biomass C flux to litter" %
        output_map[709] = &cf->CTDBc_softstem_to_litr; //%"Cut-down softstem dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levgott elhalt lgyszr biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Cut-down softstem dead biomass C flux to litter" %
		output_map[710] = &cf->cwdc_to_litrc_total; //%"Total C flux from cwd to soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs nvnyi maradvnybl az elhalt nvnyi trozba jut sznram" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Total C flux from cwd to soil" %
		output_map[711] = &cf->CTDBc_cstem_to_cwd; //%"Cut-down coarse stem dead biomass C flux to coarse woody debris" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levgott elhalt fs szr biomassza sznfluxusa Fs nvnyi maradvnyk" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Cut-down coarse stem dead biomass C flux to coarse woody debris" %
        output_map[712] = &cf->CTDBc_croot_to_cwd; //%"Cut-down coarse root dead biomass C flux to coarse woody debris" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levgott elhalt fs gykr sznfluxusa Fs nvnyi maradvnyk" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Cut-down coarse root dead biomass C flux to coarse woody debris" %
        output_map[713] = &cf->CTDBc_to_litr; //%"Cut-down dead biomass C flux to litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Levgott elhalt nvnyi biomassza sznfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Cut-down dead biomass C flux to litter" %
        output_map[714] = &cf->leafc_transfer_to_leafc; //%"Phenology C flux from leaf transfer pool to leaf" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a levl raktr trozbl az aktulis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Phenology C flux from leaf transfer pool to leaf" %
        output_map[715] = &cf->frootc_transfer_to_frootc; //%"Phenology C flux from fine root transfer pool to fine root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a hajszlgykr raktr trozbl az aktulis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Phenology C flux from fine root transfer pool to fine root" %
        output_map[716] = &cf->yieldc_transfer_to_yield; //%"Phenology C flux from yield transfer pool to yield" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a terms raktr trozbl az aktulis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Phenology C flux from yield transfer pool to yield" %
        output_map[717] = &cf->softstemc_transfer_to_softstemc; //%"Phenology C flux from softstem transfer pool to softstem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lgyszr raktr trozbl az aktulis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Phenology C flux from softstem transfer pool to softstem" %
        output_map[718] = &cf->livestemc_transfer_to_livestemc; //%"Phenology C flux from live stem transfer pool to live stem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a szjcs (fs szr klso  l rsz) raktr trozbl az aktulis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Phenology C flux from live stem transfer pool to live stem" %
        output_map[719] = &cf->deadstemc_transfer_to_deadstemc; //%"Phenology C flux from dead stem transfer to dead stem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a geszt (fs szr belso  lettelen rsz) raktr trozbl az aktulis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Phenology C flux from dead stem transfer to dead stem" %
        output_map[720] = &cf->livecrootc_transfer_to_livecrootc; //%"Phenology C flux from live coarse root transfer pool to live coarse root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a fs gykr klso  l rsz raktr trozbl az aktulis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Phenology C flux from live coarse root transfer pool to live coarse root" %
        output_map[721] = &cf->deadcrootc_transfer_to_deadcrootc; //%"Phenology C flux from dead coarse root transfer pool to dead coarse root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a fs gykr belso  lettelen rsz raktr trozbl az aktulis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Phenology C flux from dead coarse root transfer pool to dead coarse root" %
        output_map[722] = &cf->leafc_to_litr1c; //%"C flux from leaf to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a levlbol elhalt nvnyi anyag knnyen boml rszv" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from leaf to labile litter" %
        output_map[723] = &cf->leafc_to_litr2c; //%"C flux from leaf to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a levlbol hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from leaf to unshielded cellulose portion of litter" %
        output_map[724] = &cf->leafc_to_litr3c; //%"C flux from leaf to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a levlbol nem hozzvrheto cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from leaf to shielded cellulose portion of litter" %
        output_map[725] = &cf->leafc_to_litr4c; //%"C flux from leaf to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a levlbol ellenll talaj szervesanyag tartalomm" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from leaf to stable soil organic matter" %
        output_map[726] = &cf->frootc_to_litr1c; //%"C flux from fine root to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a hajszlgykrbol elhalt nvnyi anyag knnyen boml rszv" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fine root to labile litter" %
        output_map[727] = &cf->frootc_to_litr2c; //%"C flux from fine root to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a hajszlgykrbol hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fine root to unshielded cellulose portion of litter" %
        output_map[728] = &cf->frootc_to_litr3c; //%"C flux from fine root to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a hajszlgykrbol nem hozzvrheto cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fine root to shielded cellulose portion of litter" %
        output_map[729] = &cf->frootc_to_litr4c; //%"C flux from fine root to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a hajszlgykrbol ellenll talaj szervesanyag tartalomm" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fine root to stable soil organic matter" %
        output_map[730] = &cf->yieldc_to_litr1c; //%"C flux from yield to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a termsbol elhalt nvnyi anyag knnyen boml rszv" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from yield to labile litter" %
        output_map[731] = &cf->yieldc_to_litr2c; //%"C flux from yield to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a termsbol hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from yield to unshielded cellulose portion of litter" %
        output_map[732] = &cf->yieldc_to_litr3c; //%"C flux from yield to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a termsbol nem hozzvrheto cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from yield to shielded cellulose portion of litter" %
        output_map[733] = &cf->yieldc_to_litr4c; //%"C flux from yield to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a termsbol ellenll talaj szervesanyag tartalomm" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from yield to stable soil organic matter" %
        output_map[734] = &cf->softstemc_to_litr1c; //%"C flux from softstem to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lgyszrbl elhalt nvnyi anyag knnyen boml rszv" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from softstem to labile litter" %
        output_map[735] = &cf->softstemc_to_litr2c; //%"C flux from softstem to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lgyszrbl hozzfrhet cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from softstem to unshielded cellulose portion of litter" %
        output_map[736] = &cf->softstemc_to_litr3c; //%"C flux from softstem to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lgyszrbl nem hozzvrheto cellulzz" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from softstem to shielded cellulose portion of litter" %
        output_map[737] = &cf->softstemc_to_litr4c; //%"C flux from softstem to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lgyszrbl ellenll talaj szervesanyag tartalomm" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from softstem to stable soil organic matter" %
        output_map[738] = &cf->leaf_day_MR; //%"Leaf daylight maintenance respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A levl nappali nfenntart respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leaf daylight maintenance respiration" %
        output_map[739] = &cf->leaf_night_MR; //%"Leaf night maintenance respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A levl jszakai nfenntart respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leaf night maintenance respiration" %
        output_map[740] = &cf->froot_MR; //%"Fine root maintenance respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Hajszlgykr nfenntart respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Fine root maintenance respiration" %
        output_map[741] = &cf->yield_MR; //%"yield maintenance repsiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Terms nfenntart respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "yield maintenance repsiration" %
        output_map[742] = &cf->softstem_MR; //%"Softstem maintenance respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Lgyszr nfenntart respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Softstem maintenance respiration" %
        output_map[743] = &cf->livestem_MR; //%"Live stem maintenance respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szjcs (fatest klso l rsze) nfenntart respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Live stem maintenance respiration" %
        output_map[744] = &cf->livecroot_MR; //%"Live coarse root maintenance respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs szr klso l rsznek nfenntart respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Live coarse root maintenance respiration" %
        output_map[745] = &cf->psnsun_to_cpool; //%" C flux to temporary photosynthate C pool by sunlight" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nappali sznfluxus az tmeneti fotoszintzis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ " C flux to temporary photosynthate C pool by sunlight" %
        output_map[746] = &cf->psnshade_to_cpool; //%"C flux to temporary photosynthate C pool by sunshade" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "jszakai sznfluxus az tmeneti fotoszintzis trozba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux to temporary photosynthate C pool by sunshade" %
        output_map[747] = &cf->cwdc_to_litr2c[0]; //%"C flux from coarse woody debris to unshielded cellulose part of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose part of litter in soil layer 1 (0-3 cm)" %
        output_map[748] = &cf->cwdc_to_litr2c[1]; //%"C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 2 (3-10 cm)" %
        output_map[749] = &cf->cwdc_to_litr2c[2]; //%"C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 3 (10-30 cm)" %
        output_map[750] = &cf->cwdc_to_litr2c[3]; //%"C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 4 (30-60 cm)" %
        output_map[751] = &cf->cwdc_to_litr2c[4]; //%"C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 5 (60-90 cm)" %
        output_map[752] = &cf->cwdc_to_litr2c[5]; //%"C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 6 (90-120 cm)" %
        output_map[753] = &cf->cwdc_to_litr2c[6]; //%"C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 7 (120-150 cm)" %
        output_map[754] = &cf->cwdc_to_litr2c[7]; //%"C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 8 (150-200 cm)" %
        output_map[755] = &cf->cwdc_to_litr2c[8]; //%"C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 9 (200-400 cm)" %
        output_map[756] = &cf->cwdc_to_litr2c[9]; //%"C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to unshielded cellulose portion of litter in soil layer 10 (400-1000 cm)" %
        output_map[757] = &cf->cwdc_to_litr3c[0]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 1 (0-3 cm)" %
        output_map[758] = &cf->cwdc_to_litr3c[1]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 2 (3-10 cm)" %
        output_map[759] = &cf->cwdc_to_litr3c[2]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 3 (10-30 cm)" %
        output_map[760] = &cf->cwdc_to_litr3c[3]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 4 (30-60 cm)" %
        output_map[761] = &cf->cwdc_to_litr3c[4]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 5 (60-90 cm)" %
        output_map[762] = &cf->cwdc_to_litr3c[5]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 6 (90-120 cm)" %
        output_map[763] = &cf->cwdc_to_litr3c[6]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 7 (120-150 cm)" %
        output_map[764] = &cf->cwdc_to_litr3c[7]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 8 (150-200 cm)" %
        output_map[765] = &cf->cwdc_to_litr3c[8]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 9 (200-400 cm)" %
        output_map[766] = &cf->cwdc_to_litr3c[9]; //%"C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to shielded cellulose portion of litter in soil layer 10 (400-1000 cm)" %
        output_map[767] = &cf->cwdc_to_litr4c[0]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 1 (0-3 cm)" %
        output_map[768] = &cf->cwdc_to_litr4c[1]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 2 (3-10 cm)" %
        output_map[769] = &cf->cwdc_to_litr4c[2]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 3 (10-30 cm)" %
        output_map[770] = &cf->cwdc_to_litr4c[3]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 4 (30-60 cm)" %
        output_map[771] = &cf->cwdc_to_litr4c[4]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 5 (60-90 cm)" %
        output_map[772] = &cf->cwdc_to_litr4c[5]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 6 (90-120 cm)" %
        output_map[773] = &cf->cwdc_to_litr4c[6]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 7 (120-150 cm)" %
        output_map[774] = &cf->cwdc_to_litr4c[7]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 8 (150-200 cm)" %
        output_map[775] = &cf->cwdc_to_litr4c[8]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 9 (200-400 cm)" %
        output_map[776] = &cf->cwdc_to_litr4c[9]; //%"C flux from coarse woody debris to lignin portion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus Fs nvnyi maradvnybl ligninn a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from coarse woody debris to lignin portion of litter in soil layer 10 (400-1000 cm)" %
        output_map[777] = &cf->litr1_hr[0]; //%"Heterotroph respiration of labile litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircijaaz 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 1 (0-3 cm)" %
        output_map[778] = &cf->litr1_hr[1]; //%"Heterotroph respiration of labile litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 2 (3-10 cm)" %
        output_map[779] = &cf->litr1_hr[2]; //%"Heterotroph respiration of labile litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 3 (10-30 cm)" %
        output_map[780] = &cf->litr1_hr[3]; //%"Heterotroph respiration of labile litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 4 (30-60 cm)" %
        output_map[781] = &cf->litr1_hr[4]; //%"Heterotroph respiration of labile litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 5 (60-90 cm)" %
        output_map[782] = &cf->litr1_hr[5]; //%"Heterotroph respiration of labile litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 6 (90-120 cm)" %
        output_map[783] = &cf->litr1_hr[6]; //%"Heterotroph respiration of labile litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 7 (120-150 cm)" %
        output_map[784] = &cf->litr1_hr[7]; //%"Heterotroph respiration of labile litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 8 (150-200 cm)" %
        output_map[785] = &cf->litr1_hr[8]; //%"Heterotroph respiration of labile litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 9 (200-400 cm)" %
        output_map[786] = &cf->litr1_hr[9]; //%"Heterotroph respiration of labile litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil layer 10 (400-1000 cm)" %
        output_map[787] = &cf->litr1c_to_soil1c[0]; //%"C flux from labile litter to SOM pool (labile) in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 1 (0-3 cm)" %
        output_map[788] = &cf->litr1c_to_soil1c[1]; //%"C flux from labile litter to SOM pool (labile) in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 2 (3-10 cm)" %
        output_map[789] = &cf->litr1c_to_soil1c[2]; //%"C flux from labile litter to SOM pool (labile) in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 3 (10-30 cm)" %
        output_map[790] = &cf->litr1c_to_soil1c[3]; //%"C flux from labile litter to SOM pool (labile) in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 4 (30-60 cm)" %
        output_map[791] = &cf->litr1c_to_soil1c[4]; //%"C flux from labile litter to SOM pool (labile) in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 5 (60-90 cm)" %
        output_map[792] = &cf->litr1c_to_soil1c[5]; //%"C flux from labile litter to SOM pool (labile) in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 6 (90-120 cm)" %
        output_map[793] = &cf->litr1c_to_soil1c[6]; //%"C flux from labile litter to SOM pool (labile) in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 7 (120-150 cm)" %
        output_map[794] = &cf->litr1c_to_soil1c[7]; //%"C flux from labile litter to SOM pool (labile) in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 8 (150-200 cm)" %
        output_map[795] = &cf->litr1c_to_soil1c[8]; //%"C flux from labile litter to SOM pool (labile) in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 9 (200-400 cm)" %
        output_map[796] = &cf->litr1c_to_soil1c[9]; //%"C flux from labile litter to SOM pool (labile) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus knnyen boml elhalt nvnyi anyagbl a labilis szervesanyag-trozba a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile litter to SOM pool (labile) in soil layer 10 (400-1000 cm)" %
        output_map[797] = &cf->litr2_hr[0]; //%"Heterotroph respiration of unshielded cellulose soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil layer 1 (0-3 cm)" %
        output_map[798] = &cf->litr2_hr[1]; //%"Heterotroph respiration of unshielded cellulose in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose  in soil layer 2 (3-10 cm)" %
        output_map[799] = &cf->litr2_hr[2]; //%"Heterotroph respiration of unshielded cellulose in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil layer 3 (10-30 cm)" %
        output_map[800] = &cf->litr2_hr[3]; //%"Heterotroph respiration of unshielded cellulose in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil layer 4 (30-60 cm)" %
        output_map[801] = &cf->litr2_hr[4]; //%"Heterotroph respiration of unshielded cellulose in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil layer 5 (60-90 cm)" %
        output_map[802] = &cf->litr2_hr[5]; //%"Heterotroph respiration of unshielded cellulose in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil layer 6 (90-120 cm)" %
        output_map[803] = &cf->litr2_hr[6]; //%"Heterotroph respiration of unshielded cellulose in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil layer 7 (120-150 cm)" %
        output_map[804] = &cf->litr2_hr[7]; //%"Heterotroph respiration of unshielded cellulose in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil layer 8 (150-200 cm)" %
        output_map[805] = &cf->litr2_hr[8]; //%"Heterotroph respiration of unshielded cellulose in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil layer 9 (200-400 cm)" %
        output_map[806] = &cf->litr2_hr[9]; //%"Heterotroph respiration of unshielded cellulose in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil layer 10 (400-1000 cm)" %
        output_map[807] = &cf->litr2c_to_soil2c[0]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 1 (0-3 cm)" %
        output_map[808] = &cf->litr2c_to_soil2c[1]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 2 (3-10 cm)" %
        output_map[809] = &cf->litr2c_to_soil2c[2]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 3 (10-30 cm)" %
        output_map[810] = &cf->litr2c_to_soil2c[3]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 4 (30-60 cm)" %
        output_map[811] = &cf->litr2c_to_soil2c[4]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 5 (60-90 cm)" %
        output_map[812] = &cf->litr2c_to_soil2c[5]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 6 (90-120 cm)" %
        output_map[813] = &cf->litr2c_to_soil2c[6]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 7 (120-150 cm)" %
        output_map[814] = &cf->litr2c_to_soil2c[7]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 8 (150-200 cm)" %
        output_map[815] = &cf->litr2c_to_soil2c[8]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 9 (200-400 cm)" %
        output_map[816] = &cf->litr2c_to_soil2c[9]; //%"C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter to SOM pool (fast) in soil layer 10 (400-1000 cm)" %
        output_map[817] = &cf->litr3c_to_litr2c[0]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 1 (0-3 cm)" %
        output_map[818] = &cf->litr3c_to_litr2c[1]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 2 (3-10 cm)" %
        output_map[819] = &cf->litr3c_to_litr2c[2]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 3 (10-30 cm)" %
        output_map[820] = &cf->litr3c_to_litr2c[3]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 4 (30-60 cm)" %
        output_map[821] = &cf->litr3c_to_litr2c[4]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 5 (60-90 cm)" %
        output_map[822] = &cf->litr3c_to_litr2c[5]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 6 (90-120 cm)" %
        output_map[823] = &cf->litr3c_to_litr2c[6]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 7 (120-150 cm)" %
        output_map[824] = &cf->litr3c_to_litr2c[7]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 8 (150-200 cm)" %
        output_map[825] = &cf->litr3c_to_litr2c[8]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 9 (200-400 cm)" %
        output_map[826] = &cf->litr3c_to_litr2c[9]; //%"C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 10 (400-1000 cm)" %
        output_map[827] = &cf->litr4_hr[0]; //%"Heterotroph respiration of lignin portion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 1 (0-3 cm)" %
        output_map[828] = &cf->litr4_hr[1]; //%"Heterotroph respiration of lignin portion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 2 (3-10 cm)" %
		output_map[829] = &cf->litr4_hr[2]; //%"Heterotroph respiration of lignin portion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 3 (10-30 cm)" %
        output_map[830] = &cf->litr4_hr[3]; //%"Heterotroph respiration of lignin portion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 4 (30-60 cm)" %
        output_map[831] = &cf->litr4_hr[4]; //%"Heterotroph respiration of lignin portion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 5 (60-90 cm)" %
        output_map[832] = &cf->litr4_hr[5]; //%"Heterotroph respiration of lignin portion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 6 (90-120 cm)" %
        output_map[833] = &cf->litr4_hr[6]; //%"Heterotroph respiration of lignin portion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 7 (120-150 cm)" %
        output_map[834] = &cf->litr4_hr[7]; //%"Heterotroph respiration of lignin portion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 8 (150-200 cm)" %
        output_map[835] = &cf->litr4_hr[8]; //%"Heterotroph respiration of lignin portion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 9 (200-400 cm)" %
        output_map[836] = &cf->litr4_hr[9]; //%"Heterotroph respiration of lignin portion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil layer 10 (400-1000 cm)" %
        output_map[837] = &cf->litr4c_to_soil3c[0]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 1 (0-3 cm)" %
        output_map[838] = &cf->litr4c_to_soil3c[1]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 2 (3-10 cm)" %
        output_map[839] = &cf->litr4c_to_soil3c[2]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 3 (10-30 cm)" %
        output_map[840] = &cf->litr4c_to_soil3c[3]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 4 (30-60 cm)" %
        output_map[841] = &cf->litr4c_to_soil3c[4]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 5 (60-90 cm)" %
        output_map[842] = &cf->litr4c_to_soil3c[5]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 6 (90-120 cm)" %
        output_map[843] = &cf->litr4c_to_soil3c[6]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 7 (120-150 cm)" %
        output_map[844] = &cf->litr4c_to_soil3c[7]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 8 (150-200 cm)" %
        output_map[845] = &cf->litr4c_to_soil3c[8]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 9 (200-400 cm)" %
        output_map[846] = &cf->litr4c_to_soil3c[9]; //%"C flux from lignin portion of litter to shielded cellulose pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus ligninbol nem hozzfrhet cellulzz a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from lignin portion of litter to shielded cellulose pool in soil layer 10 (400-1000 cm)" %
        output_map[847] = &cf->soil1_hr[0]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil layer 1 (0-3 cm)" %
        output_map[848] = &cf->soil1_hr[1]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil layer  (3-10 cm)" %
        output_map[849] = &cf->soil1_hr[2]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile)in soil layer 3 (10-30 cm)" %
        output_map[850] = &cf->soil1_hr[3]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil layer 4 (30-60 cm)" %
        output_map[851] = &cf->soil1_hr[4]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil layer 5 (60-90 cm)" %
        output_map[852] = &cf->soil1_hr[5]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil layer 6 (90-120 cm)" %
        output_map[853] = &cf->soil1_hr[6]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil layer 7 (120-150 cm)" %
        output_map[854] = &cf->soil1_hr[7]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil layer 8 (150-200 cm)" %
        output_map[855] = &cf->soil1_hr[8]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil layer 9 (200-400 cm)" %
        output_map[856] = &cf->soil1_hr[9]; //%"Heterotroph respiration of SOM pool (labile) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil layer 10 (400-1000 cm)" %
        output_map[857] = &cf->soil1c_to_soil2c[0]; //%"C flux from labile to fast SOM pool in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 1 (0-3 cm)" %
        output_map[858] = &cf->soil1c_to_soil2c[1]; //%"C flux from labile to fast SOM pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 2 (3-10 cm)" %
        output_map[859] = &cf->soil1c_to_soil2c[2]; //%"C flux from labile to fast SOM pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 3 (10-30 cm)" %
        output_map[860] = &cf->soil1c_to_soil2c[3]; //%"C flux from labile to fast SOM pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba  a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 4 (30-60 cm)" %
        output_map[861] = &cf->soil1c_to_soil2c[4]; //%"C flux from labile to fast SOM pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba  az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 5 (60-90 cm)" %
        output_map[862] = &cf->soil1c_to_soil2c[5]; //%"C flux from labile to fast SOM pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba  a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 6 (90-120 cm)" %
        output_map[863] = &cf->soil1c_to_soil2c[6]; //%"C flux from labile to fast SOM pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba  a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 7 (120-150 cm)" %
        output_map[864] = &cf->soil1c_to_soil2c[7]; //%"C flux from labile to fast SOM pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba  a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 8 (150-200 cm)" %
        output_map[865] = &cf->soil1c_to_soil2c[8]; //%"C flux from labile to fast SOM pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba  a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 9 (200-400 cm)" %
        output_map[866] = &cf->soil1c_to_soil2c[9]; //%"C flux from labile to fast SOM pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a labilisbl a gyors bomls SOC trozba  a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from labile to fast SOM pool in soil layer 10 (400-1000 cm)" %
        output_map[867] = &cf->soil2_hr[0]; //%"Heterotroph respiration of SOM pool (fast) in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer 1 (0-3 cm)" %
        output_map[868] = &cf->soil2_hr[1]; //%"Heterotroph respiration of SOM pool (fast) in soil layer  (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer  (3-10 cm)" %
        output_map[869] = &cf->soil2_hr[2]; //%"Heterotroph respiration of SOM pool (fast) in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer 3 (10-30 cm)" %
        output_map[870] = &cf->soil2_hr[3]; //%"Heterotroph respiration of SOM pool (fast) in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer 4 (30-60 cm)" %
        output_map[871] = &cf->soil2_hr[4]; //%"Heterotroph respiration of SOM pool (fast) in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer 5 (60-90 cm)" %
        output_map[872] = &cf->soil2_hr[5]; //%"Heterotroph respiration of SOM pool (fast) in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer 6 (90-120 cm)" %
        output_map[873] = &cf->soil2_hr[6]; //%"Heterotroph respiration of SOM pool (fast) in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer 7 (120-150 cm)" %
        output_map[874] = &cf->soil2_hr[7]; //%"Heterotroph respiration of SOM pool (fast) in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer 8 (150-200 cm)" %
        output_map[875] = &cf->soil2_hr[8]; //%"Heterotroph respiration of SOM pool (fast) in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer 9 (200-400 cm)" %
        output_map[876] = &cf->soil2_hr[9]; //%"Heterotroph respiration of SOM pool (fast) in soil layer 1 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil layer 1 (400-1000 cm)" %
        output_map[877] = &cf->soil2c_to_soil3c[0]; //%"C flux from fast to slow SOM pool in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass SOM trozba az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 1 (0-3 cm)" %
        output_map[878] = &cf->soil2c_to_soil3c[1]; //%"C flux from fast to slow SOM pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass SOM trozba a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 2 (3-10 cm)" %
        output_map[879] = &cf->soil2c_to_soil3c[2]; //%"C flux from fast to slow SOM pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass  SOM trozba a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 3 (10-30 cm)" %
        output_map[880] = &cf->soil2c_to_soil3c[3]; //%"C flux from fast to slow SOM pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass SOM trozba a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 4 (30-60 cm)" %
        output_map[881] = &cf->soil2c_to_soil3c[4]; //%"C flux from fast to slow SOM pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass SOM trozba az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 5 (60-90 cm)" %
        output_map[882] = &cf->soil2c_to_soil3c[5]; //%"C flux from fast to slow SOM pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass SOM trozba a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 6 (90-120 cm)" %
        output_map[883] = &cf->soil2c_to_soil3c[6]; //%"C flux from fast to slow SOM pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass SOM trozba a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 7 (120-150 cm)" %
        output_map[884] = &cf->soil2c_to_soil3c[7]; //%"C flux from fast to slow SOM pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass SOM trozba a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 8 (150-200 cm)" %
        output_map[885] = &cf->soil2c_to_soil3c[8]; //%"C flux from fast to slow SOM pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass SOM trozba a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 9 (200-400 cm)" %
        output_map[886] = &cf->soil2c_to_soil3c[9]; //%"C flux from fast to slow SOM pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a gyorsbl a lass SOM trozba a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from fast to slow SOM pool in soil layer 10 (400-1000 cm)" %
        output_map[887] = &cf->soil3_hr[0]; //%"Heterotroph respiration of SOM pool (slow) in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 1 (0-3 cm)" %
        output_map[888] = &cf->soil3_hr[1]; //%"Heterotroph respiration of SOM pool (slow) in soil layer  (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer  (3-10 cm)" %
        output_map[889] = &cf->soil3_hr[2]; //%"Heterotroph respiration of SOM pool (slow) in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 3 (10-30 cm)" %
        output_map[890] = &cf->soil3_hr[3]; //%"Heterotroph respiration of SOM pool (slow) in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 4 (30-60 cm)" %
        output_map[891] = &cf->soil3_hr[4]; //%"Heterotroph respiration of SOM pool (slow) in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 5 (60-90 cm)" %
        output_map[892] = &cf->soil3_hr[5]; //%"Heterotroph respiration of SOM pool (slow) in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 6 (90-120 cm)" %
        output_map[893] = &cf->soil3_hr[6]; //%"Heterotroph respiration of SOM pool (slow) in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 7 (120-150 cm)" %
        output_map[894] = &cf->soil3_hr[7]; //%"Heterotroph respiration of SOM pool (slow) in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 8 (150-200 cm)" %
        output_map[895] = &cf->soil3_hr[8]; //%"Heterotroph respiration of SOM pool (slow) in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 9 (200-400 cm)" %
        output_map[896] = &cf->soil3_hr[9]; //%"Heterotroph respiration of SOM pool (slow) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 10 (400-1000 cm)" %
        output_map[897] = &cf->soil3c_to_soil4c[0]; //%"C flux from slow to stable SOM SOM pool in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 1 (0-3 cm)" %
        output_map[898] = &cf->soil3c_to_soil4c[1]; //%"C flux from slow to stable SOM in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 2 (3-10 cm)" %
        output_map[899] = &cf->soil3c_to_soil4c[2]; //%"C flux from slow to stable SOM in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 3 (10-30 cm)" %
        output_map[900] = &cf->soil3c_to_soil4c[3]; //%"C flux from slow to stable SOM in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 4 (30-60 cm)" %
        output_map[901] = &cf->soil3c_to_soil4c[4]; //%"C flux from slow to stable SOM in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 5 (60-90 cm)" %
        output_map[902] = &cf->soil3c_to_soil4c[5]; //%"C flux from slow to stable SOM in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 6 (90-120 cm)" %
        output_map[903] = &cf->soil3c_to_soil4c[6]; //%"C flux from slow to stable SOM in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 7 (120-150 cm)" %
        output_map[904] = &cf->soil3c_to_soil4c[7]; //%"C flux from slow to stable SOM in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 8 (150-200 cm)" %
        output_map[905] = &cf->soil3c_to_soil4c[8]; //%"C flux from slow to stable SOM in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 9 (200-400 cm)" %
        output_map[906] = &cf->soil3c_to_soil4c[9]; //%"C flux from slow to stable SOM in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Sznfluxus a lass SOM trozbl ellenll talaj szervesanyag tartalomm (leglassabb) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from slow to stable soil organic matter in soil layer 10 (400-1000 cm)" %
        output_map[907] = &cf->soil4_hr[0]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 1 (0-3 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 1 (0-3 cm)" %
        output_map[908] = &cf->soil4_hr[1]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 2 (3-10 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer  (3-10 cm)" %
        output_map[909] = &cf->soil4_hr[2]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 3 (10-30 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 3 (10-30 cm)" %
        output_map[910] = &cf->soil4_hr[3]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 4 (30-60 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 4 (30-60 cm)" %
        output_map[911] = &cf->soil4_hr[4]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 5 (60-90 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 5 (60-90 cm)" %
        output_map[912] = &cf->soil4_hr[5]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 6 (90-120 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable)  in soil layer 6 (90-120 cm)" %
        output_map[913] = &cf->soil4_hr[6]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 7 (120-150 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 7 (120-150 cm)" %
        output_map[914] = &cf->soil4_hr[7]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 8 (150-200 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 8 (150-200 cm)" %
        output_map[915] = &cf->soil4_hr[8]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 9 (200-400 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 9 (200-400 cm)" %
        output_map[916] = &cf->soil4_hr[9]; //%"Heterotroph respiration of SOM pool (stable) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil layer 1 (400-1000 cm)" %
	
        output_map[968] = &cf->litr1c_to_soil1c_total; //%"C flux from labile C portion of litter to SOM pool (labile) in total soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Citrogcfluxus kccyec boml elhalt cvcyi acyagbl szervesacyag szctartalmcak ba (labilis) a teljes talajoszlopbac" $\\left[\\kg_{C}m^{-2 }cap{^-1} \\right]$ "Citrogec flux from labile C portion of litter to SOM pool (labile) in total soil" %
        output_map[969] = &cf->litr2c_to_soil2c_total; //%"C flux from ucshielded cellulose C portion of litter to SOM pool (fast) in total soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Citrogcfluxus hozzfrheto cellulzbl szervesacyag szctartalmcak ba (gyors) a teljes talajoszlopbac" $\\left[\\kg_{C}m^{-2 }cap{^-1} \\right]$ "Citrogec flux from ucshielded cellulose C portion of litter to SOM pool (fast) in total soil" %
        output_map[970] = &cf->litr3c_to_litr2c_total; //%"C flux from shielded cellulose portion of litter to ucshielded cellulose pool in total soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Citrogcfluxus cem hozzfrheto cellulzbl hozzfrheto cellulzz a teljes talajoszlopbac" $\\left[\\kg_{C}m^{-2 }cap{^-1} \\right]$ "Citrogec flux from shielded cellulose portion of litter to ucshielded cellulose pool in total soil" %
        output_map[971] = &cf->litr4c_to_soil3c_total; //%"C flux from ligcin portion of litter to shielded cellulose pool in total soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Citrogcfluxus ligcinbol cem hozzfrheto cellulzz a teljes talajoszlopbac" $\\left[\\kg_{C}m^{-2 }cap{^-1} \\right]$ "Citrogec flux from ligcin portion of litter to shielded cellulose pool in total soil" %
        output_map[972] = &cf->soil1c_to_soil2c_total; //%"C flux from labile to fast decomposing SOM pool in total soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Citrogcfluxus a labilisbl a gyors szervesacyag szctartalmcak bac a teljes talajoszlopbac" $\\left[\\kg_{C}m^{-2 }cap{^-1} \\right]$ "Citrogec flux from labile to fast decomposing SOM pool in total soil" %
        output_map[973] = &cf->soil2c_to_soil3c_total; //%"C flux from fast to slow decomposing SOM pool in total soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Citrogcfluxus a gyorsbl a lass szervesacyag szctartalmcak bac a teljes talajoszlopbac" $\\left[\\kg_{C}m^{-2 }cap{^-1} \\right]$ "Citrogec flux from fast to slow decomposing SOM pool in total soil" %
        output_map[974] = &cf->soil3c_to_soil4c_total; //%"C flux from slow to stable SOM C coctect of SOM pool in total soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Citrogcfluxus a lass szervesacyag szctartalmcak bl ellecll talaj szervesacyag tartalomm (leglassabb) a teljes talajoszlopbac" $\\left[\\kg_{C}m^{-2 }cap{^-1} \\right]$ "Citrogec flux from slow to stable SOM C coctect of SOM pool in total soil" %
        
 		output_map[998] = &cf->cpool_to_leafc; //%"Daily allocation C flux from current GPP to leaf" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a levlbe" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to leaf" %
        output_map[999] = &cf->cpool_to_leafc_storage; //%"Dail allocation C flux from current GPP to leaf storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a levl raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Dail allocation C flux from current GPP to leaf storage pool" %
        output_map[1000] = &cf->cpool_to_frootc; //%"Daily allocation C flux from current GPP to fine root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a hajszlgykrbe" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to fine root" %
        output_map[1001] = &cf->cpool_to_frootc_storage; //%"Daily allocation C flux from current GPP to fine root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a hajszlgykr raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to fine root storage pool" %
        output_map[1002] = &cf->cpool_to_yield; //%"Daily allocation C flux from current GPP to yield" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a termsbe" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to yield" %
        output_map[1003] = &cf->cpool_to_yieldc_storage; //%"Daily allocation C flux from current GPP to yield storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a terms raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to yield storage pool" %
        output_map[1004] = &cf->cpool_to_softstemc; //%"Daily allocation C flux from current GPP to softstem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a lgyszrba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to softstem" %
        output_map[1005] = &cf->cpool_to_softstemc_storage; //%"Daily allocation C flux from current GPP to softstem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a lgyszr raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to softstem storage pool" %
        output_map[1006] = &cf->cpool_to_livestemc; //%"Daily allocation C flux from current GPP to live stem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a szjcsba (fatest klso l rsze)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to live stem" %
        output_map[1007] = &cf->cpool_to_livestemc_storage; //%"Daily alloaction C flux from current GPP to live stem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a szjcs raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily alloaction C flux from current GPP to live stem storage pool" %
        output_map[1008] = &cf->cpool_to_deadstemc; //%"Daily allocation C flux from current GPP to dead stem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a gesztbe (fatest belso lettelen rsze)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to dead stem" %
        output_map[1009] = &cf->cpool_to_deadstemc_storage; //%"Daily allocation C flux from current GPP to dead stem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a geszt raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to dead stem storage pool" %
        output_map[1010] = &cf->cpool_to_livecrootc; //%"Daily allocation C flux from current GPP to live coarse root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a fs gykr klso l rszbe" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to live coarse root" %
        output_map[1011] = &cf->cpool_to_livecrootc_storage; //%"Daily allocation C flux from current GPP to live coarse root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a fs gykr klso l rsznek raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to live coarse root storage pool" %
        output_map[1012] = &cf->cpool_to_deadcrootc; //%"Daily allocation C flux from current GPP to dead coarse root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a fs gykr belso lettelen rszbe" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to dead coarse root" %
        output_map[1013] = &cf->cpool_to_deadcrootc_storage; //%"Daily allocation C flux from current GPP to dead coarse root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a fs gykr belso lettelen rsznek raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to dead coarse root storage pool" %
        output_map[1014] = &cf->cpool_to_gresp_storage; //%"Daily allocation C flux from current GPP to growth respiration storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az aktulis GPP-bol a nvekedsi respirci raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily allocation C flux from current GPP to growth respiration storage pool" %
        output_map[1015] = &cf->cpool_leaf_GR; //%"Daily leaf growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A levl napi nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily leaf growth respiration flux" %
        output_map[1016] = &cf->cpool_leaf_storage_GR; //%"Daily leaf storage pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A levl raktr trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily leaf storage pool growth respiration flux" %
        output_map[1017] = &cf->transfer_leaf_GR; //%"Daily leaf transfer pool respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A levl transzfer trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily leaf transfer pool respiration flux" %
        output_map[1018] = &cf->cpool_froot_GR; //%"Daily fine root growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A hajszlgykr napi nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily fine root growth respiration flux" %
        output_map[1019] = &cf->cpool_froot_storage_GR; //%"Daily fine root storage pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A hajszlgykr raktr trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily fine root storage pool growth respiration flux" %
        output_map[1020] = &cf->transfer_froot_GR; //%"Daily fine root transfer pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A hajszlgykr transzfer trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily fine root transfer pool growth respiration flux" %
        output_map[1021] = &cf->cpool_yield_GR; //%"Daily yield growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A terms napi nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily yield growth respiration flux" %
        output_map[1022] = &cf->cpool_yieldc_storage_GR; //%"Daily yield storage pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A terms raktr trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily yield storage pool growth respiration flux" %
        output_map[1023] = &cf->transfer_yield_GR; //%"Daily yield transfer pool gowth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A terms transzfer trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily yield transfer pool gowth respiration flux" %
        output_map[1024] = &cf->cpool_softstem_GR; //%"Daily softstem growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lgyszr napi nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily softstem growth respiration flux" %
        output_map[1025] = &cf->cpool_softstem_storage_GR; //%"Daily softstem storage pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lgyszr raktr trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily softstem storage pool growth respiration flux" %
        output_map[1026] = &cf->transfer_softstem_GR; //%"Daily softstem transfer pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lgyszr transzfer trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily softstem transfer pool growth respiration flux" %
        output_map[1027] = &cf->cpool_livestem_GR; //%"Daily live stem growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A szjcs (fatest klso l rsze) napi nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily live stem growth respiration flux" %
        output_map[1028] = &cf->cpool_livestem_storage_GR; //%"Daily live stem storage pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A szjcs (fatest klso l rsze) raktr trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily live stem storage pool growth respiration flux" %
        output_map[1029] = &cf->transfer_livestem_GR; //%"Daily live stem transfer pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A szjcs (fatest klso l rsze) transzfer trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily live stem transfer pool growth respiration flux" %
        output_map[1030] = &cf->cpool_deadstem_GR; //%"Daily dead stem growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A geszt (fatest belso lettelen rsze) napi nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily dead stem growth respiration flux" %
        output_map[1031] = &cf->cpool_deadstem_storage_GR; //%"Daily dead stem storage pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A geszt (fatest belso lettelen rsze) raktr trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily dead stem storage pool growth respiration flux" %
        output_map[1032] = &cf->transfer_deadstem_GR; //%"Daily dead stem transfer pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A geszt (fatest belso lettelen rsze) transzfer trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily dead stem transfer pool growth respiration flux" %
        output_map[1033] = &cf->cpool_livecroot_GR; //%"Daily live coarse root growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs gykr klso l rsznek napi nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily live coarse root growth respiration flux" %
        output_map[1034] = &cf->cpool_livecroot_storage_GR; //%"Daily live coarse root storage pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs gykr klso l rsznek raktr trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily live coarse root storage pool growth respiration flux" %
        output_map[1035] = &cf->transfer_livecroot_GR; //%"Daily live coarse root transfer pool growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs gykr klso l rsznek transzfer trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily live coarse root transfer pool growth respiration flux" %
        output_map[1036] = &cf->cpool_deadcroot_GR; //%"Daily dead coarse root growth respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs gykr belso lettelen rsznek napi nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily dead coarse root growth respiration flux" %
        output_map[1037] = &cf->cpool_deadcroot_storage_GR; //%"Daily dead coarse root storage pool respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs gykr belso lettelen rsznek raktr trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily dead coarse root storage pool respiration flux" %
        output_map[1038] = &cf->transfer_deadcroot_GR; //%"Daily dead coarse root transfer pool respiration flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs gykr belso lettelen rsznek transzfer trozjnak nvekedsi respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily dead coarse root transfer pool respiration flux" %
        output_map[1039] = &cf->leafc_storage_to_MRdef; //%"Daily maintenance respiration ensuring flux from leaf storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a levl raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from leaf storage pool" %
        output_map[1040] = &cf->frootc_storage_to_MRdef; //%"Daily maintenance respiration ensuring flux from fine root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a hajszlgykr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from fine root storage pool" %
        output_map[1041] = &cf->yieldc_storage_to_MRdef; //%"Daily maintenance respiration ensuring flux from yield storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a terms raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from yield storage pool" %
        output_map[1042] = &cf->softstemc_storage_to_MRdef; //%"Daily maintenance respiration ensuring flux from softstem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from softstem storage pool" %
        output_map[1043] = &cf->livestemc_storage_to_MRdef; //%"Daily maintenance respiration ensuring flux from live stem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a szjcs (fatest klso l rsze) raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from live stem storage pool" %
        output_map[1044] = &cf->livecrootc_storage_to_MRdef; //%"Daily maintenance respiration ensuring flux from live coarse root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a fs gykr klso l rsznek raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from live coarse root storage pool" %
        output_map[1045] = &cf->deadstemc_storage_to_MRdef; //%"Daily maintenance respiration ensuring flux from dead stem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a geszt (fatest belso lettelen rsze) raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from dead stem storage pool" %
        output_map[1046] = &cf->deadcrootc_storage_to_MRdef; //%"Daily maintenance respiration ensuring flux from dead coarse root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a fs gykr belso lettelen rsznek raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from dead coarse root storage pool" %
        output_map[1047] = &cf->leafc_transfer_to_MRdef; //%"Daily maintenance respiration ensuring flux from leaf transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a levl transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from leaf transfer pool" %
        output_map[1048] = &cf->frootc_transfer_to_MRdef; //%"Daily maintenance respiration ensuring flux from fine root transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a hajszlgykr transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from fine root transfer pool" %
        output_map[1049] = &cf->yieldc_transfer_to_MRdef; //%"Daily maintenance respiration ensuring flux from yield transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a terms transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from yield transfer pool" %
        output_map[1050] = &cf->softstemc_transfer_to_MRdef; //%"Daily maintenance respiration ensuring flux from softstem transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from softstem transfer pool" %
        output_map[1051] = &cf->livestemc_transfer_to_MRdef; //%"Daily maintenance respiration ensuring flux from live stem transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a szjcs (fatest klso l rsze) transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from live stem transfer pool" %
        output_map[1052] = &cf->livecrootc_transfer_to_MRdef; //%"Daily maintenance respiration ensuring flux from live coarse root transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a fs gykr klso l rsznek transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from live coarse root transfer pool" %
        output_map[1053] = &cf->deadstemc_transfer_to_MRdef; //%"Daily maintenance respiration ensuring flux from dead stem transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a geszt (fatest belso lettelen rsze) transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from dead stem transfer pool" %
        output_map[1054] = &cf->deadcrootc_transfer_to_MRdef; //%"Daily maintenance respiration ensuring flux from dead coarse root transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a fs gykr belso lettelen rsznek transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from dead coarse root transfer pool" %
        output_map[1055] = &cf->leafc_to_MRdef; //%"Daily maintenance respiration ensuring flux from leaf" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a levlbol" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from leaf" %
        output_map[1056] = &cf->frootc_to_MRdef; //%"Daily maintenance respiration ensuring flux from fine root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a hajszlgykrbol" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from fine root" %
        output_map[1057] = &cf->yieldc_to_MRdef; //%"Daily maintenance respiration ensuring flux from yield" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a termsbol" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from yield" %
        output_map[1058] = &cf->softstemc_to_MRdef; //%"Daily maintenance respiration ensuring flux from softstem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a lgyszrbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from softstem" %
        output_map[1059] = &cf->livestemc_to_MRdef; //%"Daily maintenance respiration ensuring flux from live stem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a szjcsbl (fatest klso l rsze)" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from live stem" %
        output_map[1060] = &cf->livecrootc_to_MRdef; //%"Daily maintenance respiration ensuring flux from live coarse root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a fs gykr klso l rszbol" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from live coarse root" %
        output_map[1061] = &cf->NSCnw_to_MRdef; //%"Daily maintenance respiration ensuring flux from non-structured non-woody carbohydrates" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus nem strukturlt nem fs sznhidrtokbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from non-structured non-woody carbohydrates" %
        output_map[1062] = &cf->SCnw_to_MRdef; //%"Daily maintenance respiration ensuring flux from non-woody portion ofactual C pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a nem fs aktulis szntrozbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from non-woody portion ofactual C pool" %
        output_map[1063] = &cf->NSCw_to_MRdef; //%"Daily maintenance respiration ensuring flux from non-structured woody carbohydrates" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus nem strukturlt fs sznhidrtokbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from non-structured woody carbohydrates" %
        output_map[1064] = &cf->SCw_to_MRdef; //%"Daily maintenance respiration ensuring flux from woody portion ofactual C pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respircit biztost sznfluxus a fs aktulis szntrozbl" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily maintenance respiration ensuring flux from woody portion ofactual C pool" %
        output_map[1065] = &cf->leafc_storage_to_leafc_transfer; //%"Annual turnover of leaf storage to transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a levl raktr trozjbl a transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Annual turnover of leaf storage to transfer pool" %
        output_map[1066] = &cf->frootc_storage_to_frootc_transfer; //%"Annual turnover of fine root storage to transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a hajszlgykr raktr trozjbl a transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Annual turnover of fine root storage to transfer pool" %
        output_map[1067] = &cf->yieldc_storage_to_yieldc_transfer; //%"Annual turnover of yield storage to transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a terms raktr trozjbl a transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Annual turnover of yield storage to transfer pool" %
        output_map[1068] = &cf->softstemc_storage_to_softstemc_transfer; //%"Annual turnover of softstem storage to transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a lgyszr raktr trozjbl a transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Annual turnover of softstem storage to transfer pool" %
        output_map[1069] = &cf->livestemc_storage_to_livestemc_transfer; //%"Annual turnover of live stem storage to transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a szjcs (fatest klso l rsze) raktr trozjbl a transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Annual turnover of live stem storage to transfer pool" %
        output_map[1070] = &cf->deadstemc_storage_to_deadstemc_transfer; //%"Annual turnover of dead stem storage to transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a geszt (fatest belso lettelen rsze) raktr trozjbl a transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Annual turnover of dead stem storage to transfer pool" %
        output_map[1071] = &cf->livecrootc_storage_to_livecrootc_transfer; //%"Annual turnover of live coarse root storage to transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a fs gykr klso l rsz raktr trozjbl a transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Annual turnover of live coarse root storage to transfer pool" %
        output_map[1072] = &cf->deadcrootc_storage_to_deadcrootc_transfer; //%"Annual turnover of dead coarse root storage to transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a fs gykr belso lettelen rsz raktr trozjbl a transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Annual turnover of dead coarse root storage to transfer pool" %
        output_map[1073] = &cf->gresp_storage_to_gresp_transfer; //%"Annual turnover of growth respiration storage to transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a nvekedsi respirci raktr trozjbl a transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Annual turnover of growth respiration storage to transfer pool" %
        output_map[1074] = &cf->livestemc_to_deadstemc; //%"Annual turnover of live stem to dead stem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a szr l rszbol az lettelen rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Annual turnover of live stem to dead stem" %
        output_map[1075] = &cf->livecrootc_to_deadcrootc; //%"Annual turnover of live coarse root to dead coarse root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "ves sznforgalom a fs gykr l rszbol az lettelen rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Annual turnover of live coarse root to dead coarse root" %
        output_map[1076] = &cf->leafc_transfer_from_PLT; //%"Leaf transfer pool C flux from planting" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Vetsi sznfluxus a levl transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Leaf transfer pool C flux from planting" %
        output_map[1077] = &cf->frootc_transfer_from_PLT; //%"Fine root transfer pool C flux from planting" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Vetsi sznfluxus a hajszlgykr transzfer trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Fine root transfer pool C flux from planting" %
        output_map[1078] = &cf->yieldc_transfer_from_PLT; //%"yield transfer pool C flux from planting" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Vetsi sznfluxus a terms raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "yield transfer pool C flux from planting" %
        output_map[1079] = &cf->softstemc_transfer_from_PLT; //%"Softstem transfer pool C flux from planting" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Vetsi sznfluxus a lgyszr raktr trozjba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Softstem transfer pool C flux from planting" %
        output_map[1080] = &cf->leafc_to_THN; //%"Thinning C flux from leaf" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levlbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from leaf" %
        output_map[1081] = &cf->leafc_storage_to_THN; //%"Thinning C flux from leaf storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levl raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from leaf storage pool" %
        output_map[1082] = &cf->leafc_transfer_to_THN; //%"Thinning C flux from leaf transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levl transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from leaf transfer pool" %
        output_map[1083] = &cf->yieldc_to_THN; //%"Thinning C flux from yield" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a termsbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from yield" %
        output_map[1084] = &cf->yieldc_storage_to_THN; //%"Thinning C flux from yield storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a terms raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from yield storage pool" %
        output_map[1085] = &cf->yieldc_transfer_to_THN; //%"Thinning C flux from yield transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a terms transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from yield transfer pool" %
        output_map[1086] = &cf->livestemc_to_THN; //%"Thinning C flux from live stem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a szjcsbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from live stem" %
        output_map[1087] = &cf->livestemc_storage_to_THN; //%"Thinning C flux from live stem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a szjcs raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from live stem storage pool" %
        output_map[1088] = &cf->livestemc_transfer_to_THN; //%"Thinning C flux from live stem transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a szjcs transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from live stem transfer pool" %
        output_map[1089] = &cf->deadstemc_to_THN; //%"Thinning C flux from dead stem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gesztbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from dead stem" %
        output_map[1090] = &cf->deadstemc_storage_to_THN; //%"Thinning C flux from dead stem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a geszt raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from dead stem storage pool" %
        output_map[1091] = &cf->deadstemc_transfer_to_THN; //%"Thinning C flux from dead stem transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a geszt transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from dead stem transfer pool" %
        output_map[1092] = &cf->gresp_storage_to_THN; //%"Thinning C flux from growth respiration storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a nvekedsi respirci raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from growth respiration storage pool" %
        output_map[1093] = &cf->gresp_transfer_to_THN; //%"Thinning C flux from growth respiration transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a nvekedsi respirci transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from growth respiration transfer pool" %
        output_map[1094] = &cf->THN_to_CTDBc_leaf; //%"Thinning C flux to cut-down leaf biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levgott levl biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux to cut-down leaf biomass" %
        output_map[1095] = &cf->THN_to_CTDBc_yield; //%"Thinning C flux to cut-down yield biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levgott terms biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux to cut-down yield biomass" %
        output_map[1097] = &cf->THN_to_CTDBc_cstem; //%"Thinning C flux to cut-down coarse stem biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levgott fs szr biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux to cut-down coarse stem biomass" %
        output_map[1098] = &cf->STDBc_leaf_to_THN; //%"Thinning C flux from wilted leaf biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from wilted leaf biomass" %
        output_map[1099] = &cf->STDBc_yield_to_THN; //%"Thinning C flux from wilted yield biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from wilted yield biomass" %
        output_map[1100] = &cf->litrc_to_release_total; //%"Sum of direct decomposition carbon flux of litter pools" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt szervesanyag direkt bomlsnak teljes sznfluxusa" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Sum of direct decomposition carbon flux of litter pools" %
		output_map[1101] = &cf->leafc_to_MOW; //%"Mowing C flux from leaf" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a levlbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from leaf" %
        output_map[1102] = &cf->leafc_storage_to_MOW; //%"Mowing C flux from leaf storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a levl raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from leaf storage pool" %
        output_map[1103] = &cf->leafc_transfer_to_MOW; //%"Mowing C flux from leaf transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a levl transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from leaf transfer pool" %
        output_map[1104] = &cf->yieldc_to_MOW; //%"Mowing C flux from yield" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a termsbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from yield" %
        output_map[1105] = &cf->yieldc_storage_to_MOW; //%"Mowing C flux from yield storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a terms raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from yield storage pool" %
        output_map[1106] = &cf->yieldc_transfer_to_MOW; //%"Mowing C flux from yield transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a terms transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from yield transfer pool" %
        output_map[1107] = &cf->softstemc_to_MOW; //%"Mowing C flux from softstem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a lgyszrbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from softstem" %
        output_map[1108] = &cf->softstemc_storage_to_MOW; //%"Mowing C flux from softstem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from softstem storage pool" %
        output_map[1109] = &cf->softstemc_transfer_to_MOW; //%"Mowing C flux from softstem transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from softstem transfer pool" %
        output_map[1110] = &cf->gresp_storage_to_MOW; //%"Mowing C flux from growth respiration storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a nvekedsi respirci raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from growth respiration storage pool" %
        output_map[1111] = &cf->gresp_transfer_to_MOW; //%"Mowing C flux from growth respiration transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a nvekedsi respirci transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from growth respiration transfer pool" %
        output_map[1112] = &cf->MOW_to_CTDBc_leaf; //%"Mowing C flux to cut-down leaf biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a levgott levl biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux to cut-down leaf biomass" %
        output_map[1113] = &cf->MOW_to_CTDBc_yield; //%"Mowing C flux to cut-down yield biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a levgott terms biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux to cut-down yield biomass" %
        output_map[1114] = &cf->MOW_to_CTDBc_softstem; //%"Mowing C flux to cut-down softstem biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus a levgott lgyszr biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux to cut-down softstem biomass" %
        output_map[1116] = &cf->STDBc_leaf_to_MOW; //%"Mowing C flux from wilted leaf biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from wilted leaf biomass" %
        output_map[1117] = &cf->STDBc_yield_to_MOW; //%"Mowing C flux from wilted yield biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from wilted yield biomass" %
        output_map[1118] = &cf->STDBc_softstem_to_MOW; //%"Mowing C flux from wilted softstem biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kaszlsi sznfluxus az elhervadt lgyszr biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Mowing C flux from wilted softstem biomass" %

        output_map[1120] = &cf->leafc_to_HRV; //%"Harvesting C flux from leaf" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a levlbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from leaf" %
        output_map[1121] = &cf->leafc_storage_to_HRV; //%"Harvesting C flux from leaf storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a levl raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from leaf storage pool" %
        output_map[1122] = &cf->leafc_transfer_to_HRV; //%"Harvesting C flux from leaf transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a levl transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from leaf transfer pool" %
        output_map[1123] = &cf->yieldc_to_HRV; //%"Harvesting C flux from yield" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a termsbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from yield" %
        output_map[1124] = &cf->yieldc_storage_to_HRV; //%"Harvesting C flux from yield storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a terms raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from yield storage pool" %
        output_map[1125] = &cf->yieldc_transfer_to_HRV; //%"Harvesting C flux from yield transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a terms transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from yield transfer pool" %
        output_map[1126] = &cf->softstemc_to_HRV; //%"Harvesting C flux from softstem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a lgyszrbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from softstem" %
        output_map[1127] = &cf->softstemc_storage_to_HRV; //%"Harvesting C flux from softstem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from softstem storage pool" %
        output_map[1128] = &cf->softstemc_transfer_to_HRV; //%"Harvesting C flux from softstem transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from softstem transfer pool" %
        output_map[1129] = &cf->frootc_to_HRV; //%"Harvesting C flux from fine root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a finomgyrrzetbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from fine root" %
        output_map[1130] = &cf->frootc_storage_to_HRV; //%"Harvesting C flux from fine root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a finomgyrrzetbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from fine root" %
        output_map[1131] = &cf->frootc_transfer_to_HRV; //%"Harvesting C flux from fine root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a finomgyrrzetbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from fine root" %
        output_map[1132] = &cf->gresp_storage_to_HRV; //%"Harvesting C flux from growth respiration storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a nvekedsi respirci raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from growth respiration storage pool" %
        output_map[1133] = &cf->gresp_transfer_to_HRV; //%"Harvesting C flux from growth respiration transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a nvekedsi respirci transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from growth respiration transfer pool" %
        output_map[1134] = &cf->HRV_to_CTDBc_leaf; //%"Harvesting C flux to cut-down leaf biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a levgott levl biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux to cut-down leaf biomass" %
        output_map[1135] = &cf->HRV_to_CTDBc_softstem; //%"Harvesting C flux to cut-down softstem biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus a levgott lgyszr biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux to cut-down softstem biomass" %
        output_map[1136] = &cf->STDBc_leaf_to_HRV; //%"Harvesting C flux from wilted leaf biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from wilted leaf biomass" %
        output_map[1137] = &cf->STDBc_softstem_to_HRV; //%"Harvesting C flux from wilted softstem biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus az elhervadt lgyszr biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from wilted softstem biomass" %  
        output_map[1138] = &cf->STDBc_yield_to_HRV; //%"Harvesting C flux from wilted yield biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Betakartsi sznfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Harvesting C flux from wilted yield biomass" %  
        output_map[1139] = &cf->leafc_to_PLG; //%"Ploughing C flux from leaf" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a levlbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from leaf" %
        output_map[1140] = &cf->leafc_storage_to_PLG; //%"Ploughing C flux from leaf storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a levl raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from leaf storage pool" %
        output_map[1141] = &cf->leafc_transfer_to_PLG; //%"Ploughing C flux from leaf transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a levl transzfer trozjban" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from leaf transfer pool" %
        output_map[1142] = &cf->frootc_to_PLG; //%"Ploughing C flux from fine root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a hajszlgykrzetbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from fine root" %
        output_map[1143] = &cf->frootc_storage_to_PLG; //%"Ploughing C flux from fine root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a hajszlgykrzet raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from fine root storage pool" %
        output_map[1144] = &cf->frootc_transfer_to_PLG; //%"Ploughing C flux from fine root transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a hajszlgykr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from fine root transfer pool" %
        output_map[1145] = &cf->yieldc_to_PLG; //%"Ploughing C flux from yield" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a termsbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from yield" %
        output_map[1146] = &cf->yieldc_storage_to_PLG; //%"Ploughing C flux from yield storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a terms raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from yield storage pool" %
        output_map[1147] = &cf->yieldc_transfer_to_PLG; //%"Ploughing C flux from yield transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a terms transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from yield transfer pool" %
        output_map[1148] = &cf->softstemc_to_PLG; //%"Ploughing C flux from softstem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a lgyszrbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from softstem" %
        output_map[1149] = &cf->softstemc_storage_to_PLG; //%"Ploughing C flux from softstem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from softstem storage pool" %
        output_map[1150] = &cf->softstemc_transfer_to_PLG; //%"Ploughing C flux from softstem transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from softstem transfer pool" %
        output_map[1151] = &cf->gresp_storage_to_PLG; //%"Ploughing C flux from growth respiration storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a nvekedsi respirci raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from growth respiration storage pool" %
        output_map[1152] = &cf->gresp_transfer_to_PLG; //%"Ploughing C flux from growth respiration transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a nvekedsi respirci transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from growth respiration transfer pool" %
        output_map[1153] = &cf->STDBc_leaf_to_PLG; //%"Ploughing C flux from wilted leaf biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from wilted leaf biomass" %
        output_map[1154] = &cf->STDBc_froot_to_PLG; //%"Ploughing C flux from wilted fine root biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus az elhervadt hajszlgykr biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from wilted fine root biomass" %
        output_map[1155] = &cf->STDBc_yield_to_PLG; //%"Ploughing C flux from wilted yield biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from wilted yield biomass" %
        output_map[1156] = &cf->STDBc_softstem_to_PLG; //%"Ploughing C flux from wilted softstem biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus az elhervadt lgyszr biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from wilted softstem biomass" %
        output_map[1157] = &cf->cwdc_to_CWE; //%"Coarse woody debris extract flux" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "
        output_map[1158] = &cf->CTDBc_leaf_to_PLG; //%"Ploughing C flux from cut-down leaf biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a levgott levl biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from cut-down leaf biomass" %
        output_map[1159] = &cf->CTDBc_yield_to_PLG; //%"Ploughing C flux from cut-down yield biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a levgott terms biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from cut-down yield biomass" %
        output_map[1160] = &cf->CTDBc_softstem_to_PLG; //%"Ploughing C flux from cut-down softstem biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szntsi sznfluxus a levgott lgyszr biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Ploughing C flux from cut-down softstem biomass" %
        output_map[1161] = &cf->leafc_to_GRZ; //%"grazing C flux from leaf" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a levlbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from leaf" %
        output_map[1162] = &cf->leafc_storage_to_GRZ; //%"grazig C flux from leaf storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a levl raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazig C flux from leaf storage pool" %
        output_map[1163] = &cf->leafc_transfer_to_GRZ; //%"grazing C flux fromleaf transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a levl transzfer trozjban" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux fromleaf transfer pool" %
        output_map[1164] = &cf->yieldc_to_GRZ; //%"grazing C flux from yield" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a termsbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from yield" %
        output_map[1165] = &cf->yieldc_storage_to_GRZ; //%"grazing C flux from yield storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a terms raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from yield storage pool" %
        output_map[1166] = &cf->yieldc_transfer_to_GRZ; //%"grazing C flux from yield transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a terms transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from yield transfer pool" %
        output_map[1167] = &cf->softstemc_to_GRZ; //%"grazing C flux from softstem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a lgyszrbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from softstem" %
        output_map[1168] = &cf->softstemc_storage_to_GRZ; //%"grazing C flux from softstem storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from softstem storage pool" %
        output_map[1169] = &cf->softstemc_transfer_to_GRZ; //%"grazing C flux from softstem transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from softstem transfer pool" %
        output_map[1170] = &cf->gresp_storage_to_GRZ; //%"grazing C flux from growth respiration storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a nvekedsi respirci raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from growth respiration storage pool" %
        output_map[1171] = &cf->gresp_transfer_to_GRZ; //%"grazing C flux from growth respiration transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus a nvekedsi respirci transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from growth respiration transfer pool" %
        output_map[1172] = &cf->STDBc_leaf_to_GRZ; //%"grazing C flux from wilted leaf biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from wilted leaf biomass" %
        output_map[1173] = &cf->STDBc_yield_to_GRZ; //%"grazing C flux from wilted yield biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux from wilted yield biomass" %
        output_map[1174] = &cf->STDBc_softstem_to_GRZ; //%"grazing flux from wilted softstem biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus az elhervadt lgyszr biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing flux from wilted softstem biomass" %
        output_map[1175] = &cf->MOW_to_transpC; //%"Transported carbon flux by mowing" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A kaszlssal elszlltott szn mennyisge" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Transported carbon flux by mowing" %
		output_map[1176] = &cf->GRZ_to_litr1c; //%"grazing C flux to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus az elhalt nvnyi anyag knnyen boml rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux to labile litter" %
        output_map[1177] = &cf->GRZ_to_litr2c; //%"grazing C flux to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus az elhalt nvnyi anyag hozzfrhet cellulz rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux to unshielded cellulose portion of litter" %
        output_map[1178] = &cf->GRZ_to_litr3c; //%"grazing C flux to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus az elhalt nvnyi anyag nem hozzfrhet rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux to shielded cellulose portion of litter" %
        output_map[1179] = &cf->GRZ_to_litr4c; //%"grazing C flux to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Legeltetsi sznfluxus az elhalt nvnyi anyag lignin rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "grazing C flux to lignin portion of litter" %
        output_map[1180] = &cf->FRZ_to_litr1c; //%"Fertilizing C flux to labile litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Trgyzsi sznfluxus az elhalt nvnyi anyag knnyen boml rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Fertilizing C flux to labile litter" %
        output_map[1181] = &cf->FRZ_to_litr2c; //%"Fertilizing C flux to unshielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Trgyzsi sznfluxus az elhalt nvnyi anyag hozzfrhet cellulz rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Fertilizing C flux to unshielded cellulose portion of litter" %
        output_map[1182] = &cf->FRZ_to_litr3c; //%"Fertilizing C flux to shielded cellulose portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Trgyzsi sznfluxus az elhalt nvnyi anyag nem hozzfrhet cellulz rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Fertilizing C flux to shielded cellulose portion of litter" %
        output_map[1183] = &cf->FRZ_to_litr4c; //%"Fertilizing C flux to lignin portion of litter" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Trgyzsi sznfluxus az elhalt nvnyi anyag lignin rszbe" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Fertilizing C flux to lignin portion of litter" %
        output_map[1184] = &cf->CH4flux_soil; //%"Estimated CH4 flux from soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Becslt CH4 fluxus a talajbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Estimated CH4 flux from soil" %
        output_map[1185] = &cf->CH4flux_manure; //%"Estimated CH4 flux from manure" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Becslt CH4 fluxus a szerves trgybl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Estimated CH4 flux from manure" %
        output_map[1186] = &cf->CH4flux_animal; //%"Estimated CH4 flux from animals" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az koszisztma llatoktl szrmaz teljesCH4 fluxusa" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Estimated CH4 flux from animals" %
	    output_map[1187] = &cf->frootc_to_THN; //%"Thinning C flux from fine root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykrbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from froot" %
        output_map[1188] = &cf->frootc_storage_to_THN; //%"Thinning C flux from fine root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from froot storage pool" %
        output_map[1189] = &cf->frootc_transfer_to_THN; //%"Thinning C flux from fine root transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from froot transfer pool" %
        output_map[1190] = &cf->livecrootc_to_THN; //%"Thinning C flux from live coarse root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykrbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from livecroot" %
        output_map[1191] = &cf->livecrootc_storage_to_THN; //%"Thinning C flux live from coarse root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from livecroot storage pool" %
        output_map[1192] = &cf->livecrootc_transfer_to_THN; //%"Thinning C flux live from coarse root transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from livecroot transfer pool" %
		output_map[1193] = &cf->deadcrootc_to_THN; //%"Thinning C flux from dead coarse root" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykrbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from deadcroot" %
        output_map[1194] = &cf->deadcrootc_storage_to_THN; //%"Thinning C flux dead from coarse root storage pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr raktr trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from deadcroot storage pool" %
        output_map[1195] = &cf->deadcrootc_transfer_to_THN; //%"Thinning C flux dead from coarse root transfer pool" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr transzfer trozjbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from deadcroot transfer pool" %
        output_map[1196] = &cf->THN_to_CTDBc_froot; //%"Thinning C flux to cut-down fine root biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levgott gykr biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux to cut-down fine root biomass" %
        output_map[1197] = &cf->THN_to_CTDBc_croot; //%"Thinning C flux to cut-down coarse root biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levgott gykr biomasszba" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux to cut-down coarse root biomass" %
        output_map[1198] = &cf->STDBc_froot_to_THN; //%"Thinning C flux from wilted fine root biomass" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from wilted froot biomass" %
  
		output_map[1300] = &ns->leafn; //%"Actual N content of leaf pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Levl troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual N content of leaf pool" %
        output_map[1301] = &ns->leafn_storage; //%"Nitrogen content of leaf storage pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Levl raktr troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of leaf storage pool" %
        output_map[1302] = &ns->leafn_transfer; //%"Nitrogen content of leaf transfer pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Levl transzfer troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of leaf transfer pool" %
        output_map[1303] = &ns->frootn; //%"Actual N content of fine root pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Hajszlgykr troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual N content of fine root pool" %
        output_map[1304] = &ns->frootn_storage; //%"Nitrogen content of fine root storage pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Hajszlgykr raktr troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of fine root storage pool" %
        output_map[1305] = &ns->frootn_transfer; //%"Nitrogen content of fine root storage pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Hajszlgykr transzfer troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of fine root storage pool" %
        output_map[1306] = &ns->yieldn; //%"Actual N content of yield pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Terms troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual N content of yield pool" %
        output_map[1307] = &ns->yieldn_storage; //%"Nitrogen content of yield storage pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Terms raktr troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of yield storage pool" %
        output_map[1308] = &ns->yieldn_transfer; //%"Nitrogen content of yield transfer pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Terms transzfer troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of yield transfer pool" %
        output_map[1309] = &ns->softstemn; //%"Actual N content of softstem pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Lgyszr troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual N content of softstem pool" %
        output_map[1310] = &ns->softstemn_storage; //%"Nitrogen content of softstem storage pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Lgyszr raktr troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of softstem storage pool" %
        output_map[1311] = &ns->softstemn_transfer; //%"Nitrogen content of softstem transfer pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Lgyszr transzfer troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of softstem transfer pool" %
        output_map[1312] = &ns->livestemn; //%"Actual N content of live stem pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Szjcs (fatest klso l rsze) troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual N content of live stem pool" %
        output_map[1313] = &ns->livestemn_storage; //%"Nitrogen content of live stem storage pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Szjcs (fatest klso l rsze) raktr troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of live stem storage pool" %
        output_map[1314] = &ns->livestemn_transfer; //%"Nitrogen content of live stem transfer pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Szjcs (fatest klso l rsze) transzfer troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of live stem transfer pool" %
        output_map[1315] = &ns->deadstemn; //%"Actual N content of dead stem pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Geszt (fatest belso lettelen rsze) troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual N content of dead stem pool" %
        output_map[1316] = &ns->deadstemn_storage; //%"Nitrogen content of dead stem storage pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Geszt (fatest belso lettelen rsze) troz raktr troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of dead stem storage pool" %
        output_map[1317] = &ns->deadstemn_transfer; //%"Nitrogen content of dead stem transfer pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Geszt (fatest belso lettelen rsze) troz transzfer troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of dead stem transfer pool" %
        output_map[1318] = &ns->livecrootn; //%"Actual N content of live coarse root pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs gykr klso l rsznek aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual N content of live coarse root pool" %
        output_map[1319] = &ns->livecrootn_storage; //%"Nitrogen content of live coarse root storage pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs gykr klso l rsz raktr troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of live coarse root storage pool" %
        output_map[1320] = &ns->livecrootn_transfer; //%"Nitrogen content of live coarse root transfer pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs gykr klso l rsz transzfer troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of live coarse root transfer pool" %
        output_map[1321] = &ns->deadcrootn; //%"Actual N content of dead coarse root pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs gykr belso lettelen rsznek aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual N content of dead coarse root pool" %
        output_map[1322] = &ns->deadcrootn_storage; //%"Nitrogen content of dead coarse root storage pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs gykr belso lettelen rsz raktr troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of dead coarse root storage pool" %
        output_map[1323] = &ns->deadcrootn_transfer; //%"Nitrogen content of dead coarse root transfer pool" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs gykr belso lettelen rsz transzfer troz aktulis nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of dead coarse root transfer pool" %
        output_map[1324] = &ns->npool; //%"Temporary plant N pool" $\\left[\\kg_{N}m^{-2} \\right]$ "tmeneti nvnyi nitrogn troz" $\\left[\\kg_{N}m^{-2} \\right]$ "Temporary plant N pool" %
        output_map[1325] = &ns->cwdn[0]; //%"Coarse woody debris N content  in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 1 (0-3 cm)" %
        output_map[1326] = &ns->cwdn[1]; //%"Coarse woody debris N content  in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 2 (3-10 cm)" %
        output_map[1327] = &ns->cwdn[2]; //%"Coarse woody debris N content  in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 3 (10-30 cm)" %
        output_map[1328] = &ns->cwdn[3]; //%"Coarse woody debris N content  in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 4 (30-60 cm)" %
        output_map[1329] = &ns->cwdn[4]; //%"Coarse woody debris N content  in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 5 (60-90 cm)" %
        output_map[1330] = &ns->cwdn[5]; //%"Coarse woody debris N content  in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 6 (90-120 cm)" %
        output_map[1331] = &ns->cwdn[6]; //%"Coarse woody debris N content  in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 7 (120-150 cm)" %
        output_map[1332] = &ns->cwdn[7]; //%"Coarse woody debris N content  in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 8 (150-200 cm)" %
        output_map[1333] = &ns->cwdn[8]; //%"Coarse woody debris N content  in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 9 (200-400 cm)" %
        output_map[1334] = &ns->cwdn[9]; //%"Coarse woody debris N content  in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Coarse woody debris N content  in soil layer 10 (400-1000 cm)" %
        output_map[1335] = &ns->litr1n[0]; //%"Labile N proportion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya az 1. talajrtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 1 (0-3 cm)" %
        output_map[1336] = &ns->litr1n[1]; //%"Labile N proportion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 2 (3-10 cm)" %
        output_map[1337] = &ns->litr1n[2]; //%"Labile N proportion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 3 (10-30 cm)" %
        output_map[1338] = &ns->litr1n[3]; //%"Labile N proportion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 4 (30-60 cm)" %
        output_map[1339] = &ns->litr1n[4]; //%"Labile N proportion of litter in soil layer 5 (60-90 cm)$" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 5 (60-90 cm)$" %
        output_map[1340] = &ns->litr1n[5]; //%"Labile N proportion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 6 (90-120 cm)" %
        output_map[1341] = &ns->litr1n[6]; //%"Labile N proportion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 7 (120-150 cm)" %
        output_map[1342] = &ns->litr1n[7]; //%"Labile N proportion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 8 (150-200 cm)" %
        output_map[1343] = &ns->litr1n[8]; //%"Labile N proportion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 9 (200-400 cm)" %
        output_map[1344] = &ns->litr1n[9]; //%"Labile N proportion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag knnyen boml nitrogn rszarnya a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter in soil layer 10 (400-1000 cm)" %
        output_map[1345] = &ns->litr2n[0]; //%"N content of unshielded cellulose proportion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma az 1. talajrtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 1 (0-3 cm)" %
        output_map[1346] = &ns->litr2n[1]; //%"N content of unshielded cellulose proportion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 2 (3-10 cm)" %
        output_map[1347] = &ns->litr2n[2]; //%"N content of unshielded cellulose proportion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 3 (10-30 cm)" %
        output_map[1348] = &ns->litr2n[3]; //%"N content of unshielded cellulose proportion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 4 (30-60 cm)" %
        output_map[1349] = &ns->litr2n[4]; //%"N content of unshielded cellulose proportion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 5 (60-90 cm)" %
        output_map[1350] = &ns->litr2n[5]; //%"N content of unshielded cellulose proportion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 6 (90-120 cm)" %
        output_map[1351] = &ns->litr2n[6]; //%"N content of unshielded cellulose proportion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 7 (120-150 cm)" %
        output_map[1352] = &ns->litr2n[7]; //%"N content of unshielded cellulose proportion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 8 (150-200 cm)" %
        output_map[1353] = &ns->litr2n[8]; //%"N content of unshielded cellulose proportion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 9 (200-400 cm)" %
        output_map[1354] = &ns->litr2n[9]; //%"N content of unshielded cellulose proportion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz rszarnynak nitrogntartalma a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter in soil layer 10 (400-1000 cm)" %
        output_map[1355] = &ns->litr3n[0]; //%"N content of shielded cellulose proportion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma az 1. talajrtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 1 (0-3 cm)" %
        output_map[1356] = &ns->litr3n[1]; //%"N content of shielded cellulose proportion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 2 (3-10 cm)" %
        output_map[1357] = &ns->litr3n[2]; //%"N content of shielded cellulose proportion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 3 (10-30 cm)" %
        output_map[1358] = &ns->litr3n[3]; //%"N content of shielded cellulose proportion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 4 (30-60 cm)" %
        output_map[1359] = &ns->litr3n[4]; //%"N content of shielded cellulose proportion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 5 (60-90 cm)" %
        output_map[1360] = &ns->litr3n[5]; //%"N content of shielded cellulose proportion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 6 (90-120 cm)" %
        output_map[1361] = &ns->litr3n[6]; //%"N content of shielded cellulose proportion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 7 (120-150 cm)" %
        output_map[1362] = &ns->litr3n[7]; //%"N content of shielded cellulose proportion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 8 (150-200 cm)" %
        output_map[1363] = &ns->litr3n[8]; //%"N content of shielded cellulose proportion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 9 (200-400 cm)" %
        output_map[1364] = &ns->litr3n[9]; //%"N content of shielded cellulose proportion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz rszarnynak nitrogntartalma a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter in soil layer 10 (400-1000 cm)" %
        output_map[1365] = &ns->litr4n[0]; //%"N content of lignin proportion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 1 (0-3 cm)" %
        output_map[1366] = &ns->litr4n[1]; //%"N content of lignin proportion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 2 (3-10 cm)" %
        output_map[1367] = &ns->litr4n[2]; //%"N content of lignin proportion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 3 (10-30 cm)" %
        output_map[1368] = &ns->litr4n[3]; //%"N content of lignin proportion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 4 (30-60 cm)" %
        output_map[1369] = &ns->litr4n[4]; //%"N content of lignin proportion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 5 (60-90 cm)" %
        output_map[1370] = &ns->litr4n[5]; //%"N content of lignin proportion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 6 (90-120 cm)" %
        output_map[1371] = &ns->litr4n[6]; //%"N content of lignin proportion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 7 (120-150 cm)" %
        output_map[1372] = &ns->litr4n[7]; //%"N content of lignin proportion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 8 (150-200 cm)" %
        output_map[1373] = &ns->litr4n[8]; //%"N content of lignin proportion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 9 (200-400 cm)" %
        output_map[1374] = &ns->litr4n[9]; //%"N content of lignin proportion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag lignin rszarnynak nitrogntartalma a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter in soil layer 10 (400-1000 cm)" %
        output_map[1375] = &ns->litrN[0]; //%"Total N content of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 1 (0-3 cm)" %
        output_map[1376] = &ns->litrN[1]; //%"Total N content of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 2 (3-10 cm)" %
        output_map[1377] = &ns->litrN[2]; //%"Total N content of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 3 (10-30 cm)" %
        output_map[1378] = &ns->litrN[3]; //%"Total N content of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 4 (30-60 cm)" %
        output_map[1379] = &ns->litrN[4]; //%"Total N content of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 5 (60-90 cm)" %
        output_map[1380] = &ns->litrN[5]; //%"Total N content of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 6 (90-120 cm)" %
        output_map[1381] = &ns->litrN[6]; //%"Total N content of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 7 (120-150 cm)" %
        output_map[1382] = &ns->litrN[7]; //%"Total N content of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 8 (150-200 cm)" %
        output_map[1383] = &ns->litrN[8]; //%"Total N content of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 9 (200-400 cm)" %
        output_map[1384] = &ns->litrN[9]; //%"Total N content of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhalt nvnyi anyag teljes nitrogntartalma a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of litter in soil layer 10 (400-1000 cm)" %
        output_map[1385] = &ns->litr1n_total; //%"Labile N proportion of litter" $\\left[\\kg_{N}m^{-2} \\right]$ "Knnyen boml nitrogn rszarnya az elhalt nvnyi anyagban" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile N proportion of litter" %
        output_map[1386] = &ns->litr2n_total; //%"N content of unshielded cellulose proportion of litter" $\\left[\\kg_{N}m^{-2} \\right]$ "hozzfrhet cellulz rszarnynak nitrogntartalma az elhalt nvnyi anyagban" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of unshielded cellulose proportion of litter" %
        output_map[1387] = &ns->litr3n_total; //%"N content of shielded cellulose proportion of litter" $\\left[\\kg_{N}m^{-2} \\right]$ "Nem hozzfrhet cellulz rszarnynak nitrogntartalma az elhalt nvnyi anyagban" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of shielded cellulose proportion of litter" %
        output_map[1388] = &ns->litr4n_total; //%"N content of lignin proportion of litter" $\\left[\\kg_{N}m^{-2} \\right]$ "Lignin rszarnynak nitrogntartalma az elhalt nvnyi anyagban" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of lignin proportion of litter" %
        output_map[1389] = &ns->cwdn_total; //%"Total N content of coarse woody debris" $\\left[\\kg_{N}m^{-2} \\right]$ "Fs nvnyi maradvny nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of coarse woody debris" %
        output_map[1390] = &ns->STDBn_leaf; //%"N content of wilted leaf biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhervadt levl biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of wilted leaf biomass" %
        output_map[1391] = &ns->STDBn_froot; //%"N content of wilted fine root biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhervadt hajszlgykr biomoassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of wilted fine root biomass" %
        output_map[1392] = &ns->STDBn_yield; //%"N content of wilted yield biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhervadt terms biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of wilted yield biomass" %
        output_map[1393] = &ns->STDBn_softstem; //%"N content of wilted softstem biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhervadt lgyszr biomoassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of wilted softstem biomass" %
        output_map[1394] = &ns->CWEsnk_N; //%"N content of CWD-extract (sink)" $\\left[\\kg_{C}m^{-2} \\right]$ "Letrtt gak elszlltsakor tvoz N" $\\left[\\kg_{C}m^{-2} \\right]$ "N content of CWD-extract (sink)" %
		output_map[1395] = &ns->STDBn_above; //%"N content of wilted aboveground plant biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhervadt talajfeletti nvnybiomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of wilted aboveground plant biomass" %
        output_map[1396] = &ns->STDBn_below; //%"N content of wilted belowground plant biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Elhervadt talajalatti nvnyi biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of wilted belowground plant biomass" %
        output_map[1397] = &ns->CTDBn_leaf; //%"N content of cut-down leaf biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Levgott levl biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of cut-down leaf biomass" %
        output_map[1398] = &ns->CTDBn_froot; //%"N content of cut-down fineroot biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Levgott hajszlgykr biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of cut-down fineroot biomass" %
        output_map[1399] = &ns->CTDBn_yield; //%"N content of cut-down yield biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Levgott terms biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of cut-down yield biomass" %
        output_map[1400] = &ns->CTDBn_softstem; //%"N content of cut-down softstem biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Levgott lgyszr biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of cut-down softstem biomass" %
        output_map[1401] = &ns->MULsrc_N; //%"N content of mulched material" $\\left[\\kg_{C}m^{-2} \\right]$ "Mulcsknt bekerlt szerves anyag N-tartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "SUM of N content of mulched material" %
        output_map[1402] = &ns->CTDBn_cstem; //%"N content of cut-down coarse stem biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Levgott fs szr biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of cut-down coarse stem biomass" %
        output_map[1403] = &ns->CTDBn_croot; //%"N content of cut-down coarse root biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Levgott fs gykr biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of cut-down coarse root biomass" %
        output_map[1404] = &ns->CTDBn_above; //%"N content of cut-down aboveground plant biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Levgott talajfeletti nvnyi biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of cut-down aboveground plant biomass" %
        output_map[1405] = &ns->CTDBn_below; //%"N content of cut-down belowground plant biomass" $\\left[\\kg_{N}m^{-2} \\right]$ "Levgott talajalatti nvnyi biomassza nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogen content of cut-down belowground plant biomass" %
        output_map[1406] = &ns->soil1n[0]; //%"C content of SOM pool N content of soil layer 1 (0-3 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 1 (0-3 cm) (labile)" %
        output_map[1407] = &ns->soil1n[1]; //%"C content of SOM pool N content of soil layer 2 (3-10 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 2 (3-10 cm) (labile)" %
        output_map[1408] = &ns->soil1n[2]; //%"C content of SOM pool N content of soil layer 3 (10-30 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 3 (10-30 cm) (labile)" %
        output_map[1409] = &ns->soil1n[3]; //%"C content of SOM pool N content of soil layer 4 (30-60 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 4 (30-60 cm) (labile)" %
        output_map[1410] = &ns->soil1n[4]; //%"C content of SOM pool N content of soil layer 5 (60-90 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 5 (60-90 cm) (labile)" %
        output_map[1411] = &ns->soil1n[5]; //%"C content of SOM pool N content of soil layer 6 (90-120 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 6 (90-120 cm) (labile)" %
        output_map[1412] = &ns->soil1n[6]; //%"C content of SOM pool N content of soil layer 7 (120-150 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 7 (120-150 cm) (labile)" %
        output_map[1413] = &ns->soil1n[7]; //%"C content of SOM pool N content of soil layer 8 (150-200 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 8 (150-200 cm) (labile)" %
        output_map[1414] = &ns->soil1n[8]; //%"C content of SOM pool N content of soil layer 9 (200-400 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 9 (200-400 cm) (labile)" %
        output_map[1415] = &ns->soil1n[9]; //%"C content of SOM pool N content of soil layer 10 (400-1000 cm) (labile)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) labilis szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 10 (400-1000 cm) (labile)" %
        output_map[1416] = &ns->soil2n[0]; //%"C content of SOM pool N content of soil layer 1 (0-3 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 1 (0-3 cm) (fast)" %
        output_map[1417] = &ns->soil2n[1]; //%"C content of SOM pool N content of soil layer 2 (3-10 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 2 (3-10 cm) (fast)" %
        output_map[1418] = &ns->soil2n[2]; //%"C content of SOM pool N content of soil layer 3 (10-30 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 3 (10-30 cm) (fast)" %
        output_map[1419] = &ns->soil2n[3]; //%"C content of SOM pool N content of soil layer 4 (30-60 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 4 (30-60 cm) (fast)" %
        output_map[1420] = &ns->soil2n[4]; //%"C content of SOM pool N content of soil layer 5 (60-90 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 5 (60-90 cm) (fast)" %
        output_map[1421] = &ns->soil2n[5]; //%"C content of SOM pool N content of soil layer 6 (90-120 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 6 (90-120 cm) (fast)" %
        output_map[1422] = &ns->soil2n[6]; //%"C content of SOM pool N content of soil layer 7 (120-150 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 7 (120-150 cm) (fast)" %
        output_map[1423] = &ns->soil2n[7]; //%"C content of SOM pool N content of soil layer 8 (150-200 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 8 (150-200 cm) (fast)" %
        output_map[1424] = &ns->soil2n[8]; //%"C content of SOM pool N content of soil layer 9 (200-400 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 9 (200-400 cm) (fast)" %
        output_map[1425] = &ns->soil2n[9]; //%"C content of SOM pool N content of soil layer 10 (400-1000 cm) (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) labilisan boml szervesanyag-trozjnak nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 10 (400-1000 cm) (fast)" %
        output_map[1426] = &ns->soil3n[0]; //%"C content of SOM pool N content of soil layer 1 (0-3 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 1 (0-3 cm) (slow)" %
        output_map[1427] = &ns->soil3n[1]; //%"C content of SOM pool N content of soil layer 2 (3-10 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 2 (3-10 cm) (slow)" %
        output_map[1428] = &ns->soil3n[2]; //%"C content of SOM pool N content of soil layer 3 (10-30 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 3 (10-30 cm) (slow)" %
        output_map[1429] = &ns->soil3n[3]; //%"C content of SOM pool N content of soil layer 4 (30-60 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 4 (30-60 cm) (slow)" %
        output_map[1430] = &ns->soil3n[4]; //%"C content of SOM pool N content of soil layer 5 (60-90 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 5 (60-90 cm) (slow)" %
        output_map[1431] = &ns->soil3n[5]; //%"C content of SOM pool N content of soil layer 6 (90-120 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 6 (90-120 cm) (slow)" %
        output_map[1432] = &ns->soil3n[6]; //%"C content of SOM pool N content of soil layer 7 (120-150 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 7 (120-150 cm) (slow)" %
        output_map[1433] = &ns->soil3n[7]; //%"C content of SOM pool N content of soil layer 8 (150-200 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 8 (150-200 cm) (slow)" %
        output_map[1434] = &ns->soil3n[8]; //%"C content of SOM pool N content of soil layer 9 (200-400 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 9 (200-400 cm) (slow)" %
        output_map[1435] = &ns->soil3n[9]; //%"C content of SOM pool N content of soil layer 10 (400-1000 cm) (slow)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) lassan boml szervesanyag-trozjnaknitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "C content of SOM pool N content of soil layer 10 (400-1000 cm) (slow)" %
        output_map[1436] = &ns->soil4n[0]; //%"stable soil organic matter N content of soil layer 1 (0-3 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 1 (0-3 cm) (stable)" %
        output_map[1437] = &ns->soil4n[1]; //%"stable soil organic matter N content of soil layer 2 (3-10 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 2 (3-10 cm) (stable)" %
        output_map[1438] = &ns->soil4n[2]; //%"stable soil organic matter N content of soil layer 3 (10-30 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 3 (10-30 cm) (stable)" %
        output_map[1439] = &ns->soil4n[3]; //%"stable soil organic matter N content of soil layer 4 (30-60 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 4 (30-60 cm) (stable)" %
        output_map[1440] = &ns->soil4n[4]; //%"stable soil organic matter N content of soil layer 5 (60-90 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 5 (60-90 cm) (stable)" %
        output_map[1441] = &ns->soil4n[5]; //%"stable soil organic matter N content of soil layer 6 (90-120 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 6 (90-120 cm) (stable)" %
        output_map[1442] = &ns->soil4n[6]; //%"stable soil organic matter N content of soil layer 7 (120-150 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 7 (120-150 cm) (stable)" %
        output_map[1443] = &ns->soil4n[7]; //%"stable soil organic matter N content of soil layer 8 (150-200 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 8 (150-200 cm) (stable)" %
        output_map[1444] = &ns->soil4n[8]; //%"stable soil organic matter N content of soil layer 9 (200-400 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 9 (200-400 cm) (stable)" %
        output_map[1445] = &ns->soil4n[9]; //%"stable soil organic matter N content of soil layer 10 (400-1000 cm) (stable)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) ellenll talaj szervesanyag nitrogntartalma (leglassabb)" $\\left[\\kg_{N}m^{-2} \\right]$ "stable soil organic matter N content of soil layer 10 (400-1000 cm) (stable)" %
        output_map[1446] = &ns->soilN[0]; //%"Total N content of soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 1 (0-3 cm)" %
        output_map[1447] = &ns->soilN[1]; //%"Total N content of soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 2 (3-10 cm)" %
        output_map[1448] = &ns->soilN[2]; //%"Total N content of soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 3 (10-30 cm)" %
        output_map[1449] = &ns->soilN[3]; //%"Total N content of soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 4 (30-60 cm)" %
        output_map[1450] = &ns->soilN[4]; //%"Total N content of soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 5 (60-90 cm)" %
        output_map[1451] = &ns->soilN[5]; //%"Total N content of soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 6 (90-120 cm)" %
        output_map[1452] = &ns->soilN[6]; //%"Total N content of soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 7 (120-150 cm)" %
        output_map[1453] = &ns->soilN[7]; //%"Total N content of soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 8 (150-200 cm)" %
        output_map[1454] = &ns->soilN[8]; //%"Total N content of soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 9 (200-400 cm)" %
        output_map[1455] = &ns->soilN[9]; //%"Total N content of soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) teljes nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content of soil layer 10 (400-1000 cm)" %

        output_map[1506] = &ns->soil1n_total; //%"Labile SOM N pool" $\\left[\\kg_{N}m^{-2} \\right]$ "A labilis szervesanyag-troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Labile SOM N pool" %
        output_map[1507] = &ns->soil2n_total; //%"Fast decomposing SOM N pool (fast)" $\\left[\\kg_{N}m^{-2} \\right]$ "A gyorsan boml szervesanyag-troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Fast decomposing SOM N pool" %
        output_map[1508] = &ns->soil3n_total; //%"Slow decomposing SOM N pool" $\\left[\\kg_{N}m^{-2} \\right]$ "A lassan boml szervesanyag-troz nitrogntartalm" $\\left[\\kg_{N}m^{-2} \\right]$ "Slow decomposing SOM N pool" %
        output_map[1509] = &ns->soil4n_total; //%"Stable SOM N pool" $\\left[\\kg_{N}m^{-2} \\right]$ "A stabil szervesanyag-troz nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Stable SOM N pool" %
        output_map[1510] = &ns->retransn; //%"Plant pool of retranslocated N" $\\left[\\kg_{N}m^{-2} \\right]$ "Retranszloklt nvnyi nitrogntroz" $\\left[\\kg_{N}m^{-2} \\right]$ "Plant pool of retranslocated N" %
        output_map[1511] = &ns->NH4[0]; //%"Mineral NH4-N content of soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 1 (0-3 cm)" %
        output_map[1512] = &ns->NH4[1]; //%"Mineral NH4-N content of soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 2 (3-10 cm)" %
        output_map[1513] = &ns->NH4[2]; //%"Mineral NH4-N content of soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 3 (10-30 cm)" %
        output_map[1514] = &ns->NH4[3]; //%"Mineral NH4-N content of soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 4 (30-60 cm)" %
        output_map[1515] = &ns->NH4[4]; //%"Mineral NH4-N content of soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 5 (60-90 cm)" %
        output_map[1516] = &ns->NH4[5]; //%"Mineral NH4-N content of soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 6 (90-120 cm)" %
        output_map[1517] = &ns->NH4[6]; //%"Mineral NH4-N content of soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 7 (120-150 cm)" %
        output_map[1518] = &ns->NH4[7]; //%"Mineral NH4-N content of soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 8 (150-200 cm)" %
        output_map[1519] = &ns->NH4[8]; //%"Mineral NH4-N content of soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 9 (200-400 cm)" %
        output_map[1520] = &ns->NH4[9]; //%"Mineral NH4-N content of soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil layer 10 (400-1000 cm)" %
        output_map[1521] = &ns->NO3[0]; //%"Mineral NO3-N content of soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil layer 1 (0-3 cm)" %
        output_map[1522] = &ns->NO3[1]; //%"Mineral NO3-N content of soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil layer 2 (3-10 cm)" %
        output_map[1523] = &ns->NO3[2]; //%"Mineral NO3-N content of soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil layer 3 (10-30 cm)" %
        output_map[1524] = &ns->NO3[3]; //%"Mineral NO3-N content of soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil layer 4 (30-60 cm)" %
        output_map[1525] = &ns->NO3[4]; //%"Mineral NO3-N content of soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil layer 5 (60-90 cm)" %
        output_map[1526] = &ns->NO3[5]; //%"Mineral NO3-N content of soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil layer 6 (90-120 cm)" %
        output_map[1527] = &ns->NO3[6]; //%"Mineral NO3-N content of soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$
        output_map[1528] = &ns->NO3[7]; //%"Mineral NO3-N content of soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil layer 8 (150-200 cm)" %
        output_map[1529] = &ns->NO3[8]; //%"Mineral NO3-N content of soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil layer 9 (200-400 cm)" %
        output_map[1530] = &ns->NO3[9]; //%"Mineral NO3-N content of soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil layer 10 (400-1000 cm)" %
        output_map[1531] = &ns->NH4_total; //%"Mineral NH4-N content of soil" $\\left[\\kg_{N}m^{-2} \\right]$ "A talaj teljes NH4-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NH4-N content of soil" %
        output_map[1532] = &ns->NO3_total; //%"Mineral NO3-N content of soil" $\\left[\\kg_{N}m^{-2} \\right]$ "A talaj teljes NO3-N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral NO3-N content of soil" %
        output_map[1533] = &ns->Nfix_src; //%"SUM of biological N fixation" $\\left[\\kg_{N}m^{-2} \\right]$ "A biolgiai N fixci sszege" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of biological N fixation" %
        output_map[1534] = &ns->Ndep_src; //%"SUM of N deposition inputs" $\\left[\\kg_{N}m^{-2} \\right]$ "A N lepedsbol szrmaz bevtel" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N deposition inputs" %
        output_map[1535] = &ns->Ndeepleach_snk; //%"SUM of N deep leaching" $\\left[\\kg_{N}m^{-2} \\right]$ "A rendszerbol kimosdott N mennyisg" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N deep leaching" %
        output_map[1536] = &ns->Nvol_snk; //%"SUM of N lost to volatilization" $\\left[\\kg_{N}m^{-2} \\right]$ "Volatilizcis N veszts" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N lost to volatilization" %
        output_map[1537] = &ns->FIREsnk_N; //%"SUM of N lost to fire" $\\left[\\kg_{N}m^{-2} \\right]$ "Tuzelhalsbl szrmaz N vesztesg" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N lost to fire" %
        output_map[1538] = &ns->Nprec_snk; //%"SUM of N lost to precision control" $\\left[\\kg_{N}m^{-2} \\right]$ "Pontossgi N-vesztesg" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N lost to precision control" %
		output_map[1539] = &ns->SNSCsnk_N; //%"SUM of senescence N losses" $\\left[\\kg_{N}m^{-2} \\right]$ "Elregedsbol szrmaz N vesztesg" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of senescence N losses" %
        output_map[1540] = &ns->FRZsrc_N; //%"SUM of N fertilization inputs" $\\left[\\kg_{N}m^{-2} \\right]$ "Trgyzsbl szrmaz N bevtel" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N fertilization inputs" %
        output_map[1541] = &ns->PLTsrc_N; //%"SUM of planted leaf N" $\\left[\\kg_{N}m^{-2} \\right]$ "ltetett nvnyekbol szrmaz N" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of planted leaf N" %
        output_map[1542] = &ns->THNsnk_N; //%"SUM N content of thinned and transported plant material" $\\left[\\kg_{N}m^{-2} \\right]$ "A kivgott s elszlltott nvnyi anyag N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM N content of thinned and transported plant material" %
        output_map[1543] = &ns->HRVsnk_N; //%"SUM of N content of harvested and transported plant material" $\\left[\\kg_{N}m^{-2} \\right]$ "A betakartott s elszlltott nvnyi anyag N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N content of harvested and transported plant material" %
        output_map[1544] = &ns->MOWsnk_N; //%"SUM of N content of mowed and transported plant material" $\\left[\\kg_{N}m^{-2} \\right]$ "A lekaszlt s elszlltott nvnyi anyag N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N content of mowed and transported plant material" %
        output_map[1545] = &ns->GRZsnk_N; //%"SUM of grazed leaf N content" $\\left[\\kg_{N}m^{-2} \\right]$ "A lelegelt levl N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of grazed leaf N content" %
        output_map[1546] = &ns->GRZsrc_N; //%"SUM of leaf N from grazing" $\\left[\\kg_{N}m^{-2} \\right]$ "A legeltetsbol eredo levl N" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of leaf N from grazing" %	
		output_map[1547] = &ns->SPINUPsrc; //%"SUM of leaf N from spinup" $\\left[\\kg_{N}m^{-2} \\right]$ "A spinup-bl eredo N tartalom" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of leaf N from spinup" %
        output_map[1548] = &ns->GWsnk_N; //%"SUM of GW sink (GWrecharge)" $\\left[\\kg_{N}m^{-2} \\right]$ 
        output_map[1549] = &ns->GWsrc_N; //%"SUM of GW source (GWrdischarge)" $\\left[\\kg_{N}m^{-2} \\right]$ 
        output_map[1550] = &ns->NbalanceERR; //%"SUM of N balance error" $\\left[\\kg_{N}m^{-2} \\right]$ "A nitrogn mrleg hibja" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N balance error" %
        output_map[1551] = &ns->inN; //%"SUM of N input" $\\left[\\kg_{N}m^{-2} \\right]$ "A nitrognbevtel sszege" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N input" %
        output_map[1552] = &ns->outN; //%"SUM of N output" $\\left[\\kg_{N}m^{-2} \\right]$ "A nitrognvesztesg sszegeNH4-N" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N output" %
        output_map[1553] = &ns->storeN; //%"SUM of N store" $\\left[\\kg_{N}m^{-2} \\right]$ "Nitrogntrozs" $\\left[\\kg_{N}m^{-2} \\right]$ "SUM of N store" %
        output_map[1554] = &ns->sminN[0]; //%"Mineral N content of soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 1. talajrteg (0-3 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 1 (0-3 cm)" %
        output_map[1555] = &ns->sminN[1]; //%"Mineral N content of soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 2. talajrteg (3-10 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 2 (3-10 cm)" %
        output_map[1556] = &ns->sminN[2]; //%"Mineral N content of soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 3. talajrteg (10-30 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 3 (10-30 cm)" %
        output_map[1557] = &ns->sminN[3]; //%"Mineral N content of soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 4. talajrteg (30-60 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 4 (30-60 cm)" %
        output_map[1558] = &ns->sminN[4]; //%"Mineral N content of soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Az 5. talajrteg (60-90 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 5 (60-90 cm)" %
        output_map[1559] = &ns->sminN[5]; //%"Mineral N content of soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 6. talajrteg (90-120 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 6 (90-120 cm)" %
        output_map[1560] = &ns->sminN[6]; //%"Mineral N content of soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 7. talajrteg (120-150 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 7 (120-150 cm)" %
        output_map[1561] = &ns->sminN[7]; //%"Mineral N content of soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 8. talajrteg (150-200 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 8 (150-200 cm)" %
        output_map[1562] = &ns->sminN[8]; //%"Mineral N content of soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 9. talajrteg (200-400 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 9 (200-400 cm)" %
        output_map[1563] = &ns->sminN[9]; //%"Mineral N content of soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "A 10. talajrteg (400-1000 cm) N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Mineral N content of soil layer 10 (400-1000 cm)" %
   
		output_map[1700] = &nf->m_leafn_to_litr1n; //%"Mortality N flux from leaf to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus levlbol knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from leaf to labile N portion of litter" %
        output_map[1701] = &nf->m_leafn_to_litr2n; //%"Mortality N flux from leaf to unshielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus levlbol hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from leaf to unshielded cellulose N portion of litter" %
        output_map[1702] = &nf->m_leafn_to_litr3n; //%"Mortality N flux from leaf to shielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus levlbol nem hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from leaf to shielded cellulose N portion of litter" %
        output_map[1703] = &nf->m_leafn_to_litr4n; //%"Mortality N flux from leaf to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus levlbol ligninn" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from leaf to lignin N portion of litter" %
        output_map[1704] = &nf->m_frootn_to_litr1n; //%"Mortality N flux from fine root to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus hajszlgykrbol knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from fine root to labile N portion of litter" %
        output_map[1705] = &nf->m_frootn_to_litr2n; //%"Mortality N flux from fine root to unshielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus hajszlgykrbol hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from fine root to unshielded cellulose N portion of litter" %
        output_map[1706] = &nf->m_frootn_to_litr3n; //%"Mortality N flux from fine root to shielded cellulose portion N of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus hajszlgykrbol nem hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from fine root to shielded cellulose portion N of litter" %
        output_map[1707] = &nf->m_frootn_to_litr4n; //%"Mortality N flux from fine root to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus hajszlgykrbol ligninn" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from fine root to lignin N portion of litter" %
        output_map[1708] = &nf->m_yieldn_to_litr1n; //%"Mortality N flux from yield to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus termsbol knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from yield to labile N portion of litter" %
        output_map[1709] = &nf->m_yieldn_to_litr2n; //%"Mortality N flux from yield to unshielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus termsbol hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from yield to unshielded cellulose N portion of litter" %
        output_map[1710] = &nf->m_yieldn_to_litr3n; //%"Mortality N flux from yield to shielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus termsbol nem hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from yield to shielded cellulose N portion of litter" %
        output_map[1711] = &nf->m_yieldn_to_litr4n; //%"Mortality N flux from yield to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus termsbol ligninn" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from yield to lignin N portion of litter" %
        output_map[1712] = &nf->m_softstemn_to_litr1n; //%"Mortality N flux from softstem to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus lgyszrbl knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from softstem to labile N portion of litter" %
        output_map[1713] = &nf->m_softstemn_to_litr2n; //%"Mortality N flux from softstem to unshielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus lgyszrbl hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from softstem to unshielded cellulose N portion of litter" %
        output_map[1714] = &nf->m_softstemn_to_litr3n; //%"Mortality N flux from softstem to shielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus lgyszrbl nem hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from softstem to shielded cellulose N portion of litter" %
        output_map[1715] = &nf->m_softstemn_to_litr4n; //%"Mortality N flux from softstem to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus lgyszrbl ligninn" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from softstem to lignin N portion of litter" %
        output_map[1716] = &nf->m_leafn_storage_to_litr1n; //%"Mortality N flux from leaf storage pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a levl raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from leaf storage pool to labile N portion of litter" %
        output_map[1717] = &nf->m_frootn_storage_to_litr1n; //%"Mortality N flux from fine root storage pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a hajszlgykr raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from fine root storage pool to labile N portion of litter" %
        output_map[1718] = &nf->m_yieldn_storage_to_litr1n; //%"Mortality N flux from yield storage pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a terms raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from yield storage pool to labile N portion of litter" %
        output_map[1719] = &nf->m_yieldn_transfer_to_litr1n; //%"Mortality N flux from yield transfer pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a terms transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from yield transfer pool to labile N portion of litter" %
        output_map[1720] = &nf->m_softstemn_storage_to_litr1n; //%"Mortality N flux from softstem storage pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a lgyszr raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from softstem storage pool to labile N portion of litter" %
        output_map[1721] = &nf->m_softstemn_transfer_to_litr1n; //%"Mortality N flux from softstem transfer pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a lgyszr transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from softstem transfer pool to labile N portion of litter" %
        output_map[1722] = &nf->m_livestemn_storage_to_litr1n; //%"Mortality N flux from live stem storage pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a szjcs (fatest klso l rsze) raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from live stem storage pool to labile N portion of litter" %
        output_map[1723] = &nf->m_deadstemn_storage_to_litr1n; //%"Mortality N flux from dead stem storage pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a geszt (fatest belso lettelen rsze) raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from dead stem storage pool to labile N portion of litter" %
        output_map[1724] = &nf->m_livecrootn_storage_to_litr1n; //%"Mortality N flux from live coarse root storage pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a fs gykr klso l rsznek raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from live coarse root storage pool to labile N portion of litter" %
        output_map[1725] = &nf->m_deadcrootn_storage_to_litr1n; //%"Mortality N flux from dead coarse root storage pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a fs gykr belso lettelen rsznek raktr trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from dead coarse root storage pool to labile N portion of litter" %
        output_map[1726] = &nf->m_leafn_transfer_to_litr1n; //%"Mortality N flux from leaf transfer pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a levl transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from leaf transfer pool to labile N portion of litter" %
        output_map[1727] = &nf->m_frootn_transfer_to_litr1n; //%"Mortality N flux from fine root transfer pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a hajszlgykr transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from fine root transfer pool to labile N portion of litter" %
        output_map[1728] = &nf->m_livestemn_transfer_to_litr1n; //%"Mortality N flux from live stem transfer pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a szjcs (fatest klso l rsze) transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from live stem transfer pool to labile N portion of litter" %
        output_map[1729] = &nf->m_deadstemn_transfer_to_litr1n; //%"Mortality N flux from dead stem transfer pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a geszt (fatest belso lettelen rsze) transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from dead stem transfer pool to labile N portion of litter" %
        output_map[1730] = &nf->m_livecrootn_transfer_to_litr1n; //%"Mortality N flux from live coarse root transfer pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a fs gykr klso l rsznek transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from live coarse root transfer pool to labile N portion of litter" %
        output_map[1731] = &nf->m_deadcrootn_transfer_to_litr1n; //%"Mortality N flux from dead coarse root transfer pool to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a fs gykr belso lettelen rsznek transzfer trozjbl knnyen boml nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from dead coarse root transfer pool to labile N portion of litter" %
        output_map[1732] = &nf->m_livestemn_to_litr1n; //%"Mortality N flux from live stem to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a szjcs (fatest klso l rsze) knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from live stem to labile N portion of litter" %
        output_map[1733] = &nf->m_livestemn_to_cwdn; //%"Mortality N flux from live stem to coarse woody debris" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a szjcs (fatest klso l rsze) anyagbl Fs nvnyi maradvnyk" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from live stem to coarse woody debris" %
        output_map[1734] = &nf->m_deadstemn_to_cwdn; //%"Mortality N flux from dead stem to coarse woody debris" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a geszt (fatest belso lettelen rsze) anyagbl Fs nvnyi maradvnyk" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from dead stem to coarse woody debris" %
        output_map[1735] = &nf->m_livecrootn_to_litr1n; //%"Mortality N flux from live coarse root ro labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a fs gykr klso l rszbol knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from live coarse root ro labile N portion of litter" %
        output_map[1736] = &nf->m_livecrootn_to_cwdn; //%"Mortality N flux from live coarse root to coarse woody debris" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a fs gykr klso l rszbol Fs nvnyi maradvnyk" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from live coarse root to coarse woody debris" %
        output_map[1737] = &nf->m_deadcrootn_to_cwdn; //%"Mortality N flux from dead coarse root to coarse woody debris" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a fs gykr belso lettelen rszbol Fs nvnyi maradvnyk" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from dead coarse root to coarse woody debris" %
        output_map[1738] = &nf->m_retransn_to_litr1n; //%"Mortality N flux from retranslocated N to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalsi N fluxus a retranszloklt N-bol knnyen boml elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mortality N flux from retranslocated N to labile N portion of litter" %
        output_map[1739] = &nf->m_vegn_to_SNSC; //%"Total vegetation senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Teljes vegetci elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Total vegetation senescence N flux" %
        output_map[1740] = &nf->m_leafn_to_SNSC; //%"Leaf senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levl elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leaf senescence N flux" %
        output_map[1741] = &nf->m_leafn_to_SNSCgenprog; //%"Leaf gen. prog. scenescene N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Genetikailag programozott elhals levlnitrognre vonatkozan" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$  %
        output_map[1742] = &nf->m_frootn_to_SNSC; //%"Fine root senescene N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Hajszlgykr elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fine root senescene N flux" %
        output_map[1743] = &nf->m_leafn_storage_to_SNSC; //%"Leaf storage pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levl raktr troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leaf storage pool senescence N flux" %
        output_map[1744] = &nf->m_frootn_storage_to_SNSC; //%"Fine root storage pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Hajszlgykr raktr troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fine root storage pool senescence N flux" %
        output_map[1745] = &nf->m_leafn_transfer_to_SNSC; //%"Leaf transfer pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levl transzfer troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leaf transfer pool senescence N flux" %
        output_map[1746] = &nf->m_frootn_transfer_to_SNSC; //%"Fine root transfer pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Hajszlgykr transzfer troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fine root transfer pool senescence N flux" %
        output_map[1747] = &nf->m_yieldn_to_SNSC; //%"yield senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Terms elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "yield senescence N flux" %
        output_map[1748] = &nf->m_yieldn_storage_to_SNSC; //%"yield storage pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Terms raktr troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "yield storage pool senescence N flux" %
        output_map[1749] = &nf->m_yieldn_transfer_to_SNSC; //%"yield transfer pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Terms transzfer troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "yield transfer pool senescence N flux" %
        output_map[1750] = &nf->m_softstemn_to_SNSC; //%"Softstem senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Lgyszr elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Softstem senescence N flux" %
        output_map[1751] = &nf->m_softstemn_storage_to_SNSC; //%"Softstem storage pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Lgyszr raktr troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Softstem storage pool senescence N flux" %
        output_map[1752] = &nf->m_softstemn_transfer_to_SNSC; //%"Softstem transfer pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Lgyszr transzfer troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Softstem transfer pool senescence N flux" %
        output_map[1753] = &nf->m_retransn_to_SNSC; //%"Retranslocated N senescene N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Retranszloklt N elregedsi fluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Retranslocated N senescene N flux" %
        output_map[1754] = &nf->HRV_leafn_storage_to_SNSC; //%"Harvested leaf storage pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott levl raktr troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested leaf storage pool senescence N flux" %
        output_map[1755] = &nf->HRV_leafn_transfer_to_SNSC; //%"Harvested leaf transfer pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott levl transzfer troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested leaf transfer pool senescence N flux" %
        output_map[1756] = &nf->HRV_yieldn_storage_to_SNSC; //%"Harvested yield storage pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott terms raktr troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested yield storage pool senescence N flux" %
        output_map[1757] = &nf->HRV_yieldn_transfer_to_SNSC; //%"Harvested yield transfer pool senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott terms transzfer troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested yield transfer pool senescence N flux" %
        output_map[1758] = &nf->HRV_frootn_to_SNSC; //%"Harvested fine root senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott hajszlgykr elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested fine root senescence N flux" %
        output_map[1759] = &nf->HRV_softstemn_to_SNSC; //%"Harvested softstem senscence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott lgyszr elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested softstem senscence N flux" %
        output_map[1760] = &nf->HRV_frootn_storage_to_SNSC; //%"Harvested fine root storage senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott hajszlgykr raktr troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested fine root storage senescence N flux" %
        output_map[1761] = &nf->HRV_frootn_transfer_to_SNSC; //%"Harvested fine root transfer senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott hajszlgykr transzfer troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested fine root transfer senescence N flux" %
        output_map[1762] = &nf->HRV_softstemn_storage_to_SNSC; //%"Harvested softstem storage senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott lgyszr raktr troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested softstem storage senescence N flux" %
        output_map[1763] = &nf->HRV_softstemn_transfer_to_SNSC; //%"Harvested softstem transfer senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott lgyszr transzfer troz elregedsbol szrmaz nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested softstem transfer senescence N flux" %
        output_map[1764] = &nf->HRV_retransn_to_SNSC; //%"Harvested retranslocated N senescence N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartott retranszloklt N elregedsi fluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvested retranslocated N senescence N flux" %
        output_map[1765] = &nf->yieldn_to_flowHS; //%"N flux from yield flowering heat stress" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Terms virgzs alatti hostresszbol eredo nitrognfluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from yield flowering heat stress" %
        output_map[1766] = &nf->STDBn_leaf_to_litr; //%"Leaf standing dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ll elhalt levl biomassza nitrognfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leaf standing dead biomass N flux to litter" %
        output_map[1767] = &nf->STDBn_froot_to_litr; //%"Fine root standing dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ll elhalt hajszlgykr biomassza nitrognfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fine root standing dead biomass N flux to litter" %
        output_map[1768] = &nf->STDBn_yield_to_litr; //%"yield standing dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ll elhalt terms biomassza nitrognfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "yield standing dead biomass N flux to litter" %
        output_map[1769] = &nf->STDBn_softstem_to_litr; //%"Softstem standing dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ll elhalt lgyszr biomassza nitrognfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Softstem standing dead biomass N flux to litter" %
        output_map[1770] = &nf->litrn_to_release_total; //%"Sum of direct decomposition nitrogen flux of litter pools" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Az elhalt szervesanyag direkt bomlsnak teljes nitrognfluxusa" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Sum of direct decomposition nitrogen flux of litter pools" %
        output_map[1771] = &nf->STDBn_to_litr; //%"Standing dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ll elhalt nvnyi biomassza nitrognfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Standing dead biomass N flux to litter" %
        output_map[1772] = &nf->CTDBn_leaf_to_litr; //%"Cut-down leaf dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levgott elhalt levl biomassza nitrognfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cut-down leaf dead biomass N flux to litter" %
        output_map[1773] = &nf->CTDBn_froot_to_litr; //%"Cut-down fine root dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levgott elhalt hajszlgykr biomassza nitrognfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cut-down fine root dead biomass N flux to litter" %
        output_map[1774] = &nf->CTDBn_yield_to_litr; //%"Cut-down yield dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levgott elhalt terms biomassza nitrognfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cut-down yield dead biomass N flux to litter" %
        output_map[1775] = &nf->CTDBn_softstem_to_litr; //%"Cut-down softstem dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levgott elhalt lgyszr biomassza nitrognfluxusa elhalt nvnyi anyagg""" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cut-down softstem dead biomass N flux to litter" %
        output_map[1777] = &nf->CTDBn_cstem_to_cwd; //%"Cut-down coarse stem dead biomass N flux to coarse woody debris" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levgott elhalt fs szr biomassza nitrognfluxusa Fs nvnyi maradvnyk" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cut-down coarse stem dead biomass N flux to coarse woody debris" %
        output_map[1778] = &nf->CTDBn_croot_to_cwd; //%"Cut-down coarse root dead biomass N flux to coarse woody debris" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levgott elhalt fs gykr nitrognfluxusa Fs nvnyi maradvnyk" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cut-down coarse root dead biomass N flux to coarse woody debris" %
        output_map[1779] = &nf->CTDBn_to_litr; //%"Cut-down dead biomass N flux to litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levgott elhalt nvnyi biomassza nitrognfluxusa elhalt nvnyi anyagg" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cut-down dead biomass N flux to litter" %
        output_map[1780] = &nf->m_leafn_to_fire; //%"Leaf fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levl tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leaf fire N flux" %
        output_map[1781] = &nf->m_frootn_to_fire; //%"Fine root fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Hajszlgykr tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fine root fire N flux" %
        output_map[1782] = &nf->m_yieldn_to_fire; //%"yield fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Terms tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "yield fire N flux" %
        output_map[1783] = &nf->m_softstemn_to_fire; //%"Softstem fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Lgyszr tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Softstem fire N flux" %
        output_map[1784] = &nf->m_STDBn_to_fire; //%"Wilted plant biomass fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhervadt nvnyi anyag tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Wilted plant biomass fire N flux" %
        output_map[1785] = &nf->m_CTDBn_to_fire; //%"Cut-down plant biomass fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levgott nvnyi anyag tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cut-down plant biomass fire N flux" %
        output_map[1786] = &nf->m_leafn_storage_to_fire; //%"Leaf storage pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levl raktr troz tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leaf storage pool fire N flux" %
        output_map[1787] = &nf->m_frootn_storage_to_fire; //%"Fine root storage pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Hajszlgykr raktr troz tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fine root storage pool fire N flux" %
        output_map[1788] = &nf->m_yieldn_storage_to_fire; //%"yield storage pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Terms raktr troz tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "yield storage pool fire N flux" %
        output_map[1789] = &nf->m_yieldn_transfer_to_fire; //%"yield transfer pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Terms transzfer troz tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "yield transfer pool fire N flux" %
        output_map[1790] = &nf->m_softstemn_storage_to_fire; //%"Softstem storage pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Lgyszr raktr troz tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Softstem storage pool fire N flux" %
        output_map[1791] = &nf->m_softstemn_transfer_to_fire; //%"Softstem transfer pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Lgyszr transzfer troz tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Softstem transfer pool fire N flux" %
        output_map[1792] = &nf->m_livestemn_storage_to_fire; //%"Live stem storage pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szjcs (fatest klso l rsze) raktr trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Live stem storage pool fire N flux" %
        output_map[1793] = &nf->m_deadstemn_storage_to_fire; //%"Dead stem storage pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Geszt (fatest belso lettelen rsze) raktr trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Dead stem storage pool fire N flux" %
        output_map[1794] = &nf->m_livecrootn_storage_to_fire; //%"Live coarse root storage pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Fs gykr klso l rsz raktr trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Live coarse root storage pool fire N flux" %
        output_map[1795] = &nf->m_deadcrootn_storage_to_fire; //%"Dead coarse root storage pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Fs gykr belso lettelen rsz raktr trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Dead coarse root storage pool fire N flux" %
        output_map[1796] = &nf->m_leafn_transfer_to_fire; //%"Leaf transfer pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Levl transzfer troz tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leaf transfer pool fire N flux" %
        output_map[1797] = &nf->m_frootn_transfer_to_fire; //%"Fine root transfer pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Hajszlgykr transzfer troz tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fine root transfer pool fire N flux" %
        output_map[1798] = &nf->m_livestemn_transfer_to_fire; //%"Live stem transfer pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szjcs (fatest klso l rsze) transzfer trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Live stem transfer pool fire N flux" %
        output_map[1799] = &nf->m_deadstemn_transfer_to_fire; //%"Dead stem transfer pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Geszt (fatest belso lettelen rsze) transzfer trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Dead stem transfer pool fire N flux" %
        output_map[1800] = &nf->m_livecrootn_transfer_to_fire; //%"Live coarse root transfer pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Fs gykr klso l rsz transzfer trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Live coarse root transfer pool fire N flux" %
        output_map[1801] = &nf->m_deadcrootn_transfer_to_fire; //%"Dead coarse root transfer pool fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Fs gykr belso lettelen rsz transzfer trozjnak tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Dead coarse root transfer pool fire N flux" %
        output_map[1802] = &nf->m_livestemn_to_fire; //%"Live stem fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szjcs (fatest klso l rsze) tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Live stem fire N flux" %
        output_map[1803] = &nf->m_deadstemn_to_fire; //%"Dead stem fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Geszt (fatest belso lettelen rsze) tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Dead stem fire N flux" %
        output_map[1804] = &nf->m_livecrootn_to_fire; //%"Live coarse root fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Fs gykr klso l rsznek tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Live coarse root fire N flux" %
        output_map[1805] = &nf->m_deadcrootn_to_fire; //%"Dead coarse root fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Fs gykr belso lettelen rsznek tuzelhalsi fluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Dead coarse root fire N flux" %
        output_map[1806] = &nf->m_retransn_to_fire; //%"Retranslocated N fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Retranszloklt N tuzelhalsi fluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Retranslocated N fire N flux" %
        output_map[1807] = &nf->m_litr1n_to_fire_total; //%"Labile N portion of litter fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalt nvnyi anyag knnyen boml rsznek tuzelhalsi nitrognfluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Labile N portion of litter fire N flux" %
        output_map[1808] = &nf->m_litr2n_to_fire_total; //%"Unshielded cellulose portion N of litter fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalt nvnyi anyag hozzfrhet cellulz tartalmnak tuzelhalsi nitrognfluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Unshielded cellulose portion N of litter fire N flux" %
        output_map[1809] = &nf->m_litr3n_to_fire_total; //%"Shielded cellulose portion N of litter fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalt nvnyi anyag nem hozzfrhet cellulz tartalmnak tuzelhalsi nitrognfluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Shielded cellulose portion N of litter fire N flux" %
        output_map[1810] = &nf->m_litr4n_to_fire_total; //%"Lignin N portion of litter fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Elhalt nvnyi anyag lignin tartalmnak tuzelhalsi nitrognfluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Lignin N portion of litter fire N flux" %
        output_map[1811] = &nf->m_cwdn_to_fire_total; //%"Coarse woody debris fire N flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Fs nvnyi maradvny tuzelhalsi nitrognfluxusa" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Coarse woody debris fire N flux" %
        output_map[1812] = &nf->leafn_transfer_to_leafn; //%"Phenology N flux from leaf transfer pool to leaf" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a levl raktr trozbl az aktulis trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Phenology N flux from leaf transfer pool to leaf" %
        output_map[1813] = &nf->frootn_transfer_to_frootn; //%"Phenology N flux from fine root transfer pool to fine root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a hajszlgykr raktr trozbl az aktulis trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Phenology N flux from fine root transfer pool to fine root" %
        output_map[1814] = &nf->yieldn_transfer_to_yieldn; //%"Phenology N flux from yield transfer pool to yield" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a terms raktr trozbl az aktulis trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Phenology N flux from yield transfer pool to yield" %
        output_map[1815] = &nf->softstemn_transfer_to_softstemn; //%"Phenology N flux from softstem transfer pool to softstem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lgyszr raktr trozbl az aktulis trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Phenology N flux from softstem transfer pool to softstem" %
        output_map[1816] = &nf->livestemn_transfer_to_livestemn; //%"Phenology N flux from live stem transfer pool to live stem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a szjcs (fs szr klso l rsz) raktr trozbl az aktulis trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Phenology N flux from live stem transfer pool to live stem" %
        output_map[1817] = &nf->deadstemn_transfer_to_deadstemn; //%"Phenology N flux from dead stem transfer to dead stem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a geszt (fs szr belso lettelen rsz) raktr trozbl az aktulis trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Phenology N flux from dead stem transfer to dead stem" %
        output_map[1818] = &nf->livecrootn_transfer_to_livecrootn; //%"Phenology N flux from live coarse root transfer pool to live coarse root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a fs gykr klso l rsz raktr trozbl az aktulis trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Phenology N flux from live coarse root transfer pool to live coarse root" %
        output_map[1819] = &nf->deadcrootn_transfer_to_deadcrootn; //%"Phenology N flux from dead coarse root transfer pool to dead coarse root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a fs gykr belso lettelen rsz raktr trozbl az aktulis trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Phenology N flux from dead coarse root transfer pool to dead coarse root" %
        output_map[1820] = &nf->leafn_to_litr1n; //%"N flux from leaf to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a levlbol elhalt nvnyi anyag knnyen boml rszv" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from leaf to labile N portion of litter" %
        output_map[1821] = &nf->leafn_to_litr2n; //%"N flux from leaf to unshielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a levlbol hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from leaf to unshielded cellulose N portion of litter" %
        output_map[1822] = &nf->leafn_to_litr3n; //%"N flux from leaf to shielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a levlbol nem hozzvrheto cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from leaf to shielded cellulose N portion of litter" %
        output_map[1823] = &nf->leafn_to_litr4n; //%"N flux from leaf to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a levlbol ligninn" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from leaf to lignin N portion of litter" %
        output_map[1824] = &nf->leafn_to_retransn; //%"N flux from leaf to retranslocated N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a levlbol retranszloklt N-n" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from leaf to retranslocated N" %
        output_map[1825] = &nf->frootn_to_litr1n; //%"N flux from fine root to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a hajszlgykrbol elhalt nvnyi anyag knnyen boml rszv" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fine root to labile N portion of litter" %
        output_map[1826] = &nf->frootn_to_litr2n; //%"N flux from fine root to unshielded cellulose portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a hajszlgykrbol hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fine root to unshielded cellulose portion of litter" %
        output_map[1827] = &nf->frootn_to_litr3n; //%"N flux from fine root to shielded cellulose portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a hajszlgykrbol nem hozzvrheto cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fine root to shielded cellulose portion of litter" %
        output_map[1828] = &nf->frootn_to_litr4n; //%"N flux from fine root to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a hajszlgykrbol ligninn" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fine root to lignin N portion of litter" %
        output_map[1829] = &nf->yieldn_to_litr1n; //%"N flux from yield to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a termsbol elhalt nvnyi anyag knnyen boml rszv" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from yield to labile N portion of litter" %
        output_map[1830] = &nf->yieldn_to_litr2n; //%"N flux from yield to unshielded cellulose portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a termsbol hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from yield to unshielded cellulose portion of litter" %
        output_map[1831] = &nf->yieldn_to_litr3n; //%"N flux from yield to shielded cellulose portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a termsbol nem hozzvrheto cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from yield to shielded cellulose portion of litter" %
        output_map[1832] = &nf->yieldn_to_litr4n; //%"N flux from yield to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a termsbol ligninn" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from yield to lignin N portion of litter" %
        output_map[1833] = &nf->softstemn_to_litr1n; //%"N flux from softstem to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lgyszrbl elhalt nvnyi anyag knnyen boml rszv" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from softstem to labile N portion of litter" %
        output_map[1834] = &nf->softstemn_to_litr2n; //%"N flux from softstem to unshielded cellulose portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lgyszrbl hozzfrhet cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from softstem to unshielded cellulose portion of litter" %
        output_map[1835] = &nf->softstemn_to_litr3n; //%"N flux from softstem to shielded cellulose portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lgyszrbl nem hozzvrheto cellulzz" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from softstem to shielded cellulose portion of litter" %
        output_map[1836] = &nf->softstemn_to_litr4n; //%"N flux from softstem to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lgyszrbl ligninn" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from softstem to lignin N portion of litter" %
        output_map[1837] = &nf->ndep_to_sminn_total; //%"N flux from N deposition to soil mineral N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a N lepedsbol talaj svnyi N-n" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from N deposition to soil mineral N" %
        output_map[1838] = &nf->nfix_to_sminn_total; //%"N flux from N fixation to soil mineral N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus N fixcibl talaj svnyi N-n" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from N fixation to soil mineral N" %
        output_map[1839] = &nf->cwdn_to_litr2n[0]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 1 (0-3 cm)" %
        output_map[1840] = &nf->cwdn_to_litr2n[1]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 2 (3-10 cm)" %
        output_map[1841] = &nf->cwdn_to_litr2n[2]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 3 (10-30 cm)" %
        output_map[1842] = &nf->cwdn_to_litr2n[3]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 4 (30-60 cm)" %
        output_map[1843] = &nf->cwdn_to_litr2n[4]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 5 (60-90 cm)" %
        output_map[1844] = &nf->cwdn_to_litr2n[5]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 6 (90-120 cm)" %
        output_map[1845] = &nf->cwdn_to_litr2n[6]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 7 (120-150 cm)" %
        output_map[1846] = &nf->cwdn_to_litr2n[7]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 8 (150-200 cm)" %
        output_map[1847] = &nf->cwdn_to_litr2n[8]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 9 (200-400 cm)" %
        output_map[1848] = &nf->cwdn_to_litr2n[9]; //%"N flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl hozzfrhet cellulzz a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to unshielded cellulose N portion of litter in soil layer 10 (400-1000 cm)" %
        output_map[1849] = &nf->cwdn_to_litr3n[0]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 1 (0-3 cm)" %
        output_map[1850] = &nf->cwdn_to_litr3n[1]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 2 (3-10 cm)" %
        output_map[1851] = &nf->cwdn_to_litr3n[2]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 3 (10-30 cm)" %
        output_map[1852] = &nf->cwdn_to_litr3n[3]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 4 (30-60 cm)" %
        output_map[1853] = &nf->cwdn_to_litr3n[4]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 5 (60-90 cm)" %
        output_map[1854] = &nf->cwdn_to_litr3n[5]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 6 (90-120 cm)" %
        output_map[1855] = &nf->cwdn_to_litr3n[6]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 7 (120-150 cm)" %
        output_map[1856] = &nf->cwdn_to_litr3n[7]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 8 (150-200 cm)" %
        output_map[1857] = &nf->cwdn_to_litr3n[8]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 9 (200-400 cm)" %
        output_map[1858] = &nf->cwdn_to_litr3n[9]; //%"N flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl nem hozzfrhet cellulzz a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to shielded cellulose N portion of litter in soil layer 10 (400-1000 cm)" %
        output_map[1859] = &nf->cwdn_to_litr4n[0]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 1 (0-3 cm)" %
        output_map[1860] = &nf->cwdn_to_litr4n[1]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 2 (3-10 cm)" %
        output_map[1861] = &nf->cwdn_to_litr4n[2]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 3 (10-30 cm)" %
        output_map[1862] = &nf->cwdn_to_litr4n[3]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 4 (30-60 cm)" %
        output_map[1863] = &nf->cwdn_to_litr4n[4]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 5 (60-90 cm)" %
        output_map[1864] = &nf->cwdn_to_litr4n[5]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 6 (90-120 cm)" %
        output_map[1865] = &nf->cwdn_to_litr4n[6]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 7 (120-150 cm)" %
        output_map[1866] = &nf->cwdn_to_litr4n[7]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 8 (150-200 cm)" %
        output_map[1867] = &nf->cwdn_to_litr4n[8]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 9 (200-400 cm)" %
        output_map[1868] = &nf->cwdn_to_litr4n[9]; //%"N flux from coarse woody debris to lignin N portion of litter in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus Fs nvnyi maradvnybl ligninn a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from coarse woody debris to lignin N portion of litter in soil layer 10 (400-1000 cm)" %
        output_map[1869] = &nf->litr1n_to_soil1n[0]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 1 (0-3 cm)" %
        output_map[1870] = &nf->litr1n_to_soil1n[1]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 2 (3-10 cm)" %
        output_map[1871] = &nf->litr1n_to_soil1n[2]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 3 (10-30 cm)" %
        output_map[1872] = &nf->litr1n_to_soil1n[3]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 4 (30-60 cm)" %
        output_map[1873] = &nf->litr1n_to_soil1n[4]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 5 (60-90 cm)" %
        output_map[1874] = &nf->litr1n_to_soil1n[5]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 6 (90-120 cm)" %
        output_map[1875] = &nf->litr1n_to_soil1n[6]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 7 (120-150 cm)" %
        output_map[1876] = &nf->litr1n_to_soil1n[7]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 8 (150-200 cm)" %
        output_map[1877] = &nf->litr1n_to_soil1n[8]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 9 (200-400 cm)" %
        output_map[1878] = &nf->litr1n_to_soil1n[9]; //%"N flux from labile N portion of litter to SOM pool (labile) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in soil layer 10 (400-1000 cm)" %
        output_map[1879] = &nf->litr2n_to_soil2n[0]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 1 (0-3 cm)" %
        output_map[1880] = &nf->litr2n_to_soil2n[1]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 2 (3-10 cm)" %
        output_map[1881] = &nf->litr2n_to_soil2n[2]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 3 (10-30 cm)" %
        output_map[1882] = &nf->litr2n_to_soil2n[3]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 4 (30-60 cm)" %
        output_map[1883] = &nf->litr2n_to_soil2n[4]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 5 (60-90 cm)" %
        output_map[1884] = &nf->litr2n_to_soil2n[5]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 6 (90-120 cm)" %
        output_map[1885] = &nf->litr2n_to_soil2n[6]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 7 (120-150 cm)" %
        output_map[1886] = &nf->litr2n_to_soil2n[7]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 8 (150-200 cm)" %
        output_map[1887] = &nf->litr2n_to_soil2n[8]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 9 (200-400 cm)" %
        output_map[1888] = &nf->litr2n_to_soil2n[9]; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrhet cellulzbl szervesanyag szntartalmnak ba (gyors) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in soil layer 10 (400-1000 cm)" %
        output_map[1889] = &nf->litr3n_to_litr2n[0]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 1 (0-3 cm)" %
        output_map[1890] = &nf->litr3n_to_litr2n[1]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 2 (3-10 cm)" %
        output_map[1891] = &nf->litr3n_to_litr2n[2]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 3 (10-30 cm)" %
        output_map[1892] = &nf->litr3n_to_litr2n[3]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 4 (30-60 cm)" %
        output_map[1893] = &nf->litr3n_to_litr2n[4]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 5 (60-90 cm)" %
        output_map[1894] = &nf->litr3n_to_litr2n[5]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 6 (90-120 cm)" %
        output_map[1895] = &nf->litr3n_to_litr2n[6]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 7 (120-150 cm)" %
        output_map[1896] = &nf->litr3n_to_litr2n[7]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 8 (150-200 cm)" %
        output_map[1897] = &nf->litr3n_to_litr2n[8]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 9 (200-400 cm)" %
        output_map[1898] = &nf->litr3n_to_litr2n[9]; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrhet cellulzbl hozzfrhet cellulzz a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in soil layer 10 (400-1000 cm)" %
        output_map[1899] = &nf->litr4n_to_soil3n[0]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 1 (0-3 cm)" %
        output_map[1900] = &nf->litr4n_to_soil3n[1]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 2 (3-10 cm)" %
        output_map[1901] = &nf->litr4n_to_soil3n[2]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 3 (10-30 cm)" %
        output_map[1902] = &nf->litr4n_to_soil3n[3]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 4 (30-60 cm)" %
        output_map[1903] = &nf->litr4n_to_soil3n[4]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 5 (60-90 cm)" %
        output_map[1904] = &nf->litr4n_to_soil3n[5]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 6 (90-120 cm)" %
        output_map[1905] = &nf->litr4n_to_soil3n[6]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 7 (120-150 cm)" %
        output_map[1906] = &nf->litr4n_to_soil3n[7]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 8 (150-200 cm)" %
        output_map[1907] = &nf->litr4n_to_soil3n[8]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 9 (200-400 cm)" %
        output_map[1908] = &nf->litr4n_to_soil3n[9]; //%"N flux from lignin portion of litter to shielded cellulose pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrhet cellulzz a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in soil layer 10 (400-1000 cm)" %
        output_map[1909] = &nf->soil1n_to_soil2n[0]; //%"N flux from labile to fast SOM pool in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast decomposing SOM pool in soil layer 1 (0-3 cm)" %
        output_map[1910] = &nf->soil1n_to_soil2n[1]; //%"N flux from labile to fast SOM pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast decomposing SOM pool in soil layer 2 (3-10 cm)" %
        output_map[1911] = &nf->soil1n_to_soil2n[2]; //%"N flux from labile to fast SOM pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast decomposing SOM pool in soil layer 3 (10-30 cm)" %
        output_map[1912] = &nf->soil1n_to_soil2n[3]; //%"N flux from labile to fast SOM pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast decomposing SOM pool in soil layer 4 (30-60 cm)" %
        output_map[1913] = &nf->soil1n_to_soil2n[4]; //%"N flux from labile to fast SOM pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast SOM pool in soil layer 5 (60-90 cm)" %
        output_map[1914] = &nf->soil1n_to_soil2n[5]; //%"N flux from labile to fast SOM pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast SOM pool in soil layer 6 (90-120 cm)" %
        output_map[1915] = &nf->soil1n_to_soil2n[6]; //%"N flux from labile to fast SOM pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast SOM pool in soil layer 7 (120-150 cm)" %
        output_map[1916] = &nf->soil1n_to_soil2n[7]; //%"N flux from labile to fast SOM pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast SOM pool in soil layer 8 (150-200 cm)" %
        output_map[1917] = &nf->soil1n_to_soil2n[8]; //%"N flux from labile to fast SOM pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast SOM pool in soil layer 9 (200-400 cm)" %
        output_map[1918] = &nf->soil1n_to_soil2n[9]; //%"N flux from labile to fast SOM pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast SOM pool in soil layer 10 (400-1000 cm)" %
        output_map[1919] = &nf->soil2n_to_soil3n[0]; //%"N flux from fast to slow SOM pool in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 1 (0-3 cm)" %
        output_map[1920] = &nf->soil2n_to_soil3n[1]; //%"N flux from fast to slow SOM pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 2 (3-10 cm)" %
        output_map[1921] = &nf->soil2n_to_soil3n[2]; //%"N flux from fast to slow SOM pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 3 (10-30 cm)" %
        output_map[1922] = &nf->soil2n_to_soil3n[3]; //%"N flux from fast to slow SOM pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 4 (30-60 cm)" %
        output_map[1923] = &nf->soil2n_to_soil3n[4]; //%"N flux from fast to slow SOM pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 5 (60-90 cm)" %
        output_map[1924] = &nf->soil2n_to_soil3n[5]; //%"N flux from fast to slow SOM pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 6 (90-120 cm)" %
        output_map[1925] = &nf->soil2n_to_soil3n[6]; //%"N flux from fast to slow SOM pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 7 (120-150 cm)" %
        output_map[1926] = &nf->soil2n_to_soil3n[7]; //%"N flux from fast to slow SOM pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 8 (150-200 cm)" %
        output_map[1927] = &nf->soil2n_to_soil3n[8]; //%"N flux from fast to slow SOM pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 9 (200-400 cm)" %
        output_map[1928] = &nf->soil2n_to_soil3n[9]; //%"N flux from fast to slow SOM pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow SOM pool in soil layer 10 (400-1000 cm)" %
        output_map[1929] = &nf->soil3n_to_soil4n[0]; //%"N flux from slow to stable SOM in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM SOM pool in soil layer 1 (0-3 cm)" %
        output_map[1930] = &nf->soil3n_to_soil4n[1]; //%"N flux from slow to stable SOM in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM SOM pool in soil layer 2 (3-10 cm)" %
        output_map[1931] = &nf->soil3n_to_soil4n[2]; //%"N flux from slow to stable SOM in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM SOM pool in soil layer 3 (10-30 cm)" %
        output_map[1932] = &nf->soil3n_to_soil4n[3]; //%"N flux from slow to stable SOM in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM SOM pool in soil layer 4 (30-60 cm)" %
        output_map[1933] = &nf->soil3n_to_soil4n[4]; //%"N flux from slow to stable SOM in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM SOM pool in soil layer 5 (60-90 cm)" %
        output_map[1934] = &nf->soil3n_to_soil4n[5]; //%"N flux from slow to stable SOM in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM SOM pool in soil layer 6 (90-120 cm)" %
        output_map[1935] = &nf->soil3n_to_soil4n[6]; //%"N flux from slow to stable SOM in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM SOM pool in soil layer 7 (120-150 cm)" %
        output_map[1936] = &nf->soil3n_to_soil4n[7]; //%"N flux from slow to stable SOM in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM SOM pool in soil layer 8 (150-200 cm)" %
        output_map[1937] = &nf->soil3n_to_soil4n[8]; //%"N flux from slow to stable SOM in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM SOM pool in soil layer 9 (200-400 cm)" %
        output_map[1938] = &nf->soil3n_to_soil4n[9]; //%"N flux from slow to stable SOM in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM C content of SOM pool in soil layer 10 (400-1000 cm)" %
        output_map[1939] = &nf->sminn_to_soiln_s4[0]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 1 (0-3 cm)" %
        output_map[1940] = &nf->sminn_to_soiln_s4[1]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer  (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer  (3-10 cm)" %
        output_map[1941] = &nf->sminn_to_soiln_s4[2]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 3 (10-30 cm)" %
        output_map[1942] = &nf->sminn_to_soiln_s4[3]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 4 (30-60 cm)" %
        output_map[1943] = &nf->sminn_to_soiln_s4[4]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 5 (60-90 cm)" %
        output_map[1944] = &nf->sminn_to_soiln_s4[5]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 6 (90-120 cm)" %
        output_map[1945] = &nf->sminn_to_soiln_s4[6]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 7 (120-150 cm)" %
        output_map[1946] = &nf->sminn_to_soiln_s4[7]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 8 (150-200 cm)" %
        output_map[1947] = &nf->sminn_to_soiln_s4[8]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 9 (200-400 cm)" %
        output_map[1948] = &nf->sminn_to_soiln_s4[9]; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 1 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl (leglassabb) talaj svnyi ammniumm a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in soil layer 10 (400-1000 cm)" %
        output_map[1949] = &nf->sminn_to_soiln_s4_total; //%"Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N mineralizci fluxus az ellenll talaj szervesanyag tartalombl svnyi ammniumm a teljes talajban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mineralization N flux from stable SOM pool (stable) to soil mineral NH4 in total soil" %
        output_map[1950] = &nf->sminn_to_soilSUM[0]; //%"Immobilization N flux from soil mineral N to soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 1 (0-3 cm)" %
        output_map[1951] = &nf->sminn_to_soilSUM[1]; //%"Immobilization N flux from soil mineral N to soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 2 (3-10 cm)" %
        output_map[1952] = &nf->sminn_to_soilSUM[2]; //%"Immobilization N flux from soil mineral N to soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 3 (10-30 cm)" %
        output_map[1953] = &nf->sminn_to_soilSUM[3]; //%"Immobilization N flux from soil mineral N to soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 4 (30-60 cm)" %
        output_map[1954] = &nf->sminn_to_soilSUM[4]; //%"Immobilization N flux from soil mineral N to soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 5 (60-90 cm)" %
        output_map[1955] = &nf->sminn_to_soilSUM[5]; //%"Immobilization N flux from soil mineral N to soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 6 (90-120 cm)" %
        output_map[1956] = &nf->sminn_to_soilSUM[6]; //%"Immobilization N flux from soil mineral N to soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 7 (120-150 cm)" %
        output_map[1957] = &nf->sminn_to_soilSUM[7]; //%"Immobilization N flux from soil mineral N to soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 8 (150-200 cm)" %
        output_map[1958] = &nf->sminn_to_soilSUM[8]; //%"Immobilization N flux from soil mineral N to soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 9 (200-400 cm)" %
        output_map[1959] = &nf->sminn_to_soilSUM[9]; //%"Immobilization N flux from soil mineral N to soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to soil layer 10 (400-1000 cm)" %
        output_map[1960] = &nf->NH4_to_soilSUM[0]; //%"Immobilization N flux from soil NH4 to soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 1 (0-3 cm)" %
        output_map[1961] = &nf->NH4_to_soilSUM[1]; //%"Immobilization N flux from soil NH4 to soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 2 (3-10 cm)" %
        output_map[1962] = &nf->NH4_to_soilSUM[2]; //%"Immobilization N flux from soil NH4 to soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 3 (10-30 cm)" %
        output_map[1963] = &nf->NH4_to_soilSUM[3]; //%"Immobilization N flux from soil NH4 to soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 4 (30-60 cm)" %
        output_map[1964] = &nf->NH4_to_soilSUM[4]; //%"Immobilization N flux from soil NH4 to soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 5 (60-90 cm)" %
        output_map[1965] = &nf->NH4_to_soilSUM[5]; //%"Immobilization N flux from soil NH4 to soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 6 (90-120 cm)" %
        output_map[1966] = &nf->NH4_to_soilSUM[6]; //%"Immobilization N flux from soil NH4 to soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 7 (120-150 cm)" %
        output_map[1967] = &nf->NH4_to_soilSUM[7]; //%"Immobilization N flux from soil NH4 to soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 8 (150-200 cm)" %
        output_map[1968] = &nf->NH4_to_soilSUM[8]; //%"Immobilization N flux from soil NH4 to soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 9 (200-400 cm)" %
        output_map[1969] = &nf->NH4_to_soilSUM[9]; //%"Immobilization N flux from soil NH4 to soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NH4-bol a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NH4 to soil layer 10 (400-1000 cm)" %
        output_map[1970] = &nf->NO3_to_soilSUM[0]; //%"Immobilization N flux from soil NO3 to soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 1 (0-3 cm)" %
        output_map[1971] = &nf->NO3_to_soilSUM[1]; //%"Immobilization N flux from soil NO3 to soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 2 (3-10 cm)" %
        output_map[1972] = &nf->NO3_to_soilSUM[2]; //%"Immobilization N flux from soil NO3 to soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 3 (10-30 cm)" %
        output_map[1973] = &nf->NO3_to_soilSUM[3]; //%"Immobilization N flux from soil NO3 to soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 4 (30-60 cm)" %
        output_map[1974] = &nf->NO3_to_soilSUM[4]; //%"Immobilization N flux from soil NO3 to soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 5 (60-90 cm)" %
        output_map[1975] = &nf->NO3_to_soilSUM[5]; //%"Immobilization N flux from soil NO3 to soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 6 (90-120 cm)" %
        output_map[1976] = &nf->NO3_to_soilSUM[6]; //%"Immobilization N flux from soil NO3 to soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 7 (120-150 cm)" %
        output_map[1977] = &nf->NO3_to_soilSUM[7]; //%"Immobilization N flux from soil NO3 to soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 8 (150-200 cm)" %
        output_map[1978] = &nf->NO3_to_soilSUM[8]; //%"Immobilization N flux from soil NO3 to soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 9 (200-400 cm)" %
        output_map[1979] = &nf->NO3_to_soilSUM[9]; //%"Immobilization N flux from soil NO3 to soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi NO3-bl a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil NO3 to soil layer 10 (400-1000 cm)" %
        output_map[1980] = &nf->sminn_to_soil1n_l1[0]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 1 (0-3 cm)" %
        output_map[1981] = &nf->sminn_to_soil1n_l1[1]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 2 (3-10 cm)" %
        output_map[1982] = &nf->sminn_to_soil1n_l1[2]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 3 (10-30 cm)" %
        output_map[1983] = &nf->sminn_to_soil1n_l1[3]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 4 (30-60 cm)" %
        output_map[1984] = &nf->sminn_to_soil1n_l1[4]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 5 (60-90 cm)" %
        output_map[1985] = &nf->sminn_to_soil1n_l1[5]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 6 (90-120 cm)" %
        output_map[1986] = &nf->sminn_to_soil1n_l1[6]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 7 (120-150 cm)" %
        output_map[1987] = &nf->sminn_to_soil1n_l1[7]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 8 (150-200 cm)" %
        output_map[1988] = &nf->sminn_to_soil1n_l1[8]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 9 (200-400 cm)" %
        output_map[1989] = &nf->sminn_to_soil1n_l1[9]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 10 (400-1000 cm)" %
        output_map[1990] = &nf->sminn_to_soil2n_l2[0]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 1 (0-3 cm)" %
        output_map[1991] = &nf->sminn_to_soil2n_l2[1]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 2 (3-10 cm)" %
        output_map[1992] = &nf->sminn_to_soil2n_l2[2]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 3 (10-30 cm)" %
        output_map[1993] = &nf->sminn_to_soil2n_l2[3]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 4 (30-60 cm)" %
        output_map[1994] = &nf->sminn_to_soil2n_l2[4]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 5 (60-90 cm)" %
        output_map[1995] = &nf->sminn_to_soil2n_l2[5]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 6 (90-120 cm)" %
        output_map[1996] = &nf->sminn_to_soil2n_l2[6]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 7 (120-150 cm)" %
        output_map[1997] = &nf->sminn_to_soil2n_l2[7]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 8 (150-200 cm)" %
        output_map[1998] = &nf->sminn_to_soil2n_l2[8]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 9 (200-400 cm)" %
        output_map[1999] = &nf->sminn_to_soil2n_l2[9]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 10 (400-1000 cm)" %
        output_map[2000] = &nf->sminn_to_soil3n_l4[0]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 1 (0-3 cm)" %
        output_map[2001] = &nf->sminn_to_soil3n_l4[1]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 2 (3-10 cm)" %
        output_map[2002] = &nf->sminn_to_soil3n_l4[2]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 3 (10-30 cm)" %
        output_map[2003] = &nf->sminn_to_soil3n_l4[3]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 4 (30-60 cm)" %
        output_map[2004] = &nf->sminn_to_soil3n_l4[4]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 5 (60-90 cm)" %
        output_map[2005] = &nf->sminn_to_soil3n_l4[5]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 6 (90-120 cm)" %
        output_map[2006] = &nf->sminn_to_soil3n_l4[6]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 7 (120-150 cm)" %
        output_map[2007] = &nf->sminn_to_soil3n_l4[7]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 8 (150-200 cm)" %
        output_map[2008] = &nf->sminn_to_soil3n_l4[8]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 9 (200-400 cm)" %
        output_map[2009] = &nf->sminn_to_soil3n_l4[9]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 10 (400-1000 cm)" %
        output_map[2010] = &nf->sminn_to_soil2n_s1[0]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 1 (0-3 cm)" %
        output_map[2011] = &nf->sminn_to_soil2n_s1[1]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 2 (3-10 cm)" %
        output_map[2012] = &nf->sminn_to_soil2n_s1[2]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 3 (10-30 cm)" %
        output_map[2013] = &nf->sminn_to_soil2n_s1[3]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 4 (30-60 cm)" %
        output_map[2014] = &nf->sminn_to_soil2n_s1[4]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 5 (60-90 cm)" %
        output_map[2015] = &nf->sminn_to_soil2n_s1[5]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 6 (90-120 cm)" %
        output_map[2016] = &nf->sminn_to_soil2n_s1[6]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 7 (120-150 cm)" %
        output_map[2017] = &nf->sminn_to_soil2n_s1[7]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 8 (150-200 cm)" %
        output_map[2018] = &nf->sminn_to_soil2n_s1[8]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 9 (200-400 cm)" %
        output_map[2019] = &nf->sminn_to_soil2n_s1[9]; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in soil layer 10 (400-1000 cm)" %
        output_map[2020] = &nf->sminn_to_soil3n_s2[0]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 1 (0-3 cm)" %
        output_map[2021] = &nf->sminn_to_soil3n_s2[1]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 2 (3-10 cm)" %
        output_map[2022] = &nf->sminn_to_soil3n_s2[2]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 3 (10-30 cm)" %
        output_map[2023] = &nf->sminn_to_soil3n_s2[3]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 4 (30-60 cm)" %
        output_map[2024] = &nf->sminn_to_soil3n_s2[4]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 5 (60-90 cm)" %
        output_map[2025] = &nf->sminn_to_soil3n_s2[5]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 6 (90-120 cm)" %
        output_map[2026] = &nf->sminn_to_soil3n_s2[6]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 7 (120-150 cm)" %
        output_map[2027] = &nf->sminn_to_soil3n_s2[7]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 8 (150-200 cm)" %
        output_map[2028] = &nf->sminn_to_soil3n_s2[8]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 9 (200-400 cm)" %
        output_map[2029] = &nf->sminn_to_soil3n_s2[9]; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in soil layer 10 (400-1000 cm)" %
        output_map[2030] = &nf->sminn_to_soil4n_s3[0]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 1 (0-3 cm)" %
        output_map[2031] = &nf->sminn_to_soil4n_s3[1]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 2 (3-10 cm)" %
        output_map[2032] = &nf->sminn_to_soil4n_s3[2]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 3 (10-30 cm)" %
        output_map[2033] = &nf->sminn_to_soil4n_s3[3]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 4 (30-60 cm)" %
        output_map[2034] = &nf->sminn_to_soil4n_s3[4]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 5 (60-90 cm)" %
        output_map[2035] = &nf->sminn_to_soil4n_s3[5]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 6 (90-120 cm)" %
        output_map[2036] = &nf->sminn_to_soil4n_s3[6]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 7 (120-150 cm)" %
        output_map[2037] = &nf->sminn_to_soil4n_s3[7]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 8 (150-200 cm)" %
        output_map[2038] = &nf->sminn_to_soil4n_s3[8]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 9 (200-400 cm)" %
        output_map[2039] = &nf->sminn_to_soil4n_s3[9]; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in soil layer 10 (400-1000 cm)" %
        output_map[2040] = &nf->NH4_to_soilSUM_total; //%"Summarized Immobilization N flux if NH4 pool in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj NH4-tartalmbl a teljes talajban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux if NH4 pool in total soil" %
        output_map[2041] = &nf->NO3_to_soilSUM_total; //%"Summarized Immobilization N flux if NO3 pool in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj NO3-tartalmbl a teljes talajban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux if NO3 pool in total soil" %
        output_map[2042] = &nf->litrn_to_soiln_total; //%"Summarized litter to soil N-flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett elhalt nvnyi anyagbl talajba men N-fluxus" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized litter to soil N-flux" %
        output_map[2043] = &nf->NO3_to_denitr[0]; //%"Denitrification flux of soil mineral NO3 in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 1 (1-2 cm)" %
        output_map[2044] = &nf->NO3_to_denitr[1]; //%"Denitrification flux of soil mineral NO3 in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 2 (3-10 cm)" %
        output_map[2045] = &nf->NO3_to_denitr[2]; //%"Denitrification flux of soil mineral NO3 in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 3 (10-30 cm)" %
        output_map[2046] = &nf->NO3_to_denitr[3]; //%"Denitrification flux of soil mineral NO3 in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 4 (30-60 cm)" %
        output_map[2047] = &nf->NO3_to_denitr[4]; //%"Denitrification flux of soil mineral NO3 in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 5 (60-90 cm)" %
        output_map[2048] = &nf->NO3_to_denitr[5]; //%"Denitrification flux of soil mineral NO3 in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 6 (90-120 cm)" %
        output_map[2049] = &nf->NO3_to_denitr[6]; //%"Denitrification flux of soil mineral NO3 in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 7 (120-150 cm)" %
        output_map[2050] = &nf->NO3_to_denitr[7]; //%"Denitrification flux of soil mineral NO3 in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 8 (150-200 cm)" %
        output_map[2051] = &nf->NO3_to_denitr[8]; //%"Denitrification flux of soil mineral NO3 in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 9 (200-400 cm)" %
        output_map[2052] = &nf->NO3_to_denitr[9]; //%"Denitrification flux of soil mineral NO3 in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3 tartalombl a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3 in soil layer 10 (400-1000 cm)" %
        output_map[2053] = &nf->NH4_to_nitrif[0]; //%"Nitrification flux of soil mineral NH4 in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 1 (1-2 cm)" %
        output_map[2054] = &nf->NH4_to_nitrif[1]; //%"Nitrification flux of soil mineral NH4 in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 2 (3-10 cm)" %
        output_map[2055] = &nf->NH4_to_nitrif[2]; //%"Nitrification flux of soil mineral NH4 in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 3 (10-30 cm)" %
        output_map[2056] = &nf->NH4_to_nitrif[3]; //%"Nitrification flux of soil mineral NH4 in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 4 (30-60 cm)" %
        output_map[2057] = &nf->NH4_to_nitrif[4]; //%"Nitrification flux of soil mineral NH4 in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 5 (60-90 cm)" %
        output_map[2058] = &nf->NH4_to_nitrif[5]; //%"Nitrification flux of soil mineral NH4 in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 6 (90-120 cm)" %
        output_map[2059] = &nf->NH4_to_nitrif[6]; //%"Nitrification flux of soil mineral NH4 in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 7 (120-150 cm)" %
        output_map[2060] = &nf->NH4_to_nitrif[7]; //%"Nitrification flux of soil mineral NH4 in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 8 (150-200 cm)" %
        output_map[2061] = &nf->NH4_to_nitrif[8]; //%"Nitrification flux of soil mineral NH4 in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 9 (200-400 cm)" %
        output_map[2062] = &nf->NH4_to_nitrif[9]; //%"Nitrification flux of soil mineral NH4 in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4 tartalombl a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4 in soil layer 10 (400-1000 cm)" %
        output_map[2063] = &nf->N2fluxDENITR[0]; //%"Denitrification flux of N2 in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 1 (1-2 cm)" %
        output_map[2064] = &nf->N2fluxDENITR[1]; //%"Denitrification flux of N2 in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 2 (3-10 cm)" %
        output_map[2065] = &nf->N2fluxDENITR[2]; //%"Denitrification flux of N2 in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 3 (10-30 cm)" %
        output_map[2066] = &nf->N2fluxDENITR[3]; //%"Denitrification flux of N2 in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 4 (30-60 cm)" %
        output_map[2067] = &nf->N2fluxDENITR[4]; //%"Denitrification flux of N2 in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 5 (60-90 cm)" %
        output_map[2068] = &nf->N2fluxDENITR[5]; //%"Denitrification flux of N2 in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 6 (90-120 cm)" %
        output_map[2069] = &nf->N2fluxDENITR[6]; //%"Denitrification flux of N2 in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 7 (120-150 cm)" %
        output_map[2070] = &nf->N2fluxDENITR[7]; //%"Denitrification flux of N2 in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 8 (150-200 cm)" %
        output_map[2071] = &nf->N2fluxDENITR[8]; //%"Denitrification flux of N2 in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 9 (200-400 cm)" %
        output_map[2072] = &nf->N2fluxDENITR[9]; //%"Denitrification flux of N2 in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2 in soil layer 10 (400-1000 cm)" %
        output_map[2073] = &nf->N2OfluxNITRIF[0]; //%"Nitrification flux of N2O in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 1 (1-2 cm)" %
        output_map[2074] = &nf->N2OfluxNITRIF[1]; //%"Nitrification flux of N2O in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 2 (3-10 cm)" %
        output_map[2075] = &nf->N2OfluxNITRIF[2]; //%"Nitrification flux of N2O in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 3 (10-30 cm)" %
        output_map[2076] = &nf->N2OfluxNITRIF[3]; //%"Nitrification flux of N2O in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 4 (30-60 cm)" %
        output_map[2077] = &nf->N2OfluxNITRIF[4]; //%"Nitrification flux of N2O in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 5 (60-90 cm)" %
        output_map[2078] = &nf->N2OfluxNITRIF[5]; //%"Nitrification flux of N2O in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 6 (90-120 cm)" %
        output_map[2079] = &nf->N2OfluxNITRIF[6]; //%"Nitrification flux of N2O in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 7 (120-150 cm)" %
        output_map[2080] = &nf->N2OfluxNITRIF[7]; //%"Nitrification flux of N2O in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 8 (150-200 cm)" %
        output_map[2081] = &nf->N2OfluxNITRIF[8]; //%"Nitrification flux of N2O in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 9 (200-400 cm)" %
        output_map[2082] = &nf->N2OfluxNITRIF[9]; //%"Nitrification flux of N2O in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O in soil layer 10 (400-1000 cm)" %
        output_map[2083] = &nf->N2OfluxDENITR[0]; //%"Denitrification flux of N2O in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 1 (1-2 cm)" %
        output_map[2084] = &nf->N2OfluxDENITR[1]; //%"Denitrification flux of N2O in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 2 (3-10 cm)" %
        output_map[2085] = &nf->N2OfluxDENITR[2]; //%"Denitrification flux of N2O in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 3 (10-30 cm)" %
        output_map[2086] = &nf->N2OfluxDENITR[3]; //%"Denitrification flux of N2O in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 4 (30-60 cm)" %
        output_map[2087] = &nf->N2OfluxDENITR[4]; //%"Denitrification flux of N2O in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 5 (60-90 cm)" %
        output_map[2088] = &nf->N2OfluxDENITR[5]; //%"Denitrification flux of N2O in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 6 (90-120 cm)" %
        output_map[2089] = &nf->N2OfluxDENITR[6]; //%"Denitrification flux of N2O in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 7 (120-150 cm)" %
        output_map[2090] = &nf->N2OfluxDENITR[7]; //%"Denitrification flux of N2O in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 8 (150-200 cm)" %
        output_map[2091] = &nf->N2OfluxDENITR[8]; //%"Denitrification flux of N2O in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 9 (200-400 cm)" %
        output_map[2092] = &nf->N2OfluxDENITR[9]; //%"Denitrification flux of N2O in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O in soil layer 10 (400-1000 cm)" %
        output_map[2093] = &nf->NO3_to_denitr_total; //%"Denitrification flux of soil mineral NO3" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus a talaj svnyi NO3-bl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of soil mineral NO3" %
        output_map[2094] = &nf->NH4_to_nitrif_total; //%"Nitrification flux of soil mineral NH4" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus a talaj svnyi NH4-bol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of soil mineral NH4" %
        output_map[2095] = &nf->N2fluxDENITR_total; //%"Denitrification flux of N2" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2-bol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2" %
        output_map[2096] = &nf->N2OfluxNITRIF_total; //%"Nitrification flux of N2O" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrifikci fluxus N2O-bl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrification flux of N2O" %
        output_map[2097] = &nf->N2OfluxDENITR_total; //%"Denitrification flux of N2O" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Denitrifikci fluxus N2O-bl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Denitrification flux of N2O" %
        output_map[2098] = &nf->NH4_to_npool[0]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 1 (1-2 cm)" %
        output_map[2099] = &nf->NH4_to_npool[1]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 2 (3-10 cm)" %
        output_map[2100] = &nf->NH4_to_npool[2]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 3 (10-30 cm)" %
        output_map[2101] = &nf->NH4_to_npool[3]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 4 (30-60 cm)" %
        output_map[2102] = &nf->NH4_to_npool[4]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 5 (60-90 cm)" %
        output_map[2103] = &nf->NH4_to_npool[5]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 6 (90-120 cm)" %
        output_map[2104] = &nf->NH4_to_npool[6]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 7 (120-150 cm)" %
        output_map[2105] = &nf->NH4_to_npool[7]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 8 (150-200 cm)" %
        output_map[2106] = &nf->NH4_to_npool[8]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 9 (200-400 cm)" %
        output_map[2107] = &nf->NH4_to_npool[9]; //%"N flux from soil mineral NH4 to temporary plant N pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool in soil layer 10 (400-1000 cm)" %
        output_map[2108] = &nf->NO3_to_npool[0]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 1 (1-2 cm)" %
        output_map[2109] = &nf->NO3_to_npool[1]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 2 (3-10 cm)" %
        output_map[2110] = &nf->NO3_to_npool[2]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 3 (10-30 cm)" %
        output_map[2111] = &nf->NO3_to_npool[3]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 4 (30-60 cm)" %
        output_map[2112] = &nf->NO3_to_npool[4]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 5 (60-90 cm)" %
        output_map[2113] = &nf->NO3_to_npool[5]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 6 (90-120 cm)" %
        output_map[2114] = &nf->NO3_to_npool[6]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 7 (120-150 cm)" %
        output_map[2115] = &nf->NO3_to_npool[7]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 8 (150-200 cm)" %
        output_map[2116] = &nf->NO3_to_npool[8]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 9 (200-400 cm)" %
        output_map[2117] = &nf->NO3_to_npool[9]; //%"N flux from soil mineral NO3 to temporary plant N pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool in soil layer 10 (400-1000 cm)" %
        output_map[2118] = &nf->NH4_to_npool_total; //%"N flux from soil mineral NH4 to temporary plant N pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NH4 to temporary plant N pool" %
        output_map[2119] = &nf->NO3_to_npool_total; //%"N flux from soil mineral NO3 to temporary plant N pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from soil mineral NO3 to temporary plant N pool" %
        output_map[2120] = &nf->sminn_to_npool_total; //%"sminN flux to npool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$  %
        output_map[2121] = &nf->ndep_to_NH4[0]; //%"N-deposition to NH4 pool in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$
        output_map[2122] = &nf->ndep_to_NH4[1]; //%"N-deposition to NH4 pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NH4 pool in soil layer 2 (3-10 cm)" %
        output_map[2123] = &nf->ndep_to_NH4[2]; //%"N-deposition to NH4 pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NH4 pool in soil layer 3 (10-30 cm)" %
        output_map[2124] = &nf->ndep_to_NH4[3]; //%"N-deposition to NH4 pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NH4 pool in soil layer 4 (30-60 cm)" %
        output_map[2125] = &nf->ndep_to_NH4[4]; //%"N-deposition to NH4 pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NH4 pool in soil layer 5 (60-90 cm)" %
        output_map[2126] = &nf->ndep_to_NH4[5]; //%"N-deposition to NH4 pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NH4 pool in soil layer 6 (90-120 cm)" %
        output_map[2127] = &nf->ndep_to_NH4[6]; //%"N-deposition to NH4 pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NH4 pool in soil layer 7 (120-150 cm)" %
        output_map[2128] = &nf->ndep_to_NH4[7]; //%"N-deposition to NH4 pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NH4 pool in soil layer 8 (150-200 cm)" %
        output_map[2129] = &nf->ndep_to_NH4[8]; //%"N-deposition to NH4 pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NH4 pool in soil layer 9 (200-400 cm)" %
        output_map[2130] = &nf->ndep_to_NH4[9]; //%"N-deposition to NH4 pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NH4 pool in soil layer 10 (400-1000 cm)" %
        output_map[2131] = &nf->ndep_to_NO3[0]; //%"N-deposition to NO3 pool in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 1 (1-2 cm)" %
        output_map[2132] = &nf->ndep_to_NO3[1]; //%"N-deposition to NO3 pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 2 (3-10 cm)" %
        output_map[2133] = &nf->ndep_to_NO3[2]; //%"N-deposition to NO3 pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 3 (10-30 cm)" %
        output_map[2134] = &nf->ndep_to_NO3[3]; //%"N-deposition to NO3 pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 4 (30-60 cm)" %
        output_map[2135] = &nf->ndep_to_NO3[4]; //%"N-deposition to NO3 pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 5 (60-90 cm)" %
        output_map[2136] = &nf->ndep_to_NO3[5]; //%"N-deposition to NO3 pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 6 (90-120 cm)" %
        output_map[2137] = &nf->ndep_to_NO3[6]; //%"N-deposition to NO3 pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 7 (120-150 cm)" %
        output_map[2138] = &nf->ndep_to_NO3[7]; //%"N-deposition to NO3 pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 8 (150-200 cm)" %
        output_map[2139] = &nf->ndep_to_NO3[8]; //%"N-deposition to NO3 pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 9 (200-400 cm)" %
        output_map[2140] = &nf->ndep_to_NO3[9]; //%"N-deposition to NO3 pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NO3-bl az tmeneti nvnyi N trozba a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-deposition to NO3 pool in soil layer 10 (400-1000 cm)" %
        output_map[2141] = &nf->nfix_to_NH4[0]; //%"N-fixation to NH4 pool in soil layer 1 (1-2 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$
        output_map[2142] = &nf->nfix_to_NH4[1]; //%"N-fixation to NH4 pool in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-fixation to NH4 pool in soil layer 2 (3-10 cm)" %
        output_map[2143] = &nf->nfix_to_NH4[2]; //%"N-fixation to NH4 pool in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-fixation to NH4 pool in soil layer 3 (10-30 cm)" %
        output_map[2144] = &nf->nfix_to_NH4[3]; //%"N-fixation to NH4 pool in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-fixation to NH4 pool in soil layer 4 (30-60 cm)" %
        output_map[2145] = &nf->nfix_to_NH4[4]; //%"N-fixation to NH4 pool in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-fixation to NH4 pool in soil layer 5 (60-90 cm)" %
        output_map[2146] = &nf->nfix_to_NH4[5]; //%"N-fixation to NH4 pool in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-fixation to NH4 pool in soil layer 6 (90-120 cm)" %
        output_map[2147] = &nf->nfix_to_NH4[6]; //%"N-fixation to NH4 pool in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-fixation to NH4 pool in soil layer 7 (120-150 cm)" %
        output_map[2148] = &nf->nfix_to_NH4[7]; //%"N-fixation to NH4 pool in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-fixation to NH4 pool in soil layer 8 (150-200 cm)" %
        output_map[2149] = &nf->nfix_to_NH4[8]; //%"N-fixation to NH4 pool in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-fixation to NH4 pool in soil layer 9 (200-400 cm)" %
        output_map[2150] = &nf->nfix_to_NH4[9]; //%"N-fixation to NH4 pool in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a talaj svnyi NH4-bol az tmeneti nvnyi N trozba a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "NitrogeN-fixation to NH4 pool in soil layer 10 (400-1000 cm)" %
    
    	output_map[2213] = &nf->grossMINERflux[0]; //%"Gross mineralization flux in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux  in soil layer 1 (0-3 cm)" %
		output_map[2214] = &nf->grossMINERflux[1]; //%"Gross mineralization flux  in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus az 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux   in soil layer 2 (3-10 cm)" %
		output_map[2215] = &nf->grossMINERflux[2]; //%"Gross mineralization in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux  in soil layer 3 (10-360 cm)" %
		output_map[2216] = &nf->grossMINERflux[3]; //%"Gross mineralization in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus az 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux  in soil layer 4 (30-60 cm)" %
		output_map[2217] = &nf->grossMINERflux[4]; //%"Gross mineralization in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux  in soil layer 5 (60-90 cm)" %
		output_map[2218] = &nf->grossMINERflux[5]; //%"Gross mineralization in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus az 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux  in soil layer 6 (90-120 cm)" %
		output_map[2219] = &nf->grossMINERflux[6]; //%"Gross mineralization in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus az 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux  in soil layer 7 (120-150 cm)" %
		output_map[2220] = &nf->grossMINERflux[7]; //%"Gross mineralization in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus az 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux  in soil layer 8 (150-200 cm)" %
		output_map[2221] = &nf->grossMINERflux[8]; //%"Gross mineralization in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus a 9. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux in soil layer 8 (150-200 cm)" %
		output_map[2222] = &nf->grossMINERflux[9]; //%"Gross mineralization in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus a 10. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Gross mineralization flux  in soil layer 8 (150-200 cm)" %
		output_map[2223] = &nf->actIMMOBflux[0]; //%"Actual immobilization flux in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux  in soil layer 1 (0-3 cm)" %
		output_map[2224] = &nf->actIMMOBflux[1]; //%"Actual immobilization flux  in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus az 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux   in soil layer 2 (3-10 cm)" %
		output_map[2225] = &nf->actIMMOBflux[2]; //%"Actual immobilization in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux  in soil layer 3 (10-360 cm)" %
		output_map[2226] = &nf->actIMMOBflux[3]; //%"Actual immobilization in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus az 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux  in soil layer 4 (30-60 cm)" %
		output_map[2227] = &nf->actIMMOBflux[4]; //%"Actual immobilization in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux  in soil layer 5 (60-90 cm)" %
		output_map[2228] = &nf->actIMMOBflux[5]; //%"Actual immobilization in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus az 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux  in soil layer 6 (90-120 cm)" %
		output_map[2229] = &nf->actIMMOBflux[6]; //%"Actual immobilization in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus az 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux  in soil layer 7 (120-150 cm)" %
		output_map[2230] = &nf->actIMMOBflux[7]; //%"Actual immobilization in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus az 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux  in soil layer 8 (150-200 cm)" %
		output_map[2231] = &nf->actIMMOBflux[8]; //%"Actual immobilization in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus a 9. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux in soil layer 8 (150-200 cm)" %
		output_map[2232] = &nf->actIMMOBflux[9]; //%"Actual immobilization in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus a 10. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux  in soil layer 8 (150-200 cm)" %
		output_map[2233] = &nf->actIMMOBflux[0]; //%"Actual immobilization flux in soil layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis immobilizcis fluxus az 1. talajrtegben (0-3 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Actual immobilization flux  in soil layer 1 (0-3 cm)" %
		output_map[2234] = &nf->potIMMOBflux[1]; //%"Potential immobilization flux  in soil layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis immobilizcis fluxus az 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potential immobilization flux   in soil layer 2 (3-10 cm)" %
		output_map[2235] = &nf->potIMMOBflux[2]; //%"Potential immobilization in soil layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis immobilizcis fluxus a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potential immobilization flux  in soil layer 3 (10-360 cm)" %
		output_map[2236] = &nf->potIMMOBflux[3]; //%"Potential immobilization in soil layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis immobilizcis fluxus az 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potential immobilization flux  in soil layer 4 (30-60 cm)" %
		output_map[2237] = &nf->potIMMOBflux[4]; //%"Potential immobilization in soil layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis immobilizcis fluxus az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potential immobilization flux  in soil layer 5 (60-90 cm)" %
		output_map[2238] = &nf->potIMMOBflux[5]; //%"Potential immobilization in soil layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis immobilizcis fluxus az 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potential immobilization flux  in soil layer 6 (90-120 cm)" %
		output_map[2239] = &nf->potIMMOBflux[6]; //%"Potential immobilization in soil layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis immobilizcis fluxus az 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potential immobilization flux  in soil layer 7 (120-150 cm)" %
		output_map[2240] = &nf->potIMMOBflux[7]; //%"Potential immobilization in soil layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis immobilizcis fluxus az 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potential immobilization flux  in soil layer 8 (150-200 cm)" %
		output_map[2241] = &nf->potIMMOBflux[8]; //%"Potential immobilization in soil layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis immobilizcis fluxus a 9. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potential immobilization flux in soil layer 8 (150-200 cm)" %
		output_map[2242] = &nf->potIMMOBflux[9]; //%"Potential immobilization in soil layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis immobilizcis fluxus a 10. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2} \\right]$ "Potential immobilization flux  in soil layer 8 (150-200 cm)" %
		output_map[2243] = &nf->retransn_to_npool_total; //%"Daily allocation N flux from retransclocated N to temporary plant N pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus a retranszloklt N-bol az tmeneti nvnyi trozba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from retransclocated N to temporary plant N pool" %
        output_map[2244] = &nf->npool_to_leafn; //%"Daily allocation N flux from temporary plant N pool to leaf" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a levlbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to leaf" %
        output_map[2245] = &nf->npool_to_leafn_storage; //%"Dail allocation N flux from temporary plant N pool to leaf storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a levl raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Dail allocation N flux from temporary plant N pool to leaf storage pool" %
        output_map[2246] = &nf->npool_to_frootn; //%"Daily allocation N flux from temporary plant N pool to fine root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a hajszlgykrbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to fine root" %
        output_map[2247] = &nf->npool_to_frootn_storage; //%"Daily allocation N flux from temporary plant N pool to fine root storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a hajszlgykr raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to fine root storage pool" %
        output_map[2248] = &nf->npool_to_yieldn; //%"Daily allocation N flux from temporary plant N pool to yield" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a termsbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to yield" %
        output_map[2249] = &nf->npool_to_yieldn_storage; //%"Daily allocation N flux from temporary plant N pool to yield storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a terms raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to yield storage pool" %
        output_map[2250] = &nf->npool_to_softstemn; //%"Daily allocation N flux from temporary plant N pool to softstem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a lgyszrba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to softstem" %
        output_map[2251] = &nf->npool_to_softstemn_storage; //%"Daily allocation N flux from temporary plant N pool to softstem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a lgyszr raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to softstem storage pool" %
        output_map[2252] = &nf->npool_to_livestemn; //%"Daily allocation N flux from temporary plant N pool to live stem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a szjcsba (fatest klso l rsze)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to live stem" %
        output_map[2253] = &nf->npool_to_livestemn_storage; //%"Daily alloaction N flux from temporary plant N pool to live stem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a szjcs raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily alloaction N flux from temporary plant N pool to live stem storage pool" %
        output_map[2254] = &nf->npool_to_deadstemn; //%"Daily allocation N flux from temporary plant N pool to dead stem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a gesztbe (fatest belso lettelen rsze)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to dead stem" %
        output_map[2255] = &nf->npool_to_deadstemn_storage; //%"Daily allocation N flux from temporary plant N pool to dead stem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a geszt raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to dead stem storage pool" %
        output_map[2256] = &nf->npool_to_livecrootn; //%"Daily allocation N flux from temporary plant N pool to live coarse root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a fs gykr klso l rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to live coarse root" %
        output_map[2257] = &nf->npool_to_livecrootn_storage; //%"Daily allocation N flux from temporary plant N pool to live coarse root storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a fs gykr klso l rsznek raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to live coarse root storage pool" %
        output_map[2258] = &nf->npool_to_deadcrootn; //%"Daily allocation N flux from temporary plant N pool to dead coarse root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a fs gykr belso lettelen rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to dead coarse root" %
        output_map[2259] = &nf->npool_to_deadcrootn_storage; //%"Daily allocation N flux from temporary plant N pool to dead coarse root storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi allokcis fluxus az temeneti nvnyi N trozbl a fs gykr belso lettelen rsznek raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily allocation N flux from temporary plant N pool to dead coarse root storage pool" %
        output_map[2260] = &nf->leafn_storage_to_MRdef; //%"Daily maintenance respiration ensuring N flux from leaf storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a levl raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from leaf storage pool" %
        output_map[2261] = &nf->frootn_storage_to_MRdef; //%"Daily maintenance respiration ensuring N flux from fine root storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a hajszlgykr raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from fine root storage pool" %
        output_map[2262] = &nf->yieldn_storage_to_MRdef; //%"Daily maintenance respiration ensuring N flux from yield storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a terms raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from yield storage pool" %
        output_map[2263] = &nf->softstemn_storage_to_MRdef; //%"Daily maintenance respiration ensuring N flux from softstem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a lgyszr raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from softstem storage pool" %
        output_map[2264] = &nf->livestemn_storage_to_MRdef; //%"Daily maintenance respiration ensuring N flux from live stem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a szjcs raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from live stem storage pool" %
        output_map[2265] = &nf->livecrootn_storage_to_MRdef; //%"Daily maintenance respiration ensuring N flux from live coarse root storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a gykr klso l rsznek raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from live coarse root storage pool" %
        output_map[2266] = &nf->deadstemn_storage_to_MRdef; //%"Daily maintenance respiration ensuring N flux from dead stem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a geszt raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from dead stem storage pool" %
        output_map[2267] = &nf->deadcrootn_storage_to_MRdef; //%"Daily maintenance respiration ensuring N flux from dead coarse root storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a gykr belso lettelen rsznek raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from dead coarse root storage pool" %
        output_map[2268] = &nf->leafn_transfer_to_MRdef; //%"Daily maintenance respiration ensuring N flux from leaf transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a levl transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from leaf transfer pool" %
        output_map[2269] = &nf->frootn_transfer_to_MRdef; //%"Daily maintenance respiration ensuring N flux from fine root transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a hajszlgykr transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from fine root transfer pool" %
        output_map[2270] = &nf->yieldn_transfer_to_MRdef; //%"Daily maintenance respiration ensuring N flux from yield transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a terms transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from yield transfer pool" %
        output_map[2271] = &nf->softstemn_transfer_to_MRdef; //%"Daily maintenance respiration ensuring N flux from softstem transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from softstem transfer pool" %
        output_map[2272] = &nf->livestemn_transfer_to_MRdef; //%"Daily maintenance respiration ensuring N flux from live stem transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a szjcs transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from live stem transfer pool" %
        output_map[2273] = &nf->livecrootn_transfer_to_MRdef; //%"Daily maintenance respiration ensuring N flux from live coarse root transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a gykr klso l rsznek transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from live coarse root transfer pool" %
        output_map[2274] = &nf->deadstemn_transfer_to_MRdef; //%"Daily maintenance respiration ensuring N flux from dead stem transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a geszt transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from dead stem transfer pool" %
        output_map[2275] = &nf->deadcrootn_transfer_to_MRdef; //%"Daily maintenance respiration ensuring N flux from dead coarse root transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a gykr belso lettelen rsznek transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from dead coarse root transfer pool" %
        output_map[2276] = &nf->leafn_to_MRdef; //%"Daily maintenance respiration ensuring N flux from leaf" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a levlbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from leaf" %
        output_map[2277] = &nf->frootn_to_MRdef; //%"Daily maintenance respiration ensuring N flux from fine root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a hajszlgykrbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from fine root" %
        output_map[2278] = &nf->yieldn_to_MRdef; //%"Daily maintenance respiration ensuring N flux from yield" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a termsbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from yield" %
        output_map[2279] = &nf->softstemn_to_MRdef; //%"Daily maintenance respiration ensuring N flux from softstem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a lgyszrbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from softstem" %
        output_map[2280] = &nf->livestemn_to_MRdef; //%"Daily maintenance respiration ensuring N flux from live stem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a szjcsbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from live stem" %
        output_map[2281] = &nf->livecrootn_to_MRdef; //%"Daily maintenance respiration ensuring N flux from live coarse root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus a gykr klso l rszbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from live coarse root" %
        output_map[2282] = &nf->NSNnw_to_MRdef; //%"Daily maintenance respiration ensuring N flux from non-structured non-woody N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus nem strukturlt nem fs trmelkbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from non-structured non-woody N" %
        output_map[2283] = &nf->SNnw_to_MRdef; //%"Daily maintenance respiration ensuring N flux from non-woody portion of actual N pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus az aktulis N troz nem fs rszbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from non-woody portion of actual N pool" %
        output_map[2284] = &nf->NSNw_to_MRdef; //%"Daily maintenance respiration ensuring N flux from non-structured woody N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus nem strukturlt fs trmelkbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from non-structured woody N" %
        output_map[2285] = &nf->SNw_to_MRdef; //%"Daily maintenance respiration ensuring N flux from woody portion ofactual N pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi nfenntart respircit biztost N fluxus az aktulis N troz fs rszbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Daily maintenance respiration ensuring N flux from woody portion ofactual N pool" %
        output_map[2286] = &nf->leafn_storage_to_leafn_transfer; //%"Annual N turnover of leaf storage to transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a levl raktr trozjbl a transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of leaf storage to transfer pool" %
        output_map[2287] = &nf->frootn_storage_to_frootn_transfer; //%"Annual N turnover of fine root storage to transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a hajszlgykr raktr trozjbl a transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of fine root storage to transfer pool" %
        output_map[2288] = &nf->livestemn_storage_to_livestemn_transfer; //%"Annual N turnover of live stem storage to transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a szjcs (fatest klso l rsze) raktr trozjbl a transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of live stem storage to transfer pool" %
        output_map[2289] = &nf->deadstemn_storage_to_deadstemn_transfer; //%"Annual N turnover of dead stem storage to transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a geszt (fatest belso lettelen rsze) raktr trozjbl a transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of dead stem storage to transfer pool" %
        output_map[2290] = &nf->livecrootn_storage_to_livecrootn_transfer; //%"Annual N turnover of live coarse root storage to transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a fs gykr klso l rsz raktr trozjbl a transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of live coarse root storage to transfer pool" %
        output_map[2291] = &nf->deadcrootn_storage_to_deadcrootn_transfer; //%"Annual N turnover of dead coarse root storage to transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a fs gykr belso lettelen rsz raktr trozjbl a transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of dead coarse root storage to transfer pool" %
        output_map[2292] = &nf->yieldn_storage_to_yieldn_transfer; //%"Annual N turnover of yield storage to transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a terms raktr trozjbl a transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of yield storage to transfer pool" %
        output_map[2293] = &nf->softstemn_storage_to_softstemn_transfer; //%"Annual N turnover of softstem storage to transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a lgyszr raktr trozjbl a transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of softstem storage to transfer pool" %
        output_map[2294] = &nf->livestemn_to_deadstemn; //%"Annual N turnover of live stem to dead stem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a szr l rszbol az lettelen rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of live stem to dead stem" %
        output_map[2295] = &nf->livestemn_to_retransn; //%"Annual N trunover of live stem to retranslocated N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a szr l rszbol retranszloklt N-n" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N trunover of live stem to retranslocated N" %
        output_map[2296] = &nf->livecrootn_to_deadcrootn; //%"Annual N turnover of live coarse root to dead coarse root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a fs gykr l rszbol az lettelen rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of live coarse root to dead coarse root" %
        output_map[2297] = &nf->livecrootn_to_retransn; //%"Annual N turnover of live coarse root to retranslocated N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "ves nitrognforgalom a fs gykr l rszbol retranszloklt N-n" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Annual N turnover of live coarse root to retranslocated N" %
        output_map[2298] = &nf->leafn_transfer_from_PLT; //%"Leaf transfer pool N flux from planting" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Vetsi nitrognfluxus a levl transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leaf transfer pool N flux from planting" %
        output_map[2299] = &nf->frootn_transfer_from_PLT; //%"Fine root transfer pool N flux from planting" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Vetsi nitrognfluxus a hajszlgykr transzfer trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fine root transfer pool N flux from planting" %
        output_map[2300] = &nf->yieldn_transfer_from_PLT; //%"yield transfer pool N flux from planting" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Vetsi nitrognfluxus a terms raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "yield transfer pool N flux from planting" %
        output_map[2301] = &nf->softstemn_transfer_from_PLT; //%"Softstem transfer pool N flux from planting" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Vetsi nitrognfluxus a lgyszr raktr trozjba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Softstem transfer pool N flux from planting" %
        output_map[2302] = &nf->leafn_to_THN; //%"Thinning N flux from leaf" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a levlbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from leaf" %
        output_map[2303] = &nf->leafn_storage_to_THN; //%"Thinning N flux from leaf storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a levl raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from leaf storage pool" %
        output_map[2304] = &nf->leafn_transfer_to_THN; //%"Thinning N flux from leaf transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a levl transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from leaf transfer pool" %
        output_map[2305] = &nf->yieldn_to_THN; //%"Thinning N flux from yield" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a termsbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from yield" %
        output_map[2306] = &nf->yieldn_storage_to_THN; //%"Thinning N flux from yield storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a terms raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from yield storage pool" %
        output_map[2307] = &nf->yieldn_transfer_to_THN; //%"Thinning N flux from yield transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a terms transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from yield transfer pool" %
        output_map[2308] = &nf->livestemn_to_THN; //%"Thinning N flux from live stem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a szjcsbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from live stem" %
        output_map[2309] = &nf->livestemn_storage_to_THN; //%"Thinning N flux from live stem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a szjcs raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from live stem storage pool" %
        output_map[2310] = &nf->livestemn_transfer_to_THN; //%"Thinning N flux from live stem transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a szjcs transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from live stem transfer pool" %
        output_map[2311] = &nf->deadstemn_to_THN; //%"Thinning N flux from dead stem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a gesztbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from dead stem" %
        output_map[2312] = &nf->deadstemn_storage_to_THN; //%"Thinning N flux from dead stem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a geszt raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from dead stem storage pool" %
        output_map[2313] = &nf->deadstemn_transfer_to_THN; //%"Thinning N flux from dead stem transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a geszt transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from dead stem transfer pool" %
        output_map[2314] = &nf->retransn_to_THN; //%"Thinning N flux from retranslocated N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a retranszloklt N-bol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from retranslocated N" %
        output_map[2315] = &nf->THN_to_CTDBn_leaf; //%"Thinning N flux to cut-down leaf biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a levgott levl biomasszba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux to cut-down leaf biomass" %
        output_map[2316] = &nf->THN_to_CTDBn_yield; //%"Thinning N flux to cut-down yield biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a levgott terms biomasszba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux to cut-down yield biomass" %
        output_map[2318] = &nf->THN_to_CTDBn_cstem; //%"Thinning N flux to cut-down coarse stem biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus a levgott fs szr biomasszba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux to cut-down coarse stem biomass" %
        output_map[2319] = &nf->STDBn_leaf_to_THN; //%"Thinning N flux from wilted leaf biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from wilted leaf biomass" %
        output_map[2320] = &nf->STDBn_yield_to_THN; //%"Thinning N flux from wilted yield biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szlalsi nitrognfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Thinning N flux from wilted yield biomass" %
     	output_map[2321] = &nf->cwdn_to_litrn_total; //%"Total N flux from cwd to soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs nvnyi maradvnybl az elhalt nvnyi trozba jut N-ram" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Total N flux from cwd to soil" %
        output_map[2322] = &nf->leafn_to_MOW; //%"Mowing N flux from leaf" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a levlbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from leaf" %
        output_map[2323] = &nf->leafn_storage_to_MOW; //%"Mowing N flux from leaf storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a levl raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from leaf storage pool" %
        output_map[2324] = &nf->leafn_transfer_to_MOW; //%"Mowing N flux from leaf transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a levl transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from leaf transfer pool" %
        output_map[2325] = &nf->yieldn_to_MOW; //%"Mowing N flux from yield" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a termsbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from yield" %
        output_map[2326] = &nf->yieldn_storage_to_MOW; //%"Mowing N flux from yield storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a terms raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from yield storage pool" %
        output_map[2327] = &nf->yieldn_transfer_to_MOW; //%"Mowing N flux from yield transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a terms transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from yield transfer pool" %
        output_map[2328] = &nf->softstemn_to_MOW; //%"Mowing N flux from softstem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a lgyszrbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from softstem" %
        output_map[2329] = &nf->softstemn_storage_to_MOW; //%"Mowing N flux from softstem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from softstem storage pool" %
        output_map[2330] = &nf->softstemn_transfer_to_MOW; //%"Mowing N flux from softstem transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from softstem transfer pool" %

        output_map[2332] = &nf->MOW_to_CTDBn_leaf; //%"Mowing N flux to cut-down leaf biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a levgott levl biomasszba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux to cut-down leaf biomass" %
        output_map[2333] = &nf->MOW_to_CTDBn_yield; //%"Mowing N flux to cut-down yield biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a levgott terms biomasszba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux to cut-down yield biomass" %
        output_map[2334] = &nf->MOW_to_CTDBn_softstem; //%"Mowing N flux to cut-down softstem biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus a levgott lgyszr biomasszba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux to cut-down softstem biomass" %
        output_map[2336] = &nf->STDBn_leaf_to_MOW; //%"Mowing N flux from wilted leaf biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from wilted leaf biomass" %
        output_map[2337] = &nf->STDBn_yield_to_MOW; //%"Mowing N flux from wilted yield biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from wilted yield biomass" %
        output_map[2338] = &nf->STDBn_softstem_to_MOW; //%"Mowing N flux from wilted softstem biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kaszlsi nitrognfluxus az elhervadt lgyszr biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Mowing N flux from wilted softstem biomass" %
  		output_map[2339] = &nf->actIMMOBflux_total; //%"Total actual N IMMOBfluxilization" $\\left[\\kg_{N}m^{-2} \\right]$ "Aktulis N IMMOBfluxilizci a teljes talajban" $\\left[\\kg_{N}m^{-2} \\right]$ "Total actual N IMMOBfluxilization" %
        output_map[2340] = &nf->leafn_to_HRV; //%"Harvesting N flux from leaf" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a levlbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from leaf" %
        output_map[2341] = &nf->leafn_storage_to_HRV; //%"Harvesting N flux from leaf storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a levl raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from leaf storage pool" %
        output_map[2342] = &nf->leafn_transfer_to_HRV; //%"Harvesting N flux from leaf transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a levl transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from leaf transfer pool" %
        output_map[2343] = &nf->yieldn_to_HRV; //%"Harvesting N flux from yield" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a termsbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from yield" %
        output_map[2344] = &nf->yieldn_storage_to_HRV; //%"Harvesting N flux from yield storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a terms raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from yield storage pool" %
        output_map[2345] = &nf->yieldn_transfer_to_HRV; //%"Harvesting N flux from yield transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a terms transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from yield transfer pool" %
        output_map[2346] = &nf->softstemn_to_HRV; //%"Harvesting N flux from softstem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a lgyszrbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from softstem" %
        output_map[2347] = &nf->softstemn_storage_to_HRV; //%"Harvesting N flux from softstem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from softstem storage pool" %
        output_map[2348] = &nf->softstemn_transfer_to_HRV; //%"Harvesting N flux from softstem transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from softstem transfer pool" %
        output_map[2349] = &nf->frootn_to_HRV; //%"Harvesting N flux from fine root pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a gykrzetbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from fine root N" %
        output_map[2350] = &nf->frootn_storage_to_HRV; //%"Harvesting N flux from froot storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from froot storage pool" %
        output_map[2351] = &nf->frootn_transfer_to_HRV; //%"Harvesting N flux from froot transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from froot transfer pool" %
        output_map[2352] = &nf->HRV_to_CTDBn_leaf; //%"Harvesting N flux to cut-down leaf biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a levgott levl biomasszba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux to cut-down leaf biomass" %
        output_map[2353] = &nf->HRV_to_CTDBn_softstem; //%"Harvesting N flux to cut-down softstem biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus a levgott lgyszr biomasszba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux to cut-down softstem biomass" %
        output_map[2354] = &nf->STDBn_leaf_to_HRV; //%"Harvesting N flux from wilted leaf biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from wilted leaf biomass" %
        output_map[2355] = &nf->STDBn_softstem_to_HRV; //%"Harvesting N flux from wilted softstem biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus az elhervadt lgyszr biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from wilted softstem biomass" %
        output_map[2355] = &nf->STDBn_yield_to_HRV; //%"Harvesting N flux from wilted yield biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Betakartsi nitrognfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Harvesting N flux from wilted yield biomass" %
        output_map[2357] = &nf->netMINERflux_total; //%"Total Net mineralization flux " $\\left[\\kg_{N}m^{-2} \\right]$ "Nett N MINERfluxalizcia teljes talajban" $\\left[\\kg_{N}m^{-2} \\right]$ "Total Net mineralization flux " %
        output_map[2358] = &nf->leafn_to_PLG; //%"Ploughing N flux from leaf" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a levlbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from leaf" %
        output_map[2359] = &nf->leafn_storage_to_PLG; //%"Ploughing N flux from leaf storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a levl raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from leaf storage pool" %
        output_map[2360] = &nf->leafn_transfer_to_PLG; //%"Ploughing N flux from leaf transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a levl transzfer trozjban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from leaf transfer pool" %
        output_map[2361] = &nf->frootn_to_PLG; //%"Ploughing N flux from fine root" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a hajszlgykrzetbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from fine root" %
        output_map[2362] = &nf->frootn_storage_to_PLG; //%"Ploughing N flux from fine root storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a hajszlgykrzet raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from fine root storage pool" %
        output_map[2363] = &nf->frootn_transfer_to_PLG; //%"Ploughing N flux from fine root transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a hajszlgykr transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from fine root transfer pool" %
        output_map[2364] = &nf->yieldn_to_PLG; //%"Ploughing N flux from yield" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a termsbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from yield" %
        output_map[2365] = &nf->yieldn_storage_to_PLG; //%"Ploughing N flux from yield storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a terms raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from yield storage pool" %
        output_map[2366] = &nf->yieldn_transfer_to_PLG; //%"Ploughing N flux from yield transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a terms transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from yield transfer pool" %
        output_map[2367] = &nf->softstemn_to_PLG; //%"Ploughing N flux from softstem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a lgyszrbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from softstem" %
        output_map[2368] = &nf->softstemn_storage_to_PLG; //%"Ploughing N flux from softstem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from softstem storage pool" %
        output_map[2369] = &nf->softstemn_transfer_to_PLG; //%"Ploughing N flux from softstem transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from softstem transfer pool" %
        output_map[2370] = &nf->retransn_to_PLG; //%"Ploughing N flux from retranslocated N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a retranszloklt N-bol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from retranslocated N" %
        output_map[2371] = &nf->STDBn_leaf_to_PLG; //%"Ploughing N flux from wilted leaf biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from wilted leaf biomass" %
        output_map[2372] = &nf->STDBn_froot_to_PLG; //%"Ploughing N flux from wilted fine root biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus az elhervadt hajszlgykr biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from wilted fine root biomass" %
        output_map[2373] = &nf->STDBn_yield_to_PLG; //%"Ploughing N flux from wilted yield biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from wilted yield biomass" %
        output_map[2374] = &nf->STDBn_softstem_to_PLG; //%"Ploughing N flux from wilted softstem biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus az elhervadt lgyszr biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from wilted softstem biomass" %
  		output_map[2375] = &nf->potIMMOBflux_total; //%"Total potential N IMMOBfluxilization" $\\left[\\kg_{N}m^{-2} \\right]$ "Potencilis N IMMOBfluxilizci a teljes talajban" $\\left[\\kg_{N}m^{-2} \\right]$ "Total gross N IMMOBfluxilization" %
        output_map[2376] = &nf->CTDBn_leaf_to_PLG; //%"Ploughing N flux from cut-down leaf biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a levgott levl biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from cut-down leaf biomass" %
        output_map[2377] = &nf->CTDBn_yield_to_PLG; //%"Ploughing N flux from cut-down yield biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a levgott terms biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from cut-down yield biomass" %
        output_map[2378] = &nf->CTDBn_softstem_to_PLG; //%"Ploughing N flux from cut-down softstem biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Szntsi nitrognfluxus a levgott lgyszr biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Ploughing N flux from cut-down softstem biomass" %
        output_map[2379] = &nf->leafn_to_GRZ; //%"grazing N flux from leaf" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a levlbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux from leaf" %
        output_map[2380] = &nf->leafn_storage_to_GRZ; //%"grazig N flux from leaf storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a levl raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazig N flux from leaf storage pool" %
        output_map[2381] = &nf->leafn_transfer_to_GRZ; //%"grazing N flux fromleaf transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a levl transzfer trozjban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux fromleaf transfer pool" %
        output_map[2382] = &nf->yieldn_to_GRZ; //%"grazing N flux from yield" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a termsbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux from yield" %
        output_map[2383] = &nf->yieldn_storage_to_GRZ; //%"grazing N flux from yield storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a terms raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux from yield storage pool" %
        output_map[2384] = &nf->yieldn_transfer_to_GRZ; //%"grazing N flux from yield transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a terms transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux from yield transfer pool" %
        output_map[2385] = &nf->softstemn_to_GRZ; //%"grazing N flux from softstem" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a lgyszrbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux from softstem" %
        output_map[2386] = &nf->softstemn_storage_to_GRZ; //%"grazing N flux from softstem storage pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a lgyszr raktr trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux from softstem storage pool" %
        output_map[2387] = &nf->softstemn_transfer_to_GRZ; //%"grazing N flux from softstem transfer pool" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a lgyszr transzfer trozjbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux from softstem transfer pool" %
        output_map[2388] = &nf->STDBn_leaf_to_GRZ; //%"grazing N flux from wilted leaf biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux from wilted leaf biomass" %
        output_map[2389] = &nf->STDBn_yield_to_GRZ; //%"grazing N flux from wilted yield biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus az elhervadt terms biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux from wilted yield biomass" %
        output_map[2390] = &nf->STDBn_softstem_to_GRZ; //%"grazing flux from wilted softstem biomass" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus az elhervadt lgyszr biomasszbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing flux from wilted softstem biomass" %
	    output_map[2391] = &nf->grossMINERflux_total; //%"Total gross N MINERfluxalization" $\\left[\\kg_{N}m^{-2} \\right]$ "Brutt mineralizcis fluxus a teljes talajban" $\\left[\\kg_{N}m^{-2} \\right]$ "Total gross N MINERfluxalization" %
		output_map[2392] = &nf->retransn_to_GRZ; //%"grazing flux from retranslocated N" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus a retranszloklt N-bol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing flux from retranslocated N" %
        output_map[2393] = &nf->GRZ_to_litr1n; //%"grazing N flux to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus az elhalt nvnyi anyag knnyen boml rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux to labile N portion of litter" %
        output_map[2394] = &nf->GRZ_to_litr2n; //%"grazing N flux to unshielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus az elhalt nvnyi anyag hozzfrhet cellulz rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux to unshielded cellulose N portion of litter" %
        output_map[2395] = &nf->GRZ_to_litr3n; //%"grazing N flux to shielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus az elhalt nvnyi anyag nem hozzfrhet cellulz rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux to shielded cellulose N portion of litter" %
        output_map[2396] = &nf->GRZ_to_litr4n; //%"grazing N flux to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Legeltetsi nitrognfluxus az elhalt nvnyi anyag lignin rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "grazing N flux to lignin N portion of litter" %
        output_map[2397] = &nf->FRZ_to_NH4; //%"Fertilizing N flux to soil mineral NH4" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Trgyzsi nitrognfluxus a talaj svnyi NH4-be" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fertilizing N flux to soil mineral NH4" %
        output_map[2398] = &nf->FRZ_to_NO3; //%"Fertilizing N flux to soil mineral NO3" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Trgyzsi nitrognfluxus a talaj svnyi NO3-ba" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fertilizing N flux to soil mineral NO3" %
        output_map[2399] = &nf->FRZ_to_litr1n; //%"Fertilizing N flux to labile N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Trgyzsi nitrognfluxus az elhalt nvnyi anyag knnyen boml rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fertilizing N flux to labile N portion of litter" %
        output_map[2400] = &nf->FRZ_to_litr2n; //%"Fertilizing N flux to unshielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Trgyzsi nitrognfluxus az elhalt nvnyi anyag hozzfrhet cellulz rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fertilizing N flux to unshielded cellulose N portion of litter" %
        output_map[2401] = &nf->FRZ_to_litr3n; //%"Fertilizing N flux to shielded cellulose N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Trgyzsi nitrognfluxus az elhalt nvnyi anyag nem hozzfrhet cellulz rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fertilizing N flux to shielded cellulose N portion of litter" %
        output_map[2402] = &nf->FRZ_to_litr4n; //%"Fertilizing N flux to lignin N portion of litter" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Trgyzsi nitrognfluxus az elhalt nvnyi anyag lignin rszbe" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Fertilizing N flux to lignin N portion of litter" %
        output_map[2403] = &nf->N2OfluxGRZ; //%"Estimated N2O flux from grazing" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Becslt N2O fluxus a legeltetsbol" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Estimated N2O flux from grazing" %
        output_map[2404] = &nf->N2OfluxFRZ; //%"Estimated N2O flux from fertilizing" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Becslt N2O fluxus a trgyzsbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Estimated N2O flux from fertilizing" %
        output_map[2405] = &nf->sminN_fromFL; //%"Mineralized N flux from flooding" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$%
        output_map[2406] = &nf->orgN_fromFL; //%"Organic N flux from flooding" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$%
        output_map[2407] = &cf->orgC_fromFL; //%"Organic C flux from flooding" $\\leNPPft[\\kg_{C}m^{-2 }day^{-1} \\right]$%
        output_map[2408] = &nf->litr1n_to_soil1n_total; //%"N flux from labile N portion of litter to SOM pool (labile) in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus knnyen boml elhalt nvnyi anyagbl szervesanyag szntartalmnak ba (labilis) a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile N portion of litter to SOM pool (labile) in total soil" %
        output_map[2409] = &nf->litr2n_to_soil2n_total; //%"N flux from unshielded cellulose N portion of litter to SOM pool (fast) in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus hozzfrheto cellulzbl szervesanyag szntartalmnak ba (gyors) a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from unshielded cellulose N portion of litter to SOM pool (fast) in total soil" %
        output_map[2410] = &nf->litr3n_to_litr2n_total; //%"N flux from shielded cellulose portion of litter to unshielded cellulose pool in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus nem hozzfrheto cellulzbl hozzfrheto cellulzz a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from shielded cellulose portion of litter to unshielded cellulose pool in total soil" %
        output_map[2411] = &nf->litr4n_to_soil3n_total; //%"N flux from lignin portion of litter to shielded cellulose pool in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus ligninbol nem hozzfrheto cellulzz a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from lignin portion of litter to shielded cellulose pool in total soil" %
        output_map[2412] = &nf->soil1n_to_soil2n_total; //%"N flux from labile to fast decomposing SOM pool in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a labilisbl a gyors szervesanyag szntartalmnak ban a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from labile to fast decomposing SOM pool in total soil" %
        output_map[2413] = &nf->soil2n_to_soil3n_total; //%"N flux from fast to slow decomposing SOM pool in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a gyorsbl a lass szervesanyag szntartalmnak ban a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from fast to slow decomposing SOM pool in total soil" %
        output_map[2414] = &nf->soil3n_to_soil4n_total; //%"N flux from slow to stable SOM C content of SOM pool in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Nitrognfluxus a lass szervesanyag szntartalmnak bl ellenll talaj szervesanyag tartalomm (leglassabb) a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Nitrogen flux from slow to stable SOM C content of SOM pool in total soil" %
        output_map[2415] = &nf->sminn_to_soil1n_l1_total; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in total soil column" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in total soil column" %
        output_map[2416] = &nf->sminn_to_soil2n_l2_total; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in total soil column" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in total soil column" %
        output_map[2417] = &nf->sminn_to_soil3n_l4_total; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in total soil column" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in total soil column" %
        output_map[2418] = &nf->sminn_to_soil2n_s1_total; //%"Immobilization N flux from soil mineral N to SOM pool (labile) in total soil column" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (labilis) a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (labile) in total soil column" %
        output_map[2419] = &nf->sminn_to_soil3n_s2_total; //%"Immobilization N flux from soil mineral N to SOM pool (fast) in total soil column" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (gyors) a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (fast) in total soil column" %
        output_map[2420] = &nf->sminn_to_soil4n_s3_total; //%"Immobilization N flux from soil mineral N to SOM pool (slow) in total soil column" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "N immobilizci fluxus a talaj svnyi N-bol a szervesanyag szntartalmnak ba (lass) a teljes talajoszlopban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Immobilization N flux from soil mineral N to SOM pool (slow) in total soil column" %
		output_map[2421] = &nf->frootn_to_THN; //%"Thinning N flux from fine root" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykrbol" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from froot" %
        output_map[2422] = &nf->frootn_storage_to_THN; //%"Thinning N flux from fine root storage pool" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr raktr trozjbl" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from froot storage pool" %
        output_map[2423] = &nf->frootn_transfer_to_THN; //%"Thinning N flux from fine root transfer pool" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr transzfer trozjbl" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from froot transfer pool" %
        output_map[2424] = &nf->livecrootn_to_THN; //%"Thinning N flux from live coarse root" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykrbol" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from livecroot" %
        output_map[2425] = &nf->livecrootn_storage_to_THN; //%"Thinning N flux live from coarse root storage pool" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr raktr trozjbl" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from livecroot storage pool" %
        output_map[2426] = &nf->livecrootn_transfer_to_THN; //%"Thinning N flux live from coarse root transfer pool" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr transzfer trozjbl" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from livecroot transfer pool" %
		output_map[2427] = &nf->deadcrootn_to_THN; //%"Thinning N flux from dead coarse root" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykrbol" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from deadcroot" %
        output_map[2428] = &nf->deadcrootn_storage_to_THN; //%"Thinning N flux dead from coarse root storage pool" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr raktr trozjbl" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from deadcroot storage pool" %
        output_map[2429] = &nf->deadcrootn_transfer_to_THN; //%"Thinning N flux dead from coarse root transfer pool" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a gykr transzfer trozjbl" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from deadcroot transfer pool" %
        output_map[2430] = &nf->THN_to_CTDBn_froot; //%"Thinning N flux to nut-down fine root biomass" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levgott gykr biomasszba" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux to nut-down fine root biomass" %
        output_map[2431] = &nf->THN_to_CTDBn_croot; //%"Thinning N flux to nut-down coarse root biomass" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus a levgott gykr biomasszba" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux to nut-down coarse root biomass" %
        output_map[2432] = &nf->STDBn_froot_to_THN; //%"Thinning N flux from wilted fine root biomass" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Szlalsi sznfluxus az elhervadt levl biomasszbl" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "Thinning C flux from wilted froot biomass" %
        output_map[2433] = &nf->SNSC_to_retrans; //%"N flux to retranslocation pool during senescence" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Az elszrads sorn a retranszloklt N-be jut N fluxusa" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "N flux to retranslocation pool during senescence" %
        output_map[2434] = &nf->leafSNSCgenprog_to_retrans; //%"N flux to retranslocation pool during senescence" $\\left[\\kg_{n}m^{-2 }day^{-1} \\right]$ "Az elszrads sorn a retranszloklt N-be jut N fluxusa" $\\left[\\kg_{n}m^{-2 }nap{^-1} \\right]$ "N flux to retranslocation pool during senescence" %
		output_map[2435] = &nf->minerFlux_LtoS[0]; //%"Summarized mineralization N flux from litter decomposition in layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cumulated leached N flux from DON of total SOM pool in litter layer 2 (3-10 cm)" %
		output_map[2436] = &nf->minerFlux_LtoS[1]; //%"Summarized mineralization N flux from litter decomposition in layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition in layer 2 (3-10 cm)" %
        output_map[2437] = &nf->minerFlux_LtoS[2]; //%"Summarized mineralization N flux from litter decomposition in layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition in layer 3 (10-30 cm)" %
        output_map[2438] = &nf->minerFlux_LtoS[3]; //%"Summarized mineralization N flux from litter decomposition in layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) az 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition in layer 4 (30-60 cm)" %
        output_map[2439] = &nf->minerFlux_LtoS[4]; //%"Summarized mineralization N flux from litter decomposition in layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition in layer 5 (60-90 cm)" %
        output_map[2440] = &nf->minerFlux_LtoS[5]; //%"Summarized mineralization N flux from litter decomposition in layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition in layer 6 (90-120 cm)" %
        output_map[2441] = &nf->minerFlux_LtoS[6]; //%"Summarized mineralization N flux from litter decomposition in layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition in layer 7 (120-150 cm)" %
        output_map[2442] = &nf->minerFlux_LtoS[7]; //%"Summarized mineralization N flux from litter decomposition in layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition in layer 8 (150-200 cm)" %
        output_map[2443] = &nf->minerFlux_LtoS[8]; //%"Summarized mineralization N flux from litter decomposition in layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition in layer 9 (200-400 cm)" %
        output_map[2444] = &nf->minerFlux_LtoS[9]; //%"Summarized mineralization N flux from litter decomposition in layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition in layer 10 (400-1000 cm)" %
		output_map[2445] = &nf->minerFlux_StoS[0]; //%"Summarized mineralization N flux from soil decomposition in layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 1 (0-3 cm)" %
		output_map[2446] = &nf->minerFlux_StoS[1]; //%"Summarized mineralization N flux from soil decomposition in layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 2 (3-10 cm)" %
        output_map[2447] = &nf->minerFlux_StoS[2]; //%"Summarized mineralization N flux from soil decomposition in layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 3 (10-30 cm)" %
        output_map[2448] = &nf->minerFlux_StoS[3]; //%"Summarized mineralization N flux from soil decomposition in layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) az 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 4 (30-60 cm)" %
        output_map[2449] = &nf->minerFlux_StoS[4]; //%"Summarized mineralization N flux from soil decomposition in layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 5 (60-90 cm)" %
        output_map[2450] = &nf->minerFlux_StoS[5]; //%"Summarized mineralization N flux from soil decomposition in layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 6 (90-120 cm)" %
        output_map[2451] = &nf->minerFlux_StoS[6]; //%"Summarized mineralization N flux from soil decomposition in layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 7 (120-150 cm)" %
        output_map[2452] = &nf->minerFlux_StoS[7]; //%"Summarized mineralization N flux from soil decomposition in layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 8 (150-200 cm)" %
        output_map[2453] = &nf->minerFlux_StoS[8]; //%"Summarized mineralization N flux from soil decomposition in layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 9 (200-400 cm)" %
        output_map[2454] = &nf->minerFlux_StoS[9]; //%"Summarized mineralization N flux from soil decomposition in layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition in layer 10 (400-1000 cm)" %
		output_map[2455] = &nf->immobFlux_LtoS[0]; //%"Summarized immobilization N flux from litter decomposition in layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition" %
		output_map[2456] = &nf->immobFlux_LtoS[1]; //%"Summarized immobilization N flux from litter decomposition in layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition in layer 2 (3-10 cm)" %
        output_map[2457] = &nf->immobFlux_LtoS[2]; //%"Summarized immobilization N flux from litter decomposition in layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition in layer 3 (10-30 cm)" %
        output_map[2458] = &nf->immobFlux_LtoS[3]; //%"Summarized immobilization N flux from litter decomposition in layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) az 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition in layer 4 (30-60 cm)" %
        output_map[2459] = &nf->immobFlux_LtoS[4]; //%"Summarized immobilization N flux from litter decomposition in layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition in layer 5 (60-90 cm)" %
        output_map[2460] = &nf->immobFlux_LtoS[5]; //%"Summarized immobilization N flux from litter decomposition in layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition in layer 6 (90-120 cm)" %
        output_map[2461] = &nf->immobFlux_LtoS[6]; //%"Summarized immobilization N flux from litter decomposition in layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition in layer 7 (120-150 cm)" %
        output_map[2462] = &nf->immobFlux_LtoS[7]; //%"Summarized immobilization N flux from litter decomposition in layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition in layer 8 (150-200 cm)" %
        output_map[2463] = &nf->immobFlux_LtoS[8]; //%"Summarized immobilization N flux from litter decomposition in layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition in layer 9 (200-400 cm)" %
        output_map[2464] = &nf->immobFlux_LtoS[9]; //%"Summarized immobilization N flux from litter decomposition in layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from litter decomposition in layer 10 (400-1000 cm)" %
		output_map[2465] = &nf->immobFlux_StoS[0]; //%"Summarized immobilization N flux from soil decomposition in layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cumulated leached N flux from DON of total SOM pool in soil layer 2 (3-10 cm)" %
		output_map[2466] = &nf->immobFlux_StoS[1]; //%"Summarized immobilization N flux from soil decomposition in layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition in layer 2 (3-10 cm)" %
        output_map[2467] = &nf->immobFlux_StoS[2]; //%"Summarized immobilization N flux from soil decomposition in layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition in layer 3 (10-30 cm)" %
        output_map[2468] = &nf->immobFlux_StoS[3]; //%"Summarized immobilization N flux from soil decomposition in layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) az 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition in layer 4 (30-60 cm)" %
        output_map[2469] = &nf->immobFlux_StoS[4]; //%"Summarized immobilization N flux from soil decomposition in layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition in layer 5 (60-90 cm)" %
        output_map[2470] = &nf->immobFlux_StoS[5]; //%"Summarized immobilization N flux from soil decomposition in layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition in layer 6 (90-120 cm)" %
        output_map[2471] = &nf->immobFlux_StoS[6]; //%"Summarized immobilization N flux from soil decomposition in layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition in layer 7 (120-150 cm)" %
        output_map[2472] = &nf->immobFlux_StoS[7]; //%"Summarized immobilization N flux from soil decomposition in layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition in layer 8 (150-200 cm)" %
        output_map[2473] = &nf->immobFlux_StoS[8]; //%"Summarized immobilization N flux from soil decomposition in layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition in layer 9 (200-400 cm)" %
        output_map[2474] = &nf->immobFlux_StoS[9]; //%"Summarized immobilization N flux from soil decomposition in layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett immobilizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition in layer 10 (400-1000 cm)" %		
		output_map[2475] = &nf->environment_to_sminn[0]; //%"Summarized N input from environment in layer 1 (0-3 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett krnyezetbl szrmaz N-input 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Cumulated leached N flux from DON of total SOM pool in litter layer 2 (3-10 cm)" %
		output_map[2476] = &nf->environment_to_sminn[1]; //%"Summarized N input from environment in layer 2 (3-10 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett krnyezetbl szrmaz N-input 2. talajrtegben (3-10 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized N input from environment in layer 2 (3-10 cm)" %
        output_map[2477] = &nf->environment_to_sminn[2]; //%"Summarized N input from environment in layer 3 (10-30 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett krnyezetbl szrmaz N-input 3. talajrtegben (10-30 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized N input from environment in layer 3 (10-30 cm)" %
        output_map[2478] = &nf->environment_to_sminn[3]; //%"Summarized N input from environment in layer 4 (30-60 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) az 4. talajrtegben (30-60 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized N input from environment in layer 4 (30-60 cm)" %
        output_map[2479] = &nf->environment_to_sminn[4]; //%"Summarized N input from environment in layer 5 (60-90 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) az 5. talajrtegben (60-90 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized N input from environment in layer 5 (60-90 cm)" %
        output_map[2480] = &nf->environment_to_sminn[5]; //%"Summarized N input from environment in layer 6 (90-120 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett krnyezetbl szrmaz N-input 6. talajrtegben (90-120 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized N input from environment in layer 6 (90-120 cm)" %
        output_map[2481] = &nf->environment_to_sminn[6]; //%"Summarized N input from environment in layer 7 (120-150 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett krnyezetbl szrmaz N-input 7. talajrtegben (120-150 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized N input from environment in layer 7 (120-150 cm)" %
        output_map[2482] = &nf->environment_to_sminn[7]; //%"Summarized N input from environment in layer 8 (150-200 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett krnyezetbl szrmaz N-input 8. talajrtegben (150-200 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized N input from environment in layer 8 (150-200 cm)" %
        output_map[2483] = &nf->environment_to_sminn[8]; //%"Summarized N input from environment in layer 9 (200-400 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett krnyezetbl szrmaz N-input 9. talajrtegben (200-400 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized N input from environment in layer 9 (200-400 cm)" %
        output_map[2484] = &nf->environment_to_sminn[9]; //%"Summarized N input from environment in layer 10 (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett krnyezetbl szrmaz N-input 10. talajrtegben (400-1000 cm)" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized N input from environment in layer 10 (400-1000 cm)" %
        output_map[2485] = &nf->minerFlux_LtoS_total; //%"Summarized mineralization N flux from litter decomposition in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a teljes talajban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition" %
		output_map[2486] = &nf->minerFlux_StoS_total; //%"Summarized mineralization N flux from soil decomposition in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a teljes talajban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from soil decomposition" %
		output_map[2487] = &nf->immobFlux_LtoS_total; //%"Summarized mineralization N flux from litter decomposition in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (az elhalt nvnyi anyagtrozk bomlsa sorn felszabadul N) a teljes talajban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized mineralization N flux from litter decomposition" %
		output_map[2488] = &nf->immobFlux_StoS_total; //%"Summarized mineralization N flux from soil decomposition in total soil" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "sszestett mineralizcis fluxus (a talajtrozk bomlsa sorn felszabadul N) a teljes talajban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Summarized immobilization N flux from soil decomposition" %
     
		output_map[2499] = &epv->winterEnd_date; //%"Date of end of wintering" $\\left[day of year\\right]$ "A telels vgnek napja" $\\left[v napja\\right]$ "Date of end of wintering" %
		output_map[2500] = &epv->thermal_time; //%"Difference between avg. temp. and base temperature" $\\left[Celsius\\right]$ "Az tlaghomrsklet s bzishomrsklet klnbsge" $\\left[Celsius\\right]$ "Difference between avg. temp. and base temperature" %
        output_map[2501] = &epv->leafday; //%"Counter for days when leaves are on" $\\left[n\\right]$ "Szmll a levlnvekedsi napokhoz" $\\left[db\\right]$ "Counter for days  when leaves are on" %
        output_map[2502] = &epv->n_actphen; //%"Number of the actual phenophase" $\\left[n\\right]$ "Az aktulis fenofzis szma" $\\left[db\\right]$ "Number of the actual phenophase" %
		output_map[2503] = &epv->leafday_lastmort; //%"Last day of genetical mortality" $\\left[n\\right]$ "A genetikai elhals utols napja"$\\left[n\\right]$ "Last day of genetical mortality" %
        output_map[2504] = &epv->flowHS_mort; //%"Mortality coefficient of flowering heat stress" $\\left[prop\\right]$ "A virgzsi hostressz mortalitsi egytthatja" $\\left[rszarny\\right]$ "Mortality coefficient of flowering heat stress" %
        output_map[2505] = &epv->transfer_ratio; //%"Transfer proportion on actual day" $\\left[prop\\right]$ "Transzfer rszarnya az aktulis napon" $\\left[rszarny\\right]$ "Transfer proportion on actual day" %
        output_map[2506] = &epv->day_leafc_litfall_increment; //%"Daily rate of leaf litterfall" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lombhulls napi rtja" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily rate of leaf litterfall" %
        output_map[2507] = &epv->day_yield_litfall_increment; //%"Daily rate of yield litterfall" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A terms elhulls napi rtja" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily rate of yield litterfall" %
        output_map[2508] = &epv->day_softstemc_litfall_increment; //%"Daily rate of softstem litterfall" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lgyszr elhulls napi rtja" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily rate of softstem litterfall" %
        output_map[2509] = &epv->day_frootc_litfall_increment; //%"Daily rate of fineroot litterfall" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A hajszlgykr elhulls napi rtja" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily rate of fineroot litterfall" %
        output_map[2510] = &epv->day_livestemc_turnover_increment; //%"Daily rate of livestem turnover" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az fs szr l rsznek napi talakulsi rtja" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily rate of livestem turnover" %
        output_map[2511] = &epv->day_livecrootc_turnover_increment; //%"Daily rate of live coarse root turnover" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A fs gykr l rsznek talakulsi rtja" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily rate of live coarse root turnover" %
        output_map[2512] = &epv->annmax_leafc; //%"Annual maximum daily leaf C content" $\\left[\\kg_{C}m^{-2} \\right]$ "A levl napi szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2} \\right]$ "Annual maximum daily leaf C content" %
        output_map[2513] = &epv->annmax_yieldc; //%"Annual maximum daily yield C content" $\\left[\\kg_{C}m^{-2} \\right]$ "A terms napi szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2} \\right]$ "Annual maximum daily yield C content" %
        output_map[2514] = &epv->annmax_softstemc; //%"Annual maximum daily softstem C content" $\\left[\\kg_{C}m^{-2} \\right]$ "A lgyszr napi szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2} \\right]$ "Annual maximum daily softstem C content" %
        output_map[2515] = &epv->annmax_frootc; //%"Annual maximum daily fine root C content" $\\left[\\kg_{C}m^{-2} \\right]$ "A hajszlgykr napi szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2} \\right]$ "Annual maximum daily fine root C content" %
        output_map[2516] = &epv->annmax_livestemc; //%"Annual maximum daily livestem C content" $\\left[\\kg_{C}m^{-2} \\right]$ "A szjcs napi szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2} \\right]$ "Annual maximum daily livestem C content" %
        output_map[2517] = &epv->annmax_livecrootc; //%"Annual maximum daily live coarse root C content" $\\left[\\kg_{C}m^{-2} \\right]$ "A fs gykr klso l rsz napi szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2} \\right]$ "Annual maximum daily live coarse root C content" %
        output_map[2518] = &epv->DSR; //%"Number of days since rain" $\\left[n\\right]$ "Csapadkos nap ta eltelt napok szma" $\\left[db\\right]$ "Number of days since rain" %
        output_map[2519] = &epv->cumWS; //%"Cumulative soil water stress" $\\left[dimless\\right]$ "Kumulatv talajnedvessg-stressz" $\\left[dimless\\right]$ "Cumulative soil water stress" %
        output_map[2520] = &epv->projLAI; //%"Live projected leaf area index" $\\left[\\m^2m^{-2} \\right]$ "Levlfelleti index" $\\left[\\m^2m^{-2} \\right]$ "Live projected leaf area index" %
        output_map[2521] = &epv->allLAI; //%"Live all-sided leaf area index" $\\left[\\m^2m^{-2} \\right]$ "Ktoldali levlfelleti index" $\\left[\\m^2m^{-2} \\right]$ "Live all-sided leaf area index" %
        output_map[2522] = &epv->SLA_avg; //%"Canopy average proj. SLA" $\\left[\\m^2m^{-2} \\right]$ "A lomkorona tlagos specifikus levlfelleti indexe" $\\left[\\m^2m^{-2} \\right]$ "Canopy average proj. specific leaf area" %
        output_map[2523] = &epv->plaisun; //%"Sunlit projected leaf area index" $\\left[\\m^2m^{-2} \\right]$ "Napos oldal levlfelleti indexe" $\\left[\\m^2m^{-2} \\right]$ "Sunlit projected leaf area index" %
        output_map[2524] = &epv->plaishade; //%"Shaded projected leaf area index" $\\left[\\m^2m^{-2} \\right]$ "rnykos oldal levlfelleti indexe" $\\left[\\m^2m^{-2} \\right]$ "Shaded projected leaf area index" %
        output_map[2525] = &epv->projSLA_sun; //%"Sunlit projected SLA" $\\left[\\m^2{kg_{C}}^{-1} \\right]$ "Napos oldal specifikus levlfelleti indexe" $\\left[\\m^2{kg_{C}}^{-1} \\right]$ "Sunlit projected specific leaf area" %
        output_map[2526] = &epv->projSLA_shade; //%"Shaded projected SLA" $\\left[\\m^2{kg_{C}}^{-1} \\right]$ "rnykos oldal specifikus levlfelleti indexe" $\\left[\\m^2{kg_{C}}^{-1} \\right]$ "Shaded projected specific leaf area" %
        output_map[2527] = &epv->plantHeight; //%"Height of plant (based on stemw and" $\\left[m\\right]$ "Nvny magassg" $\\left[m\\right]$ "Height of plant (based on stemw and" %
        output_map[2528] = &epv->NDVI; //%"Normalized difference vegetation index" $\\left[ratio\\right]$ "NDVI" $\\left[ratio\\right]$ "Normalized difference vegetation index" %
        output_map[2529] = &epv->rootlengthProp[0]; //%"Proportion of total root lenght of soil layer 1 (0-3 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya az 1. talajrtegben (0-3 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 1 (0-3 cm)" %
        output_map[2530] = &epv->rootlengthProp[1]; //%"Proportion of total root lenght of soil layer 2 (3-10 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya a 2. talajrtegben (3-10 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 2 (3-10 cm)" %
        output_map[2531] = &epv->rootlengthProp[2]; //%"Proportion of total root lenght of soil layer 3 (10-30 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya a 3. talajrtegben (10-30 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 3 (10-30 cm)" %
        output_map[2532] = &epv->rootlengthProp[3]; //%"Proportion of total root lenght of soil layer 4 (30-60 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya a 4. talajrtegben (30-60 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 4 (30-60 cm)" %
        output_map[2533] = &epv->rootlengthProp[4]; //%"Proportion of total root lenght of soil layer 5 (60-90 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya az 5. talajrtegben (60-90 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 5 (60-90 cm)" %
        output_map[2534] = &epv->rootlengthProp[5]; //%"Proportion of total root lenght of soil layer 6 (90-120 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya a 6. talajrtegben (90-120 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 6 (90-120 cm)" %
        output_map[2535] = &epv->rootlengthProp[6]; //%"Proportion of total root lenght of soil layer 7 (120-150 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya a 7. talajrtegben (120-150 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 7 (120-150 cm)" %
        output_map[2536] = &epv->rootlengthProp[7]; //%"Proportion of total root lenght of soil layer 8 (150-200 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya a 8. talajrtegben (150-200 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 8 (150-200 cm)" %
        output_map[2537] = &epv->rootlengthProp[8]; //%"Proportion of total root lenght of soil layer 9 (200-400 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya az 9. talajrtegben (200-400 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 9 (200-400 cm)" %
        output_map[2538] = &epv->rootlengthProp[9]; //%"Proportion of total root lenght of soil layer 10 (400-1000 cm)" $\\left[prop\\right]$ "A teljes gykrhossz rszarnya a 10. talajrtegben (400-1000 cm)" $\\left[rszarny\\right]$ "Proportion of total root lenght of soil layer 10 (400-1000 cm)" %
        output_map[2539] = &epv->PSI[0]; //%"Water potential of soil and leaves of soil layer 1 (0-3 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja az 1. talajrtegben (0-3 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 1 (0-3 cm)" %
        output_map[2540] = &epv->PSI[1]; //%"Water potential of soil and leaves of soil layer 2 (3-10 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja a 2. talajrtegben (3-10 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 2 (3-10 cm)" %
        output_map[2541] = &epv->PSI[2]; //%"Water potential of soil and leaves of soil layer 3 (10-30 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja a 3. talajrtegben (10-30 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 3 (10-30 cm)" %
        output_map[2542] = &epv->PSI[3]; //%"Water potential of soil and leaves of soil layer 4 (30-60 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja a 4. talajrtegben (30-60 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 4 (30-60 cm)" %
        output_map[2543] = &epv->PSI[4]; //%"Water potential of soil and leaves of soil layer 5 (60-90 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja az 5. talajrtegben (60-90 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 5 (60-90 cm)" %
        output_map[2544] = &epv->PSI[5]; //%"Water potential of soil and leaves of soil layer 6 (90-120 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja a 6. talajrtegben (90-120 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 6 (90-120 cm)" %
        output_map[2545] = &epv->PSI[6]; //%"Water potential of soil and leaves of soil layer 7 (120-150 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja a 7. talajrtegben (120-150 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 7 (120-150 cm)" %
        output_map[2546] = &epv->PSI[7]; //%"Water potential of soil and leaves of soil layer 8 (150-200 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja a 8. talajrtegben (150-200 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 8 (150-200 cm)" %
        output_map[2547] = &epv->PSI[8]; //%"Water potential of soil and leaves of soil layer 9 (200-400 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja az 9. talajrtegben (200-400 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 9 (200-400 cm)" %
        output_map[2548] = &epv->PSI[9]; //%"Water potential of soil and leaves of soil layer 10 (400-1000 cm)" $\\left[MPa\\right]$ "A talaj s levl vzpotencilja a 10. talajrtegben (400-1000 cm)" $\\left[MPa\\right]$ "Water potential of soil and leaves of soil layer 10 (400-1000 cm)" %
        output_map[2549] = &epv->pF[0]; //%"Soil water suction derived from log(soil water potential) of soil layer 1 (0-3 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge az 1. talajrtegben (0-3 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 1 (0-3 cm)" %
        output_map[2550] = &epv->pF[1]; //%"Soil water suction derived from log(soil water potential) of soil layer 2 (3-10 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge a 2. talajrtegben (3-10 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 2 (3-10 cm)" %
        output_map[2551] = &epv->pF[2]; //%"Soil water suction derived from log(soil water potential) of soil layer 3 (10-30 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge a 3. talajrtegben (10-30 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 3 (10-30 cm)" %
        output_map[2552] = &epv->pF[3]; //%"Soil water suction derived from log(soil water potential) of soil layer 4 (30-60 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge a 4. talajrtegben (30-60 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 4 (30-60 cm)" %
        output_map[2553] = &epv->pF[4]; //%"Soil water suction derived from log(soil water potential) of soil layer 5 (60-90 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge az 5. talajrtegben (60-90 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 5 (60-90 cm)" %
        output_map[2554] = &epv->pF[5]; //%"Soil water suction derived from log(soil water potential) of soil layer 6 (90-120 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge a 6. talajrtegben (90-120 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 6 (90-120 cm)" %
        output_map[2555] = &epv->pF[6]; //%"Soil water suction derived from log(soil water potential) of soil layer 7 (120-150 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge a 7. talajrtegben (120-150 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 7 (120-150 cm)" %
        output_map[2556] = &epv->pF[7]; //%"Soil water suction derived from log(soil water potential) of soil layer 8 (150-200 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge a 8. talajrtegben (150-200 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 8 (150-200 cm)" %
        output_map[2557] = &epv->pF[8]; //%"Soil water suction derived from log(soil water potential) of soil layer 9 (200-400 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge az 9. talajrtegben (200-400 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 9 (200-400 cm)" %
        output_map[2558] = &epv->pF[9]; //%"Soil water suction derived from log(soil water potential) of soil layer 10 (400-1000 cm)" $\\left[cm\\right]$ "A talaj vzmegtart kpessge a 10. talajrtegben (400-1000 cm)" $\\left[cm\\right]$ "Soil water suction derived from log(soil water potential) of soil layer 10 (400-1000 cm)" %
        output_map[2559] = &epv->hydrCONDUCTact[0]; //%"Hydraulic conductivity on the given day of soil layer 1 (0-3 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon az 1. talajrtegben (0-3 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 1 (0-3 cm)" %
        output_map[2560] = &epv->hydrCONDUCTact[1]; //%"Hydraulic conductivity on the given day of soil layer 2 (3-10 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon a 2. talajrtegben (3-10 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 2 (3-10 cm)" %
        output_map[2561] = &epv->hydrCONDUCTact[2]; //%"Hydraulic conductivity on the given day of soil layer 3 (10-30 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon a 3. talajrtegben (10-30 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 3 (10-30 cm)" %
        output_map[2562] = &epv->hydrCONDUCTact[3]; //%"Hydraulic conductivity on the given day of soil layer 4 (30-60 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon a 4. talajrtegben (30-60 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 4 (30-60 cm)" %
        output_map[2563] = &epv->hydrCONDUCTact[4]; //%"Hydraulic conductivity on the given day of soil layer 5 (60-90 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon az 5. talajrtegben (60-90 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 5 (60-90 cm)" %
        output_map[2564] = &epv->hydrCONDUCTact[5]; //%"Hydraulic conductivity on the given day of soil layer 6 (90-120 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon a 6. talajrtegben (90-120 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 6 (90-120 cm)" %
        output_map[2565] = &epv->hydrCONDUCTact[6]; //%"Hydraulic conductivity on the given day of soil layer 7 (120-150 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon a 7. talajrtegben (120-150 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 7 (120-150 cm)" %
        output_map[2566] = &epv->hydrCONDUCTact[7]; //%"Hydraulic conductivity on the given day of soil layer 8 (150-200 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon a 8. talajrtegben (150-200 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 8 (150-200 cm)" %
        output_map[2567] = &epv->hydrCONDUCTact[8]; //%"Hydraulic conductivity on the given day of soil layer 9 (200-400 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon az 9. talajrtegben (200-400 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 9 (200-400 cm)" %
        output_map[2568] = &epv->hydrCONDUCTact[9]; //%"Hydraulic conductivity on the given day of soil layer 10 (400-1000 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus vezetokpessg az adott napon a 10. talajrtegben (400-1000 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic conductivity on the given day of soil layer 10 (400-1000 cm)" %
        output_map[2569] = &epv->hydrDIFFUSact[0]; //%"Hydraulic diffusivity on the given day of soil layer 1 (0-3 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon az 1. talajrtegben (0-3 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 1 (0-3 cm)" %
        output_map[2570] = &epv->hydrDIFFUSact[1]; //%"Hydraulic diffusivity on the given day of soil layer 2 (3-10 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon a 2. talajrtegben (3-10 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 2 (3-10 cm)" %
        output_map[2571] = &epv->hydrDIFFUSact[2]; //%"Hydraulic diffusivity on the given day of soil layer 3 (10-30 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon a 3. talajrtegben (10-30 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 3 (10-30 cm)" %
        output_map[2572] = &epv->hydrDIFFUSact[3]; //%"Hydraulic diffusivity on the given day of soil layer 4 (30-60 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon a 4. talajrtegben (30-60 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 4 (30-60 cm)" %
        output_map[2573] = &epv->hydrDIFFUSact[4]; //%"Hydraulic diffusivity on the given day of soil layer 5 (60-90 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon az 5. talajrtegben (60-90 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 5 (60-90 cm)" %
        output_map[2574] = &epv->hydrDIFFUSact[5]; //%"Hydraulic diffusivity on the given day of soil layer 6 (90-120 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon a 6. talajrtegben (90-120 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 6 (90-120 cm)" %
        output_map[2575] = &epv->hydrDIFFUSact[6]; //%"Hydraulic diffusivity on the given day of soil layer 7 (120-150 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon a 7. talajrtegben (120-150 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 7 (120-150 cm)" %
        output_map[2576] = &epv->hydrDIFFUSact[7]; //%"Hydraulic diffusivity on the given day of soil layer 8 (150-200 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon a 8. talajrtegben (150-200 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 8 (150-200 cm)" %
        output_map[2577] = &epv->hydrDIFFUSact[8]; //%"Hydraulic diffusivity on the given day of soil layer 9 (200-400 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon az 9. talajrtegben (200-400 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 9 (200-400 cm)" %
        output_map[2578] = &epv->hydrDIFFUSact[9]; //%"Hydraulic diffusivity on the given day of soil layer 10 (400-1000 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulikus diffuzivits az adott napon a 10. talajrtegben (400-1000 cm)" $\\left[\\ms^{-1} \\right]$ "Hydraulic diffusivity on the given day of soil layer 10 (400-1000 cm)" %
		output_map[2579] = &epv->rootDepth;        //%"Actual depth of the root" $\\left[m\\right]$ "Aktulis gykrmlysg" $\\left[m\\right]$ "Actual depth of the root" %
		output_map[2580] = &epv->rootDepth_phen[0]; //%"Rooting depth of the phenphase1" $\\left[dimless\\right]$ "Az 1. fenofzis gykerezsi mlysge" $\\left[dimless\\right]$ "Rooting depth of the phenphase1" %
        output_map[2581] = &epv->rootDepth_phen[1]; //%"Rooting depth of the phenphase2" $\\left[dimless\\right]$ "Az 1. fenofzis gykerezsi mlysge" $\\left[dimless\\right]$ "Rooting depth of the phenphase2" %
        output_map[2582] = &epv->rootDepth_phen[2]; //%"Rooting depth of the phenphase3" $\\left[dimless\\right]$ "Az 1. fenofzis gykerezsi mlysge" $\\left[dimless\\right]$ "Rooting depth of the phenphase3" %
        output_map[2583] = &epv->rootDepth_phen[3]; //%"Rooting depth of the phenphase4" $\\left[dimless\\right]$ "Az 1. fenofzis gykerezsi mlysge" $\\left[dimless\\right]$ "Rooting depth of the phenphase4" %
        output_map[2584] = &epv->rootDepth_phen[4]; //%"Rooting depth of the phenphase5" $\\left[dimless\\right]$ "Az 1. fenofzis gykerezsi mlysge" $\\left[dimless\\right]$ "Rooting depth of the phenphase5" %
        output_map[2585] = &epv->rootDepth_phen[5]; //%"Rooting depth of the phenphase6" $\\left[dimless\\right]$ "Az 1. fenofzis gykerezsi mlysge" $\\left[dimless\\right]$ "Rooting depth of the phenphase6" %
        output_map[2586] = &epv->rootDepth_phen[6]; //%"Rooting depth of the phenphase7" $\\left[dimless\\right]$ "Az 1. fenofzis gykerezsi mlysge" $\\left[dimless\\right]$ "Rooting depth of the phenphase7" %
		output_map[2587] = &epv->cumCalloc_plant; //%"Cumulated amount of allocated C" $\\left[\\kg_{C}m^{-2} \\right]$ "Alloklt C kumullt mennyisge" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulated amount of allocated C" %
        output_map[2588] = &epv->cumNalloc_plant; //%"Cumulated amount of allocated N" $\\left[\\kg_{N}m^{-2} \\right]$ "Alloklt N kumullt mennyisge" $\\left[\\kg_{N}m^{-2} \\right]$ "Cumulated amount of allocated N" %
		output_map[2589] = &epv->ts_nitrif[0]; //%"Nitrification temperature scalar in soil layer 1 (0-3 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja az 1. talajrtegben (0-3 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 1 (0-3 cm)" %
        output_map[2590] = &epv->ts_nitrif[1]; //%"Nitrification temperature scalar in soil layer 2 (3-10 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja a 2. talajrtegben (3-10 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 2 (3-10 cm)" %
        output_map[2591] = &epv->ts_nitrif[2]; //%"Nitrification temperature scalar in soil layer 3 (10-30 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja a 3. talajrtegben (10-30 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 3 (10-30 cm)" %
        output_map[2592] = &epv->ts_nitrif[3]; //%"Nitrification temperature scalar in soil layer 4 (30-60 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja a 4. talajrtegben (30-60 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 4 (30-60 cm)" %
        output_map[2593] = &epv->ts_nitrif[4]; //%"Nitrification temperature scalar in soil layer 5 (60-90 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja az 5. talajrtegben (60-90 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 5 (60-90 cm)" %
        output_map[2594] = &epv->ts_nitrif[5]; //%"Nitrification temperature scalar in soil layer 6 (90-120 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja a 6. talajrtegben (90-120 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 6 (90-120 cm)" %
        output_map[2595] = &epv->ts_nitrif[6]; //%"Nitrification temperature scalar in soil layer 7 (120-150 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja a 7. talajrtegben (120-150 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 7 (120-150 cm)" %
        output_map[2596] = &epv->ts_nitrif[7]; //%"Nitrification temperature scalar in soil layer 8 (150-200 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja a 8. talajrtegben (150-200 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 8 (150-200 cm)" %
        output_map[2597] = &epv->ts_nitrif[8]; //%"Nitrification temperature scalar in soil layer 9 (200-400 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja az 9. talajrtegben (200-400 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 9 (200-400 cm)" %
        output_map[2598] = &epv->ts_nitrif[9]; //%"Nitrification temperature scalar in soil layer 10 (400-1000 cm)" $\\left[dimless\\right]$ "Nitrifikci homrskleti skalrja a 10. talajrtegben (400-1000 cm)" $\\left[dimless\\right]$ "Nitrification temperature scalar in soil layer 10 (400-1000 cm)" %
		output_map[2599] = &epv->VWCsat_RZ; //%"Average value of VWC at saturation (rooting zone)" $\\left[\\m^{3}m^{-3} \\right]$ "A teltsi ponthoz tartoz talajnedvessg-tartalom tlagos rtke (gykrzna)" $\\left[\\m^{3}m^{-3} \\right]$ "Average value of VWC at saturation (rooting zone)" %
        output_map[2600] = &epv->VWCfc_RZ; //%"Average value of VWC at field capacity (rooting zone)" $\\left[\\m^{3}m^{-3} \\right]$ "A szabadfldi vzkapacitshoz tartoz talajnedvessg-tartalom tlagos rtke (gykrzna)" $\\left[\\m^{3}m^{-3} \\right]$ "Average value of VWC at field capacity (rooting zone)" %
        output_map[2601] = &epv->VWCwp_RZ; //%"Average value of VWC at wilting point (rooting zone)" $\\left[\\m^{3}m^{-3} \\right]$ "A hervadsponthoz tartoz talajnedvessg-tartalom tlagos rtke (gykrzna)" $\\left[\\m^{3}m^{-3} \\right]$ "Average value of VWC at wilting point (rooting zone)" %
        output_map[2602] = &epv->VWChw_RZ; //%"Average value of hygroscopic VWC (rooting zone)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus talajnedvessg-tartalom (gykrznag)" $\\left[\\m^{3}m^{-3} \\right]$ "Average value of hygroscopic volumetric water content (mrooting zone)" %
        output_map[2603] = &epv->VWC[0]; //%"Volumetric water content of soil layer 1 (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom az 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 1 (0-3 cm)" %
        output_map[2604] = &epv->VWC[1]; //%"Volumetric water content of soil layer 2 (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom a 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 2 (3-10 cm)" %
        output_map[2605] = &epv->VWC[2]; //%"Volumetric water content of soil layer 3 (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom a 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 3 (10-30 cm)" %
        output_map[2606] = &epv->VWC[3]; //%"Volumetric water content of soil layer 4 (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom a 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 4 (30-60 cm)" %
        output_map[2607] = &epv->VWC[4]; //%"Volumetric water content of soil layer 5 (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom az 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 5 (60-90 cm)" %
        output_map[2608] = &epv->VWC[5]; //%"Volumetric water content of soil layer 6 (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom a 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 6 (90-120 cm)" %
        output_map[2609] = &epv->VWC[6]; //%"Volumetric water content of soil layer 7 (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom a 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 7 (120-150 cm)" %
        output_map[2610] = &epv->VWC[7]; //%"Volumetric water content of soil layer 8 (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom a 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 8 (150-200 cm)" %
        output_map[2611] = &epv->VWC[8]; //%"Volumetric water content of soil layer 9 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 9 (200-400 cm)" %
        output_map[2612] = &epv->VWC[9]; //%"Volumetric water content of soil layer 10 (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Trfogati vztartalom a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content of soil layer 10 (400-1000 cm)" %
 		output_map[2613] = &epv->relVWCsat_fc[0]; //%"Relative volumetric water content (SAT-FC) of soil layer 1 (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) az 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 1 (0-3 cm)" %
        output_map[2614] = &epv->relVWCsat_fc[1]; //%"Relative volumetric water content (SAT-FC) of soil layer 2 (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) a 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 2 (3-10 cm)" %
        output_map[2615] = &epv->relVWCsat_fc[2]; //%"Relative volumetric water content (SAT-FC) of soil layer 3 (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) a 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 3 (10-30 cm)" %
        output_map[2616] = &epv->relVWCsat_fc[3]; //%"Relative volumetric water content (SAT-FC) of soil layer 4 (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) a 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 4 (30-60 cm)" %
        output_map[2617] = &epv->relVWCsat_fc[4]; //%"Relative volumetric water content (SAT-FC) of soil layer 5 (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) az 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 5 (60-90 cm)" %
        output_map[2618] = &epv->relVWCsat_fc[5]; //%"Relative volumetric water content (SAT-FC) of soil layer 6 (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) a 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 6 (90-120 cm)" %
        output_map[2619] = &epv->relVWCsat_fc[6]; //%"Relative volumetric water content (SAT-FC) of soil layer 7 (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) a 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 7 (120-150 cm)" %
        output_map[2620] = &epv->relVWCsat_fc[7]; //%"Relative volumetric water content (SAT-FC) of soil layer 8 (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) a 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 8 (150-200 cm)" %
        output_map[2621] = &epv->relVWCsat_fc[8]; //%"Relative volumetric water content (SAT-FC) of soil layer 9 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 9 (200-400 cm)" %
        output_map[2622] = &epv->relVWCsat_fc[9]; //%"Relative volumetric water content (SAT-FC) of soil layer 10 (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (SAT-FC) of soil layer 10 (400-1000 cm)" %
  		output_map[2623] = &epv->relVWCfc_wp[0]; //%"Relative volumetric water content (FC-WP) of soil layer 1 (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (FC-WP) az 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 1 (0-3 cm)" %
        output_map[2624] = &epv->relVWCfc_wp[1]; //%"Relative volumetric water content (FC-WP) of soil layer 2 (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (SAT-FC) a 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 2 (3-10 cm)" %
        output_map[2625] = &epv->relVWCfc_wp[2]; //%"Relative volumetric water content (FC-WP) of soil layer 3 (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (FC-WP) a 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 3 (10-30 cm)" %
        output_map[2626] = &epv->relVWCfc_wp[3]; //%"Relative volumetric water content (FC-WP) of soil layer 4 (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (FC-WP) a 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 4 (30-60 cm)" %
        output_map[2627] = &epv->relVWCfc_wp[4]; //%"Relative volumetric water content (FC-WP) of soil layer 5 (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (FC-WP) az 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 5 (60-90 cm)" %
        output_map[2628] = &epv->relVWCfc_wp[5]; //%"Relative volumetric water content (FC-WP) of soil layer 6 (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (FC-WP) a 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 6 (90-120 cm)" %
        output_map[2629] = &epv->relVWCfc_wp[6]; //%"Relative volumetric water content (FC-WP) of soil layer 7 (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (FC-WP) a 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 7 (120-150 cm)" %
        output_map[2630] = &epv->relVWCfc_wp[7]; //%"Relative volumetric water content (FC-WP) of soil layer 8 (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (FC-WP) a 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 8 (150-200 cm)" %
        output_map[2631] = &epv->relVWCfc_wp[8]; //%"Relative volumetric water content (FC-WP) of soil layer 9 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (FC-WP) az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 9 (200-400 cm)" %
        output_map[2632] = &epv->relVWCfc_wp[9]; //%"Relative volumetric water content (FC-WP) of soil layer 10 (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relatv trfogati vztartalom (FC-WP) a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Relative volumetric water content (FC-WP) of soil layer 10 (400-1000 cm)" %
        output_map[2633] = &epv->VWC_avg; //%"Average volumetric water content in active layers" $\\left[\\m^{3}m^{-3} \\right]$ "tlagos trfogati vztartalom az aktv rtegekben" $\\left[\\m^{3}m^{-3} \\right]$ "Average volumetric water content in active layers" %
        output_map[2634] = &epv->VWC_RZ; //%"Average volumetric water content in rootzone (max.soil.depth)" $\\left[\\m^{3}m^{-3} \\right]$ "tlagos trfogati vztartalom a gykrznban (max. talajmlysg)" $\\left[\\m^{3}m^{-3} \\right]$ "Average volumetric water content in rootzone (max.soil.depth)" %
        output_map[2635] = &epv->VWC_RZmax;  //%"Average value of VWC (maximum of rooting zone)" $\\left[\\m^{3}m^{-3} \\right]$ "A talajnedvessg-tartalom tlagos rtke (gykrzna maximlis mlysge)" $\\left[\\m^{3}m^{-3} \\right]$ "Average value of VWC (maximum of rooting zone)" %	
        output_map[2636] = &epv->rootDepth; //%"Actual depth of the rooting zone" $\\left[m\\right]$ "A gykrzna tlagos mlysge" $\\left[m\\right]$ "Actual depth of the rooting zone" %
        output_map[2637] = &epv->dlmr_area_sun; //%"Sunlit leaf MR" $\\left[\\mu$mol$_{C} m^{-2}_{proj}\\right]$ "A napsttte levelek nfenntart respircija" $\\left[\\mu$mol$_{C} m^{-2}_{proj}\\right]$ "Sunlit leaf maintenance respiration" %
        output_map[2638] = &epv->dlmr_area_shade; //%"Shaded leaf MR" $\\left[\\mu$mol$_{C} m^{-2}_{proj}\\right]$ "rnykolt levelek nfenntart respircija" $\\left[\\mu$mol$_{C} m^{-2}_{proj}\\right]$ "Shaded leaf maintenance respiration" %
        output_map[2639] = &epv->gl_t_wv_sun; //%"Sunlit leaf-scale conductance to transpired water" $\\left[\\m s^{-1} \\right]$ "Levlszintu transzspircis vezetokpessg (napfnyes levlldal)" $\\left[\\m s^{-1} \\right]$ "Sunlit leaf-scale conductance to transpired water" %
        output_map[2640] = &epv->gl_t_wv_shade; //%"Shaded leaf-scale conductance to transpired water" $\\left[\\m^{3}s^{-1} \\right]$ "Levlszintu transzspircis vezetokpessg  rnykos levlldal)" $\\left[\\m^{3}s^{-1} \\right]$ "Shaded leaf-scale conductance to transpired water" %
        output_map[2641] = &epv->assim_sun; //%"Sunlit assimilation per unit pleaf area index" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Levlfelleti egysgre vettett asszimilci (napfnyes levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunlit assimilation per unit projected leaf area index" %
        output_map[2642] = &epv->assim_shade; //%"Shaded assimilation per unit pleaf area index" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Levlfelleti egysgre vettett asszimilci (rnykolt levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Shaded assimilation per unit projected leaf area index" %
        output_map[2643] = &epv->ts_decomp[0]; //%"Decomposition temperature scalar in soil layer 1 (0-3 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja az 1. talajrtegben (0-3 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 1 (0-3 cm)" %
        output_map[2644] = &epv->ts_decomp[1]; //%"Decomposition temperature scalar in soil layer 2 (3-10 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja a 2. talajrtegben (3-10 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 2 (3-10 cm)" %
        output_map[2645] = &epv->ts_decomp[2]; //%"Decomposition temperature scalar in soil layer 3 (10-30 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja a 3. talajrtegben (10-30 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 3 (10-30 cm)" %
        output_map[2646] = &epv->ts_decomp[3]; //%"Decomposition temperature scalar in soil layer 4 (30-60 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja a 4. talajrtegben (30-60 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 4 (30-60 cm)" %
        output_map[2647] = &epv->ts_decomp[4]; //%"Decomposition temperature scalar in soil layer 5 (60-90 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja az 5. talajrtegben (60-90 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 5 (60-90 cm)" %
        output_map[2648] = &epv->ts_decomp[5]; //%"Decomposition temperature scalar in soil layer 6 (90-120 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja a 6. talajrtegben (90-120 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 6 (90-120 cm)" %
        output_map[2649] = &epv->ts_decomp[6]; //%"Decomposition temperature scalar in soil layer 7 (120-150 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja a 7. talajrtegben (120-150 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 7 (120-150 cm)" %
        output_map[2650] = &epv->ts_decomp[7]; //%"Decomposition temperature scalar in soil layer 8 (150-200 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja a 8. talajrtegben (150-200 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 8 (150-200 cm)" %
        output_map[2651] = &epv->ts_decomp[8]; //%"Decomposition temperature scalar in soil layer 9 (200-400 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja az 9. talajrtegben (200-400 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 9 (200-400 cm)" %
        output_map[2652] = &epv->ts_decomp[9]; //%"Decomposition temperature scalar in soil layer 10 (400-1000 cm)" $\\left[dimless\\right]$ "Lebomls homrskleti skalrja a 10. talajrtegben (400-1000 cm)" $\\left[dimless\\right]$ "Decomposition temperature scalar in soil layer 10 (400-1000 cm)" %
        output_map[2653] = &epv->ws_decomp[0]; //%"Decomposition water scalar in soil layer 1 (0-3 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja az 1. talajrtegben (0-3 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 1 (0-3 cm)" %
        output_map[2654] = &epv->ws_decomp[1]; //%"Decomposition water scalar in soil layer 2 (3-10 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja a 2. talajrtegben (3-10 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 2 (3-10 cm)" %
        output_map[2655] = &epv->ws_decomp[2]; //%"Decomposition water scalar in soil layer 3 (10-30 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja a 3. talajrtegben (10-30 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 3 (10-30 cm)" %
        output_map[2656] = &epv->ws_decomp[3]; //%"Decomposition water scalar in soil layer 4 (30-60 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja a 4. talajrtegben (30-60 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 4 (30-60 cm)" %
        output_map[2657] = &epv->ws_decomp[4]; //%"Decomposition water scalar in soil layer 5 (60-90 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja az 5. talajrtegben (60-90 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 5 (60-90 cm)" %
        output_map[2658] = &epv->ws_decomp[5]; //%"Decomposition water scalar in soil layer 6 (90-120 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja a 6. talajrtegben (90-120 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 6 (90-120 cm)" %
        output_map[2659] = &epv->ws_decomp[6]; //%"Decomposition water scalar in soil layer 7 (120-150 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja a 7. talajrtegben (120-150 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 7 (120-150 cm)" %
        output_map[2660] = &epv->ws_decomp[7]; //%"Decomposition water scalar in soil layer 8 (150-200 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja a 8. talajrtegben (150-200 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 8 (150-200 cm)" %
        output_map[2661] = &epv->ws_decomp[8]; //%"Decomposition water scalar in soil layer 9 (200-400 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja az 9. talajrtegben (200-400 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 9 (200-400 cm)" %
        output_map[2662] = &epv->ws_decomp[9]; //%"Decomposition water scalar in soil layer 10 (400-1000 cm)" $\\left[dimless\\right]$ "Lebomls vz skalrja a 10. talajrtegben (400-1000 cm)" $\\left[dimless\\right]$ "Decomposition water scalar in soil layer 10 (400-1000 cm)" %
        output_map[2663] = &epv->rs_decomp[0]; //%"Decomposition combined scalar in soil layer 1 (0-3 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja az 1. talajrtegben (0-3 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 1 (0-3 cm)" %
        output_map[2664] = &epv->rs_decomp[1]; //%"Decomposition combined scalar in soil layer 2 (3-10 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja a 2. talajrtegben (3-10 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 2 (3-10 cm)" %
        output_map[2665] = &epv->rs_decomp[2]; //%"Decomposition combined scalar in soil layer 3 (10-30 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja a 3. talajrtegben (10-30 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 3 (10-30 cm)" %
        output_map[2666] = &epv->rs_decomp[3]; //%"Decomposition combined scalar in soil layer 4 (30-60 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja a 4. talajrtegben (30-60 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 4 (30-60 cm)" %
        output_map[2667] = &epv->rs_decomp[4]; //%"Decomposition combined scalar in soil layer 5 (60-90 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja az 5. talajrtegben (60-90 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 5 (60-90 cm)" %
        output_map[2668] = &epv->rs_decomp[5]; //%"Decomposition combined scalar in soil layer 6 (90-120 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja a 6. talajrtegben (90-120 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 6 (90-120 cm)" %
        output_map[2669] = &epv->rs_decomp[6]; //%"Decomposition combined scalar in soil layer 7 (120-150 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja a 7. talajrtegben (120-150 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 7 (120-150 cm)" %
        output_map[2670] = &epv->rs_decomp[7]; //%"Decomposition combined scalar in soil layer 8 (150-200 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja a 8. talajrtegben (150-200 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 8 (150-200 cm)" %
        output_map[2671] = &epv->rs_decomp[8]; //%"Decomposition combined scalar in soil layer 9 (200-400 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja az 9. talajrtegben (200-400 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 9 (200-400 cm)" %
        output_map[2672] = &epv->rs_decomp[9]; //%"Decomposition combined scalar in soil layer 10 (400-1000 cm)" $\\left[dimless\\right]$ "Lebomls kombinlt skalrja a 10. talajrtegben (400-1000 cm)" $\\left[dimless\\right]$ "Decomposition combined scalar in soil layer 10 (400-1000 cm)" %
        output_map[2673] = &epv->rs_decomp_avg; //%"Decomposition combined and averaged scalar" $\\left[dimless\\right]$ "Lebomlsi kombinlt s tlagolt skalrja" $\\left[dimless\\right]$ "Decomposition combined and averaged scalar" %
  		output_map[2674] = &epv->annmax_rootDepth;   //%"Year-to-date maximum rooting depth" $\\left[\\m \\right]$ "Maximlis ves gykrmlysg" $\\left[\\m\\right]$ "Year-to-date maximum rooting depth" %
        output_map[2675] = &epv->annmax_plantHeight; //%"Year-to-date maximum plant height" $\\left[\\m\\right]$ "Maximlis ves nvnymagassg" $\\left[\\m\\right]$ "Year-to-date maximum plant height" %
	    output_map[2676] = &epv->litr1_CNratio; //%"CN ratio of labile litter pool" $\\left[\\dimless\\right]$ "Labilis elhalt nvnyi troz CN-arnya" $\\left[\\m\\right]$ "CN ratio of labile litter pool" %
		output_map[2677] = &epv->litr2_CNratio; //%"CN ratio of u. cellulose litter pool" $\\left[\\dimless\\right]$ "Nem vdett cellulz elhalt nvnyi troz CN-arnya" $\\left[\\m\\right]$ "CN ratio of u. celluloselitter pool" %
		output_map[2678] = &epv->litr3_CNratio; //%"CN ratio of s. cellulose litter pool" $\\left[\\dimless\\right]$ "Vdett cellulz elhalt nvnyi troz CN-arnya" $\\left[\\m\\right]$ "CN ratio of s. celluloselitter pool" %
		output_map[2679] = &epv->litr4_CNratio; //%"CN ratio of lignin litter pool" $\\left[\\dimless\\right]$ "Ligning elhalt nvnyi troz CN-arnya" $\\left[\\m\\right]$ "CN ratio of ligninlitter pool" %
		output_map[2680] = &epv->relVWCsat_fc_RZmax;  //%"Average value of relVWCsat_fc (maximum of rooting zone)" $\\left[\\m^{3}m^{-3} \\right]$ "A talajnedvessg-tartalom tlagos rtke (gykrzna maximlis mlysge)" $\\left[\\m^{3}m^{-3} \\right]$ "Average value of relVWCsat_fc (maximum of rooting zone)" %	
		output_map[2681] = &epv->relVWCfc_wp_RZmax;  //%"Average value of relVWCfc_wp (maximum of rooting zone)" $\\left[\\m^{3}m^{-3} \\right]$ "A talajnedvessg-tartalom tlagos rtke (gykrzna maximlis mlysge)" $\\left[\\m^{3}m^{-3} \\right]$ "Average value of relVWCfc_wp (maximum of rooting zone)" %	
        output_map[2682] = &epv->cumWS_anoxic; //%"Cumulative anoxic soil water stress" $\\left[dimless\\right]$ "Kumulatv anoxikus talajnedvessg-stressz" $\\left[dimless\\right]$ "Cumulative anoxic soil water stress" %
        output_map[2683] = &epv->cumWS_drought; //%"Cumulative dought soil water stress" $\\left[dimless\\right]$ "Kumulatv szrazsgi talajnedvessg-stressz" $\\left[dimless\\right]$ "Cumulative dought soil water stress" %
        output_map[2684] = &epv->m_WSanoxic; //%"Anoxic soil water stress multiplier (1: no stress, 0: full stress)" $\\left[dimless\\right]$ "Anoxikus talajnedvessg-stressz szorztnyezje " $\\left[dimless\\right]$ "Anoxic soil water stress multiplier (1: no stress, 0: full stress)" %
        output_map[2685] = &epv->m_WSdrought; //%"Drought soil water stress multiplier (1: no stress, 0: full stress)" $\\left[dimless\\right]$ "Szrazsgi alajnedvessg-stressz szorztnyezje " $\\left[dimless\\right]$ "Drought soil water stress multiplier (1: no stress, 0: full stress)" %
        output_map[2703] = &epv->m_NS; //%"Averaged (regarding to rooting zone) soil N stress" $\\left[dimless\\right]$ "tlagos N-stressz a gykrznra vonatkozan" $\\left[db\\right]$ "Cumulative soil N stress" %
		output_map[2704] = &epv->stomaCONDUCT_max;  //%"Maximal stomatal conductance with temperature-pressure correction" $\\left[\\ms^{-1} \\right]$ "Maximlis sztmavezets homrskleti- s nyomskorrekcival" $\\left[\\ms^{-1} \\right]$ "Maximal stomatal conductance with temperature-pressure correction" %
        output_map[2705] = &epv->m_Tmin;            //%"Freezing night temperature multiplier" $\\left[dimless\\right]$ "Fagypont alatti jszakai homrsklet szorz" $\\left[dimless\\right]$ "Freezing night temperature multiplier" %
        output_map[2706] = &epv->m_WS_layer[0]; //%"Soil water stress multiplier in soil layer 1 (0-3 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz az 1. talajrtegben (0-3 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 1 (0-3 cm)" %
        output_map[2707] = &epv->m_WS_layer[1]; //%"Soil water stress multiplier in soil layer 2 (3-10 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz a 2. talajrtegben (3-10 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 2 (3-10 cm)" %
        output_map[2708] = &epv->m_WS_layer[2]; //%"Soil water stress multiplier in soil layer 3 (10-30 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz a 3. talajrtegben (10-30 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 3 (10-30 cm)" %
        output_map[2709] = &epv->m_WS_layer[3]; //%"Soil water stress multiplier in soil layer 4 (30-60 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz a 4. talajrtegben (30-60 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 4 (30-60 cm)" %
        output_map[2710] = &epv->m_WS_layer[4]; //%"Soil water stress multiplier in soil layer 5 (60-90 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz az 5. talajrtegben (60-90 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 5 (60-90 cm)" %
        output_map[2711] = &epv->m_WS_layer[5]; //%"Soil water stress multiplier in soil layer 6 (90-120 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz a 6. talajrtegben (90-120 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 6 (90-120 cm)" %
        output_map[2712] = &epv->m_WS_layer[6]; //%"Soil water stress multiplier in soil layer 7 (120-150 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz a 7. talajrtegben (120-150 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 7 (120-150 cm)" %
        output_map[2713] = &epv->m_WS_layer[7]; //%"Soil water stress multiplier in soil layer 8 (150-200 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz a 8. talajrtegben (150-200 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 8 (150-200 cm)" %
        output_map[2714] = &epv->m_WS_layer[8]; //%"Soil water stress multiplier in soil layer 9 (200-400 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz az 9. talajrtegben (200-400 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 9 (200-400 cm)" %
        output_map[2715] = &epv->m_WS_layer[9]; //%"Soil water stress multiplier in soil layer 10 (400-1000 cm)" $\\left[dimless\\right]$ "Talajnedvessg stressz szorz a 10. talajrtegben (400-1000 cm)" $\\left[dimless\\right]$ "Soil water stress multiplier in soil layer 10 (400-1000 cm)" %
        output_map[2716] = &epv->m_WS; //%"Soil water stress multiplier (1: no stress, 0: full stress)" $\\left[dimless\\right]$ "Talajnedvessg-stressz szorztnyezje " $\\left[dimless\\right]$ "Soil water stress multiplier (1: no stress, 0: full stress)" %
        output_map[2717] = &epv->m_ppfd_sun; //%"Sunlit PAR flux density multiplier" $\\left[dimless\\right]$ "Napos fotoszintetikusan aktv sugrzs fluxus surusg szorz" $\\left[dimless\\right]$ "Sunlit photosyntetically active radiation flux density multiplier" %
        output_map[2718] = &epv->m_ppfd_shade; //%"Sunshade PAR flux density multiplier" $\\left[dimless\\right]$ "rnykos fotoszintetikusan aktv sugrzs fluxus surusg szorz" $\\left[dimless\\right]$ "Sunshade photosyntetically active radiation flux density multiplier" %
        output_map[2719] = &epv->m_vpd; //%"Vapor pressure deficit multiplier" $\\left[dimless\\right]$ "Teltsi hiny szorz" $\\left[dimless\\right]$ "Vapor pressure deficit multiplier" %
        output_map[2720] = &epv->m_final_sun; //%"Sunlit product of all other multipliers" $\\left[dimless\\right]$ "Stresszfaktorok szorzata (napos levlldal)" $\\left[dimless\\right]$ "Sunlit product of all other multipliers" %
        output_map[2721] = &epv->m_final_shade; //%"Sunshade product of all other multipliers" $\\left[dimless\\right]$ "Stresszfaktorok szorzata (rnykolt levlldal)" $\\left[dimless\\right]$ "Sunshade product of all other multipliers" %
        output_map[2722] = &epv->m_WSlenght; //%"Soil water stress length multiplier" $\\left[dimless\\right]$ "Talajnedvessg stressz hossznak szorztnyezoje" $\\left[dimless\\right]$ "Soil water stress length multiplier" %
        output_map[2723] = &epv->m_extremT; //%"Extrem temperature multiplier" $\\left[dimless\\right]$ "Extrm homrskleti szorz" $\\left[dimless\\right]$ "Extrem temperature multiplier" %
        output_map[2724] = &epv->SMSI; //%"Soil moisture stress index" $\\left[prop\\right]$ "Talajnedvessg stressz index" $\\left[rszarny\\right]$ "Soil moisture stress index" %
        output_map[2725] = &epv->gcorr; //%"Temperature and pressure correction factor for conductances" $\\left[dimless\\right]$ "Konduktancik homrskleti s nyoms korrekcis faktora" $\\left[dimless\\right]$ "Temperature and pressure correction factor for conductances" %
        output_map[2726] = &epv->gl_bl; //%"Leaf boundary layer conductance" $\\left[\\ms^{-1} \\right]$ "Levl hatrrteg vezetokpessge" $\\left[\\ms^{-1} \\right]$ "Leaf boundary layer conductance" %
        output_map[2727] = &epv->gl_c; //%"Leaf cuticular conductance" $\\left[\\ms^{-1} \\right]$ "Levl kutikulris vezetokpessge" $\\left[\\ms^{-1} \\right]$ "Leaf cuticular conductance" %
        output_map[2728] = &epv->gl_s_sun; //%"Sunlit leaf-scale stomatal conductance" $\\left[\\ms^{-1} \\right]$ "Napos oldal levlszintu sztomatlis konduktanccia" $\\left[\\ms^{-1} \\right]$ "Sunlit leaf-scale stomatal conductance" %
        output_map[2729] = &epv->gl_s_shade; //%"Sunshade leaf-scale stomatal conductance" $\\left[\\ms^{-1} \\right]$ "rnykos oldal levlszintu sztma-vezetokpessge" $\\left[\\ms^{-1} \\right]$ "Sunshade leaf-scale stomatal conductance" %
        output_map[2730] = &epv->gl_e_wv; //%"Leaf conductance to evaporated water" $\\left[\\ms^{-1} \\right]$ "Levlszintu transzspricis vezetokpessg (napfnyes levlldal)" $\\left[\\ms^{-1} \\right]$ "Leaf conductance to evaporated water" %
        output_map[2731] = &epv->gl_sh; //%"Leaf conductance to sensible heat" $\\left[\\ms^{-1} \\right]$ "Levlszintu transzspricis vezetokpessg rnykos levlldal)" $\\left[\\ms^{-1} \\right]$ "Leaf conductance to sensible heat" %
        output_map[2732] = &epv->gc_e_wv; //%"Canopy conductance to evaporated water" $\\left[\\ms^{-1} \\right]$ "Levlfelleti egysgre vettett asszimilci (napfnyes levlldal)" $\\left[\\ms^{-1} \\right]$ "Canopy conductance to evaporated water" %
        output_map[2733] = &epv->gc_sh; //%"Canopy conductance to sensible heat" $\\left[\\ms^{-1} \\right]$ "Levlfelleti egysgre vettett asszimilci (rnykolt levlldal)" $\\left[\\ms^{-1} \\right]$ "Canopy conductance to sensible heat" %
        output_map[2734] = &epv->annmax_lai; //%"Year-to-date maximum projected leaf area index" $\\left[\\m^{2}m^{-2} \\right]$ "Maximlis levlfelleti index vrol vre" $\\left[\\m^{2}m^{-2} \\right]$ "Year-to-date maximum projected leaf area index" %
	    output_map[2735] = &epv->IMMOBratio[0]; //%"Immobilization ratio in soil layer 1 (0-3 cm)" $\\left[flag\\right]$ "Immobilizci arny az 1. talajrtegben (0-3 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 1 (0-3 cm)" %
        output_map[2736] = &epv->IMMOBratio[1]; //%"Immobilization ratio in soil layer 2 (3-10 cm)" $\\left[flag\\right]$ "Immobilizci arny a 2. talajrtegben (3-10 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 2 (3-10 cm)" %
        output_map[2737] = &epv->IMMOBratio[2]; //%"Immobilization ratio in soil layer 3 (10-30 cm)" $\\left[flag\\right]$ "Immobilizcis arny a 3. talajrtegben (10-30 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 3 (10-30 cm)" %
        output_map[2738] = &epv->IMMOBratio[3]; //%"Immobilization ratio in soil layer 4 (30-60 cm)" $\\left[flag\\right]$ "Immobilizcis arny a 4. talajrtegben (30-60 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 4 (30-60 cm)" %
        output_map[2739] = &epv->IMMOBratio[4]; //%"Immobilization ratio in soil layer 5 (60-90 cm)" $\\left[flag\\right]$ "Immobilizcis arny az 5. talajrtegben (60-90 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 5 (60-90 cm)" %
        output_map[2740] = &epv->IMMOBratio[5]; //%"Immobilization ratio in soil layer 6 (90-120 cm)" $\\left[flag\\right]$ "Immobilizcis arny a 6. talajrtegben (90-120 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 6 (90-120 cm)" %
        output_map[2741] = &epv->IMMOBratio[6]; //%"Immobilization ratio in soil layer 7 (120-150 cm)" $\\left[flag\\right]$ "Immobilizcis arny a 7. talajrtegben (120-150 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 7 (120-150 cm)" %
        output_map[2742] = &epv->IMMOBratio[7]; //%"Immobilization ratio in soil layer 8 (150-200 cm)" $\\left[flag\\right]$ "Immobilizcis arny a 8. talajrtegben (150-200 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 8 (150-200 cm)" %
        output_map[2743] = &epv->IMMOBratio[8]; //%"Immobilization ratio in soil layer 9 (200-400 cm)" $\\left[flag\\right]$ "Immobilizcis arny az 9. talajrtegben (200-400 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 9 (200-400 cm)" %
        output_map[2744] = &epv->IMMOBratio[9]; //%"Immobilization ratio in soil layer 9 (400-1000 cm)" $\\left[flag\\right]$ "Immobilizcis arny az 9. talajrtegben (400-1000 cm)" $\\left[flag\\right]$ "Immobilization ratio in soil layer 9 (200-400 cm)" %
		output_map[2745] = &epv->plantCalloc; //%"Amount of allocated C" $\\left[\\kg_{C}m^{-2} \\right]$ "Alloklt C mennyisg" $\\left[\\kg_{C}m^{-2} \\right]$ "Amount of allocated C" %
        output_map[2746] = &epv->plantNalloc; //%"Amount of allocated N" $\\left[\\kg_{N}m^{-2} \\right]$ "Alloklt N mennyisg" $\\left[\\kg_{N}m^{-2} \\right]$ "Amount of allocated N" %
        output_map[2747] = &epv->excess_c; //%"Difference between available and allocated C" $\\left[\\kg_{C}m^{-2} \\right]$ "Az elrheto s alloklt C mennyisg klnbsge" $\\left[\\kg_{C}m^{-2} \\right]$ "Difference between available and allocated C" %
        output_map[2748] = &epv->pnow; //%"Proportion of growth displayed on current day" $\\left[prop\\right]$ "A beplo asszimillt anyag arnya" $\\left[rszarny\\right]$ "Proportion of growth displayed on current day" %
     	output_map[2751] = &epv->plantNdemand; //%"Amount of plant N demand" $\\left[\\kg_{N}m^{-2} \\right]$ "Nvnyi N szksglet" $\\left[\\kg_{N}m^{-2} \\right]$ "Amount of plant N demand" %
		output_map[2752] = &epv->assim_Tcoeff; //%"Maximum temperature limitation factor of photosynthesis" $\\left[dimless\\right]$ "A maximum homrsklet limitl tnyezoje a fotoszintzisre vonatkozan" $\\left[dimless\\right]$ "Maximum temperature limitation factor of photosynthesis" %
		output_map[2753] = &epv->assim_WScoeff; //%"Soil moisture stress limitation factor of photosynthesis" $\\left[dimless\\right]$ "A talajnedvssg-stress limitl tnyezoje a fotoszintzisre vonatkozan" $\\left[dimless\\right]$ "Soil moisture stress limitation factor of photosynthesis" %
		output_map[2754] = &epv->cumNS; //%"Cumulative soil N stress" $\\left[n\\right]$ "Kumulatv N-stressz" $\\left[db\\right]$ "Cumulative soil N stress" %
  		output_map[2755] = &epv->WSlenght; //%"Limitiation factor of SWC-stress length" $\\left[\\dimless$C$\\right]$ "Az SWC-stressz hossznak limitcis egytthatja" $\\left[\\dimless$C$\\right]$ "Limitiation of SWC-stress length" %
		output_map[2756] = &epv->WFPS[0]; //%"Water filled pore spaceof soil layer 1 (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustraz 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 1 (0-3 cm)" %
        output_map[2757] = &epv->WFPS[1]; //%"Water filled pore spaceof soil layer 2 (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustra 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 2 (3-10 cm)" %
        output_map[2758] = &epv->WFPS[2]; //%"Water filled pore spaceof soil layer 3 (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustra 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 3 (10-30 cm)" %
        output_map[2759] = &epv->WFPS[3]; //%"Water filled pore spaceof soil layer 4 (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustra 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 4 (30-60 cm)" %
        output_map[2760] = &epv->WFPS[4]; //%"Water filled pore spaceof soil layer 5 (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustraz 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 5 (60-90 cm)" %
        output_map[2761] = &epv->WFPS[5]; //%"Water filled pore spaceof soil layer 6 (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustra 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 6 (90-120 cm)" %
        output_map[2762] = &epv->WFPS[6]; //%"Water filled pore spaceof soil layer 7 (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustra 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 7 (120-150 cm)" %
        output_map[2763] = &epv->WFPS[7]; //%"Water filled pore spaceof soil layer 8 (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustra 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 8 (150-200 cm)" %
        output_map[2764] = &epv->WFPS[8]; //%"Water filled pore spaceof soil layer 9 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustraz 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 9 (200-400 cm)" %
        output_map[2765] = &epv->WFPS[9]; //%"Water filled pore spaceof soil layer 10 (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Vzzel tlttt prustra 10. talajrtegben (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Water filled pore spaceof soil layer 10 (400-1000 cm)" %
		output_map[2766] = &epv->ws_nitrif[0]; //%"Nitrification water filled pore space scalar in soil layer 1 (0-3 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja az 1. talajrtegben (0-3 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 1 (0-3 cm)" %
        output_map[2767] = &epv->ws_nitrif[1]; //%"Nitrification water filled pore space scalar in soil layer 2 (3-10 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja a 2. talajrtegben (3-10 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 2 (3-10 cm)" %
        output_map[2768] = &epv->ws_nitrif[2]; //%"Nitrification water filled pore space scalar in soil layer 3 (10-30 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja a 3. talajrtegben (10-30 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 3 (10-30 cm)" %
        output_map[2769] = &epv->ws_nitrif[3]; //%"Nitrification water filled pore space scalar in soil layer 4 (30-60 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja a 4. talajrtegben (30-60 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 4 (30-60 cm)" %
        output_map[2770] = &epv->ws_nitrif[4]; //%"Nitrification water filled pore space scalar in soil layer 5 (60-90 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja az 5. talajrtegben (60-90 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 5 (60-90 cm)" %
        output_map[2771] = &epv->ws_nitrif[5]; //%"Nitrification water filled pore space scalar in soil layer 6 (90-120 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja a 6. talajrtegben (90-120 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 6 (90-120 cm)" %
        output_map[2772] = &epv->ws_nitrif[6]; //%"Nitrification water filled pore space scalar in soil layer 7 (120-150 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja a 7. talajrtegben (120-150 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 7 (120-150 cm)" %
        output_map[2773] = &epv->ws_nitrif[7]; //%"Nitrification water filled pore space scalar in soil layer 8 (150-200 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja a 8. talajrtegben (150-200 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 8 (150-200 cm)" %
        output_map[2774] = &epv->ws_nitrif[8]; //%"Nitrification water filled pore space scalar in soil layer 9 (200-400 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja az 9. talajrtegben (200-400 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 9 (200-400 cm)" %
        output_map[2775] = &epv->ws_nitrif[9]; //%"Nitrification water filled pore space scalar in soil layer 10 (400-1000 cm)" $\\left[dimless\\right]$ "Nitrifikci vzzel tlttt prus tr skalrja a 10. talajrtegben (400-1000 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 10 (400-1000 cm)"
		output_map[2776] = &epv->ps_nitrif[0]; //%"Nitrification pH response function in soil layer 1 (0-3 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja az 1. talajrtegben (0-3 cm)" $\\left[dimless\\right]$ "Nitrification pH response function in soil layer 1 (0-3 cm)" %
        output_map[2777] = &epv->ps_nitrif[1]; //%"Nitrification pH response function in soil layer 2 (3-10 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja a 2. talajrtegben (3-10 cm)" $\\left[dimless\\right]$ "Nitrification pH response function in soil layer 2 (3-10 cm)" %
        output_map[2778] = &epv->ps_nitrif[2]; //%"Nitrification pH response function in soil layer 3 (10-30 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja a 3. talajrtegben (10-30 cm)" $\\left[dimless\\right]$ "Nitrification pH response function in soil layer 3 (10-30 cm)" %
        output_map[2779] = &epv->ps_nitrif[3]; //%"Nitrification pH response function in soil layer 4 (30-60 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja a 4. talajrtegben (30-60 cm)" $\\left[dimless\\right]$ "Nitrification pH response function in soil layer 4 (30-60 cm)" %
        output_map[2780] = &epv->ps_nitrif[4]; //%"Nitrification pH response function in soil layer 5 (60-90 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja az 5. talajrtegben (60-90 cm)" $\\left[dimless\\right]$ "Nitrification pH response function in soil layer 5 (60-90 cm)" %
        output_map[2781] = &epv->ps_nitrif[5]; //%"Nitrification pH response function in soil layer 6 (90-120 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja a 6. talajrtegben (90-120 cm)" $\\left[dimless\\right]$ "Nitrification pH response function in soil layer 6 (90-120 cm)" %
        output_map[2782] = &epv->ps_nitrif[6]; //%"Nitrification pH response function in soil layer 7 (120-150 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja a 7. talajrtegben (120-150 cm)" $\\left[dimless\\right]$ "Nitrification water filled pore space scalar in soil layer 7 (120-150 cm)" %
        output_map[2783] = &epv->ps_nitrif[7]; //%"Nitrification pH response function in soil layer 8 (150-200 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja a 8. talajrtegben (150-200 cm)" $\\left[dimless\\right]$ "Nitrification pH response function in soil layer 8 (150-200 cm)" %
        output_map[2784] = &epv->ps_nitrif[8]; //%"Nitrification pH response function in soil layer 9 (200-400 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja az 9. talajrtegben (200-400 cm)" $\\left[dimless\\right]$ "Nitrification pH response function in soil layer 9 (200-400 cm)" %
        output_map[2785] = &epv->ps_nitrif[9]; //%"Nitrification pH response function in soil layer 10 (400-1000 cm)" $\\left[dimless\\right]$ "Nitrifikci pH skalrja a 10. talajrtegben (400-1000 cm)" $\\left[dimless\\right]$ "Nitrification pH response function in soil layer 10 (400-1000 cm)"
        output_map[2786] = &epv->phenphase_date[0]; //%"First day of the phenphase1" $\\left[dimless\\right]$ "Az 1. fenofzis elso napja" $\\left[dimless\\right]$ "First day of the phenphase1" %
        output_map[2787] = &epv->phenphase_date[1]; //%"First day of the phenphase2" $\\left[dimless\\right]$ "Az 1. fenofzis elso napja" $\\left[dimless\\right]$ "First day of the phenphase2" %
        output_map[2788] = &epv->phenphase_date[2]; //%"First day of the phenphase3" $\\left[dimless\\right]$ "Az 1. fenofzis elso napja" $\\left[dimless\\right]$ "First day of the phenphase3" %
        output_map[2789] = &epv->phenphase_date[3]; //%"First day of the phenphase4" $\\left[dimless\\right]$ "Az 1. fenofzis elso napja" $\\left[dimless\\right]$ "First day of the phenphase4" %
        output_map[2790] = &epv->phenphase_date[4]; //%"First day of the phenphase5" $\\left[dimless\\right]$ "Az 1. fenofzis elso napja" $\\left[dimless\\right]$ "First day of the phenphase5" %
        output_map[2791] = &epv->phenphase_date[5]; //%"First day of the phenphase6" $\\left[dimless\\right]$ "Az 1. fenofzis elso napja" $\\left[dimless\\right]$ "First day of the phenphase6" %
        output_map[2792] = &epv->phenphase_date[6]; //%"First day of the phenphase7" $\\left[dimless\\right]$ "Az 1. fenofzis elso napja" $\\left[dimless\\right]$ "First day of the phenphase7" %
		output_map[2793] = &epv->WPM; //%"Daily whole plant mortality value" $\\left[dimless\\right]$ "Az ltalnos pusztulsi egytthat aktulis napi rtke" $\\left[dimless\\right]$ "Whole plant mortality value on actual day" %
        output_map[2794] = &epv->flower_date; //%"Start of flowering phenophase" $\\left[day of year\\right]$ "Virgzsi fenofzis kezdete" $\\left[v napja\\right]$ "Start of flowering phenophase" %
		output_map[2795] = &epv->SCpercent; //%"Percent of soil coverage" $\\left[%\\right]$ "A mulcs lefedettsgi szzalka" $\\left[%\\right]$ "Percent of mulch coverage" %
		output_map[2796] = &epv->SC_EVPred; //%"evaporation reduction of soil cover" $\\left[dimless\\right]$ "A talajtakar prolgsszablyoz hatsa" $\\left[dimless\\right]$ "evaporation reduction of soil cover" %	
        output_map[2797] = &epv->projLAI_STDB; //%"Standing dead projected leaf area index" $\\left[\\m^2m^{-2} \\right]$ "Lbon ll elhalt biomassza levlfelleti indexe" $\\left[\\m^2m^{-2} \\right]$ "Standing dead projected leaf area index" %


        output_map[2800] = &sprop->RCN; //%"Runoff curve number" $\\left[m\\right]$ "Elfolysi grbe rtke" $\\left[m\\right]$ "Runoff curve number" %
		output_map[2801] = &sprop->soilB[0]; //%"Clapp-Hornberger ""b"" parameter in soil layer 1 (0-3 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter az 1. talajrtegben (0-3 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 1 (0-3 cm)" %
        output_map[2802] = &sprop->soilB[1]; //%"Clapp-Hornberger ""b"" parameter in soil layer 2 (3-10 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter a 2. talajrtegben (3-10 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 2 (3-10 cm)" %
        output_map[2803] = &sprop->soilB[2]; //%"Clapp-Hornberger ""b"" parameter in soil layer 3 (10-30 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter a 3. talajrtegben (10-30 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 3 (10-30 cm)" %
        output_map[2804] = &sprop->soilB[3]; //%"Clapp-Hornberger ""b"" parameter in soil layer 4 (30-60 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter a 4. talajrtegben (30-60 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 4 (30-60 cm)" %
        output_map[2805] = &sprop->soilB[4]; //%"Clapp-Hornberger ""b"" parameter in soil layer 5 (60-90 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter az 5. talajrtegben (60-90 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 5 (60-90 cm)" %
        output_map[2806] = &sprop->soilB[5]; //%"Clapp-Hornberger ""b"" parameter in soil layer 6 (90-120 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter a 6. talajrtegben (90-120 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 6 (90-120 cm)" %
        output_map[2807] = &sprop->soilB[6]; //%"Clapp-Hornberger ""b"" parameter in soil layer 7 (120-150 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter a 7. talajrtegben (120-150 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 7 (120-150 cm)" %
        output_map[2808] = &sprop->soilB[7]; //%"Clapp-Hornberger ""b"" parameter in soil layer 8 (150-200 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter a 8. talajrtegben (150-200 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 8 (150-200 cm)" %
        output_map[2809] = &sprop->soilB[8]; //%"Clapp-Hornberger ""b"" parameter in soil layer 9 (200-400 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter az 9. talajrtegben (200-400 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 9 (200-400 cm)" %
        output_map[2810] = &sprop->soilB[9]; //%"Clapp-Hornberger ""b"" parameter in soil layer 10 (400-1000 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger "b" paramter a 10. talajrtegben (400-1000 cm)" $\\left[dimless\\right]$ "Clapp-Hornberger ""b"" parameter in soil layer 10 (400-1000 cm)" %
        output_map[2811] = &sprop->BD[0]; //%"Bulk density in soil layer 1 (0-3 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg az 1. talajrtegben (0-3 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 1 (0-3 cm)" %
        output_map[2812] = &sprop->BD[1]; //%"Bulk density in soil layer 2 (3-10 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg a 2. talajrtegben (3-10 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 2 (3-10 cm)" %
        output_map[2813] = &sprop->BD[2]; //%"Bulk density in soil layer 3 (10-30 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg a 3. talajrtegben (10-30 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 3 (10-30 cm)" %
        output_map[2814] = &sprop->BD[3]; //%"Bulk density in soil layer 4 (30-60 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg a 4. talajrtegben (30-60 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 4 (30-60 cm)" %
        output_map[2815] = &sprop->BD[4]; //%"Bulk density in soil layer 5 (60-90 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg az 5. talajrtegben (60-90 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 5 (60-90 cm)" %
        output_map[2816] = &sprop->BD[5]; //%"Bulk density in soil layer 6 (90-120 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg a 6. talajrtegben (90-120 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 6 (90-120 cm)" %
        output_map[2817] = &sprop->BD[6]; //%"Bulk density in soil layer 7 (120-150 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg a 7. talajrtegben (120-150 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 7 (120-150 cm)" %
        output_map[2818] = &sprop->BD[7]; //%"Bulk density in soil layer 8 (150-200 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg a 8. talajrtegben (150-200 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 8 (150-200 cm)" %
        output_map[2819] = &sprop->BD[8]; //%"Bulk density in soil layer 9 (200-400 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg az 9. talajrtegben (200-400 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 9 (200-400 cm)" %
        output_map[2820] = &sprop->BD[9]; //%"Bulk density in soil layer 10 (400-1000 cm)" $\\left[\\kgm^{-3} \\right]$ "Trfogati surusg a 10. talajrtegben (400-1000 cm)" $\\left[\\gm^{-3} \\right]$ "Bulk density in soil layer 10 (400-1000 cm)" %
        output_map[2821] = &sprop->VWCsat[0]; //%"Volumetric water content at saturation in soil layer 1 (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom az 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 1 (0-3 cm)" %
        output_map[2822] = &sprop->VWCsat[1]; //%"Volumetric water content at saturation in soil layer 2 (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom a 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 2 (3-10 cm)" %
        output_map[2823] = &sprop->VWCsat[2]; //%"Volumetric water content at saturation in soil layer 3 (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom a 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 3 (10-30 cm)" %
        output_map[2824] = &sprop->VWCsat[3]; //%"Volumetric water content at saturation in soil layer 4 (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom a 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 4 (30-60 cm)" %
        output_map[2825] = &sprop->VWCsat[4]; //%"Volumetric water content at saturation in soil layer 5 (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom az 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 5 (60-90 cm)" %
        output_map[2826] = &sprop->VWCsat[5]; //%"Volumetric water content at saturation in soil layer 6 (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom a 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 6 (90-120 cm)" %
        output_map[2827] = &sprop->VWCsat[6]; //%"Volumetric water content at saturation in soil layer 7 (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom a 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 7 (120-150 cm)" %
        output_map[2828] = &sprop->VWCsat[7]; //%"Volumetric water content at saturation in soil layer 8 (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom a 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 8 (150-200 cm)" %
        output_map[2829] = &sprop->VWCsat[8]; //%"Volumetric water content at saturation in soil layer 9 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 9 (200-400 cm)" %
        output_map[2830] = &sprop->VWCsat[9]; //%"Volumetric water content at saturation in soil layer 10 (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Teltsi trfogati vztartalom a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at saturation in soil layer 10 (400-1000 cm)" %
        output_map[2831] = &sprop->VWCfc[0]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 1 (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom az 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 1 (0-3 cm)" %
        output_map[2832] = &sprop->VWCfc[1]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 2 (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom a 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 2 (3-10 cm)" %
        output_map[2833] = &sprop->VWCfc[2]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 3 (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom a 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 3 (10-30 cm)" %
        output_map[2834] = &sprop->VWCfc[3]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 4 (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom a 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 4 (30-60 cm)" %
        output_map[2835] = &sprop->VWCfc[4]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 5 (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom az 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 5 (60-90 cm)" %
        output_map[2836] = &sprop->VWCfc[5]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 6 (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom a 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 6 (90-120 cm)" %
        output_map[2837] = &sprop->VWCfc[6]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 7 (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom a 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 7 (120-150 cm)" %
        output_map[2838] = &sprop->VWCfc[7]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 8 (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom a 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 8 (150-200 cm)" %
        output_map[2839] = &sprop->VWCfc[8]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 9 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 9 (200-400 cm)" %
        output_map[2840] = &sprop->VWCfc[9]; //%"Volumetric water content at field capacity (=-0.033 MPa) in soil layer 10 (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Szabadfldi vzkapacits trfogati vztartalom a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at field capacity (=-0.033 MPa) in soil layer 10 (400-1000 cm)" %
        output_map[2841] = &sprop->VWCwp[0]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 1 (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom az 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 1 (0-3 cm)" %
        output_map[2842] = &sprop->VWCwp[1]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 2 (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom a 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 2 (3-10 cm)" %
        output_map[2843] = &sprop->VWCwp[2]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 3 (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom a 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 3 (10-30 cm)" %
        output_map[2844] = &sprop->VWCwp[3]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 4 (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom a 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 4 (30-60 cm)" %
        output_map[2845] = &sprop->VWCwp[4]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 5 (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom az 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 5 (60-90 cm)" %
        output_map[2846] = &sprop->VWCwp[5]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 6 (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom a 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 6 (90-120 cm)" %
        output_map[2847] = &sprop->VWCwp[6]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 7 (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom a 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 7 (120-150 cm)" %
        output_map[2848] = &sprop->VWCwp[7]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 8 (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom a 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 8 (150-200 cm)" %
        output_map[2849] = &sprop->VWCwp[8]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 9 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 9 (200-400 cm)" %
        output_map[2850] = &sprop->VWCwp[9]; //%"Volumetric water content at wilting point (= pF 4.2) in soil layer 10 (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Hervadspont trfogati vztartalom a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at wilting point (= pF 4.2) in soil layer 10 (400-1000 cm)" %
        output_map[2851] = &sprop->VWChw[0]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 1 (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom az 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 1 (0-3 cm)" %
        output_map[2852] = &sprop->VWChw[1]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 2 (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom a 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 2 (3-10 cm)" %
        output_map[2853] = &sprop->VWChw[2]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 3 (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom a 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 3 (10-30 cm)" %
        output_map[2854] = &sprop->VWChw[3]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 4 (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom a 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 4 (30-60 cm)" %
        output_map[2855] = &sprop->VWChw[4]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 5 (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom az 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 5 (60-90 cm)" %
        output_map[2856] = &sprop->VWChw[5]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 6 (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom a 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 6 (90-120 cm)" %
        output_map[2857] = &sprop->VWChw[6]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 7 (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom a 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 7 (120-150 cm)" %
        output_map[2858] = &sprop->VWChw[7]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 8 (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom a 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 8 (150-200 cm)" %
        output_map[2859] = &sprop->VWChw[8]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 9 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 9 (200-400 cm)" %
        output_map[2860] = &sprop->VWChw[9]; //%"Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 10 (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Higroszkopikus pont trfogati vztartalom a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at hygroscopic water point (= pF 6.2) in soil layer 10 (400-1000 cm)" %
        output_map[2861] = &sprop->PSIsat[0]; //%"Soil matric potential at saturation in soil layer 1 (0-3 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil az 1. talajrtegben (0-3 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 1 (0-3 cm)" %
        output_map[2862] = &sprop->PSIsat[1]; //%"Soil matric potential at saturation in soil layer 2 (3-10 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil a 2. talajrtegben (3-10 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 2 (3-10 cm)" %
        output_map[2863] = &sprop->PSIsat[2]; //%"Soil matric potential at saturation in soil layer 3 (10-30 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil a 3. talajrtegben (10-30 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 3 (10-30 cm)" %
        output_map[2864] = &sprop->PSIsat[3]; //%"Soil matric potential at saturation in soil layer 4 (30-60 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil a 4. talajrtegben (30-60 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 4 (30-60 cm)" %
        output_map[2865] = &sprop->PSIsat[4]; //%"Soil matric potential at saturation in soil layer 5 (60-90 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil az 5. talajrtegben (60-90 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 5 (60-90 cm)" %
        output_map[2866] = &sprop->PSIsat[5]; //%"Soil matric potential at saturation in soil layer 6 (90-120 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil a 6. talajrtegben (90-120 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 6 (90-120 cm)" %
        output_map[2867] = &sprop->PSIsat[6]; //%"Soil matric potential at saturation in soil layer 7 (120-150 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil a 7. talajrtegben (120-150 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 7 (120-150 cm)" %
        output_map[2868] = &sprop->PSIsat[7]; //%"Soil matric potential at saturation in soil layer 8 (150-200 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil a 8. talajrtegben (150-200 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 8 (150-200 cm)" %
        output_map[2869] = &sprop->PSIsat[8]; //%"Soil matric potential at saturation in soil layer 9 (200-400 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil az 9. talajrtegben (200-400 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 9 (200-400 cm)" %
        output_map[2870] = &sprop->PSIsat[9]; //%"Soil matric potential at saturation in soil layer 10 (400-1000 cm)" $\\left[\\MPa \\right]$ "Teltsi talaj mtrix potencil a 10. talajrtegben (400-1000 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at saturation in soil layer 10 (400-1000 cm)" %
        output_map[2871] = &sprop->PSIfc[0]; //%"Soil matric potential at field capacity in soil layer 1 (0-3 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil az 1. talajrtegben (0-3 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 1 (0-3 cm)" %
        output_map[2872] = &sprop->PSIfc[1]; //%"Soil matric potential at field capacity in soil layer 2 (3-10 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil a 2. talajrtegben (3-10 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 2 (3-10 cm)" %
        output_map[2873] = &sprop->PSIfc[2]; //%"Soil matric potential at field capacity in soil layer 3 (10-30 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil a 3. talajrtegben (10-30 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 3 (10-30 cm)" %
        output_map[2874] = &sprop->PSIfc[3]; //%"Soil matric potential at field capacity in soil layer 4 (30-60 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil a 4. talajrtegben (30-60 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 4 (30-60 cm)" %
        output_map[2875] = &sprop->PSIfc[4]; //%"Soil matric potential at field capacity in soil layer 5 (60-90 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil az 5. talajrtegben (60-90 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 5 (60-90 cm)" %
        output_map[2876] = &sprop->PSIfc[5]; //%"Soil matric potential at field capacity in soil layer 6 (90-120 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil a 6. talajrtegben (90-120 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 6 (90-120 cm)" %
        output_map[2877] = &sprop->PSIfc[6]; //%"Soil matric potential at field capacity in soil layer 7 (120-150 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil a 7. talajrtegben (120-150 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 7 (120-150 cm)" %
        output_map[2878] = &sprop->PSIfc[7]; //%"Soil matric potential at field capacity in soil layer 8 (150-200 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil a 8. talajrtegben (150-200 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 8 (150-200 cm)" %
        output_map[2879] = &sprop->PSIfc[8]; //%"Soil matric potential at field capacity in soil layer 9 (200-400 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil az 9. talajrtegben (200-400 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 9 (200-400 cm)" %
        output_map[2880] = &sprop->PSIfc[9]; //%"Soil matric potential at field capacity in soil layer 10 (400-1000 cm)" $\\left[\\MPa \\right]$ "Szabadfldi vzkapacits talaj mtrix potencil a 10. talajrtegben (400-1000 cm)" $\\left[\\MPa \\right]$ "Soil matric potential at field capacity in soil layer 10 (400-1000 cm)" %
        output_map[2881] = &sprop->VWCeq[0]; //%"Volumetric water content at equilibrium in soil layer 1 (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom az 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 1 (0-3 cm)" %
        output_map[2882] = &sprop->VWCeq[1]; //%"Volumetric water content at equilibrium in soil layer 2 (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom a 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 2 (3-10 cm)" %
        output_map[2883] = &sprop->VWCeq[2]; //%"Volumetric water content at equilibrium in soil layer 3 (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom a 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 3 (10-30 cm)" %
        output_map[2884] = &sprop->VWCeq[3]; //%"Volumetric water content at equilibrium in soil layer 4 (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom a 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 4 (30-60 cm)" %
        output_map[2885] = &sprop->VWCeq[4]; //%"Volumetric water content at equilibrium in soil layer 5 (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom az 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 5 (60-90 cm)" %
        output_map[2886] = &sprop->VWCeq[5]; //%"Volumetric water content at equilibrium in soil layer 6 (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom a 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 6 (90-120 cm)" %
        output_map[2887] = &sprop->VWCeq[6]; //%"Volumetric water content at equilibrium in soil layer 7 (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom a 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 7 (120-150 cm)" %
        output_map[2888] = &sprop->VWCeq[7]; //%"Volumetric water content at equilibrium in soil layer 8 (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom a 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 8 (150-200 cm)" %
        output_map[2889] = &sprop->VWCeq[8]; //%"Volumetric water content at equilibrium in soil layer 9 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 9 (200-400 cm)" %
        output_map[2890] = &sprop->VWCeq[9]; //%"Volumetric water content at equilibrium in soil layer 10 (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Egyenslyi talajnedvessg trfogati vztartalom az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}m^{-3} \\right]$ "Volumetric water content at equilibrium in soil layer 9 (200-400 cm)" %
        output_map[2891] = &sprop->hydrCONDUCTsat[0]; //%"Hidraulic conductivity at saturation in soil layer 1 (0-3 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets az 1. talajrtegben (0-3 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 1 (0-3 cm)" %
        output_map[2892] = &sprop->hydrCONDUCTsat[1]; //%"Hidraulic conductivity at saturation in soil layer 2 (3-10 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets a 2. talajrtegben (3-10 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 2 (3-10 cm)" %
        output_map[2893] = &sprop->hydrCONDUCTsat[2]; //%"Hidraulic conductivity at saturation in soil layer 3 (10-30 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets a 3. talajrtegben (10-30 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 3 (10-30 cm)" %
        output_map[2894] = &sprop->hydrCONDUCTsat[3]; //%"Hidraulic conductivity at saturation in soil layer 4 (30-60 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets a 4. talajrtegben (30-60 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 4 (30-60 cm)" %
        output_map[2895] = &sprop->hydrCONDUCTsat[4]; //%"Hidraulic conductivity at saturation in soil layer 5 (60-90 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets az 5. talajrtegben (60-90 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 5 (60-90 cm)" %
        output_map[2896] = &sprop->hydrCONDUCTsat[5]; //%"Hidraulic conductivity at saturation in soil layer 6 (90-120 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets a 6. talajrtegben (90-120 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 6 (90-120 cm)" %
        output_map[2897] = &sprop->hydrCONDUCTsat[6]; //%"Hidraulic conductivity at saturation in soil layer 7 (120-150 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets a 7. talajrtegben (120-150 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 7 (120-150 cm)" %
        output_map[2898] = &sprop->hydrCONDUCTsat[7]; //%"Hidraulic conductivity at saturation in soil layer 8 (150-200 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets a 8. talajrtegben (150-200 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 8 (150-200 cm)" %
        output_map[2899] = &sprop->hydrCONDUCTsat[8]; //%"Hidraulic conductivity at saturation in soil layer 9 (200-400 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets az 9. talajrtegben (200-400 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 9 (200-400 cm)" %
        output_map[2900] = &sprop->hydrCONDUCTsat[9]; //%"Hidraulic conductivity at saturation in soil layer 10 (400-1000 cm)" $\\left[\\ms^{-1} \\right]$ "Teltsi hidraulikus vezets a 10. talajrtegben (400-1000 cm)" $\\left[\\ms^{-1} \\right]$ "Hidraulic conductivity at saturation in soil layer 10 (400-1000 cm)" %
        output_map[2901] = &sprop->hydrDIFFUSsat[0]; //%"Hidraulic diffusivity at saturation in soil layer 1 (0-3 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits az 1. talajrtegben (0-3 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 1 (0-3 cm)" %
        output_map[2902] = &sprop->hydrDIFFUSsat[1]; //%"Hidraulic diffusivity at saturation in soil layer 2 (3-10 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits a 2. talajrtegben (3-10 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 2 (3-10 cm)" %
        output_map[2903] = &sprop->hydrDIFFUSsat[2]; //%"Hidraulic diffusivity at saturation in soil layer 3 (10-30 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits a 3. talajrtegben (10-30 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 3 (10-30 cm)" %
        output_map[2904] = &sprop->hydrDIFFUSsat[3]; //%"Hidraulic diffusivity at saturation in soil layer 4 (30-60 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits a 4. talajrtegben (30-60 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 4 (30-60 cm)" %
        output_map[2905] = &sprop->hydrDIFFUSsat[4]; //%"Hidraulic diffusivity at saturation in soil layer 5 (60-90 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits az 5. talajrtegben (60-90 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 5 (60-90 cm)" %
        output_map[2906] = &sprop->hydrDIFFUSsat[5]; //%"Hidraulic diffusivity at saturation in soil layer 6 (90-120 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits a 6. talajrtegben (90-120 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 6 (90-120 cm)" %
        output_map[2907] = &sprop->hydrDIFFUSsat[6]; //%"Hidraulic diffusivity at saturation in soil layer 7 (120-150 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits a 7. talajrtegben (120-150 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 7 (120-150 cm)" %
        output_map[2908] = &sprop->hydrDIFFUSsat[7]; //%"Hidraulic diffusivity at saturation in soil layer 8 (150-200 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits a 8. talajrtegben (150-200 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 8 (150-200 cm)" %
        output_map[2909] = &sprop->hydrDIFFUSsat[8]; //%"Hidraulic diffusivity at saturation in soil layer 9 (200-400 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits az 9. talajrtegben (200-400 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 9 (200-400 cm)" %
        output_map[2910] = &sprop->hydrDIFFUSsat[9]; //%"Hidraulic diffusivity at saturation in soil layer 10 (400-1000 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Teltsi hidraulikus diffuzivits a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at saturation in soil layer 10 (400-1000 cm)" %
        output_map[2911] = &sprop->hydrCONDUCTfc[0]; //%"Hidraulic conductivity at field capacity in soil layer 1 (0-3 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets az 1. talajrtegben (0-3 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 1 (0-3 cm)" %
        output_map[2912] = &sprop->hydrCONDUCTfc[1]; //%"Hidraulic conductivity at field capacity in soil layer 2 (3-10 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets a 2. talajrtegben (3-10 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 2 (3-10 cm)" %
        output_map[2913] = &sprop->hydrCONDUCTfc[2]; //%"Hidraulic conductivity at field capacity in soil layer 3 (10-30 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets a 3. talajrtegben (10-30 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 3 (10-30 cm)" %
        output_map[2914] = &sprop->hydrCONDUCTfc[3]; //%"Hidraulic conductivity at field capacity in soil layer 4 (30-60 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets a 4. talajrtegben (30-60 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 4 (30-60 cm)" %
        output_map[2915] = &sprop->hydrCONDUCTfc[4]; //%"Hidraulic conductivity at field capacity in soil layer 5 (60-90 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets az 5. talajrtegben (60-90 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 5 (60-90 cm)" %
        output_map[2916] = &sprop->hydrCONDUCTfc[5]; //%"Hidraulic conductivity at field capacity in soil layer 6 (90-120 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets a 6. talajrtegben (90-120 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 6 (90-120 cm)" %
        output_map[2917] = &sprop->hydrCONDUCTfc[6]; //%"Hidraulic conductivity at field capacity in soil layer 7 (120-150 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets a 7. talajrtegben (120-150 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 7 (120-150 cm)" %
        output_map[2918] = &sprop->hydrCONDUCTfc[7]; //%"Hidraulic conductivity at field capacity in soil layer 8 (150-200 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets a 8. talajrtegben (150-200 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 8 (150-200 cm)" %
        output_map[2919] = &sprop->hydrCONDUCTfc[8]; //%"Hidraulic conductivity at field capacity in soil layer 9 (200-400 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets az 9. talajrtegben (200-400 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 9 (200-400 cm)" %
        output_map[2920] = &sprop->hydrCONDUCTfc[9]; //%"Hidraulic conductivity at field capacity in soil layer 10 (400-1000 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus vezets a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{3}s^{-1} \\right]$ "Hidraulic conductivity at field capacity in soil layer 10 (400-1000 cm)" %
        output_map[2921] = &sprop->hydrDIFFUSfc[0]; //%"Hidraulic diffusivity at field capacity in soil layer 1 (0-3 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits az 1. talajrtegben (0-3 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 1 (0-3 cm)" %
        output_map[2922] = &sprop->hydrDIFFUSfc[1]; //%"Hidraulic diffusivity at field capacity in soil layer 2 (3-10 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits a 2. talajrtegben (3-10 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 2 (3-10 cm)" %
        output_map[2923] = &sprop->hydrDIFFUSfc[2]; //%"Hidraulic diffusivity at field capacity in soil layer 3 (10-30 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits a 3. talajrtegben (10-30 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 3 (10-30 cm)" %
        output_map[2924] = &sprop->hydrDIFFUSfc[3]; //%"Hidraulic diffusivity at field capacity in soil layer 4 (30-60 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits a 4. talajrtegben (30-60 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 4 (30-60 cm)" %
        output_map[2925] = &sprop->hydrDIFFUSfc[4]; //%"Hidraulic diffusivity at field capacity in soil layer 5 (60-90 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits az 5. talajrtegben (60-90 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 5 (60-90 cm)" %
        output_map[2926] = &sprop->hydrDIFFUSfc[5]; //%"Hidraulic diffusivity at field capacity in soil layer 6 (90-120 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits a 6. talajrtegben (90-120 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 6 (90-120 cm)" %
        output_map[2927] = &sprop->hydrDIFFUSfc[6]; //%"Hidraulic diffusivity at field capacity in soil layer 7 (120-150 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits a 7. talajrtegben (120-150 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 7 (120-150 cm)" %
        output_map[2928] = &sprop->hydrDIFFUSfc[7]; //%"Hidraulic diffusivity at field capacity in soil layer 8 (150-200 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits a 8. talajrtegben (150-200 cm) " $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 8 (150-200 cm)" %
        output_map[2929] = &sprop->hydrDIFFUSfc[8]; //%"Hidraulic diffusivity at field capacity in soil layer 9 (200-400 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits az 9. talajrtegben (200-400 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 9 (200-400 cm)" %
        output_map[2930] = &sprop->hydrDIFFUSfc[9]; //%"Hidraulic diffusivity at field capacity in soil layer 10 (400-1000 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Szabadfldi vzkapacits hidraulikus diffuzivits a 10. talajrtegben (400-1000 cm)" $\\left[\\m^{2}s^{-1} \\right]$ "Hidraulic diffusivity at field capacity in soil layer 10 (400-1000 cm)" %
        output_map[2931] = &sprop->GWD; //%"Depth of groundwater" $\\left[\\m\\right]$ "Talavztkr mlysge" $\\left[\\m\\right]$ "Depth of groundwater" %
        output_map[2932] = &sprop->CFD; //%"Depth of upper layer of capillary fringe" $\\left[m\\right]$ "A kapillris rteg tetejnek mlysge" $\\left[m\\right]$ "Depth of the upper layer of capillary fringe" %
        output_map[2933] = &sprop->GWlayer; //%"Number of layer containing groundwater table" $\\left[dimless\\right]$ "A talajvztkrt tartalmaz rteg sorszma" $\\left[m\\right]$ "Number of layer containing groundwater table" %
        output_map[2934] = &sprop->CFlayer; //%"Number of layer containing the upper layer of capillary fringe" $\\left[dimless\\right]$ "A kapillris rteg tetejt tartalmaz rteg sorszma" $\\left[m\\right]$ "Number of layer containing upper layer of capillary fringe" %
        output_map[2935] = &sprop->soilw_NORMcf; //%"Soil water content in normal zone of CFlayer" $\\left[m\\right]$
        output_map[2936] = &sprop->soilw_CAPILcf; //%"Soil water content in normal zone of CFlayer" $\\left[m\\right]$
        output_map[2937] = &sprop->soilw_NORMgw; //%"Soil water content in normal zone of GWlayer" $\\left[m\\right]$
        output_map[2938] = &sprop->soilw_CAPILgw; //%"Soil water content in normal zone of GWlayer" $\\left[m\\right]$
        output_map[2939] = &sprop->VWC_NORMcf; //%"Volumetric water content in normal zone of CFlayer" $\\left[m\\right]$
        output_map[2940] = &sprop->VWC_CAPILcf; //%"Volumetric water content in normal zone of CFlayer" $\\left[m\\right]$
        output_map[2941] = &sprop->VWC_NORMgw; //%"Volumetric water content in normal zone of GWlayer" $\\left[m\\right]$
        output_map[2942] = &sprop->VWC_CAPILgw; //%"Volumetric water content in normal zone of GWlayer" $\\left[m\\right]$
        output_map[2943] = &sprop->dz_NORMcf; //%"Thickness of normal zone of CFlayer" $\\left[m\\right]$
        output_map[2944] = &sprop->dz_CAPILcf; //%"Thickness of capillary zone of CFlayer" $\\left[m\\right]$
        output_map[2945] = &sprop->dz_NORMgw; //%"Thickness of normal zone of GWlayer" $\\left[m\\right]$
        output_map[2946] = &sprop->dz_CAPILgw; //%"Thickness of capillary zone of GWlayer" $\\left[m\\right]$
        output_map[2947] = &sprop->dz_SATgw; //%"Thickness of saturated zone of GWlayer" $\\left[m\\right]$
        output_map[2948] = &sprop->balance_NORMcf; //%"Water balance error of normal zone of CFlayer" $\\left[m\\right]$
        output_map[2949] = &sprop->balance_CAPILcf;//%"Water balance error of capillary zone of CFlayer" $\\left[m\\right]$
        output_map[2950] = &sprop->balance_NORMgw;//%"Water balance error of normal zone of GWlayer" $\\left[m\\right]$
        output_map[2951] = &sprop->balance_CAPILgw; //%"Water balance error of capillary zone of GWlayer" $\\left[m\\right]$
   
        output_map[2952] = &psn_sun->co2; //%"Sunlit atmospheric CO2 conc." $\\left[\\ppm \\right]$ "Lgkri CO2 koncentrci napon" $\\left[\\ppm \\right]$ "Sunlit atmospheric CO2 conc." %
        output_map[2953] = &psn_shade->co2; //%"Sunshade atmospheric CO2 conc." $\\left[\\ppm \\right]$ "Lgkri CO2 koncentrci rnykban" $\\left[\\ppm \\right]$ "Sunshade atmospheric CO2 conc." %
        output_map[2954] = &psn_sun->t; //%"Sunlit temperature" $\\left[Celsius\\right]$ "Homrsklet napon" $\\left[Celsius\\right]$ "Sunlit temperature" %
        output_map[2955] = &psn_shade->t; //%"Sunshade temperature" $\\left[Celsius\\right]$ "Homrsklet rnykban" $\\left[Celsius\\right]$ "Sunshade temperature" %
        output_map[2956] = &psn_sun->lnc; //%"Leaf N per unit sunlit leaf area" $\\left[\\kg_{Nleaf}m^{-2} \\right]$ "Levl N tartalom napos levlfelleti egysgre vettve" $\\left[\\kg_{Nleaf}m^{-2} \\right]$ "Leaf N  per unit sunlit leaf area" %
        output_map[2957] = &psn_shade->lnc; //%"Leaf N per unit sunshade area" $\\left[\\kg_{Nleaf}m^{-2} \\right]$ "Levl N tartalom rnykos levlfelleti egysgre vettve" $\\left[\\kg_{Nleaf}m^{-2} \\right]$ "Leaf N  per unit sunshade area" %
        output_map[2958] = &psn_sun->flnr; //%"Sunlit fraction of leaf N in Rubisco" $\\left[\\kg_{NRubisco}kg_{Nleaf}^{-1} \\right]$ "Rubisco enzim levl N tartalmnak napos rsze" $\\left[\\kg_{NRubisco}kg_{Nleaf}^{-1} \\right]$ "Sunlit fraction of leaf N  in Rubisco" %
        output_map[2959] = &psn_shade->flnr; //%"Sunshade fraction of leaf N in Rubisco" $\\left[\\kg_{NRubisco}kg_{Nleaf}^{-1} \\right]$ "Rubisco enzim levl N tartalmnak rnykos rsze" $\\left[\\kg_{NRubisco}kg_{Nleaf}^{-1} \\right]$ "Sunshade fraction of leaf N  in Rubisco" %
        output_map[2960] = &psn_sun->flnp; //%"Sunlit fraction of leaf N in PEP Carboxylase" $\\left[\\kg_{NPEP}kg_{Nleaf}^{-1} \\right]$ "PEP Carboxilz levl N tartalmnak napos rsze" $\\left[\\kg_{NPEP}kg_{Nleaf}^{-1} \\right]$ "Sunlit fraction of leaf N  in PEP Carboxylase" %
        output_map[2961] = &psn_shade->flnp; //%"Sunshade fraction of leaf N in PEP Carboxylase" $\\left[\\kg_{NPEP}kg_{Nleaf}^{-1} \\right]$ "PEP Carboxilz levl N tartalmnak rnykos rsze" $\\left[\\kg_{NPEP}kg_{Nleaf}^{-1} \\right]$ "Sunshade fraction of leaf N  in PEP Carboxylase" %
        output_map[2962] = &psn_sun->ppfd; //%"Sunlit PAR flux per unit sunlit leaf area" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Napos fotoszintetikusan aktv sugrzs napos levlfelleti indexre vettett rsze" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunlit PAR flux per unit sunlit leaf area" %
        output_map[2963] = &psn_shade->ppfd; //%"Sunshade PAR flux per unit sunlit leaf area" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "rnykos fotoszintetikusan aktv sugrzs napos levlfelleti indexre vettett rsze" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunshade PAR flux per unit sunlit leaf area" %
        output_map[2964] = &psn_sun->g; //%"Sunlit conductance to CO2" $\\left[\\mu$mol$ m^{-2} s^{-1}Pa{-1}\\right]$ "CO2-vezetokpessg (napos levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}Pa{-1}\\right]$ "Sunlit conductance to CO2" %
        output_map[2965] = &psn_shade->g; //%"Sunshade conductance to CO2" $\\left[\\mu$mol$ m^{-2} s^{-1}Pa{-1}\\right]$ "CO2-vezetokpessg (rnykolt levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}Pa{-1}\\right]$ "Sunshade conductance to CO2" %
        output_map[2966] = &psn_sun->dlmr; //%"Sunlit day leaf maintenance respiration" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Levl napi nfenntart respircija a napon" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunlit day leaf maintenance respiration" %
        output_map[2967] = &psn_shade->dlmr; //%"Sunshade day leaf maintenance respiration" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Levl napi nfenntart respircija rnykban" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunshade day leaf maintenance respiration" %
        output_map[2968] = &psn_sun->Ci; //%"Sunlit intercellular CO2 concentration" $\\left[\\Pa \\right]$ "Sejtkzi CO2 koncentrci (napos levlldal)" $\\left[\\Pa \\right]$ "Sunlit intercellular CO2 concentration" %
        output_map[2969] = &psn_shade->Ci; //%"Sunshade intercellular CO2 concentration" $\\left[\\Pa \\right]$ "Sejtkzi CO2 koncentrci (rnykolt levlldal)" $\\left[\\Pa \\right]$ "Sunshade intercellular CO2 concentration" %
        output_map[2970] = &psn_sun->O2; //%"Sunlit atmospheric O2 concentration" $\\left[\\Pa \\right]$ "Lgkri O2 koncentrci (napos levlldal)" $\\left[\\Pa \\right]$ "Sunlit atmospheric O2 concentration" %
        output_map[2971] = &psn_shade->O2; //%"Sunshade atmospheric O2 concentration" $\\left[\\Pa \\right]$ "Lgkri O2 koncentrci (rnykolt levlldal)" $\\left[\\Pa \\right]$ "Sunshade atmospheric O2 concentration" %
        output_map[2972] = &psn_sun->Ca; //%"Sunlit atmospheric CO2 concentration" $\\left[\\Pa \\right]$ "Lgkri CO2 koncentrci (napos oldal)" $\\left[\\Pa \\right]$ "Sunlit atmospheric CO2 concentration" %
        output_map[2973] = &psn_shade->Ca; //%"Sunshade atmospheric CO2 concentration" $\\left[\\Pa \\right]$ "Lgkri CO2 koncentrci (rnykolt oldal)" $\\left[\\Pa \\right]$ "Sunshade atmospheric CO2 concentration" %
        output_map[2974] = &psn_sun->gamma; //%"Sunlit CO2 compensation point" $\\left[\\Pa \\right]$ "CO2 kompenzcis pont (napos levlldal)" $\\left[\\Pa \\right]$ "Sunlit CO2 compensation point" %
        output_map[2975] = &psn_shade->gamma; //%"Sunshade CO2 compensation point" $\\left[\\Pa \\right]$ "CO2 kompenzcis pont (rnykolt levlldal)" $\\left[\\Pa \\right]$ "Sunshade CO2 compensation point" %
        output_map[2976] = &psn_sun->Kc; //%"Sunlit MM constant carboxylation" $\\left[\\Pa \\right]$ "Karboxilci (napos levlldal)" $\\left[\\Pa \\right]$ "Sunlit MM constant carboxylation" %
        output_map[2977] = &psn_shade->Kc; //%"Sunshade MM constant carboxylation" $\\left[\\Pa \\right]$ "Karboxilci (rnykolt levlldal)" $\\left[\\Pa \\right]$ "Sunshade MM constant carboxylation" %
        output_map[2978] = &psn_sun->Ko; //%"Sunlit MM constant oxygenation" $\\left[\\Pa \\right]$ "Oxigenci (napos levlldal)" $\\left[\\Pa \\right]$ "Sunlit MM constant oxygenation" %
        output_map[2979] = &psn_shade->Ko; //%"Sunshade MM constant oxygenation" $\\left[\\Pa \\right]$ "Oxigenci (rnykolt levlldal)" $\\left[\\Pa \\right]$ "Sunshade MM constant oxygenation" %
        output_map[2980] = &psn_sun->Vmax; //%"Sunlit max. rate of carboxylation" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Maximlis karboxilcis rta (napos levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunlit max. rate of carboxylation" %
        output_map[2981] = &psn_shade->Vmax; //%"Sunshade max. rate of carboxylation" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Maximlis karboxilcis rta (rnykolt levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunshade max. rate of carboxylation" %
        output_map[2982] = &psn_sun->Jmax; //%"Sunlit max. rate of electron transport" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Maximlis elektron transzport rta (napos levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunlit max. rate of electron transport" %
        output_map[2983] = &psn_shade->Jmax; //%"Sunshade max. rate of electron transport" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Maximlis elektron transzport rta (rnykolt levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunshade max. rate of electron transport" %
        output_map[2984] = &psn_sun->J; //%"Sunlit rate of RuBP regeneration" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Rubisco-regenerci (napos levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunlit rate of RuBP regeneration" %
        output_map[2985] = &psn_shade->J; //%"Sunshade rate of RuBP regeneration" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Rubisco-regenerci (rnykolt levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunshade rate of RuBP regeneration" %
        output_map[2986] = &psn_sun->Av; //%"Sunlit carboxylation limited assimilation" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Karboxilci ltal limitlt asszimilci (napos levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunlit carboxylation limited assimilation" %
        output_map[2987] = &psn_shade->Av; //%"Sunshade carboxylation limited assimilation" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Karboxilci ltal limitlt asszimilci (rnykolt levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunshade carboxylation limited assimilation" %
        output_map[2988] = &psn_sun->Aj; //%"Sunlit RuBP regeneration limited assimilation" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Rubisco-limitlt asszimilci (napos levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunlit RuBP regeneration limited assimilation" %
        output_map[2989] = &psn_shade->Aj; //%"Sunshade RuBP regeneration limited assimilation" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Rubisco-limitlt asszimilci (rnykolt levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunshade RuBP regeneration limited assimilation" %
        output_map[2990] = &psn_sun->A; //%"Sunlit final assimilation rate" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Vgso asszimilcis rta (napos levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunlit final assimilation rate" %
        output_map[2991] = &psn_shade->A; //%"Sunshade final assimilation rate" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Vgso asszimilcis rta (rnykolt levlldal)" $\\left[\\mu$mol$ m^{-2} s^{-1}\\right]$ "Sunshade final assimilation rate" %
    	output_map[2992] = &psn_sun->pa; //%"Sunlit atmospheric pressure" $\\left[\\Pa \\right]$ "Lgkri nyoms napon" $\\left[\\Pa \\right]$ "Sunlit atmospheric pressure" %
        output_map[2993] = &psn_shade->pa; //%"Sunshade atmospheric pressure" $\\left[\\Pa \\right]$ "Lgkri nyoms rnykban" $\\left[\\Pa \\right]$ "Sunshade atmospheric pressure" %
  
		output_map[3000] = &summary->annprcp; //%"Annual precipitation" $\\left[\\mm year^{-1} \\right]$ "ves csapadk" $\\left[\\mm v^{-1} \\right]$ "Annual precipitation" %
        output_map[3001] = &summary->anntavg; //%"Annual average air temperature" $\\left[Celsius\\right]$ "ves tlaghomrsklet" $\\left[Celsius\\right]$ "Annual average air temperature" %
        output_map[3002] = &summary->cumRunoff; //%"Cumulated SUM of runoff" $\\left[\\kg_{H_{2}O}m^{-2}year^{-1}} \\right]$ "Lefolys kumullt sszege" $\\left[\\kg_{H_{2}O}m^{-2}v^{-1}} \\right]$ "Cumulated SUM of runoff" %
        output_map[3003] = &summary->cumWleach_RZmax; //%"Cumulated SUM of water leaching from rootzone" $\\left[\\kg_{H_{2}O}m^{-2}year^{-1}} \\right]$ "Kifolys kumullt sszege" $\\left[\\kg_{H_{2}O}m^{-2}v^{-1}} \\right]$ "Cumulated SUM of water leaching from rootzone" %
        output_map[3004] = &summary->N2Oflux_total; //%"Daily N2O flux" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Napi N2O fluxus" $\\left[\\kg_{N}m^{-2 }nap^{-1} \\right]$ "Daily N2O flux" %
        output_map[3005] = &summary->NEP; //%"Net ecosystem production" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nett koszisztma produkci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Net ecosystem production" %
        output_map[3006] = &summary->NPP; //%"Net primary production" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nett primr produkci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Net primary production" %
        output_map[3007] = &summary->NEE; //%"Net ecosystem exchange" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nett koszisztma kicserlds" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Net ecosystem exchange" %
        output_map[3008] = &summary->NBP; //%"Net biom production" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nett biom produkci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Net biom production" %
        output_map[3009] = &summary->GPP; //%"gross primary production" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Brutt primr produkci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "gross primary production" %
        output_map[3010] = &summary->MR; //%"Maintenance respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "nfenntart respirci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Maintenance respiration" %
        output_map[3011] = &summary->GR; //%"growth respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Nvekedsi respirci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "growth respiration" %
        output_map[3012] = &summary->HR; //%"Heterotroph respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Heterotrf respirci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration" %
        output_map[3013] = &summary->SR; //""Soil respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Talaj respirci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "//""Soil respiration" %
        output_map[3014] = &summary->TR; //""Total respiration" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Teljes respirci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "//""Total respiration" %
        output_map[3015] = &summary->fire; //%"Fire losses" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Tuzelhalsi vesztesg" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Fire losses" %
        output_map[3016] = &summary->litfallc; //%"Total litterfall" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Teljes lombhulls" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Total litterfall" %
        output_map[3017] = &summary->litfallc_above; //%"Total litterfall aboveground" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Teljes lombhulls talaj felett" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Total litterfall aboveground" %
        output_map[3018] = &summary->litfallc_below; //%"Total litterfall belowground" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Teljes lombhulls talaj alatt" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Total litterfall belowground" %
        output_map[3019] = &summary->litdecomp; //%"Total litter decomposition" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Teljes lehullott lomb dekompozci" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Total litter decomposition" %
        output_map[3020] = &summary->litfire; //%"Total litter fire mortality" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Lehullott lomb teljes tuzelhalsa" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Total litter fire mortality" %
        output_map[3021] = &summary->cumCH4fluxCeq; //%"Cumulative CH4 flux in C eq" $\\left[\\kg_{C}m^{-2 }\\right]$ "Kumulatv CH4 fluxus sznegyenrtkben" $\\left[\\kg_{C}m^{-2 }\\right]$ "Cumulative CH4 flux in C eq." %
        output_map[3022] = &summary->cumNPP; //%"Cumulative annual SUM of NPP" $\\left[\\kg_{C}m^{-2} \\right]$ "Nett primr produkc kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of NPP" %
        output_map[3023] = &summary->cumNEP; //%"Cumulative annual SUM of NEP" $\\left[\\kg_{C}m^{-2} \\right]$ "Nett koszisztma produkci kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of NEP" %
        output_map[3024] = &summary->cumNEE; //%"Cumulative annual SUM of NEE" $\\left[\\kg_{C}m^{-2} \\right]$ "Nett koszisztma kicserlds kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of NEE" %
        output_map[3025] = &summary->cumGPP; //%"Cumulative annual SUM of GPP" $\\left[\\kg_{C}m^{-2} \\right]$ "Brutt primr produkci kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of GPP" %
        output_map[3026] = &summary->cumMR; //%"Cumulative annual SUM of MR" $\\left[\\kg_{C}m^{-2} \\right]$ "nfenntart respirci kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of MR" %
        output_map[3027] = &summary->cumGR; //%"Cumulative annual SUM of GR" $\\left[\\kg_{C}m^{-2} \\right]$ "Nvekedsi respirci kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of GR" %
        output_map[3028] = &summary->cumHR; //%"Cumulative annual SUM of HR" $\\left[\\kg_{C}m^{-2} \\right]$ "Heterotrf respirci kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of HR" %
        output_map[3029] = &summary->cumTR; //%"Cumulative SUM of total ecosystem respiration " $\\left[\\kg_{C}m^{-2} \\right]$ "A teljes koszisztma respirci ves kumulatv sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative SUM of total ecosystem respiration " %
        output_map[3030] = &summary->cumN2Oflux; //%"Cumulative annual SUM N2O flux" $\\left[\\kg_{N}m^{-2} \\right]$ "N2O fluxus kumulatv ves sszege" $\\left[\\kg_{N}m^{-2} \\right]$ "Cumulative annual SUM N2O flux" %
        output_map[3031] = &summary->cumCloss_MGM; //%"Cumulative annual SUM of management C loss" $\\left[\\kg_{C}m^{-2} \\right]$ "Muvelsbol eredo sznvesztesg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of management C loss" %
        output_map[3032] = &summary->cumCplus_MGM; //%"Cumulative annual SUM of management C plus" $\\left[\\kg_{C}m^{-2} \\right]$ "Muvelsbol eredo sznbevtel kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of management C plus" %
        output_map[3033] = &summary->cumCloss_THN_w; //%"Cumulative annual SUM of thinning woody C loss" $\\left[\\kg_{C}m^{-2} \\right]$ "Fs szn ritktsbl eredo vesztesg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of thinning woody C loss" %
        output_map[3034] = &summary->cumCloss_THN_nw; //%"Cumulative annual SUM of thinning non-woody C loss" $\\left[\\kg_{C}m^{-2} \\right]$ "Nem fs szn ritktsbl eredo vesztesg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of thinning non-woody C loss" %
        output_map[3035] = &summary->cumCloss_MOW; //%"Cumulative annual SUM of mowing C loss" $\\left[\\kg_{C}m^{-2} \\right]$ "Kaszlsbl eredo sznvesztesg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of mowing C loss" %
        output_map[3036] = &summary->cumCloss_HRV; //%"Cumulative annual SUM of harvesting C loss" $\\left[\\kg_{C}m^{-2} \\right]$ "Betakartsbl eredo sznvesztesg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of harvesting C loss" %
        output_map[3037] = &summary->cumYieldC_HRV; //%"Cumulative annual SUM of harvested yield" $\\left[\\kg_{C}m^{-2} \\right]$ "Betakartott terms kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of harvested yield" %
        output_map[3038] = &summary->cumCloss_PLG; //%"Cumulative annual SUM of ploughing C loss" $\\left[\\kg_{C}m^{-2} \\right]$ "Szntsbl eredo sznvesztesg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of ploughing C loss" %
        output_map[3039] = &summary->cumCloss_GRZ; //%"Cumulative annual SUM of grazing C loss" $\\left[\\kg_{C}m^{-2} \\right]$ "Legeltetsbol eredo sznvesztesg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of grazing C loss" %
        output_map[3040] = &summary->cumCplus_GRZ; //%"Cumulative annual SUM of grazing C plus" $\\left[\\kg_{C}m^{-2} \\right]$ "Legeltetsbol eredo sznbevtel kumulatv ves ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of grazing C plus" %
        output_map[3041] = &summary->cumCplus_FRZ; //%"Cumulative annual SUM of fertilizing C plus" $\\left[\\kg_{C}m^{-2} \\right]$ "Trgyzsbl szrmaz sznbevtel kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of fertilizing C plus" %
        output_map[3042] = &summary->cumCplus_PLT; //%"Cumulative annual SUM of planting C plus" $\\left[\\kg_{C}m^{-2} \\right]$ "Vetsbol szrmaz sznbevtel kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of planting C change" %
        output_map[3043] = &summary->cumNplus_GRZ; //%"Cumulative annual SUM of grazing N plus" $\\left[\\kg_{N}m^{-2} \\right]$ "Legeltetsbol szrmaz N bevtel kumulatv ves sszege" $\\left[\\kg_{N}m^{-2} \\right]$ "Cumulative annual SUM of grazing N  plus" %
        output_map[3044] = &summary->cumNplus_FRZ; //%"Cumulative annual SUM of fertilizing N plus" $\\left[\\kg_{N}m^{-2} \\right]$ "Trgyzsbl szrmaz N bevtel kumulatv ves sszege" $\\left[\\kg_{N}m^{-2} \\right]$ "Cumulative annual SUM of fertilizing N  plus" %
        output_map[3045] = &summary->cumCloss_SNSC; //%"Cumulative annual SUM of senescence C loss" $\\left[\\kg_{C}m^{-2} \\right]$ "Elregedsbol szrmaz sznvesztesg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of senescence C loss" %
        output_map[3046] = &summary->cumCplus_STDB; //%"Cumulative annual SUM of standing dead biome C plus" $\\left[\\kg_{C}m^{-2} \\right]$ "ll elhalt biomasszbl szrmaz sznbetvtel kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of standing dead biome C plus" %
        output_map[3047] = &summary->cumCplus_CTDB; //%"Cumulative annual SUM of cut-down dead biome C plus" $\\left[\\kg_{C}m^{-2} \\right]$ "Kivgott elhalt biomasszbl szrmaz sznbevtel kumulatv sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of cut-down dead biome C plus" %
        output_map[3048] = &summary->cumEVPsurface; //%"Cumulative SUM of evaporation" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "EVPorci kumulatv ves sszege" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Cumulative SUM of evaporation" %
        output_map[3049] = &summary->cumETcanopy; //%"Cumulative SUM of transpiration" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Transpirci kumulatv ves sszege" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Cumulative SUM of transpiration" %
        output_map[3050] = &summary->cumET; //%"Cumulative SUM of evapotranspiration" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Evapotranszpirci kumulatv sszege" $\\left[\\kg_{H_{2}O}m^{-2} \\right]$ "Cumulative SUM of evapotranspiration" %
        output_map[3051] = &summary->leafDM; //%"Dry matter content of leaves" $\\left[\\kg_{DM}m^{-2} \\right]$ "Levl szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "Dry matter C content of leaves" %
        output_map[3052] = &summary->leaflitrDM; //%"Dry matteC content of leaf litter" $\\left[\\kg_{DM}m^{-2} \\right]$ "Elhullott levl szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "Dry matter content of leaf litter" %
        output_map[3053] = &summary->frootDM; //%"Dry matter content of fine roots" $\\left[\\kg_{DM}m^{-2} \\right]$ "Hajszlgykr szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "Dry matter content of fine roots" %
        output_map[3054] = &summary->yieldDM; //%"Dry matter content of yields" $\\left[\\kg_{DM}m^{-2} \\right]$ "Terms szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "Dry matter content of yields" %
        output_map[3055] = &summary->softstemDM; //%"Dry matter content of softstems" $\\left[\\kg_{DM}m^{-2} \\right]$ "Lgyszr szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "Dry matter content of softstems" %
        output_map[3056] = &summary->livewoodDM; //%"Dry matter content of live wood" $\\left[\\kg_{DM}m^{-2} \\right]$ "Fatest l rsz szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "Dry matter content of live wood" %
        output_map[3057] = &summary->deadwoodDM; //%"Dry matter content of dead wood" $\\left[\\kg_{DM}m^{-2} \\right]$ "Fatest elhalt rsz szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "Dry matter content of dead wood" %
        output_map[3058] = &summary->vegC; //%"Total vegetation C content" $\\left[\\kg_{C}m^{-2} \\right]$ "Teljes vegetci szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total vegetation C content" %
  		output_map[3059] = &summary->litrN_total; //%"Total Litter N content" $\\left[\\kg_{N}m^{-2} \\right]$ "Az elhalt szerves anyag nitrogntartalma a teljes talajban" $\\left[\\kg_{N}m^{-2} \\right]$ "Total Litter N content" %
        output_map[3060] = &summary->litrC_total; //%"Total litter C content" $\\left[\\kg_{C}m^{-2} \\right]$ "Az elhalt szerves anyag szntartalma a teljes talajbaa" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter C content" %
        output_map[3061] = &summary->soilC_total; //%"Total soil C content" $\\left[\\kg_{C}m^{-2} \\right]$ "A talaj teljes szntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total soil C content" %
        output_map[3062] = &summary->soilN_total; //%"Total soil N content" $\\left[\\kg_{N}m^{-2} \\right]$ "A talaj teljes N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total soil N  content" %
        output_map[3063] = &summary->sminN_total; //%"Total soil mineralized N content" $\\left[\\kg_{N}m^{-2} \\right]$ "A talaj teljes svnyi N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total soil mineralized N  content" %
        output_map[3064] = &summary->totalC; //%"Total C content" $\\left[\\kg_{C}m^{-2} \\right]$ "Teljes szntartalom" $\\left[\\kg_{C}m^{-2} \\right]$ "Total C content" %
        output_map[3065] = &summary->SOCpercent[0]; //%"Soil organic matter C content in 0-3 cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 0-3 cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 0-3  cm" %
        output_map[3066] = &summary->SOCpercent[1]; //%"Soil organic matter C content in 3-10 cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 3-10 cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 3-10 cm" %
        output_map[3067] = &summary->SOCpercent[2]; //%"Soil organic matter C content in 10-30 cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 10-30 cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 10-30  cm" %
        output_map[3068] = &summary->SOCpercent[3]; //%"Soil organic matter C content in 30-60 cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 30-60 cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 30-60 cm" %
        output_map[3069] = &summary->SOCpercent[4]; //%"Soil organic matter C content in 60-90 cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 60-90 cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 60-90 cm" %
        output_map[3070] = &summary->SOCpercent[5]; //%"Soil organic matter C content in 90-120 cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 90-120 cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 90-120 cm" %
        output_map[3071] = &summary->SOCpercent[6]; //%"Soil organic matter C content in 120-150 cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 120-150 cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 120-150 cm" %
        output_map[3072] = &summary->SOCpercent[7]; //%"Soil organic matter C content in 150-200 cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 150-200 cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 150-200 cm" %
        output_map[3073] = &summary->SOCpercent[8]; //%"Soil organic matter C content in 200-400  cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 200-400  cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 200-400 cm" %
        output_map[3074] = &summary->SOCpercent[9]; //%"Soil organic matter C content in 400-1000 cm" $\\left[%\\right]$ "Talaj szervesanyagtartalma a 400-1000 cm-es rtegben" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil organic matter C content in 400-1000 cm" %
        output_map[3075] = &summary->leafc_LandD; //%"Live and dead leaf C content" $\\left[\\kg_{C}m^{-2} \\right]$ "l s elhalt levelek szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Live and dead leaf C content" %
        output_map[3076] = &summary->frootc_LandD; //%"Live and dead fine root C content" $\\left[\\kg_{C}m^{-2} \\right]$ "l s elhalt gykr szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Live and dead fine root C content" %
        output_map[3077] = &summary->yield_LandD; //%"Live and dead yield C content" $\\left[\\kg_{C}m^{-2} \\right]$ "l s elhalt terms szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Live and dead yield C content" %
        output_map[3078] = &summary->softstemc_LandD; //%"Live and dead sofstem C content" $\\left[\\kg_{C}m^{-2} \\right]$ "l s elhalt lgyszr szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Live and dead sofstem C content" %
    	output_map[3079] = &summary->NH4_ppm[0]; //%"Soil NH4-N content in ppm of soil layer 1 (0-3 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben az 1. talajrtegben (0-3 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 1 (0-3 cm)" %
		output_map[3080] = &summary->NH4_ppm[1]; //%"Soil NH4-N content in ppm of soil layer 2 (3-10 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben a 2. talajrtegben (3-10 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 2 (3-10 cm)" %
		output_map[3081] = &summary->NH4_ppm[2]; //%"Soil NH4-N content in ppm of soil layer 3 (10-30 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben a 3. talajrtegben (10-30 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 3 (10-30 cm)" %
		output_map[3082] = &summary->NH4_ppm[3]; //%"Soil NH4-N content in ppm of soil layer 4 (30-60 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben a 4. talajrtegben (30-60 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 4 (30-60 cm)" %
		output_map[3083] = &summary->NH4_ppm[4]; //%"Soil NH4-N content in ppm of soil layer 5 (60-90 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben az 5. talajrtegben (60-90 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 5 (60-90 cm)" %
		output_map[3084] = &summary->NH4_ppm[5]; //%"Soil NH4-N content in ppm of soil layer 6 (90-120 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben a 6. talajrtegben (90-120 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 6 (90-120 cm)" %
		output_map[3085] = &summary->NH4_ppm[6]; //%"Soil NH4-N content in ppm of soil layer 7 (120-150 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben a 7. talajrtegben (120-150 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 7 (120-150 cm)" %
		output_map[3086] = &summary->NH4_ppm[7]; //%"Soil NH4-N content in ppm of soil layer 8 (150-200 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben a 8. talajrtegben (150-200 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 8 (150-200 cm)" %
		output_map[3087] = &summary->NH4_ppm[8]; //%"Soil NH4-N content in ppm of soil layer 9 (200-400 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben az 9. talajrtegben (200-400 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 9 (200-400 cm)" %
		output_map[3088] = &summary->NH4_ppm[9]; //%"Soil NH4-N content in ppm of soil layer 10 (400-1000 cm)" $\\left[\\ppm \\right]$ "Talaj NH4 tartalom ppm-ben a 10. talajrtegben (400-1000 cm)" $\\left[\\ppm \\right]$ "Soil NH4-N content in ppm of soil layer 10 (400-1000 cm)" %
		output_map[3089] = &summary->NO3_ppm[0]; //%"Soil NO3-N content in ppm of soil layer 1 (0-3 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben az 1. talajrtegben (0-3 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 1 (0-3 cm)" %
		output_map[3090] = &summary->NO3_ppm[1]; //%"Soil NO3-N content in ppm of soil layer 2 (3-10 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben a 2. talajrtegben (3-10 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 2 (3-10 cm)" %
		output_map[3091] = &summary->NO3_ppm[2]; //%"Soil NO3-N content in ppm of soil layer 3 (10-30 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben a 3. talajrtegben (10-30 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 3 (10-30 cm)" %
		output_map[3092] = &summary->NO3_ppm[3]; //%"Soil NO3-N content in ppm of soil layer 4 (30-60 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben a 4. talajrtegben (30-60 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 4 (30-60 cm)" %
		output_map[3093] = &summary->NO3_ppm[4]; //%"Soil NO3-N content in ppm of soil layer 5 (60-90 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben az 5. talajrtegben (60-90 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 5 (60-90 cm)" %
		output_map[3094] = &summary->NO3_ppm[5]; //%"Soil NO3-N content in ppm of soil layer 6 (90-120 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben a 6. talajrtegben (90-120 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 6 (90-120 cm)" %
		output_map[3095] = &summary->NO3_ppm[6]; //%"Soil NO3-N content in ppm of soil layer 7 (120-150 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben a 7. talajrtegben (120-150 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 7 (120-150 cm)" %
		output_map[3096] = &summary->NO3_ppm[7]; //%"Soil NO3-N content in ppm of soil layer 8 (150-200 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben a 8. talajrtegben (150-200 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 8 (150-200 cm)" %
		output_map[3097] = &summary->NO3_ppm[8]; //%"Soil NO3-N content in ppm of soil layer 9 (200-400 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben az 9. talajrtegben (200-400 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 9 (200-400 cm)" %
		output_map[3098] = &summary->NO3_ppm[9]; //%"Soil NO3-N content in ppm of soil layer 10 (400-1000 cm)" $\\left[\\ppm \\right]$ "Talaj NO3 tartalom ppm-ben a 10. talajrtegben (400-1000 cm)" $\\left[\\ppm \\right]$ "Soil NO3-N content in ppm of soil layer 10 (400-1000 cm)" %
		output_map[3099] = &summary->CH4flux_total; //%"Estimated total CH4 flux of ecosystem" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Becslt CH4 fluxus az erjedsbol" $\\left[\\kg_{C}m^{-2 }nap{^-1} \\right]$ "Estimated total ecosystem CH4 flux" %	
		output_map[3100] = &summary->NGB; //%"Net greenhouse gas balance" $\\left[\\kg_{C}m^{-2}day^{-1}\\right]$ "Nett veghzgz mrleg" $\\left[\\kg_{C}m^{-2}m^{-2} \\right]$ "Net greenhouse gas balance" %
		output_map[3101] = &summary->cumNGB; //%"Cumulative annual SUM of NGB" $\\left[\\kg_{C}m^{-2}\\right]$ "Nett veghzgz mrleg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of NGB" %
		output_map[3102] = &summary->Cflux_lateral; //%"Lateral C flux" $\\left[\\kg_{C}m^{-2}day^{-1} \\right]$ "Laterlis sznfluxus" $\\left[\\kg_{C}m^{-2}day^{-1} \\right]$ "Lateral C flux" %
		output_map[3103] = &summary->harvestIndex; //%"Harvest index" $\\left[\\dimless\\right]$ "Harvest index" $\\left[\\dimless\\right]$ "Harvest index" %
		output_map[3104] = &summary->sminNavail_total; //%"Total available soil mineralized N content" $\\left[\\kg_{N}m^{-2} \\right]$ "A talaj teljes hozzfrhet svnyi N tartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total available soil mineralized N  content" %
		output_map[3105] = &summary->cumNleach_RZmax; //%"Cumulated SUM of N leaching from rootzone" $\\left[\\kg_{N}m^{-2}} \\right]$ "Gykrznbl val N-kimosds kumullt sszege" $\\left[\\kg_{H_{2}O}m^{-2}} \\right]$ "Cumulated SUM of N leaching from rootzone" %
		output_map[3106] = &summary->cumSR; //%"Cumulated SUM of soil respiration" $\\left[\\kg_{C}m^{-2}} \\right]$ "Gykrznbl val N-kimosds kumullt sszege" $\\left[\\kg_{H_{2}O}m^{-2}} \\right]$ "Cumulated SUM of N leaching from rootzone" %
		output_map[3107] = &summary->CNlitr_total; //%"C:N ratio of litter pool " $\\left[\\kg_{C}kg_{N}^{-1}\\right]$ "C:N arny a  elhalt anyag trozban " $\\left[\\ppm \\right]$ "C:N ratio of  litter pool " %
		output_map[3108] = &summary->CNsoil_total; //%"C:N ratio of soil pool " $\\left[\\kg_{C}kg_{N}^{-1}\\right]$ "C:N arny a  talaj trozban " $\\left[\\ppm \\right]$ "C:N ratio of  soil pool " %
		output_map[3109] = &summary->litr1HR_total; //%"Heterotroph respiration of labile litter in soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis litter troz heterotrf respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of labile litter in soil" %
		output_map[3110] = &summary->litr2HR_total; //%"Heterotroph respiration of unshielded cellulose soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag hozzfrhet cellulz trozjnak heterotrf respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "C flux from unshielded cellulose portion of litter in soil" %
		output_map[3111] = &summary->litr4HR_total; //%"Heterotroph respiration of lignin portion of litter in soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Az elhalt nvnyi anyag lignin trozjnak heterotrf respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of lignin portion of litter in soil" %
		output_map[3112] = &summary->soil1HR_total; //%"Heterotroph respiration of SOM pool (labile) in soil " $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A labilis szervesanyag szntartalmnak heterotrf respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (labile) in soil" %
		output_map[3113] = &summary->soil2HR_total; //%"Heterotroph respiration of SOM pool (fast) in soil " $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A gyors bomls SOM-troz heterotrf respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (slow) in soil" %
		output_map[3114] = &summary->soil3HR_total; //%"Heterotroph respiration of SOM pool (slow) in soil " $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A lass bomls SOM-troz heterotrf respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil" %
		output_map[3115] = &summary->soil4HR_total; //%"Heterotroph respiration of SOM pool (stable) in soil" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "A stabil SOM-troz heterotrf respircija" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Heterotroph respiration of SOM pool (stable) in soil" % 
		output_map[3116] = &summary->yieldDM_HRV;   //%"Dry matter content of yield at harvest (annual value)" $\\left[\\kg_{DM}m^{-2} \\right]$ "Terms szrazanyag-tartalma aratskor (ves vltoz)" $\\left[\\kg_{DM}m^{-2} \\right]$ "Dry matter content of yield at harvest" %
        output_map[3117] = &summary->cumCloss_PLT; //%"Cumulative annual SUM of planting C loss (standing dead biomass)" $\\left[\\kg_{C}m^{-2} \\right]$ "Vetsbol szrmaz sznvesztesg kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of planting C change" %
	    output_map[3118] = &summary->leafCN; //%"C and N ratio of leaves (live+standind dead)" $\\left[\\kg_{C}kg_{N}^{-1}\\right]$ "Levl szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "C and N ratio  of leaves" %
        output_map[3119] = &summary->frootCN; //%"C and N ratio of fine roots" $\\left[\\kg_{C}kg_{N}^{-1}\\right]$ "Hajszlgykr szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "C and N ratio of fine roots" %
        output_map[3120] = &summary->yieldN; //%"C and N ratio of yields" $\\left[\\kg_{C}kg_{N}^{-1}\\right]$ "Terms szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "C and N ratio of yields" %
        output_map[3121] = &summary->softstemCN; //%"C and N ratio of softstems" $\\left[\\kg_{C}kg_{N}^{-1}\\right]$ "Lgyszr szrazanyag-tartalma" $\\left[\\kg_{DM}m^{-2} \\right]$ "C and N ratio of softstems" %
        output_map[3122] = &summary->rootIndex; //%" Ratio of fine root C content and vegetation C content on harvest day" $\\left[\\dimless\\right]$ "A finomgykrzet s a vegetci szntartalmnak arnya az arats napjn" $\\left[\\dimless\\right]$ "Ratio of fine root C content and vegetation C content on harvest day" %
        output_map[3123] = &summary->litrCwdC_total; //%"Total Litter and cwdc C content" $\\left[\\kg_{N}m^{-2} \\right]$ "Az elhalt szerves anyag szntartalma a teljes talajban" $\\left[\\kg_{N}m^{-2} \\right]$ "Total Litter and cwdc C content" %
        output_map[3124] = &summary->litrCwdN_total; //%"Total litter and cwdc N content" $\\left[\\kg_{C}m^{-2} \\right]$ "Az elhalt szerves anyag nitrogntartalma a teljes talajban" $\\left[\\kg_{C}m^{-2} \\right]$ "Total litter and cwdc N content" %
        output_map[3125] = &summary->cumIMMOBflux_RZ; //%"cumulative immobilization flux (sminN_to_soil) in rootzone" $\\left[\\kg_{N}m^{-2} \\right]$ 
        output_map[3126] = &summary->cumNdemand; //%"cumulative plant N demand" $\\left[\\kg_{N}m^{-2} \\right]$ 
        output_map[3127] = &summary->cumNflux; //%"Cumulative annual SUM N2 flux" $\\left[\\kg_{N}m^{-2} \\right]$ "N2 fluxus kumulatv ves sszege" $\\left[\\kg_{N}m^{-2} \\right]$ "Cumulative annual SUM N2 flux" %
        output_map[3128] = &summary->belowground_ratio; //%"Ratio of root to vegetation C content" $\\left[\\dimless\\right]$ "A gykrzet s a vegetci szntartalmnak arnya" $\\left[\\dimless\\right]$ "Ratio of root C content and vegetation C content" %
		output_map[3129] = &summary->cumCH4flux; //%"Cumulative annual SUM of total CH4 flux" $\\left[\\kg_{C}m^{-2} \\right]$ "CH4 fluxus kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of CH4 flux" %
   		output_map[3130] = &summary->cumNBP; //%"Cumulative annual SUM of NBP" $\\left[\\kg_{C}m^{-2}\\right]$ "Nett biomassza produkci kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of NBP" %
	    output_map[3131] = &summary->N2OfluxCeq; //%"Daily N2O flux in C eq" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi N2O fluxus sznegyenrtkben" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily N2O flux in C eq." %
  	    output_map[3132] = &summary->cumN2OfluxCeq; //%"Cumulative annual SUM N2O fluxn C eq" $\\left[\\kg_{C}m^{-2} \\right]$ "N2O fluxus kumulatv ves sszege sznegyenrtkben" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM N2O flux in C eq." %
    	output_map[3133] = &summary->cumCflux_lateral; //%"Cumulative lateral C flux" $\\left[\\kg_{C}m^{-2} \\right]$ "Kumulatv laterlis C fluxus" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative lateral C flux" %
		output_map[3134] = &summary->cumAR; //%"Cumulative annual SUM of AR" $\\left[\\kg_{C}m^{-2} \\right]$ "Autotrf respirci kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of AR" %
  		output_map[3135] = &summary->livingSC; //%" Living structural carbohydrate " $\\left[\\kg_{C}m^{-2}\\right]$ "l biomasszban trolt strukturlt sznhidrt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living structural carbohydrate" %
		output_map[3136] = &summary->livingNSC; //%"Living non-structural carbohydrate " $\\left[\\kg_{C}m^{-2}\\right]$ "l biomasszban trolt nem-strukturlt sznhidrt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living non-structural carbohydrate" %
		output_map[3137] = &summary->livingBIOMabove; //%" Living aboveground biomass" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn feletti biomassza" $\\left[\\kg_{C}m^{-2}\\right]$ "Living aboveground biomass" %
		output_map[3138] = &summary->livingBIOMbelow; //%"Living belowground biomass" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn alatti biomassza " $\\left[\\kg_{C}m^{-2}\\right]$ "Living belowground biomass" %
		output_map[3139] = &summary->BIOMaboveSUM;  //%" Total (living and dead) aboveground biomass" $\\left[\\kg_{C}m^{-2}\\right]$ "l s holt, felszn feletti biomassza szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2}\\right]$ "Total (living and dead) aboveground biomass" %
		output_map[3140] = &summary->BIOMbelowSUM;  //%"Total (living and dead) belowground biomass" $\\left[\\kg_{C}m^{-2}\\right]$ "l holt, felszn alatti biomassza szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2}\\right]$ "Total (living and dead)  belowground biomass" %
		output_map[3141] = &summary->annmax_livingBIOMabove; //%"Annual maximum of living aboveground biomass" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn feletti biomassza ves maximuma" $\\left[\\kg_{C}m^{-2}\\right]$ "Annmax living aboveground biomass" %
		output_map[3142] = &summary->annmax_livingBIOMbelow; //%"Annual maximum of living belowground biomass" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn alatti biomassza ves maximuma" $\\left[\\kg_{C}m^{-2}\\right]$ "Annmax living belowground biomass" %
		output_map[3143] = &summary->annmax_BIOMaboveSUM; //%"Annual maximum of total living and dead aboveground biomass" $\\left[\\kg_{C}m^{-2}\\right]$ "l s holt, felszn feletti biomassza szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2}\\right]$ "Annmax living and dead  aboveground biomass C" %
		output_map[3144] = &summary->annmax_BIOMbelowSUM; //%"Annual maximum of total living and dead  belowground biomass" $\\left[\\kg_{C}m^{-2}\\right]$ "l holt, felszn alatti biomassza szntartalmnak ves maximuma" $\\left[\\kg_{C}m^{-2}\\right]$ "Annmax living and dead  belowground biomass C" %
		output_map[3145] = &summary->LDbelowC_nw;    //%"Living+dead belowground non-woody biomass C content without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Teljes talajalatti nem-fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total belowground non-woody biomass C content" %
		output_map[3146] = &summary->LDbelowC_w;     //%"Living+dead belowground woody biomass C content without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2} \\right]$ "Teljes talajalatti fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total belowground woody biomass C content" %
		output_map[3147] = &summary->LDbelowCwithNSC_nw; //%"Living+dead belowground non-woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l s holt felszn alatti, nem-fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living+dead belowground non-woody biomass C with non-structured carbohydrate" %
		output_map[3148] = &summary->LDbelowCwithNSC_w;  //%"Living+dead belowground woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l s holt, felszn alatti, fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living+dead belowground woody biomass C with non-structured carbohydrate" %
		output_map[3149] = &summary->LbelowC_nw;     //%"Living belowground non-woody biomass C without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn alatti nem fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "Living belowground non-woody biomass C" %
		output_map[3150] = &summary->LbelowC_w;      //%"Living belowground woody biomass C without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn alatti, fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "Living belowground woody biomass C" %
		output_map[3151] = &summary->LbelowCwithNSC_nw;  //%"Living belowground non-woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn alatti, nem fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living belowground non-woody biomass C with non-structured carbohydrate" %
		output_map[3152] = &summary->LbelowCwithNSC_w;   //%"Living belowground woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn alatti, fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living belowground woody biomass C with non-structured carbohydrate" %
		output_map[3153] = &summary->DbelowC_nw;     //%"Dead belowground non-woody biomass C without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Holt, felszn alatti nem fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "Dead belowground non-woody biomass C" %
		output_map[3154] = &summary->DbelowC_w;      //%"Dead belowground woody biomass C without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Holt, felszn alatti, fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "Dead belowground woody biomass C" %
		output_map[3155] = &summary->DbelowCwithNSC_nw;  //%"Dead belowground non-woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Holt, felszn alatti, nem fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Dead belowground non-woody biomass C with non-structured carbohydrate" %
		output_map[3156] = &summary->DbelowCwithNSC_w;   //%"Dead belowground woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Holt, felszn alatti, fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Dead belowground woody biomass C with non-structured carbohydrate" %			
		output_map[3157] = &summary->LDaboveC_nw;    //%"Living+dead aboveground non-woody biomass C content without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Teljes talajfeletti nem-fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total aboveground non-woody biomass C content" %
		output_map[3158] = &summary->LDaboveC_w;     //%"Living+dead aboveground woody biomass C content without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2} \\right]$ "Teljes talajfeletti fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2} \\right]$ "Total aboveground woody biomass C content" %
		output_map[3159] = &summary->LDaboveCwithNSC_nw; //%"Living+dead aboveground non-woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l s holt felszn feletti, nem-fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living+dead aboveground non-woody biomass C with non-structured carbohydrate" %
		output_map[3160] = &summary->LDaboveCwithNSC_w;  //%"Living+dead aboveground woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l s holt, felszn feletti, fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living+dead aboveground woody biomass C with non-structured carbohydrate" %
		output_map[3161] = &summary->LaboveC_nw;     //%"Living aboveground non-woody biomass C without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn feletti nem fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "Living aboveground non-woody biomass C" %
		output_map[3162] = &summary->LaboveC_w;      //%"Living aboveground woody biomass C without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn feletti, fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "Living aboveground woody biomass C" %
		output_map[3163] = &summary->LaboveCwithNSC_nw;  //%"Living aboveground non-woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn feletti, nem fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living aboveground non-woody biomass C with non-structured carbohydrate" %
		output_map[3164] = &summary->LaboveCwithNSC_w;   //%"Living aboveground woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "l, felszn feletti, fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Living aboveground woody biomass C with non-structured carbohydrate" %
		output_map[3165] = &summary->DaboveC_nw;     //%"Dead aboveground non-woody biomass C without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Holt, felszn feletti nem fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "Dead aboveground non-woody biomass C" %
		output_map[3166] = &summary->DaboveC_w;      //%"Dead aboveground woody biomass C without non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Holt, felszn feletti, fs biomassza szntartalma" $\\left[\\kg_{C}m^{-2}\\right]$ "Dead aboveground woody biomass C" %
		output_map[3167] = &summary->DaboveCwithNSC_nw;  //%"Dead aboveground non-woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Holt, felszn feletti, nem fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Dead aboveground non-woody biomass C with non-structured carbohydrate" %
		output_map[3168] = &summary->DaboveCwithNSC_w;   //%"Dead aboveground woody biomass C with non-structured carbohydrate" $\\left[\\kg_{C}m^{-2}\\right]$ "Holt, felszn feletti, fs biomassza szntartalma a nem-strukturlt szntrozkkal egytt" $\\left[\\kg_{C}m^{-2}\\right]$ "Dead aboveground woody biomass C with non-structured carbohydrate" %			
		output_map[3169] = &summary->sminN_RZmax; //%"Soil mineralized N content in maximal rooting zone" $\\left[\\kg_{N}m^{-2} \\right]$ "A talaj mineralizlt N tartalma a gykrznban" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil mineralized N  content in rooting zone" %
		output_map[3170] = &summary->soilC_RZmax; //%"Soil C content in maximal rooting zone" $\\left[\\kg_{C}m^{-2} \\right]$ "A talaj szntartalma a gykrznban" $\\left[\\kg_{C}m^{-2} \\right]$ "Soil C content in rooting zone" %
		output_map[3171] = &summary->soilN_RZmax; //%"Soil N content in maximal rooting zone" $\\left[\\kg_{N}m^{-2} \\right]$ "A talaj nitrogntartalma a teljes gykrznban" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil N content in maximal rooting zone" %
		output_map[3172] = &summary->litrC_RZmax; //%"Litter C content in maximal rooting zone" $\\left[\\kg_{C}m^{-2} \\right]$ "Az elhalt szerves anyag szntartalma a teljes gykrznban" $\\left[\\kg_{C}m^{-2} \\right]$ "Litter C content in maximal rooting zone" %
		output_map[3173] = &summary->litrN_RZmax; //%"Litter N content in maximal rooting zone" $\\left[\\kg_{N}m^{-2} \\right]$ "Az elhalt szerves anyag nitrogntartalma a teljes gykrznban" $\\left[\\kg_{N}m^{-2} \\right]$ "Litter N content in maximal rooting zone" %
		output_map[3174] = &summary->sminNavail_RZmax; //%"Available soil mineralized N content in maximal rooting zone" $\\left[\\kg_{N}m^{-2} \\right]$ "A talaj mineralizlt N tartalma a gykrznban" $\\left[\\kg_{N}m^{-2} \\right]$ "Soil mineralized N  content in rooting zone" %
		output_map[3175] = &summary->tally1;  //%"Tally of total soil C during successive met cycles (metcyle=1) for comparison" $\\left[\\kg_{C}m^{-2} \\right]$
		output_map[3176] = &summary->tally2;  //%"Tally of total soil C during successive met cycles (metcyle=2) for comparison" $\\left[\\kg_{C}m^{-2} \\right]$
		output_map[3177] = &summary->steady1; //%"Marker for comparison of soilC change and spinup tolerance in metcyle=1" $\\left[\\dimless\\right]$
		output_map[3178] = &summary->steady2; //%"Marker for comparison of soilC change and spinup tolerance in metcyle=2" $\\left[\\dimless\\right]$
		output_map[3179] = &summary->metcycle;//%"Counter for metcyles (0,1 or 2)" $\\left[\\dimless\\right]$
        output_map[3180] = &summary->sminNavail[0]; //%"Available soil N content of soil layer 1 (0-3 cm)" $\\left[\\kgN m-2\\right]$ "Talaj hozzfrhet N-tartalma az 1. talajrtegben (0-3 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 1 (0-3 cm)" %
        output_map[3181] = &summary->sminNavail[1]; //%"Available soil N content of soil layer 2 (3-10 cm)" $\\left[\\kgN m-2\\right]$ "Talaj hozzfrhet N-tartalma a 2. talajrtegben (3-10 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 2 (3-10 cm)" %
        output_map[3182] = &summary->sminNavail[2]; //%"Available soil N content of soil layer 3 (10-30 cm)" $\\left[\\kgN m-2 \\right]$ "Talaj hozzfrhet N-tartalma a 3. talajrtegben (10-30 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 3 (10-30 cm)" %
        output_map[3183] = &summary->sminNavail[3]; //%"Available soil N content of soil layer 4 (30-60 cm)" $\\left[\\kgN m-2 \\right]$ "Talaj hozzfrhet N-tartalma a 4. talajrtegben (30-60 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 4 (30-60 cm)" %
        output_map[3184] = &summary->sminNavail[4]; //%"Available soil N content of soil layer 5 (60-90 cm)" $\\left[\\kgN m-2 \\right]$ "Talaj hozzfrhet N-tartalma az 5. talajrtegben (60-90 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 5 (60-90 cm)" %
        output_map[3185] = &summary->sminNavail[5]; //%"Available soil N content of soil layer 6 (90-120 cm)" $\\left[\\kgN m-2\\right]$ "Talaj  hozzfrhet N-tartalma a 6. talajrtegben (90-120 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 6 (90-120 cm)" %
        output_map[3186] = &summary->sminNavail[6]; //%"Available soil N content of soil layer 7 (120-150 cm)" $\\left[\\kgN m-2\\right]$ "Talaj hozzfrhet N-tartalma a 7. talajrtegben (120-150 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 7 (120-150 cm)" %
        output_map[3187] = &summary->sminNavail[7]; //%"Available soil N content of soil layer 8 (150-200 cm)" $\\left[\\kgN m-2\\right]$ "Talaj hozzfrhet N-tartalma a 8. talajrtegben (150-200 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 8 (150-200 cm)" %
        output_map[3188] = &summary->sminNavail[8]; //%"Available soil N content of soil layer 9 (200-400 cm)" $\\left[\\kgN m-2\\right]$ "Talaj hozzfrhet N-tartalma az 9. talajrtegben (200-400 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 9 (200-400 cm)" %
        output_map[3189] = &summary->sminNavail[9]; //%"Available soil N content of soil layer 10 (400-1000 cm)" $\\left[\\kgN m-2\\right]$ "Talaj hozzfrhet N-tartalma a 10. talajrtegben (400-1000 cm)" $\\left[\\kgN m-2\\right]$ "Available soil N content of soil layer 10 (400-1000 cm)" %
        output_map[3190] = &summary->cumNPPabove_nw; //%"Cumulative annual SUM of aboveground non-woody NPP" $\\left[\\kg_{C}m^{-2} \\right]$ "Felszn feletti nem-fs nett primr produkc kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of aboveground non-woody NPP" %
        output_map[3191] = &summary->cumNPPbelow_nw; //%"Cumulative annual SUM of belowground non-woody NPP" $\\left[\\kg_{C}m^{-2} \\right]$ "Felszn alatti nem-fs nett primr produkc kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of belowground non-woody NPP" %
        output_map[3192] = &summary->cumNPPabove_w; //%"Cumulative annual SUM of aboveground woody NPP" $\\left[\\kg_{C}m^{-2} \\right]$ "Felszn feletti  fs nett primr produkc kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of aboveground woody NPP" %
        output_map[3193] = &summary->cumNPPbelow_w; //%"Cumulative annual SUM of belowground woody NPP" $\\left[\\kg_{C}m^{-2} \\right]$ "Felszn alatti fs nett primr produkc kumulatv ves sszege" $\\left[\\kg_{C}m^{-2} \\right]$ "Cumulative annual SUM of belowground   woody NPP" %
        output_map[3194] = &summary->vegN; //%"Total organic N content of vegetation" $\\left[\\kg_{N}m^{-2} \\right]$ "Az koszisztma teljes szerves nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total organic N content of ecosystem" %
        output_map[3195] = &summary->totalN; //%"Total N content" $\\left[\\kg_{N}m^{-2} \\right]$ "Teljes N-tartalom" $\\left[\\kg_{N}m^{-2} \\right]$ "Total N content" %
        output_map[3196] = &summary->cumPETcanopy;     //%"Cumulative potential evapotranspiration of canopy" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Kumulatv potencilis levlfelleti prolgs-prologtats" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Cumulative potential evapotranspiration of canopy" %
        output_map[3197] = &summary->cumPETsurface;  //%"Cumulative potential evaporation of surface" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Kumulatv potencilis felszni prolgs" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Cumulative potential  evaporation of surface" %
        output_map[3198] = &summary->cumPET; //%"Cumulative sum potential evapotranspiration" $\\left[\\kg_{H2O}m^{-2}\\right]$ "A PET kumulatv sszege" $\\left[\\kg_{H2O}m^{-2 } \\right]$ "Cumulative sum GW-infiltration" %
  
        output_map[3200] = &summary->cumMRdeficit_NSC; //%"Cumulative flux of carbon flux from NSC pools to cpool to cover MR-deficit" $\\left[\\kg_{C}m^{-2 }\\right]$ "Kumulatv fluxus az NSC trozbl az MR-deficit fedezsre" $\\left[\\kg_{C}m^{-2 }\\right]$ "Cumulative flux of non-materialized MR due to lack of C in carbon pools" %
        output_map[3201] = &summary->cumMRdeficit_SC; //%"Cumulative flux of carbon flux from SC pools to cpool to cover MR-deficit" $\\left[\\kg_{C}m^{-2 }\\right]$ "Kumulatv fluxus az NSC trozbl az MR-deficit fedezsre" $\\left[\\kg_{C}m^{-2 }\\right]$ "Cumulative flux of carbon flux from SC pools to cpool to cover MR-deficit" %
        output_map[3202] = &summary->CH4fluxCeq; //%"Daily CH4 flux in C eq" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Napi CH4 fluxus sznegyenrtkben" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Daily CH4 flux in C eq." %
        output_map[3203] = &summary->Wleach_RZmax;     //%"Soil water leached from rootzone (perc+diff)" $\\left[\\kg_{H_{2}O}m^{-2}day^{-1}} \\right]$ "Gykrznbl tmosd nedvessg (szivrgs+diffzi)" $\\left[\\kg_{H_{2}O}m^{-2}nap^{-1}} \\right]$ "Soil water leached from rootzone (percolation+diffusion)" %
        output_map[3204] = &summary->sminNleach_RZmax; //%"Leached soil mineral N from rootzone" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kimosdott talaj svnyi N a gykrznbl" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leached soil mineral N from rootzone" %
        output_map[3205] = &summary->DONleach_RZmax;   //%"Leached DON from rootzone" $\\left[\\kg_{N}m^{-2 }day^{-1} \\right]$ "Kimosds a talaj oldott szerves nitrogntartalmbl a gykrznban" $\\left[\\kg_{N}m^{-2 }nap{^-1} \\right]$ "Leached DON from rootzone" %
        output_map[3206] = &summary->DOCleach_RZmax;   //%"Leached DOC from rootzone" $\\left[\\kg_{C}m^{-2 }day^{-1} \\right]$ "Kimosds az oldott szervesanyag tartalombl a gykrznban" $\\left[\\kg_{C}m^{-2 }nap^{-1} \\right]$ "Leached dissolved organic C content from rootzone" %
        output_map[3207] = &summary->NH4_RZmax; //%"Soil mineralized NH4 content in maximal rooting zone" $\\left[\\kg_{N}m^{-2} \\right]$ %
        output_map[3208] = &summary->NO3_RZmax; //%"Soil mineralized NO3 content in maximal rooting zone" $\\left[\\kg_{N}m^{-2} \\right]$ %
        output_map[3209] = &summary->cumFLsoilw; //%"Cumulative sum of water from flooding " $\\left[\\kg_{N}m^{-2} \\right]$ %
        output_map[3210] = &summary->cumWflux_fromPRCP; //%"Cumulative sum of water from PRCP" $\\left[\\kg_{H2O}m^{-2}\\right]$ "A GW-bl szrmaz vzfluxus kumulatv sszege" $\\left[\\kg_{H2O}m^{-2 } \\right]$ "Cumulative sum of water from GW" %
        output_map[3211] = &summary->cumWflux_fromFRZ; //%"Cumulative sum of water from irrigation" $\\left[\\kg_{H2O}m^{-2}\\right]$ "Az ntzsbl szrmaz vzfluxus kumulatv sszege" $\\left[\\kg_{H2O}m^{-2 } \\right]$ "Cumulative sum of water from irrigation" %    
        output_map[3212] = &summary->cumWflux_fromIRG; //%"Cumulative sum of water from fertilization" $\\left[\\kg_{H2O}m^{-2}\\right]$ "Az trgyzsbl szrmaz vzfluxus kumulatv sszege" $\\left[\\kg_{H2O}m^{-2 } \\right]$ "Cumulative sum of water from fertilization" %
        output_map[3213] = &summary->cumGWdischarge; //%"Cumulative sum of water from GW" $\\left[\\kg_{H2O}m^{-2}\\right]$ "
        output_map[3214] = &summary->cumGWrecharge; //%"Cumulative sum of water into GW" $\\left[\\kg_{H2O}m^{-2}\\right]$ "
        output_map[3215] = &summary->cumEVPfromGW;//%"Cumulative sum of soil evaporation from GW" $\\left[\\kg_{H2O}m^{-2}\\right]$ "
        output_map[3216] = &summary->cumTRPfromGW;//%"Cumulative sum of soil evaporation from GW" $\\left[\\kg_{H2O}m^{-2}\\right]$ "
        output_map[3217] = &summary->cumRunoffD; //%"Cumulated SUM of Dunnian runoff" $\\left[\\kg_{H_{2}O}m^{-2}year^{-1}} \\right]$ "Lefolys kumullt sszege" $\\left[\\kg_{H_{2}O}m^{-2}v^{-1}} \\right]$ "Cumulated SUM of runoff" %
        output_map[3218] = &summary->cumRunoffH; //%"Cumulated SUM of Hortonian runoff" $\\left[\\kg_{H_{2}O}m^{-2}year^{-1}} \\right]$ "Lefolys kumullt sszege" $\\left[\\kg_{H_{2}O}m^{-2}v^{-1}} \\right]$ "Cumulated SUM of runoff" %
        output_map[3219] = &summary->orgN_ppm[0]; //%"Soil orgN-N content in ppm of soil layer 1 (0-3 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben az 1. talajrtegben (0-3 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 1 (0-3 cm)" %
        output_map[3220] = &summary->orgN_ppm[1]; //%"Soil orgN-N content in ppm of soil layer 2 (3-10 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben a 2. talajrtegben (3-10 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 2 (3-10 cm)" %
        output_map[3221] = &summary->orgN_ppm[2]; //%"Soil orgN-N content in ppm of soil layer 3 (10-30 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben a 3. talajrtegben (10-30 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 3 (10-30 cm)" %
        output_map[3222] = &summary->orgN_ppm[3]; //%"Soil orgN-N content in ppm of soil layer 4 (30-60 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben a 4. talajrtegben (30-60 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 4 (30-60 cm)" %
        output_map[3223] = &summary->orgN_ppm[4]; //%"Soil orgN-N content in ppm of soil layer 5 (60-90 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben az 5. talajrtegben (60-90 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 5 (60-90 cm)" %
        output_map[3224] = &summary->orgN_ppm[5]; //%"Soil orgN-N content in ppm of soil layer 6 (90-120 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben a 6. talajrtegben (90-120 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 6 (90-120 cm)" %
        output_map[3225] = &summary->orgN_ppm[6]; //%"Soil orgN-N content in ppm of soil layer 7 (120-150 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben a 7. talajrtegben (120-150 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 7 (120-150 cm)" %
        output_map[3226] = &summary->orgN_ppm[7]; //%"Soil orgN-N content in ppm of soil layer 8 (150-200 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben a 8. talajrtegben (150-200 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 8 (150-200 cm)" %
        output_map[3227] = &summary->orgN_ppm[8]; //%"Soil orgN-N content in ppm of soil layer 9 (200-400 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben az 9. talajrtegben (200-400 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 9 (200-400 cm)" %
        output_map[3228] = &summary->orgN_ppm[9]; //%"Soil orgN-N content in ppm of soil layer 10 (400-1000 cm)" $\\left[\\ppm \\right]$ "Talaj orgN tartalom ppm-ben a 10. talajrtegben (400-1000 cm)" $\\left[\\ppm \\right]$ "Soil orgN-N content in ppm of soil layer 10 (400-1000 cm)" %
        output_map[3229] = &summary->GWdischarge_NH4;      //%"NH4-discharge" $\\left[\\kg_{N}m^{-2}day^{-1}\\right]$ 
        output_map[3230] = &summary->GWdischarge_NO3;      //%"NO3-discharge" $\\left[\\kg_{N}m^{-2}day^{-1}\\right]$ 
        output_map[3231] = &summary->GWdischarge_orgN;     //%"orgN-discharge" $\\left[\\kg_{N}m^{-2}day^{-1}\\right]$ 
        output_map[3232] = &summary->GWrecharge_NH4;       //%"NH4-recharge" $\\left[\\kg_{N}m^{-2}day^{-1}\\right]$ 
        output_map[3233] = &summary->GWrecharge_NO3;       //%"NO3-recharge" $\\left[\\kg_{N}m^{-2}day^{-1}\\right]$ 
        output_map[3234] = &summary->GWrecharge_orgN;      //%"orgN-recharge" $\\left[\\kg_{N}m^{-2}day^{-1}\\right]$ 
        output_map[3235] = &summary->cumGWdischarge_NH4;   //%"Cumulative sum of NH4-discharge" $\\left[\\kg_{N}m^{-2}\\right]$ 
        output_map[3236] = &summary->cumGWdischarge_NO3;   //%"Cumulative sum of NO3-discharge" $\\left[\\kg_{N}m^{-2}\\right]$ 
        output_map[3237] = &summary->cumGWdischarge_orgN;  //%"Cumulative sum of orgN-discharge" $\\left[\\kg_{N}m^{-2}\\right]$ 
        output_map[3238] = &summary->cumGWrecharge_NH4;    //%"Cumulative sum of NH4-recharge" $\\left[\\kg_{N}m^{-2}\\right]$ 
        output_map[3239] = &summary->cumGWrecharge_NO3;    //%"Cumulative sum of NO3-recharge" $\\left[\\kg_{N}m^{-2}\\right]$ 
        output_map[3240] = &summary->cumGWrecharge_orgN;   //%"Cumulative sum of orgN-recharge" $\\left[\\kg_{N}m^{-2}\\right]$ 
        output_map[3241] = &summary->cumGWbalance;         //%"Cumulative sum of groundwater balance (recharge-discharge)" $\\left[\\kg_{H2O}m^{-2}\\right]$ 
        output_map[3242] = &summary->cumGWbalance_NH4;     //%"Cumulative sum of NH4-balance (recharge-discharge)" $\\left[\\kg_{N}m^{-2}\\right]$ 
        output_map[3243] = &summary->cumGWbalance_NO3;     //%"Cumulative sum of orgN-discharge (recharge-discharge)" $\\left[\\kg_{N}m^{-2}\\right]$ 
        output_map[3244] = &summary->cumGWbalance_orgN;    //%"Cumulative sum of orgN-discharge (recharge-discharge)" $\\left[\\kg_{N}m^{-2}\right]$ 
        output_map[3245] = &summary->GWbalance;            //%"Groundwater balance (recharge-discharge)" $\\left[\\kg_{H2O}m^{-2}day^{-1}\\right]$ 
        output_map[3246] = &summary->GWbalance_NH4;        //%"NH4-balance" $\\left[\\kg_{N}m^{-2}day^{-1}\\right]$ 
        output_map[3247] = &summary->GWbalance_NO3;        //%"NO3-balance" $\\left[\\kg_{N}m^{-2}day^{-1}\\right]$ 
        output_map[3248] = &summary->GWbalance_orgN;       //%"orgN-dbalance" $\\left[\\kg_{N}m^{-2}day^{-1}\\right]$ 
         
        output_map[3300] = &summary->BD_top5;  //%"Avareged bulk density in the top 5 cm of soil" $\\left[\\kg_{C}m^{-3}\\right]$ 
        output_map[3301] = &summary->BD_top10; //%"Avareged bulk density in the top 10 cm of soil" $\\left[\\kg_{C}m^{-3}\\right]$ 
        output_map[3302] = &summary->BD_top15; //%"Avareged bulk density in the top 15 cm of soil" $\\left[\\kg_{C}m^{-3}\\right]$ 
        output_map[3303] = &summary->BD_top20; //%"Avareged bulk density in the top 20 cm of soil" $\\left[\\kg_{C}m^{-3}\\right]$ 
        output_map[3304] = &summary->BD_top25; //%"Avareged bulk density in the top 25 cm of soil" $\\left[\\kg_{C}m^{-3}\\right]$ 
        output_map[3305] = &summary->BD_top30; //%"Avareged bulk density in the top 30 cm of soil" $\\left[\\kg_{C}m^{-3}\\right]$ 
        output_map[3306] = &summary->VWC_top5;  //%"Avareged volumetric water content in the top 5 cm of soil" $\\left[\\m^{3}m^{-3} \\right]$
        output_map[3307] = &summary->VWC_top10; //%"Avareged volumetric water content in the top 10 cm of soil" $\\left[\\m^{3}m^{-3} \\right]$
        output_map[3308] = &summary->VWC_top15; //%"Avareged volumetric water content in the top 15 cm of soil" $\\left[\\m^{3}m^{-3} \\right]$
        output_map[3309] = &summary->VWC_top20; //%"Avareged volumetric water content in the top 20 cm of soil" $\\left[\\m^{3}m^{-3} \\right]$
        output_map[3310] = &summary->VWC_top25; //%"Avareged volumetric water content in the top 25 cm of soil" $\\left[\\m^{3}m^{-3} \\right]$
        output_map[3311] = &summary->VWC_top30; //%"Avareged volumetric water content in the top 30 cm of soil" $\\left[\\m^{3}m^{-3} \\right]$
        output_map[3312] = &summary->Tsoil_top5; //%"Avareged daily temperature in the top 5 cm of soil" $\\left[Celsius\\right]$ 
        output_map[3313] = &summary->Tsoil_top10;//%"Avareged daily temperature in the top 10 cm of soil" $\\left[Celsius\\right]$ 
        output_map[3314] = &summary->Tsoil_top15;//%"Avareged daily temperature in the top 15 cm of soil" $\\left[Celsius\\right]$ 
        output_map[3315] = &summary->Tsoil_top20;//%"Avareged daily temperature in the top 20 cm of soil" $\\left[Celsius\\right]$ 
        output_map[3316] = &summary->Tsoil_top25;//%"Avareged daily temperature in the top 25 cm of soil" $\\left[Celsius\\right]$ 
        output_map[3317] = &summary->Tsoil_top30;//%"Avareged daily temperature in the top 30  cm of soil" $\\left[Celsius\\right]$ 
        output_map[3318] = &summary->SOC_top5;  //%"Total soil organic carbon content in the top 5 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3319] = &summary->SOC_top10; //%"Total soil organic carbon content in the top 10 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3320] = &summary->SOC_top15; //%"Total soil organic carbon content in the top 15 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3321] = &summary->SOC_top20; //%"Total soil organic carbon content in the top 20 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3322] = &summary->SOC_top25; //%"Total soil organic carbon content in the top 25 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3323] = &summary->SOC_top30; //%"Total soil organic carbon content in the top 30 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3324] = &summary->SOCpercent_top5;  //%"Total soil organic carbon content (carbon/soil in percent) in the top 5 cm of soil" $\\left[\\%\\right]$ 
        output_map[3325] = &summary->SOCpercent_top10; //%"Total soil organic carbon content (carbon/soil in percent) in the top 10 cm of soil" $\\left[\\%\\right]$ 
        output_map[3326] = &summary->SOCpercent_top15; //%"Total soil organic carbon content (carbon/soil in percent) in the top 15 cm of soil" $\\left[\\%\\right]$ 
        output_map[3327] = &summary->SOCpercent_top20; //%"Total soil organic carbon content (carbon/soil in percent) in the top 20 cm of soil" $\\left[\\%\\right]$ 
        output_map[3328] = &summary->SOCpercent_top25; //%"Total soil organic carbon content (carbon/soil in percent) in the top 25 cm of soil" $\\left[\\%\\right]$ 
        output_map[3329] = &summary->SOCpercent_top30; //%"Total soil organic carbon content (carbon/soil in percent) in the top 30 cm of soil" $\\left[\\%\\right]$ 
        output_map[3330] = &summary->SOC4_top5;  //%"Total stable soil organic carbon content in the top 5 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3331] = &summary->SOC4_top10; //%"Total stable soil organic carbon content in the top 10 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3332] = &summary->SOC4_top15; //%"Total stable soil organic carbon content in the top 15 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3333] = &summary->SOC4_top20; //%"Total stable soil organic carbon content in the top 20 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3334] = &summary->SOC4_top25; //%"Total stable soil organic carbon content in the top 25 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3335] = &summary->SOC4_top30; //%"Total stable soil organic carbon content in the top 30 cm of soil" $\\left[\\kg_{C}m^{-2}\\right]$ 
        output_map[3336] = &summary->SOC4percent_top5;  //%"Total stable soil organic carbon content (carbon/soil in percent) in the top 5 cm of soil" $\\left[\\%\\right]$ 
        output_map[3337] = &summary->SOC4percent_top10; //%"Total stable soil organic carbon content (carbon/soil in percent) in the top 10 cm of soil" $\\left[\\%\\right]$ 
        output_map[3338] = &summary->SOC4percent_top15; //%"Total stable soil organic carbon content (carbon/soil in percent) in the top 15 cm of soil" $\\left[\\%\\right]$ 
        output_map[3339] = &summary->SOC4percent_top20; //%"Total stable soil organic carbon content (carbon/soil in percent) in the top 20 cm of soil" $\\left[\\%\\right]$ 
        output_map[3340] = &summary->SOC4percent_top25; //%"Total stable soil organic carbon content (carbon/soil in percent) in the top 25 cm of soil" $\\left[\\%\\right]$ 
        output_map[3341] = &summary->SOC4percent_top30; //%"Total stable soil organic carbon content (carbon/soil in percent) in the top 30 cm of soil" $\\left[\\%\\right]$ 
        output_map[3342] = &summary->NH4ppmAVAIL_top30; //%"Available soil NH4-N content in soil top 0-30 cm" $\\left[\\ppm\\right]$ "A feltalaj (0-30 cm) hozzfrhet NH4-N tartalma" $\\left[\\ppm \\right]$ "Available soil NH4-N content in soil top 0-30 cm" %
        output_map[3343] = &summary->NO3ppmAVAIL_top30; //%"Available soil NO3-N content in soil top 0-30 cm" $\\left[\\ppm\\right]$ "A feltalaj (0-30 cm) hozzfrhet NO3-N tartalma" $\\left[\\ppm \\right]$ "Available soil NO3-N content in soil top 0-30 cm" %
        output_map[3344] = &summary->sminNppmAVAIL_top30; //%"Available mineralized N in soil top 0-30 cm" $\\left[\\ppm\\right]$ "A feltalaj (0-30 cm) teljes mineralizlt N tartalma" $\\left[\\ppm \\right]$ "Total soil mineralized N-content in soil top 0-30 cm" %


        output_map[3501] = &summary->NH4_unsat; //%"NH4-content of unsaturated zone" $\\left[\\kg_{N}m^{-2 } \\right]$ "NH4-content of unsaturated zone" $\\left[\\kg_{N}m^{-2 } \\right]$ "NH4-content of unsaturated zone" %
        output_map[3502] = &summary->NO3_unsat; //%"NO3-content of unsaturated zone" $\\left[\\kg_{N}m^{-2 } \\right]$ "NO3-content of unsaturated zone" $\\left[\\kg_{N}m^{-2 } \\right]$ "NO3-content of unsaturated zone" %
        output_map[3503] = &summary->orgN_unsat; //%"Organic N-content above GW-zone (unsaturated and aboveground)" $\\left[\\kg_{N}m^{-2 } \\right]$ "Organic N-content above GW-zone (unsaturated and aboveground)" $\\left[\\kg_{N}m^{-2 } \\right]$ "Organic N-content above GW-zone (unsaturated and aboveground)" %
        output_map[3504] = &summary->orgN; //%"Total organic N content of ecosystem" $\\left[\\kg_{N}m^{-2} \\right]$ "Az koszisztma teljes szerves nitrogntartalma" $\\left[\\kg_{N}m^{-2} \\right]$ "Total organic N content of ecosystem" %
        output_map[3505] = &summary->cumGWsrc; //%"Cumulative sum of GW-evaporation" $\\left[\\kg_{H2O}m^{-2}\\right]$ 
        output_map[3506] = &summary->cumWinput; //%"Cumulative sum of water inputs" $\\left[\\kg_{H2O}m^{-2}\\right]$ 
        output_map[3507] = &summary->cumGWsnk; //%"Cumulative sum of GW-infiltration" $\\left[\\kg_{H2O}m^{-2}\\right]$ "Cumulative sum GW-infiltration" $\\left[\\kg_{H2O}m^{-2 } \\right]$ "Cumulative sum potential evapotranspiration" %
        output_map[3508] = &summary->cumWoutput; //%"Cumulative sum of GW-infiltration" $\\left[\\kg_{H2O}m^{-2}\\right]$ "Cumulative sum GW-infiltration" $\\left[\\kg_{H2O}m^{-2 } \\right]$ "Cumulative sum potential evapotranspiration" %
        output_map[3509] = &summary->cumTOTALchangeGW_NH4; //%"Cumulative sum of all NH4 fluxes (ecological processes, denitrification, fertilization) covered by GW in GWlayer" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3510] = &summary->cumTOTALchangeGW_NO3; //%"Cumulative sum of all NO3 fluxes (ecological processes, denitrification, fertilization) covered by GW in GWlayer" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3511] = &summary->cumTOTALchangeGW_orgN; //%"Cumulative sum of all orgN fluxes (ecological processes, denitrification, fertilization) covered by GW in GWlayer" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3512] = &summary->cumUNSATecofunc_NH4; //%"Cumulative sum of NH4 ecological fluxes (fixaton, deposition,mineralization-immobilization,  plant uptake, nitrification, denitrification) affected by GW-effect in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3513] = &summary->cumUNSATfertil_NH4; //%"Cumulative sum of NH4 fertilization fluxes affected by GW-effect in unsaturated zone" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3514] = &summary->cumUNSATdischarge_NH4; //%"Cumulative sum of NH4 discharge fluxes in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3515] = &summary->cumUNSATrecharge_NH4; //%"Cumulative sum of NH4 recharge fluxes in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3516] = &summary->cumUNSATecofunc_NO3; //%"Cumulative sum of NO3 ecological fluxes (fixaton, deposition,mineralization-immobilization,  plant uptake, nitrification, denitrification) affected by GW-effect in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3517] = &summary->cumUNSATfertil_NO3; //%"Cumulative sum of NO3 fertilization fluxes affected by GW-effect in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3518] = &summary->cumUNSATdischarge_NO3; //%"Cumulative sum of NO3 discharge fluxes in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3519] = &summary->cumUNSATrecharge_NO3; //%"Cumulative sum of NO3 recharge fluxes in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3520] = &summary->cumUNSATplantUPto_orgN; //%"Cumulative sum of orgN plant uptake fluxes  affected by GW-effect in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3521] = &summary->cumUNSATecofunc_orgN; //%"Cumulative sum of orgN ecological fluxes (fixaton, deposition,mineralization-immobilization,  plant uptake, nitrification, denitrification) affected by GW-effect in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3522] = &summary->cumUNSATfertil_orgN; //%"Cumulative sum of orgN fertilization fluxes affected by GW-effect in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3523] = &summary->cumUNSATdischarge_orgN; //%"Cumulative sum of orgN discharge fluxes in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3524] = &summary->cumUNSATrecharge_orgN; //%"Cumulative sum of orgN recharge fluxes in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3525] = &summary->cumTOTALchangeGW_orgN; //%"Cumulative sum of all orgN fluxes (ecological processes, denitrification, fertilization) affected by GW-effect in the total soil" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3526] = &summary->cumTOTALplantUPto_orgN; //%"Cumulative sum of orgN plant uptake fluxes affected by GW-effect in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3527] = &summary->cumTOTALecofunc_orgN; //%"Cumulative sum of orgN ecological fluxes (fixaton, deposition,mineralization-immobilization,  plant uptake, nitrification, denitrification) affected by GW-effect in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3528] = &summary->cumTOTALfertil_orgN; //%"Cumulative sum of orgN fertilization fluxes affected by GW-effect in unsaturated zone (above GWD)" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3529] = &summary->cumTOTALdischarge_orgN; //%"Cumulative sum of orgN discharge fluxen in total soil" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3530] = &summary->cumTOTALrecharge_orgN; //%"Cumulative sum of orgN recharge fluxen in total soil" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3531] = &summary->cumHRV_to_transpN; //%"Cumulative sum of harvested and transported N" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3532] = &summary->cumNplus_PLT; //%" Cumulative sum of N plus due to planting" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3533] = &summary->cumUNSATdenitr; //%" Cumulative denitrification N flux" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3534] = &summary->cumUNSATvolat; //%"Cumulative estimated N2O volatilization" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3535] = &summary->cumENVtoSMINN; //%"Cumulative denitrification N flux" $\\left[\\kg_{N}m^{-2 }\\right]$ 
        output_map[3536] = &summary->cumFRZtoN; //%"Cumulative sum of N flux due to fertilization" $\\left[\\kg_{N}m^{-2 }\\right]$ 

        output_map[3540] = &sprop->DBARarray[0]; //%"Unlimited value of DBAR in diffusion calculation between layer 1 and 2" $\\left[dimless\\right]$ 
        output_map[3541] = &sprop->DBARarray[1]; //%"Unlimited value of DBAR in diffusion calculation between layer 2 and 3" $\\left[dimless\\right]$ 
        output_map[3542] = &sprop->DBARarray[2]; //%"Unlimited value of DBAR in diffusion calculation between layer 3 and 4" $\\left[dimless\\right]$ 
        output_map[3543] = &sprop->DBARarray[3]; //%"Unlimited value of DBAR in diffusion calculation between layer 4 and 5" $\\left[dimless\\right]$ 
        output_map[3544] = &sprop->DBARarray[4]; //%"Unlimited value of DBAR in diffusion calculation between layer 5 and 6" $\\left[dimless\\right]$ 
        output_map[3545] = &sprop->DBARarray[5]; //%"Unlimited value of DBAR in diffusion calculation between layer 6 and 7" $\\left[dimless\\right]$ 
        output_map[3546] = &sprop->DBARarray[6]; //%"Unlimited value of DBAR in diffusion calculation between layer 7 and 8" $\\left[dimless\\right]$ 
        output_map[3547] = &sprop->DBARarray[7]; //%"Unlimited value of DBAR in diffusion calculation between layer 8 and 9" $\\left[dimless\\right]$ 
        output_map[3548] = &sprop->DBARarray[8]; //%"Unlimited value of DBAR in diffusion calculation between layer 9 and 10" $\\left[dimless\\right]$ 
        output_map[3549] = &sprop->DBARarray[9]; //%"Unlimited value of DBAR in diffusion calculation between SAT and CAPIL sublayers" $\\left[dimless\\right]$ 
        output_map[3550] = &sprop->DBARarray[10]; //%"Unlimited value of DBAR in diffusion calculation between CAPIL and NORM layers" $\\left[dimless\\right]$ 
        output_map[3551] = &sprop->DBARarray[11]; //%"Unlimited value of DBAR in diffusion calculation between last GW-layer and first noGW-layer" $\\left[dimless\\right]$ 

        output_map[3560] = &soilInfo->balance_UNSAT[0]; //%"Balance of NH4 in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 
        output_map[3561] = &soilInfo->balance_UNSAT[1]; //%"Balance of NO3 in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 
        output_map[3562] = &soilInfo->balance_UNSAT[2]; //%"Balance of soil1N in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 
        output_map[3563] = &soilInfo->balance_UNSAT[3]; //%"Balance of soil2N in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 
        output_map[3564] = &soilInfo->balance_UNSAT[4]; //%"Balance of soil3N in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 
        output_map[3565] = &soilInfo->balance_UNSAT[5]; //%"Balance of soil4N in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 
        output_map[3566] = &soilInfo->balance_UNSAT[6]; //%"Balance of soil1C in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 
        output_map[3567] = &soilInfo->balance_UNSAT[7]; //%"Balance of soil2C in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 
        output_map[3568] = &soilInfo->balance_UNSAT[8]; //%"Balance of soil3C in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 
        output_map[3569] = &soilInfo->balance_UNSAT[9]; //%"Balance of soil4C in unsaturated part of groundwater layer" $\\left[dimless\\right]$ 

    }


	return (errorCode);
}
		
